/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.redis.model;

import com.dbeaver.db.redis.RedisConstants;
import com.dbeaver.db.redis.RedisUtils;
import com.dbeaver.db.redis.exec.RedisKeySetStatement;
import com.dbeaver.db.redis.exec.RedisKeySizeStatement;
import com.dbeaver.db.redis.exec.RedisSession;
import com.dbeaver.db.redis.model.RedisDataSource;
import com.dbeaver.db.redis.model.RedisDatabase;
import com.dbeaver.db.redis.model.RedisKeyAttribute;
import com.dbeaver.db.redis.model.RedisKeyNameConstraint;
import com.dbeaver.db.redis.model.RedisKeyScoredConstraint;
import com.dbeaver.db.redis.model.RedisKeySimpleConstraint;
import com.dbeaver.db.redis.model.RedisKeyType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBPQualifiedObject;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPSaveableObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.impl.AbstractExecutionSource;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.impl.data.ExecuteBatchImpl;
import org.jkiss.dbeaver.model.impl.sql.SelectTableGenerator;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import redis.clients.jedis.commands.JedisCommands;
import redis.clients.jedis.commands.KeyCommands;

public class RedisKey
implements DBSEntity,
DBPNamedObject2,
DBSDataContainer,
DBSDataManipulator,
DBPSaveableObject,
DBPQualifiedObject,
DBPRefreshableObject,
SelectTableGenerator {
    private static final Log log = Log.getLog(RedisKey.class);
    private static final List<RedisKey> EMPTY_SUB_KEYS = Collections.emptyList();
    private final RedisDatabase database;
    private final RedisKey parentKey;
    private String keyName;
    private RedisKeyType keyType;
    private Long ttl;
    private long keySize = -1L;
    private final boolean isFolder;
    private boolean persisted;
    private List<RedisKey> subKeys;
    private List<RedisKeyAttribute> attributes = null;

    public RedisKey(@NotNull RedisDatabase database, @Nullable RedisKey parentKey, @NotNull String keyName, boolean isFolder) {
        this.database = database;
        this.parentKey = parentKey;
        this.keyName = keyName;
        this.isFolder = isFolder;
        this.persisted = true;
    }

    @Association
    @Nullable
    public RedisKey getParentKey() {
        return this.parentKey;
    }

    @NotNull
    public RedisDataSource getDataSource() {
        return this.database.getDataSource();
    }

    @Property(viewable=true, editable=true, valueTransformer=DBObjectNameCaseTransformer.class, order=1)
    @NotNull
    public String getName() {
        return this.keyName;
    }

    public RedisDatabase getDatabase() {
        return this.database;
    }

    @Property(viewable=true, order=3)
    @NotNull
    public RedisKeyType getKeyType(DBRProgressMonitor monitor) {
        if (this.keyType == null) {
            if (this.isFolder) {
                return RedisKeyType.folder;
            }
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (RedisSession session = (RedisSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)("Read key [" + this.getFullyQualifiedName(DBPEvaluationContext.DML) + "] type"));){
                    RedisUtils.selectCurDatabase(session, this.getDatabase());
                    this.keyType = session.supportsCommands(JedisCommands.class) ? RedisKeyType.valueOf(session.getCommands(JedisCommands.class).type(this.getFullyQualifiedName(DBPEvaluationContext.DML))) : RedisKeyType.valueOf(session.getCommands(KeyCommands.class).type(this.getFullyQualifiedName(DBPEvaluationContext.DML)));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                log.error((Object)"Error getting key type", e);
                this.keyType = RedisKeyType.string;
            }
        }
        return this.keyType;
    }

    @Property(viewable=false, order=4)
    public long getTTL(DBRProgressMonitor monitor) {
        if (this.ttl == null) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (RedisSession session = (RedisSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)("Read key [" + this.getFullyQualifiedName(DBPEvaluationContext.DML) + "] TTL"));){
                    RedisUtils.selectCurDatabase(session, this.getDatabase());
                    this.ttl = session.supportsCommands(KeyCommands.class) ? Long.valueOf(session.getCommands(KeyCommands.class).ttl(this.getFullyQualifiedName(DBPEvaluationContext.DML))) : Long.valueOf(session.getCommands(KeyCommands.class).ttl(this.getFullyQualifiedName(DBPEvaluationContext.DML)));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                log.error((Object)e);
            }
            if (this.ttl == null) {
                this.ttl = -1L;
            }
        }
        return this.ttl;
    }

    @Nullable
    public Long getTTL() {
        return this.ttl;
    }

    public void setTTL(long ttl) {
        this.ttl = ttl;
    }

    @Property(viewable=false, order=5)
    public long getKeySize(DBRProgressMonitor monitor) throws DBCException {
        if (this.keySize < 0L) {
            Throwable throwable = null;
            Object var3_4 = null;
            try (RedisSession session = (RedisSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Count key size");){
                RedisUtils.selectCurDatabase(session, this.getDatabase());
                this.countData((DBCExecutionSource)new AbstractExecutionSource((DBSDataContainer)this, DBUtils.getDefaultContext((DBSObject)this, (boolean)true), (Object)this), (DBCSession)session, null, 0L);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return this.keySize;
    }

    public String getDescription() {
        return null;
    }

    public DBSObject getParentObject() {
        return this.parentKey != null ? this.parentKey : this.database;
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }

    public boolean isFolder() {
        return this.isFolder;
    }

    @Association
    public List<RedisKey> getKeys(DBRProgressMonitor monitor) throws DBCException {
        if (this.subKeys == null) {
            this.subKeys = RedisUtils.getKeys(monitor, this.database, this, null, true);
        }
        return this.subKeys;
    }

    public void setSubKeys(List<String> keys, String divider) {
        if (keys == null) {
            return;
        }
        if (keys.isEmpty()) {
            if (this.subKeys == null) {
                this.subKeys = EMPTY_SUB_KEYS;
            }
            return;
        }
        for (String key : keys) {
            this.addSubKey(key, divider);
        }
    }

    public void addSubKey(@NotNull String key, @NotNull String divider) {
        List<String> foundSubKeys = RedisKey.splitSubKeys(key, divider);
        if (this.subKeys == null) {
            this.subKeys = new ArrayList<RedisKey>();
        }
        RedisKey parent = this;
        RedisKey child = null;
        int i = 0;
        while (i < foundSubKeys.size()) {
            for (RedisKey k : parent.subKeys) {
                if (!k.keyName.equals(foundSubKeys.get(i))) continue;
                child = k;
                break;
            }
            if (child == null) {
                child = new RedisKey(this.database, parent, foundSubKeys.get(i), i != foundSubKeys.size() - 1);
                parent.subKeys.add(child);
                child.subKeys = new ArrayList<RedisKey>();
            }
            if (i != foundSubKeys.size() - 1) {
                parent = child;
                child = null;
            }
            ++i;
        }
    }

    public static int findIndexOfValidDivider(@NotNull String key, @NotNull String divider) {
        int i = 0;
        while (i < key.length()) {
            int index = key.indexOf(divider, i);
            if (index == -1) {
                return -1;
            }
            if (index != i) {
                return index;
            }
            ++i;
        }
        return -1;
    }

    @NotNull
    public static List<String> splitSubKeys(@NotNull String key, @NotNull String divider) {
        String subKey;
        ArrayList<String> listOfSubKeys = new ArrayList<String>();
        do {
            String keyName;
            int divPos;
            if ((divPos = key.indexOf(divider)) == 0) {
                int newDivider = RedisKey.findIndexOfValidDivider(key, divider);
                if (newDivider != -1) {
                    subKey = key.substring(newDivider + divider.length());
                    keyName = key.substring(0, newDivider);
                } else {
                    keyName = key;
                    subKey = null;
                }
            } else if (divPos != -1) {
                subKey = key.substring(divPos + divider.length());
                keyName = key.substring(0, divPos);
            } else {
                keyName = key;
                subKey = null;
            }
            listOfSubKeys.add(keyName);
            key = subKey;
        } while (subKey != null);
        return listOfSubKeys;
    }

    @Property(viewable=true, valueTransformer=DBObjectNameCaseTransformer.class, order=2)
    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        if (this.parentKey == null) {
            return this.getName();
        }
        String keyDivider = this.getDataSource().getKeyDivider();
        StringBuilder fqn = new StringBuilder();
        RedisKey key = this;
        while (key != null) {
            if (fqn.length() > 0) {
                fqn.insert(0, keyDivider);
            }
            fqn.insert(0, key.keyName);
            key = key.parentKey;
        }
        return fqn.toString();
    }

    public String[] getSupportedFeatures() {
        return new String[]{"data.select", "data.update", "data.delete", "data.insert", "data.key.value"};
    }

    /*
     * Exception decompiling
     */
    @NotNull
    public DBCStatistics readData(@NotNull DBCExecutionSource source, @NotNull DBCSession session, @NotNull DBDDataReceiver dataReceiver, @Nullable DBDDataFilter dataFilter, long firstRow, long maxRows, long flags, int fetchSize) throws DBCException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void createSelectStatement(@NotNull DBRProgressMonitor monitor, @NotNull StringBuilder sql) {
        RedisKeyType keyType = this.getKeyType(monitor);
        switch (keyType) {
            case list: {
                sql.append("LRANGE");
                break;
            }
            case set: {
                sql.append("SMEMBERS");
                break;
            }
            case zset: {
                sql.append("ZRANGEBYSCORE");
                break;
            }
            case hash: {
                sql.append("HGETALL");
                break;
            }
            default: {
                sql.append("GET");
            }
        }
        sql.append(" ").append(this.getFullyQualifiedName(DBPEvaluationContext.DDL));
        if (keyType == RedisKeyType.list) {
            sql.append(" -100 100");
        } else if (keyType == RedisKeyType.zset) {
            sql.append(" -inf +inf");
        }
        sql.append(";");
    }

    public long countData(@NotNull DBCExecutionSource source, @NotNull DBCSession session, @Nullable DBDDataFilter dataFilter, long flags) throws DBCException {
        if (this.keySize < 0L) {
            Throwable throwable = null;
            Object var7_7 = null;
            try (RedisKeySizeStatement keyStatement = new RedisKeySizeStatement((RedisSession)session, this.getFullyQualifiedName(DBPEvaluationContext.DML), this.getKeyType(session.getProgressMonitor()));){
                keyStatement.executeStatement();
                this.keySize = keyStatement.getKeySize();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return this.keySize;
    }

    @NotNull
    public DBSDataManipulator.ExecuteBatch insertData(@NotNull DBCSession session, @NotNull DBSAttributeBase[] attributes, DBDDataReceiver keysReceiver, @NotNull DBCExecutionSource source, @NotNull Map<String, Object> options) throws DBCException {
        if (this.getKeyType(session.getProgressMonitor()) == RedisKeyType.string) {
            throw new DBCException("Can't add second value to string key");
        }
        return this.updateData(session, new DBSAttributeBase[0], attributes, keysReceiver, source);
    }

    @NotNull
    public DBSDataManipulator.ExecuteBatch updateData(@NotNull DBCSession session, @NotNull DBSAttributeBase[] updateAttributes, final @NotNull DBSAttributeBase[] keyAttributes, DBDDataReceiver keysReceiver, @NotNull DBCExecutionSource source) throws DBCException {
        return new ExecuteBatchImpl(keyAttributes, null, false, updateAttributes){
            boolean isInsert;
            {
                super($anonymous0, $anonymous1, $anonymous2);
                this.isInsert = ArrayUtils.isEmpty((Object[])dBSAttributeBaseArray);
            }

            @NotNull
            protected DBCStatement prepareStatement(@NotNull DBCSession session, DBDValueHandler[] handlers, Object[] attributeValues, Map<String, Object> options) throws DBCException {
                return new RedisKeySetStatement((RedisSession)session, RedisKey.this, RedisKey.this.getKeyType(session.getProgressMonitor()), ArrayUtils.isEmpty((Object[])keyAttributes) ? null : keyAttributes[0].getName(), null);
            }

            protected void bindStatement(@NotNull DBDValueHandler[] handlers, @NotNull DBCStatement statement, Object[] attributeValues) throws DBCException {
                RedisKeySetStatement setStatement = (RedisKeySetStatement)statement;
                if (attributeValues.length > 1) {
                    setStatement.setName(CommonUtils.toString((Object)attributeValues[this.isInsert ? 0 : 1]));
                }
                if (attributeValues.length == 1) {
                    setStatement.setValue(attributeValues[0]);
                } else {
                    setStatement.setValue(attributeValues[this.isInsert ? 1 : 0]);
                    if (attributeValues.length == 3) {
                        setStatement.setOldValue(attributeValues[this.isInsert ? 1 : 2]);
                    }
                }
            }
        };
    }

    @NotNull
    public DBSDataManipulator.ExecuteBatch deleteData(@NotNull DBCSession session, @NotNull DBSAttributeBase[] keyAttributes, @NotNull DBCExecutionSource source) throws DBCException {
        return new ExecuteBatchImpl(keyAttributes, null, false){

            @NotNull
            protected DBCStatement prepareStatement(@NotNull DBCSession session, DBDValueHandler[] handlers, Object[] attributeValues, Map<String, Object> options) throws DBCException {
                return new RedisKeySetStatement((RedisSession)session, RedisKey.this, RedisKey.this.getKeyType(session.getProgressMonitor()), null, null);
            }

            protected void bindStatement(@NotNull DBDValueHandler[] handlers, @NotNull DBCStatement statement, Object[] attributeValues) throws DBCException {
                String nameOrValue = CommonUtils.toString((Object)(attributeValues.length > 1 ? attributeValues[1] : attributeValues[0]));
                ((RedisKeySetStatement)statement).setName(nameOrValue);
            }
        };
    }

    @NotNull
    public DBCStatistics truncateData(@NotNull DBCSession session, @NotNull DBCExecutionSource source) throws DBCException {
        throw new DBCException("Truncate not supported");
    }

    public String toString() {
        return this.getFullyQualifiedName(DBPEvaluationContext.DML);
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.keyType = null;
        this.ttl = null;
        this.keySize = -1L;
        this.subKeys = null;
        return this;
    }

    @NotNull
    public DBSEntityType getEntityType() {
        return RedisConstants.TYPE_KEY;
    }

    public List<RedisKeyAttribute> getAttributes(@NotNull DBRProgressMonitor monitor) {
        if (this.attributes == null) {
            this.attributes = new ArrayList<RedisKeyAttribute>();
            switch (this.getKeyType(monitor)) {
                case string: {
                    this.attributes.add(new RedisKeyAttribute(this, "output", 0));
                    break;
                }
                case set: {
                    this.attributes.add(new RedisKeyAttribute(this, "value", 1));
                    break;
                }
                case zset: {
                    this.attributes.add(new RedisKeyAttribute(this, "score", 1));
                    this.attributes.add(new RedisKeyAttribute(this, "value", 1));
                    break;
                }
                default: {
                    this.attributes.add(new RedisKeyAttribute(this, "name", 0));
                    this.attributes.add(new RedisKeyAttribute(this, "value", 1));
                }
            }
        }
        return this.attributes;
    }

    public DBSEntityAttribute getAttribute(@NotNull DBRProgressMonitor monitor, @NotNull String attributeName) throws DBException {
        return (DBSEntityAttribute)DBUtils.findObject(this.getAttributes(monitor), (String)attributeName);
    }

    public List<RedisKeySimpleConstraint> getConstraints(@NotNull DBRProgressMonitor monitor) throws DBException {
        return Collections.singletonList(switch (this.getKeyType(monitor)) {
            case RedisKeyType.string -> new RedisKeySimpleConstraint(this);
            case RedisKeyType.zset -> new RedisKeyScoredConstraint(this);
            default -> new RedisKeyNameConstraint(this);
        });
    }

    public Collection<? extends DBSEntityAssociation> getAssociations(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    public Collection<? extends DBSEntityAssociation> getReferences(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    public void setName(String newName) {
        this.keyName = newName;
    }

    public void setKeyType(@NotNull RedisKeyType keyType) {
        this.keyType = keyType;
    }
}

