/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.redis.exec;

import com.dbeaver.db.redis.RedisUtils;
import com.dbeaver.db.redis.exec.RedisBaseResultSet;
import com.dbeaver.db.redis.exec.RedisBaseStatement;
import com.dbeaver.db.redis.exec.RedisResultSetSimple;
import com.dbeaver.db.redis.exec.RedisSession;
import java.util.List;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.qm.QMUtils;
import redis.clients.jedis.commands.ScriptingKeyCommands;

public class RedisEvalStatement
extends RedisBaseStatement {
    protected Object result;

    public RedisEvalStatement(RedisSession session, String query) {
        super(session, query);
    }

    public boolean executeStatement() throws DBCException {
        if (this.session.isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementExecuteBegin((DBCStatement)this);
        }
        try {
            RedisUtils.selectCurDatabase(this.session);
            if (this.getSession().supportsCommands(ScriptingKeyCommands.class)) {
                ScriptingKeyCommands jedis = this.session.getCommands(ScriptingKeyCommands.class);
                this.result = jedis.eval(this.getQueryString());
            } else {
                this.result = this.session.getCommands(ScriptingKeyCommands.class).eval(this.getQueryString(), List.of(this.getClusterSampleKey()), List.of());
            }
            boolean bl = this.result != null;
            return bl;
        }
        catch (Throwable e) {
            throw this.handleExecuteError(e);
        }
        finally {
            if (this.session.isLoggingEnabled()) {
                QMUtils.getDefaultHandler().handleStatementExecuteEnd((DBCStatement)this, -1L, this.executeError);
            }
        }
    }

    public RedisBaseResultSet openResultSet() throws DBCException {
        if (this.result == null) {
            return null;
        }
        return new RedisResultSetSimple(this, this.result, this.offset);
    }
}

