/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.data.importer;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.impl.local.LocalStatement;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.tools.transfer.IDataTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseTransferUtils;
import org.jkiss.dbeaver.tools.transfer.stream.StreamDataImporterColumnInfo;
import org.jkiss.dbeaver.tools.transfer.stream.StreamEntityMapping;
import org.jkiss.dbeaver.tools.transfer.stream.StreamTransferResultSet;
import org.jkiss.dbeaver.tools.transfer.stream.importer.StreamImporterAbstract;
import org.jkiss.utils.Pair;
import org.jkiss.utils.xml.SAXListener;
import org.jkiss.utils.xml.SAXReader;
import org.jkiss.utils.xml.XMLException;
import org.xml.sax.Attributes;

public class DataImporterXML
extends StreamImporterAbstract {
    private static final int MAX_COLUMN_LENGTH = 1024;
    private static final int ROW_ELEMENT = 2;
    private static final int COLUMN_ELEMENT = 3;

    @NotNull
    public List<StreamDataImporterColumnInfo> readColumnsInfo(final @NotNull StreamEntityMapping entityMapping, @NotNull InputStream inputStream) throws DBException {
        final LinkedHashMap columns = new LinkedHashMap();
        try {
            new SAXReader(inputStream).parse(new SAXListener(){
                private final StringBuilder buffer = new StringBuilder();
                private int element = 0;

                public void saxStartElement(SAXReader reader, String ns, String name, Attributes atts) {
                    ++this.element;
                }

                public void saxEndElement(SAXReader reader, String ns, String name) {
                    if (this.element == 3) {
                        String data = this.buffer.toString();
                        Pair dataType = DatabaseTransferUtils.getDataType((String)data);
                        StreamDataImporterColumnInfo columnInfo = columns.computeIfAbsent(name, key -> {
                            StreamDataImporterColumnInfo info = new StreamDataImporterColumnInfo(entityMapping, columns.size(), key, null, 1024, DBPDataKind.UNKNOWN);
                            info.setMappingMetadataPresent(true);
                            return info;
                        });
                        switch ((DBPDataKind)dataType.getFirst()) {
                            case STRING: {
                                columnInfo.updateMaxLength(entityMapping.getDataSource(), (long)data.length());
                            }
                            case BOOLEAN: 
                            case NUMERIC: {
                                columnInfo.updateType((DBPDataKind)dataType.getFirst(), (String)dataType.getSecond());
                                break;
                            }
                        }
                    }
                    --this.element;
                    this.buffer.setLength(0);
                }

                public void saxText(SAXReader reader, String data) {
                    if (this.element == 3) {
                        this.buffer.append(data);
                    }
                }
            });
        }
        catch (IOException | XMLException e) {
            throw new DBException("Error parsing XML file", e);
        }
        return new ArrayList<StreamDataImporterColumnInfo>(columns.values());
    }

    public void runImport(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSource streamDataSource, @NotNull InputStream inputStream, final @NotNull IDataTransferConsumer consumer) throws DBException {
        DBCExecutionContext context = streamDataSource.getDefaultInstance().getDefaultContext(monitor, false);
        StreamEntityMapping entityMapping = this.getSite().getSourceObject();
        Throwable throwable = null;
        Object var8_9 = null;
        try (final DBCSession producerSession = context.openSession(monitor, DBCExecutionPurpose.UTIL, "Transfer stream data");){
            LocalStatement localStatement = new LocalStatement(producerSession, "SELECT * FROM Stream");
            final StreamTransferResultSet resultSet = new StreamTransferResultSet(producerSession, (DBCStatement)localStatement, entityMapping);
            consumer.fetchStart(producerSession, (DBCResultSet)resultSet, -1L, -1L);
            try {
                try {
                    new SAXReader(inputStream).parse(new SAXListener(entityMapping){
                        private final StringBuilder buffer = new StringBuilder();
                        private final Map<String, String> values = new LinkedHashMap<String, String>();
                        private int element = 0;
                        {
                            for (StreamDataImporterColumnInfo column : streamEntityMapping.getStreamColumns()) {
                                this.values.put(column.getName(), null);
                            }
                        }

                        public void saxStartElement(SAXReader reader, String ns, String name, Attributes atts) {
                            ++this.element;
                        }

                        public void saxEndElement(SAXReader reader, String ns, String name) throws XMLException {
                            if (this.element == 3) {
                                this.values.put(name, this.buffer.toString());
                            } else if (this.element == 2) {
                                resultSet.setStreamRow(this.values.values().toArray());
                                this.values.replaceAll((k, v) -> null);
                                try {
                                    consumer.fetchRow(producerSession, (DBCResultSet)resultSet);
                                }
                                catch (DBCException e) {
                                    throw new XMLException("Error fetching row", (Throwable)e);
                                }
                            }
                            --this.element;
                            this.buffer.setLength(0);
                        }

                        public void saxText(SAXReader reader, String data) {
                            if (this.element == 3) {
                                this.buffer.append(data);
                            }
                        }
                    });
                }
                catch (IOException | XMLException e) {
                    throw new DBException("Error importing date from XML file", e);
                }
            }
            finally {
                try {
                    consumer.fetchEnd(producerSession, (DBCResultSet)resultSet);
                }
                finally {
                    consumer.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

