/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.odbc.bridge;

import com.dbeaver.jdbc.odbc.OdbcException;
import com.dbeaver.jdbc.odbc.bridge.OdbcLibrary;
import com.dbeaver.jdbc.odbc.bridge.util.OdbcUtil;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import java.sql.SQLException;
import java.util.Objects;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;

public class OdbcHandle
implements AutoCloseable {
    private final Type type;
    private Pointer pointer;

    private OdbcHandle(@NotNull Type type) {
        this.type = type;
    }

    public void open(@Nullable OdbcHandle input) throws SQLException {
        if (!this.isClosed()) {
            throw new SQLException("Handle is open");
        }
        this.pointer = OdbcHandle.allocate(this.type, input);
    }

    @NotNull
    public Type getType() {
        return this.type;
    }

    @NotNull
    public Pointer getPointer() {
        return Objects.requireNonNull(this.pointer, "Handle is closed");
    }

    public boolean isClosed() {
        return this.pointer == null;
    }

    @Override
    public void close() throws SQLException {
        if (this.pointer != null) {
            OdbcUtil.check(OdbcLibrary.INSTANCE.SQLFreeHandle(this.type, this), this);
            this.pointer = null;
        }
    }

    public String toString() {
        return "OdbcHandle{" + String.valueOf((Object)this.type) + ", " + String.valueOf(this.pointer) + "}";
    }

    @NotNull
    private static Pointer allocate(@NotNull Type type, @Nullable OdbcHandle input) throws OdbcException {
        PointerByReference output = new PointerByReference();
        if (OdbcUtil.succeeded(OdbcLibrary.INSTANCE.SQLAllocHandle(type, input, output))) {
            return output.getValue();
        }
        throw new OdbcException("Can't allocate handle of type " + String.valueOf((Object)type), null, 0);
    }

    public static final class Connection
    extends OdbcHandle {
        private Connection(@NotNull Environment environment) throws SQLException {
            super(Type.CONNECTION);
            this.open(environment);
        }

        @NotNull
        public Statement newStatementHandle() throws SQLException {
            return new Statement(this);
        }
    }

    public static final class Environment
    extends OdbcHandle {
        private Environment() {
            super(Type.ENVIRONMENT);
        }

        @NotNull
        public static Environment nullHandle() {
            return new Environment();
        }

        @NotNull
        public Connection newConnectionHandle() throws SQLException {
            return new Connection(this);
        }
    }

    public static final class Statement
    extends OdbcHandle {
        private Statement(@NotNull Connection connection) throws SQLException {
            super(Type.STATEMENT);
            this.open(connection);
        }
    }

    public static enum Type {
        ENVIRONMENT(1),
        CONNECTION(2),
        STATEMENT(3);

        private final short value;

        private Type(short value) {
            this.value = value;
        }

        public short getValue() {
            return this.value;
        }
    }
}

