/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.odbc;

import com.dbeaver.jdbc.base.AbstractJdbcConnection;
import com.dbeaver.jdbc.base.AbstractJdbcDatabaseMetaData;
import com.dbeaver.jdbc.odbc.JdbcOdbcBridgeDriver;
import com.dbeaver.jdbc.odbc.JdbcOdbcConnection;
import com.dbeaver.jdbc.odbc.JdbcOdbcResultSet;
import com.dbeaver.jdbc.odbc.JdbcOdbcResultSetMetaData;
import com.dbeaver.jdbc.odbc.JdbcOdbcStatement;
import com.dbeaver.jdbc.odbc.bridge.OdbcLibrary;
import com.dbeaver.jdbc.odbc.bridge.util.OdbcUtil;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.ShortByReference;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.util.Map;
import java.util.StringJoiner;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;

public class JdbcOdbcDatabaseMetaData
extends AbstractJdbcDatabaseMetaData<JdbcOdbcConnection> {
    private final JdbcOdbcBridgeDriver driver = new JdbcOdbcBridgeDriver();

    public JdbcOdbcDatabaseMetaData(@NotNull JdbcOdbcConnection connection, @NotNull String url) {
        super((AbstractJdbcConnection)connection, url);
    }

    public boolean allProceduresAreCallable() throws SQLException {
        return this.getInfoBoolean((short)20);
    }

    public boolean allTablesAreSelectable() throws SQLException {
        return this.getInfoBoolean((short)19);
    }

    public String getUserName() throws SQLException {
        return this.getInfoString((short)47);
    }

    public boolean isReadOnly() throws SQLException {
        return this.getInfoBoolean((short)25);
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        return this.getInfoShort((short)85) == 0;
    }

    public boolean nullsAreSortedLow() throws SQLException {
        return this.getInfoShort((short)85) == 1;
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        return this.getInfoShort((short)85) == 2;
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        return this.getInfoShort((short)85) == 4;
    }

    public String getDatabaseProductName() throws SQLException {
        return this.getInfoString((short)17);
    }

    public String getDatabaseProductVersion() throws SQLException {
        return this.getInfoString((short)18);
    }

    public String getDriverName() throws SQLException {
        return String.format("%s (%s)", "DBeaver JDBC-ODBC Bridge", this.getInfoString((short)6));
    }

    public String getDriverVersion() throws SQLException {
        return String.format("%d.%d.%d (%s)", this.driver.getMajorVersion(), this.driver.getMinorVersion(), this.driver.getMicroVersion(), this.getInfoString((short)7));
    }

    public int getDriverMajorVersion() {
        return this.driver.getMajorVersion();
    }

    public int getDriverMinorVersion() {
        return this.driver.getMajorVersion();
    }

    public boolean usesLocalFiles() throws SQLException {
        return this.getInfoShort((short)84) == 2;
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        return this.getInfoShort((short)84) == 1;
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return this.getInfoShort((short)28) == 3;
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return this.getInfoShort((short)28) == 1;
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return this.getInfoShort((short)28) == 2;
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return this.getInfoShort((short)28) == 4;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return this.getInfoShort((short)93) == 3;
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return this.getInfoShort((short)93) == 1;
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return this.getInfoShort((short)93) == 2;
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return this.getInfoShort((short)93) == 4;
    }

    public String getIdentifierQuoteString() throws SQLException {
        return this.getInfoString((short)29);
    }

    public String getSQLKeywords() throws SQLException {
        return this.getInfoString((short)89);
    }

    public String getNumericFunctions() throws SQLException {
        int info = this.getInfoInt((short)49);
        StringJoiner out = new StringJoiner(",");
        if ((info & 1) != 0) {
            out.add("ABS");
        }
        if ((info & 2) != 0) {
            out.add("ACOS");
        }
        if ((info & 4) != 0) {
            out.add("ASIN");
        }
        if ((info & 8) != 0) {
            out.add("ATAN");
        }
        if ((info & 0x10) != 0) {
            out.add("ATAN2");
        }
        if ((info & 0x20) != 0) {
            out.add("CEILING");
        }
        if ((info & 0x40) != 0) {
            out.add("COS");
        }
        if ((info & 0x80) != 0) {
            out.add("COT");
        }
        if ((info & 0x100) != 0) {
            out.add("EXP");
        }
        if ((info & 0x200) != 0) {
            out.add("FLOOR");
        }
        if ((info & 0x400) != 0) {
            out.add("LOG");
        }
        if ((info & 0x800) != 0) {
            out.add("MOD");
        }
        if ((info & 0x1000) != 0) {
            out.add("SIGN");
        }
        if ((info & 0x2000) != 0) {
            out.add("SIN");
        }
        if ((info & 0x4000) != 0) {
            out.add("SQRT");
        }
        if ((info & 0x8000) != 0) {
            out.add("TAN");
        }
        if ((info & 0x10000) != 0) {
            out.add("PI");
        }
        if ((info & 0x20000) != 0) {
            out.add("RAND");
        }
        if ((info & 0x40000) != 0) {
            out.add("DEGREES");
        }
        if ((info & 0x80000) != 0) {
            out.add("LOG10");
        }
        if ((info & 0x100000) != 0) {
            out.add("POWER");
        }
        if ((info & 0x200000) != 0) {
            out.add("RADIANS");
        }
        if ((info & 0x400000) != 0) {
            out.add("ROUND");
        }
        if ((info & 0x800000) != 0) {
            out.add("TRUNCATE");
        }
        return out.toString();
    }

    public String getStringFunctions() throws SQLException {
        int info = this.getInfoInt((short)50);
        StringJoiner out = new StringJoiner(",");
        if ((info & 1) != 0) {
            out.add("CONCAT");
        }
        if ((info & 2) != 0) {
            out.add("INSERT");
        }
        if ((info & 4) != 0) {
            out.add("LEFT");
        }
        if ((info & 8) != 0) {
            out.add("LTRIM");
        }
        if ((info & 0x10) != 0) {
            out.add("LENGTH");
        }
        if ((info & 0x20) != 0) {
            out.add("LOCATE");
        }
        if ((info & 0x40) != 0) {
            out.add("LCASE");
        }
        if ((info & 0x80) != 0) {
            out.add("REPEAT");
        }
        if ((info & 0x100) != 0) {
            out.add("REPLACE");
        }
        if ((info & 0x200) != 0) {
            out.add("RIGHT");
        }
        if ((info & 0x400) != 0) {
            out.add("RTRIM");
        }
        if ((info & 0x800) != 0) {
            out.add("SUBSTRING");
        }
        if ((info & 0x1000) != 0) {
            out.add("UCASE");
        }
        if ((info & 0x2000) != 0) {
            out.add("ASCII");
        }
        if ((info & 0x4000) != 0) {
            out.add("CHAR");
        }
        if ((info & 0x8000) != 0) {
            out.add("DIFFERENCE");
        }
        if ((info & 0x10000) != 0) {
            out.add("LOCATE_2");
        }
        if ((info & 0x20000) != 0) {
            out.add("SOUNDEX");
        }
        if ((info & 0x40000) != 0) {
            out.add("SPACE");
        }
        if ((info & 0x80000) != 0) {
            out.add("BIT_LENGTH");
        }
        if ((info & 0x100000) != 0) {
            out.add("CHAR_LENGTH");
        }
        if ((info & 0x200000) != 0) {
            out.add("CHARACTER_LENGTH");
        }
        if ((info & 0x400000) != 0) {
            out.add("OCTET_LENGTH");
        }
        if ((info & 0x800000) != 0) {
            out.add("POSITION");
        }
        return out.toString();
    }

    public String getSystemFunctions() throws SQLException {
        int info = this.getInfoInt((short)51);
        StringJoiner out = new StringJoiner(",");
        if ((info & 1) != 0) {
            out.add("USERNAME");
        }
        if ((info & 2) != 0) {
            out.add("DBNAME");
        }
        if ((info & 4) != 0) {
            out.add("IFNULL");
        }
        return out.toString();
    }

    public String getTimeDateFunctions() throws SQLException {
        int info = this.getInfoInt((short)52);
        StringJoiner out = new StringJoiner(",");
        if ((info & 1) != 0) {
            out.add("NOW");
        }
        if ((info & 2) != 0) {
            out.add("CURDATE");
        }
        if ((info & 4) != 0) {
            out.add("DAYOFMONTH");
        }
        if ((info & 8) != 0) {
            out.add("DAYOFWEEK");
        }
        if ((info & 0x10) != 0) {
            out.add("DAYOFYEAR");
        }
        if ((info & 0x20) != 0) {
            out.add("MONTH");
        }
        if ((info & 0x40) != 0) {
            out.add("QUARTER");
        }
        if ((info & 0x80) != 0) {
            out.add("WEEK");
        }
        if ((info & 0x100) != 0) {
            out.add("YEAR");
        }
        if ((info & 0x200) != 0) {
            out.add("CURTIME");
        }
        if ((info & 0x400) != 0) {
            out.add("HOUR");
        }
        if ((info & 0x800) != 0) {
            out.add("MINUTE");
        }
        if ((info & 0x1000) != 0) {
            out.add("SECOND");
        }
        if ((info & 0x2000) != 0) {
            out.add("TIMESTAMPADD");
        }
        if ((info & 0x4000) != 0) {
            out.add("TIMESTAMPDIFF");
        }
        if ((info & 0x8000) != 0) {
            out.add("DAYNAME");
        }
        if ((info & 0x10000) != 0) {
            out.add("MONTHNAME");
        }
        if ((info & 0x20000) != 0) {
            out.add("CURRENT_DATE");
        }
        if ((info & 0x40000) != 0) {
            out.add("CURRENT_TIME");
        }
        if ((info & 0x80000) != 0) {
            out.add("CURRENT_TIMESTAMP");
        }
        if ((info & 0x100000) != 0) {
            out.add("EXTRACT");
        }
        return out.toString();
    }

    public String getSearchStringEscape() throws SQLException {
        return this.getInfoString((short)14);
    }

    public String getExtraNameCharacters() throws SQLException {
        return this.getInfoString((short)94);
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return (this.getInfoInt((short)86) & 1) != 0;
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return (this.getInfoInt((short)86) & 2) != 0;
    }

    public boolean supportsColumnAliasing() throws SQLException {
        return this.getInfoBoolean((short)87);
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        return this.getInfoShort((short)22) == 0;
    }

    public boolean supportsConvert() throws SQLException {
        return (this.getInfoInt((short)48) & 1) > 0;
    }

    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        int to;
        short from;
        switch (fromType) {
            case -5: {
                from = 53;
                break;
            }
            case -2: {
                from = 54;
                break;
            }
            case -7: {
                from = 55;
                break;
            }
            case 1: {
                from = 56;
                break;
            }
            case 91: {
                from = 57;
                break;
            }
            case 3: {
                from = 58;
                break;
            }
            case 8: {
                from = 59;
                break;
            }
            case 6: {
                from = 60;
                break;
            }
            case 4: {
                from = 61;
                break;
            }
            case -1: {
                from = 62;
                break;
            }
            case 2: {
                from = 63;
                break;
            }
            case 7: {
                from = 64;
                break;
            }
            case 5: {
                from = 65;
                break;
            }
            case 92: {
                from = 66;
                break;
            }
            case 93: {
                from = 67;
                break;
            }
            case -6: {
                from = 68;
                break;
            }
            case -3: {
                from = 69;
                break;
            }
            case 12: {
                from = 70;
                break;
            }
            case -4: {
                from = 71;
                break;
            }
            default: {
                return false;
            }
        }
        switch (toType) {
            case -5: {
                to = 16384;
                break;
            }
            case -2: {
                to = 1024;
                break;
            }
            case -7: {
                to = 4096;
                break;
            }
            case 1: {
                to = 1;
                break;
            }
            case 91: {
                to = 32768;
                break;
            }
            case 3: {
                to = 4;
                break;
            }
            case 8: {
                to = 128;
                break;
            }
            case 6: {
                to = 32;
                break;
            }
            case 4: {
                to = 8;
                break;
            }
            case -1: {
                to = 512;
                break;
            }
            case 2: {
                to = 2;
                break;
            }
            case 7: {
                to = 64;
                break;
            }
            case 5: {
                to = 16;
                break;
            }
            case 92: {
                to = 65536;
                break;
            }
            case 93: {
                to = 131072;
                break;
            }
            case -6: {
                to = 8192;
                break;
            }
            case -3: {
                to = 2048;
                break;
            }
            case 12: {
                to = 256;
                break;
            }
            case -4: {
                to = 262144;
                break;
            }
            default: {
                return false;
            }
        }
        return (this.getInfoInt(from) & to) != 0;
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        return this.getInfoShort((short)74) != 0;
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return this.getInfoShort((short)74) != 1;
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return this.getInfoBoolean((short)27);
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        return !this.getInfoBoolean((short)90);
    }

    public boolean supportsGroupBy() throws SQLException {
        return this.getInfoShort((short)88) != 0;
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        return this.getInfoShort((short)88) == 3;
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return this.getInfoShort((short)88) == 2;
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        return this.getInfoBoolean((short)113);
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        return this.getInfoBoolean((short)36);
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        return this.getInfoBoolean((short)37);
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        return this.getInfoShort((short)75) == 1;
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        switch (this.getInfoShort((short)15)) {
            case 0: 
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        switch (this.getInfoShort((short)15)) {
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return this.getInfoShort((short)15) == 2;
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return (this.getInfoInt((short)118) & 1) != 0;
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return (this.getInfoInt((short)118) & 4) != 0;
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        return (this.getInfoInt((short)118) & 8) != 0;
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return this.getInfoBoolean((short)73);
    }

    public boolean supportsOuterJoins() throws SQLException {
        switch (this.getInfoString((short)38)) {
            case "F": 
            case "N": 
            case "Y": {
                return true;
            }
        }
        return false;
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        return "F".equals(this.getInfoString((short)38));
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        return "N".equals(this.getInfoString((short)38));
    }

    public String getSchemaTerm() throws SQLException {
        return this.getInfoString((short)39);
    }

    public String getProcedureTerm() throws SQLException {
        return this.getInfoString((short)40);
    }

    public String getCatalogTerm() throws SQLException {
        return this.getInfoString((short)42);
    }

    public boolean isCatalogAtStart() throws SQLException {
        return this.getInfoShort((short)114) == 1;
    }

    public String getCatalogSeparator() throws SQLException {
        return this.getInfoString((short)41);
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return (this.getInfoInt((short)91) & 1) != 0;
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return (this.getInfoInt((short)91) & 2) != 0;
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return (this.getInfoInt((short)91) & 4) != 0;
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return (this.getInfoInt((short)91) & 8) != 0;
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return (this.getInfoInt((short)91) & 0x10) != 0;
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return (this.getInfoInt((short)92) & 1) != 0;
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return (this.getInfoInt((short)92) & 2) != 0;
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return (this.getInfoInt((short)92) & 4) != 0;
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return (this.getInfoInt((short)92) & 8) != 0;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return (this.getInfoInt((short)92) & 0x10) != 0;
    }

    public boolean supportsPositionedDelete() throws SQLException {
        return (this.getInfoInt((short)80) & 1) != 0;
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        return (this.getInfoInt((short)80) & 2) != 0;
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        return (this.getInfoInt((short)80) & 4) != 0;
    }

    public boolean supportsStoredProcedures() throws SQLException {
        return this.getInfoBoolean((short)21);
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return (this.getInfoInt((short)95) & 1) != 0;
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        return (this.getInfoInt((short)95) & 2) != 0;
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        return (this.getInfoInt((short)95) & 4) != 0;
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return (this.getInfoInt((short)95) & 8) != 0;
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return (this.getInfoInt((short)95) & 0x10) != 0;
    }

    public boolean supportsUnion() throws SQLException {
        return (this.getInfoInt((short)96) & 1) != 0;
    }

    public boolean supportsUnionAll() throws SQLException {
        return (this.getInfoInt((short)96) & 2) != 0;
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return this.getInfoShort((short)23) == 2;
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return this.getInfoShort((short)24) == 2;
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return this.getInfoShort((short)23) != 0;
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return this.getInfoShort((short)24) != 0;
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        return this.getInfoInt((short)112);
    }

    public int getMaxCharLiteralLength() throws SQLException {
        return this.getInfoInt((short)108);
    }

    public int getMaxColumnNameLength() throws SQLException {
        return this.getInfoShort((short)30);
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        return this.getInfoShort((short)97);
    }

    public int getMaxColumnsInIndex() throws SQLException {
        return this.getInfoShort((short)98);
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        return this.getInfoShort((short)99);
    }

    public int getMaxColumnsInSelect() throws SQLException {
        return this.getInfoShort((short)100);
    }

    public int getMaxColumnsInTable() throws SQLException {
        return this.getInfoShort((short)101);
    }

    public int getMaxConnections() throws SQLException {
        return this.getInfoShort((short)0);
    }

    public int getMaxCursorNameLength() throws SQLException {
        return this.getInfoShort((short)31);
    }

    public int getMaxIndexLength() throws SQLException {
        return this.getInfoShort((short)102);
    }

    public int getMaxSchemaNameLength() throws SQLException {
        return this.getInfoShort((short)32);
    }

    public int getMaxProcedureNameLength() throws SQLException {
        return this.getInfoShort((short)33);
    }

    public int getMaxCatalogNameLength() throws SQLException {
        return this.getInfoShort((short)34);
    }

    public int getMaxRowSize() throws SQLException {
        return this.getInfoShort((short)104);
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return this.getInfoBoolean((short)103);
    }

    public int getMaxStatementLength() throws SQLException {
        return this.getInfoShort((short)105);
    }

    public int getMaxStatements() throws SQLException {
        return this.getInfoShort((short)1);
    }

    public int getMaxTableNameLength() throws SQLException {
        return this.getInfoShort((short)35);
    }

    public int getMaxTablesInSelect() throws SQLException {
        return this.getInfoShort((short)106);
    }

    public int getMaxUserNameLength() throws SQLException {
        return this.getInfoShort((short)107);
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        return this.getInfoInt((short)26);
    }

    public boolean supportsTransactions() throws SQLException {
        return this.getInfoShort((short)46) != 0;
    }

    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        return (this.getInfoInt((short)72) & level) != 0;
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return this.getInfoShort((short)46) != 2;
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return this.getInfoShort((short)46) != 1;
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return this.getInfoShort((short)46) != 3;
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return this.getInfoShort((short)46) != 4;
    }

    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        return this.getProcedures(catalog, schemaPattern, functionNamePattern);
    }

    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        return this.getProcedureColumns(catalog, schemaPattern, functionNamePattern, columnNamePattern);
    }

    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        JdbcOdbcStatement statement = (JdbcOdbcStatement)((Object)((JdbcOdbcConnection)this.connection).createStatement());
        OdbcUtil.check(OdbcLibrary.INSTANCE.SQLProceduresW(statement.getHandle(), catalog, (short)-3, schemaPattern, (short)-3, procedureNamePattern, (short)-3), statement.getHandle());
        return statement.createResultSet(true);
    }

    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        JdbcOdbcStatement statement = (JdbcOdbcStatement)((Object)((JdbcOdbcConnection)this.connection).createStatement());
        OdbcUtil.check(OdbcLibrary.INSTANCE.SQLProcedureColumnsW(statement.getHandle(), catalog, (short)-3, schemaPattern, (short)-3, procedureNamePattern, (short)-3, columnNamePattern, (short)-3), statement.getHandle());
        return statement.createResultSet(true);
    }

    public JdbcOdbcResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        return this.prepareGetTables(catalog, schemaPattern, tableNamePattern, types).createResultSet(true);
    }

    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        JdbcOdbcStatement statement = (JdbcOdbcStatement)((Object)((JdbcOdbcConnection)this.connection).createStatement());
        OdbcUtil.check(OdbcLibrary.INSTANCE.SQLColumnsW(statement.getHandle(), catalog, (short)-3, schemaPattern, (short)-3, tableNamePattern, (short)-3, columnNamePattern, (short)-3), statement.getHandle());
        return statement.createResultSet(true);
    }

    public ResultSet getSchemas() throws SQLException {
        JdbcOdbcStatement statement = this.prepareGetTables("", "%", "", null);
        JdbcOdbcResultSetMetaData metadata = new JdbcOdbcResultSetMetaData(statement, Map.of("TABLE_CAT", "TABLE_CATALOG"), new int[]{2, 1});
        return statement.createResultSet(metadata, true);
    }

    public ResultSet getCatalogs() throws SQLException {
        JdbcOdbcStatement statement = this.prepareGetTables("%", "", "", null);
        JdbcOdbcResultSetMetaData metadata = new JdbcOdbcResultSetMetaData(statement, null, new int[]{1});
        return statement.createResultSet(metadata, true);
    }

    public ResultSet getTableTypes() throws SQLException {
        JdbcOdbcStatement statement = this.prepareGetTables(null, null, "%", null);
        JdbcOdbcResultSetMetaData metadata = new JdbcOdbcResultSetMetaData(statement, null, new int[]{4});
        return statement.createResultSet(metadata, true);
    }

    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        throw OdbcUtil.notImplemented();
    }

    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        throw OdbcUtil.notImplemented();
    }

    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        throw OdbcUtil.notImplemented();
    }

    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        throw OdbcUtil.notImplemented();
    }

    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        JdbcOdbcStatement statement = (JdbcOdbcStatement)((Object)((JdbcOdbcConnection)this.connection).createStatement());
        OdbcUtil.check(OdbcLibrary.INSTANCE.SQLPrimaryKeysW(statement.getHandle(), catalog, (short)-3, schema, (short)-3, table, (short)-3), statement.getHandle());
        return statement.createResultSet(true);
    }

    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        return this.getCrossReference(null, null, null, catalog, schema, table);
    }

    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        return this.getCrossReference(catalog, schema, table, null, null, null);
    }

    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        JdbcOdbcStatement statement = (JdbcOdbcStatement)((Object)((JdbcOdbcConnection)this.connection).createStatement());
        OdbcUtil.check(OdbcLibrary.INSTANCE.SQLForeignKeysW(statement.getHandle(), parentCatalog, (short)-3, parentSchema, (short)-3, parentTable, (short)-3, foreignCatalog, (short)-3, foreignSchema, (short)-3, foreignTable, (short)-3), statement.getHandle());
        return statement.createResultSet(true);
    }

    public ResultSet getTypeInfo() throws SQLException {
        JdbcOdbcStatement statement = (JdbcOdbcStatement)((Object)((JdbcOdbcConnection)this.connection).createStatement());
        OdbcUtil.check(OdbcLibrary.INSTANCE.SQLGetTypeInfoW(statement.getHandle(), (short)0), statement.getHandle());
        JdbcOdbcResultSetMetaData metadata = new JdbcOdbcResultSetMetaData(statement, Map.of("COLUMN_SIZE", "PRECISION"), null);
        return statement.createResultSet(metadata, true);
    }

    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        JdbcOdbcStatement statement = (JdbcOdbcStatement)((Object)((JdbcOdbcConnection)this.connection).createStatement());
        OdbcUtil.check(OdbcLibrary.INSTANCE.SQLStatisticsW(statement.getHandle(), catalog, (short)-3, schema, (short)-3, table, (short)-3, unique ? (short)1 : 0, approximate ? (short)0 : 1), statement.getHandle());
        return statement.createResultSet(true);
    }

    public boolean supportsResultSetType(int type) throws SQLException {
        return type == 1003;
    }

    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        return false;
    }

    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        throw OdbcUtil.notImplemented();
    }

    public boolean ownDeletesAreVisible(int type) throws SQLException {
        throw OdbcUtil.notImplemented();
    }

    public boolean ownInsertsAreVisible(int type) throws SQLException {
        throw OdbcUtil.notImplemented();
    }

    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        throw OdbcUtil.notImplemented();
    }

    public boolean othersDeletesAreVisible(int type) throws SQLException {
        throw OdbcUtil.notImplemented();
    }

    public boolean othersInsertsAreVisible(int type) throws SQLException {
        throw OdbcUtil.notImplemented();
    }

    public boolean updatesAreDetected(int type) throws SQLException {
        throw OdbcUtil.notImplemented();
    }

    public boolean deletesAreDetected(int type) throws SQLException {
        throw OdbcUtil.notImplemented();
    }

    public boolean insertsAreDetected(int type) throws SQLException {
        throw OdbcUtil.notImplemented();
    }

    public boolean supportsBatchUpdates() throws SQLException {
        throw OdbcUtil.notSupported();
    }

    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        throw OdbcUtil.notSupported();
    }

    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    public boolean supportsSavepoints() {
        return false;
    }

    public boolean supportsNamedParameters() {
        return false;
    }

    public boolean supportsMultipleOpenResults() {
        return false;
    }

    public boolean supportsGetGeneratedKeys() {
        return false;
    }

    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        throw OdbcUtil.notSupported();
    }

    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        throw OdbcUtil.notSupported();
    }

    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        throw OdbcUtil.notSupported();
    }

    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        switch (holdability) {
            case 1: {
                return this.supportsOpenCursorsAcrossCommit();
            }
            case 2: {
                return true;
            }
        }
        return false;
    }

    public int getResultSetHoldability() throws SQLException {
        switch (this.getInfoShort((short)23)) {
            case 2: {
                return 1;
            }
            case 1: {
                return 2;
            }
        }
        throw new SQLException("holdability is not supported");
    }

    public int getDatabaseMajorVersion() throws SQLException {
        int[] segments = this.getDatabaseVersionSegments();
        if (segments != null) {
            return segments[0];
        }
        throw OdbcUtil.notImplemented();
    }

    public int getDatabaseMinorVersion() throws SQLException {
        int[] segments = this.getDatabaseVersionSegments();
        if (segments != null) {
            return segments[1];
        }
        throw OdbcUtil.notImplemented();
    }

    public int getJDBCMajorVersion() {
        return 4;
    }

    public int getJDBCMinorVersion() {
        return 2;
    }

    public int getSQLStateType() {
        return 1;
    }

    public boolean locatorsUpdateCopy() throws SQLException {
        throw OdbcUtil.notSupported();
    }

    public boolean supportsStatementPooling() throws SQLException {
        throw OdbcUtil.notSupported();
    }

    public RowIdLifetime getRowIdLifetime() throws SQLException {
        throw OdbcUtil.notSupported();
    }

    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        throw OdbcUtil.notImplemented();
    }

    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        throw OdbcUtil.notSupported();
    }

    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        throw OdbcUtil.notSupported();
    }

    public ResultSet getClientInfoProperties() throws SQLException {
        throw OdbcUtil.notSupported();
    }

    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        throw OdbcUtil.notImplemented();
    }

    public boolean generatedKeyAlwaysReturned() {
        return false;
    }

    @NotNull
    private JdbcOdbcStatement prepareGetTables(@Nullable String catalog, @Nullable String schemaPattern, @Nullable String tableNamePattern, @Nullable String[] types) throws SQLException {
        JdbcOdbcStatement statement = (JdbcOdbcStatement)((Object)((JdbcOdbcConnection)this.connection).createStatement());
        OdbcUtil.check(OdbcLibrary.INSTANCE.SQLTablesW(statement.getHandle(), catalog, (short)-3, schemaPattern, (short)-3, tableNamePattern, (short)-3, types != null ? String.join((CharSequence)",", types) : null, (short)-3), statement.getHandle());
        return statement;
    }

    @Nullable
    private int[] getDatabaseVersionSegments() throws SQLException {
        String version = this.getDatabaseProductVersion();
        String[] segments = version.split("\\.", 3);
        if (segments.length >= 2) {
            return new int[]{Integer.parseInt(segments[0]), Integer.parseInt(segments[1])};
        }
        return null;
    }

    @NotNull
    private String getInfoString(short type) throws SQLException {
        ShortByReference stringLength = new ShortByReference();
        OdbcUtil.check(OdbcLibrary.INSTANCE.SQLGetInfoW(((JdbcOdbcConnection)this.connection).getHandle(), type, null, (short)0, stringLength), ((JdbcOdbcConnection)this.connection).getHandle());
        Throwable throwable = null;
        Object var4_5 = null;
        try (Memory string = new Memory((long)stringLength.getValue() * (long)Native.WCHAR_SIZE + 1L);){
            OdbcUtil.check(OdbcLibrary.INSTANCE.SQLGetInfoW(((JdbcOdbcConnection)this.connection).getHandle(), type, (Pointer)string, (short)(string.size() - 1L), null), ((JdbcOdbcConnection)this.connection).getHandle());
            return string.getWideString(0L);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private int getInfoInt(short type) throws SQLException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Memory result = new Memory(4L);){
            OdbcUtil.check(OdbcLibrary.INSTANCE.SQLGetInfoW(((JdbcOdbcConnection)this.connection).getHandle(), type, (Pointer)result, (short)result.size(), null), ((JdbcOdbcConnection)this.connection).getHandle());
            return result.getInt(0L);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private int getInfoShort(short type) throws SQLException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Memory result = new Memory(2L);){
            OdbcUtil.check(OdbcLibrary.INSTANCE.SQLGetInfoW(((JdbcOdbcConnection)this.connection).getHandle(), type, (Pointer)result, (short)result.size(), null), ((JdbcOdbcConnection)this.connection).getHandle());
            return result.getShort(0L) & 0xFFFF;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private boolean getInfoBoolean(short type) throws SQLException {
        return "Y".equals(this.getInfoString(type));
    }
}

