/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.data.transfer.ui;

import com.dbeaver.data.transfer.mail.SMTPAuthentication;
import com.dbeaver.data.transfer.mail.SMTPProfile;
import com.dbeaver.data.transfer.mail.SMTPProfileManager;
import com.dbeaver.data.transfer.ui.internal.DTEEMessages;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ListContentProvider;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.ui.preferences.AbstractPrefPage;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.SecurityUtils;

public class PrefPageMail
extends AbstractPrefPage
implements IWorkbenchPreferencePage {
    public static final String PAGE_ID = "com.dbeaver.preferences.mail";
    private final List<SMTPProfile> profiles = new ArrayList<SMTPProfile>();
    private ListViewer profilesViewer;

    public void init(IWorkbench workbench) {
    }

    @NotNull
    protected Control createPreferenceContent(@NotNull Composite parent) {
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)1);
        Group group = UIUtils.createControlGroup((Composite)composite, (String)DTEEMessages.pref_page_mail_group_profiles, (int)2, (int)768, (int)300);
        this.profilesViewer = new ListViewer((Composite)group, 2820);
        this.profilesViewer.getList().setLayoutData((Object)new GridData(4, 4, true, true));
        this.profilesViewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.profilesViewer.setInput(this.profiles);
        ToolBar toolbar = new ToolBar((Composite)group, 512);
        toolbar.setLayoutData((Object)GridDataFactory.fillDefaults().align(1, 1).create());
        UIUtils.createToolItem((ToolBar)toolbar, (String)DTEEMessages.pref_page_mail_group_profiles_button_add, (DBPImage)UIIcon.ADD, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SMTPProfile profile = PrefPageMail.this.promptForProfile(null);
                if (profile != null) {
                    PrefPageMail.this.profiles.add(profile);
                    PrefPageMail.this.profilesViewer.refresh();
                }
            }
        });
        ToolItem removeItem = UIUtils.createToolItem((ToolBar)toolbar, (String)DTEEMessages.pref_page_mail_group_profiles_button_remove, (DBPImage)UIIcon.DELETE, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = PrefPageMail.this.profilesViewer.getList().getSelectionIndex();
                SMTPProfile smtpProfile = PrefPageMail.this.profiles.get(index);
                if (!UIUtils.confirmAction((Shell)PrefPageMail.this.getShell(), (String)"Profile delete", (String)("Are you sure you want to delete SMTP profile for '" + smtpProfile.getHostname() + "'"))) {
                    return;
                }
                PrefPageMail.this.profiles.remove(index);
                PrefPageMail.this.profilesViewer.refresh();
                PrefPageMail.this.profilesViewer.getList().select(CommonUtils.clamp((int)index, (int)0, (int)(PrefPageMail.this.profilesViewer.getList().getItemCount() - 1)));
                PrefPageMail.this.profilesViewer.getList().notifyListeners(13, new Event());
            }
        });
        ToolItem editItem = UIUtils.createToolItem((ToolBar)toolbar, (String)DTEEMessages.pref_page_mail_group_profiles_button_edit, (DBPImage)UIIcon.EDIT, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SMTPProfile original = (SMTPProfile)PrefPageMail.this.profilesViewer.getStructuredSelection().getFirstElement();
                SMTPProfile profile = PrefPageMail.this.promptForProfile(original);
                if (profile != null) {
                    int index = PrefPageMail.this.profiles.indexOf(original);
                    PrefPageMail.this.profiles.set(index, profile);
                    PrefPageMail.this.profilesViewer.refresh();
                    PrefPageMail.this.profilesViewer.getList().select(index);
                    PrefPageMail.this.profilesViewer.getList().notifyListeners(13, new Event());
                }
            }
        });
        Composite buttonComposite = UIUtils.createComposite((Composite)group, (int)2);
        buttonComposite.setLayoutData((Object)new GridData(768));
        UIUtils.createEmptyLabel((Composite)buttonComposite, (int)1, (int)1).setLayoutData((Object)new GridData(768));
        Button connectionTestButton = UIUtils.createDialogButton((Composite)buttonComposite, (String)DTEEMessages.pref_page_mail_group_profiles_button_test, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SMTPProfile profile = (SMTPProfile)PrefPageMail.this.profilesViewer.getStructuredSelection().getFirstElement();
                try {
                    UIUtils.getDialogRunnableContext().run(true, true, monitor -> {
                        PrefPageMail.this.testConnection(monitor, profile);
                        DBWorkbench.getPlatformUI().showMessageBox(DTEEMessages.pref_page_mail_group_profiles_test_success_title, DTEEMessages.pref_page_mail_group_profiles_test_success_message, false);
                    });
                }
                catch (InvocationTargetException e) {
                    DBWorkbench.getPlatformUI().showError(DTEEMessages.pref_page_mail_group_profiles_test_error_title, DTEEMessages.pref_page_mail_group_profiles_test_error_message, e.getTargetException());
                }
                catch (InterruptedException interruptedException) {}
            }
        });
        this.profilesViewer.addSelectionChangedListener(event -> {
            boolean enabled = !this.profilesViewer.getStructuredSelection().isEmpty();
            removeItem.setEnabled(enabled);
            editItem.setEnabled(enabled);
            connectionTestButton.setEnabled(enabled);
        });
        this.setSettings();
        return composite;
    }

    public boolean performOk() {
        SMTPProfileManager.setProfiles(this.profiles);
        return true;
    }

    private void setSettings() {
        this.profiles.clear();
        this.profiles.addAll(SMTPProfileManager.getProfiles());
        this.profilesViewer.refresh();
        this.profilesViewer.getList().notifyListeners(13, new Event());
    }

    protected void performDefaults() {
        this.profiles.clear();
        this.profilesViewer.refresh();
    }

    @Nullable
    private SMTPProfile promptForProfile(@Nullable SMTPProfile profile) {
        ConfigurationDialog dialog = new ConfigurationDialog(this.getShell(), profile);
        if (dialog.open() == 0) {
            return dialog.getValue();
        }
        return null;
    }

    private void testConnection(@NotNull DBRProgressMonitor monitor, @NotNull SMTPProfile profile) throws InvocationTargetException {
        monitor.beginTask("Test SMTP connection to " + String.valueOf(profile), 1);
        try {
            try {
                profile.testConnection(monitor);
            }
            catch (DBException e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            monitor.done();
        }
    }

    private static class ConfigurationDialog
    extends BaseDialog {
        private final SMTPProfile source;
        private String hostname;
        private int port;
        private String username;
        private String password;
        private Text passwordText;

        public ConfigurationDialog(@NotNull Shell shell, @Nullable SMTPProfile source) {
            super(shell, source != null ? DTEEMessages.pref_page_mail_group_profiles_dialog_edit_title : DTEEMessages.pref_page_mail_group_profiles_dialog_new_title, null);
            this.source = source;
            this.hostname = source != null ? source.getHostname() : "";
            this.port = source != null ? source.getPort() : 587;
            this.username = source != null && source.getAuthentication() != null ? source.getAuthentication().getUsername() : null;
            this.password = source != null && source.getAuthentication() != null ? source.getAuthentication().getPassword() : null;
            this.setShellStyle(67696);
        }

        protected Composite createDialogArea(Composite parent) {
            Composite composite = super.createDialogArea(parent);
            Composite inner = UIUtils.createPlaceholder((Composite)composite, (int)4, (int)5);
            inner.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).hint(350, -1).create());
            Text hostText = UIUtils.createLabelText((Composite)inner, (String)DTEEMessages.pref_page_mail_group_profiles_dialog_host, (String)"");
            hostText.setText(CommonUtils.notEmpty((String)this.hostname));
            hostText.addModifyListener(e -> {
                this.hostname = hostText.getText();
                this.updateCompletion();
            });
            Text portText = UIUtils.createLabelText((Composite)inner, (String)DTEEMessages.pref_page_mail_group_profiles_dialog_port, (String)"");
            portText.setText(Integer.toString(this.port));
            portText.addVerifyListener(UIUtils.getIntegerVerifyListener((Locale)Locale.getDefault()));
            portText.addModifyListener(e -> {
                this.port = CommonUtils.toInt((Object)portText.getText());
                this.updateCompletion();
            });
            Text usernameText = UIUtils.createLabelText((Composite)inner, (String)DTEEMessages.pref_page_mail_group_profiles_dialog_username, (String)"");
            usernameText.setText(CommonUtils.notEmpty((String)this.username));
            usernameText.addModifyListener(e -> {
                this.username = CommonUtils.isEmptyTrimmed((String)usernameText.getText()) ? null : usernameText.getText();
                this.updateCompletion();
            });
            ((GridData)usernameText.getLayoutData()).horizontalSpan = 3;
            this.passwordText = UIUtils.createLabelText((Composite)inner, (String)DTEEMessages.pref_page_mail_group_profiles_dialog_password, (String)"", (int)0x400800);
            this.passwordText.setText(CommonUtils.notEmpty((String)this.password));
            this.passwordText.addModifyListener(e -> {
                this.password = CommonUtils.isEmptyTrimmed((String)this.passwordText.getText()) ? null : this.passwordText.getText();
                this.updateCompletion();
            });
            ((GridData)this.passwordText.getLayoutData()).horizontalSpan = 3;
            return composite;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            super.createButtonsForButtonBar(parent);
            this.updateCompletion();
        }

        @NotNull
        public SMTPProfile getValue() {
            return new SMTPProfile(this.source != null ? this.source.getId() : SecurityUtils.generateUniqueId(), this.hostname, this.port, this.username != null ? new SMTPAuthentication(this.username, CommonUtils.notEmpty((String)this.password)) : null);
        }

        private void updateCompletion() {
            boolean isHostnameValid = !CommonUtils.isEmptyTrimmed((String)this.hostname) && this.port > 0;
            boolean isCredentialsValid = CommonUtils.isEmptyTrimmed((String)this.username) || !CommonUtils.isEmptyTrimmed((String)this.password);
            this.passwordText.setEnabled(!CommonUtils.isEmptyTrimmed((String)this.username));
            this.getButton(0).setEnabled(isHostnameValid && isCredentialsValid);
        }
    }
}

