/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.sybase.model;

import com.dbeaver.db.sybase.model.SybaseDataSource;
import java.sql.ResultSet;
import java.util.Date;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPSystemObject;
import org.jkiss.dbeaver.model.access.DBAUser;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class SybaseUser
implements DBAUser,
DBPSystemObject {
    private SybaseDataSource sybaseDataSource;
    private String name;
    private long userId;
    private long failedLoginAttempts;
    private Date passCreationTime;
    private Date lastLoginTime;
    private boolean expPasswordOnLogin;
    private String description;

    SybaseUser(SybaseDataSource sybaseDataSource, String name, @NotNull JDBCResultSet resultSet) {
        this.sybaseDataSource = sybaseDataSource;
        this.name = name;
        this.userId = JDBCUtils.safeGetLong((ResultSet)resultSet, (String)"user_id");
        this.description = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"remarks");
        this.failedLoginAttempts = JDBCUtils.safeGetLong((ResultSet)resultSet, (String)"failed_login_attempts");
        this.passCreationTime = JDBCUtils.safeGetTimestamp((ResultSet)resultSet, (String)"password_creation_time");
        this.lastLoginTime = JDBCUtils.safeGetTimestamp((ResultSet)resultSet, (String)"last_login_time");
        this.expPasswordOnLogin = JDBCUtils.safeGetBoolean((ResultSet)resultSet, (String)"expire_password_on_login");
    }

    @Nullable
    public DBSObject getParentObject() {
        return this.sybaseDataSource;
    }

    @Nullable
    public DBPDataSource getDataSource() {
        return this.sybaseDataSource;
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Property(viewable=true, order=2)
    public long getUserId() {
        return this.userId;
    }

    @Property(viewable=true, order=3)
    public long getFailedLoginAttempts() {
        return this.failedLoginAttempts;
    }

    @Property(viewable=true, order=4)
    public Date getPassCreationTime() {
        return this.passCreationTime;
    }

    @Property(viewable=true, order=5)
    public Date getLastLoginTime() {
        return this.lastLoginTime;
    }

    @Property(viewable=true, order=6)
    public boolean isExpPasswordOnLogin() {
        return this.expPasswordOnLogin;
    }

    @Property(viewable=true, length=PropertyLength.MULTILINE, order=100)
    @Nullable
    public String getDescription() {
        return this.description;
    }

    public boolean isPersisted() {
        return true;
    }

    public boolean isSystem() {
        return this.name.startsWith("SYS_") || "SYS".equals(this.name);
    }
}

