/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.ui.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mysql.model.MySQLDataSource;
import org.jkiss.dbeaver.ext.mysql.model.MySQLUser;
import org.jkiss.dbeaver.ext.mysql.ui.config.UserPropertyHandler;
import org.jkiss.dbeaver.ext.mysql.ui.internal.MySQLUIMessages;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvent;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommand;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBECommandFilter;
import org.jkiss.dbeaver.model.edit.DBECommandQueue;
import org.jkiss.dbeaver.model.edit.DBECommandReflector;
import org.jkiss.dbeaver.model.edit.DBECommandRename;
import org.jkiss.dbeaver.model.edit.DBEObjectMaker;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.edit.prop.DBECommandComposite;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.edit.AbstractObjectManager;
import org.jkiss.dbeaver.model.impl.edit.DBECommandAbstract;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.utils.CommonUtils;

public class MySQLUserManager
extends AbstractObjectManager<MySQLUser>
implements DBEObjectMaker<MySQLUser, MySQLDataSource>,
DBECommandFilter<MySQLUser>,
DBEObjectRenamer<MySQLUser> {
    private static final String OPTION_SUPPRESS_FLUSH_PRIVILEGES = "suppress.flushPrivileges";
    private static final boolean USE_DIRECT_UPDATE = false;

    public long getMakerOptions(DBPDataSource dataSource) {
        return 4L;
    }

    @Nullable
    public DBSObjectCache<? extends DBSObject, MySQLUser> getObjectsCache(MySQLUser object) {
        return null;
    }

    public boolean canCreateObject(Object container) {
        return true;
    }

    public boolean canDeleteObject(MySQLUser object) {
        return true;
    }

    public MySQLUser createNewObject(DBRProgressMonitor monitor, DBECommandContext commandContext, Object container, Object copyFrom, Map<String, Object> options) {
        MySQLUser newUser = new MySQLUser((MySQLDataSource)container, null);
        if (copyFrom instanceof MySQLUser) {
            MySQLUser tplUser = (MySQLUser)copyFrom;
            newUser.setUserName(tplUser.getUserName());
            newUser.setHost(tplUser.getHost());
            newUser.setMaxQuestions(tplUser.getMaxQuestions());
            newUser.setMaxUpdates(tplUser.getMaxUpdates());
            newUser.setMaxConnections(tplUser.getMaxConnections());
            newUser.setMaxUserConnections(tplUser.getMaxUserConnections());
        }
        commandContext.addCommand((DBECommand)new CommandCreateUser(newUser), (DBECommandReflector)new AbstractObjectManager.CreateObjectReflector((DBEObjectMaker)this), true);
        return newUser;
    }

    public void deleteObject(DBECommandContext commandContext, MySQLUser user, Map<String, Object> options) {
        commandContext.addCommand((DBECommand)new CommandDropUser(user), (DBECommandReflector)new AbstractObjectManager.DeleteObjectReflector((DBEObjectMaker)this), true);
    }

    public void filterCommands(DBECommandQueue<MySQLUser> queue) {
    }

    public void renameObject(@NotNull DBECommandContext commandContext, @NotNull MySQLUser object, @NotNull Map<String, Object> options, @NotNull String newName) {
        CommandRenameUser command = new CommandRenameUser(object, MySQLUIMessages.edit_user_manager_command_rename_user, options, newName);
        commandContext.addCommand((DBECommand)command, (DBECommandReflector)new ReflectorRenameUser(), true);
    }

    private static class CommandCreateUser
    extends DBECommandAbstract<MySQLUser> {
        protected CommandCreateUser(MySQLUser user) {
            super((DBPObject)user, MySQLUIMessages.edit_user_manager_command_create_user);
        }

        public void validateCommand(@NotNull DBRProgressMonitor monitor, @NotNull Map<String, Object> options) throws DBException {
            if (CommonUtils.isEmpty((String)((MySQLUser)this.getObject()).getUserName())) {
                throw new DBException("Can't create user with empty name");
            }
            if (CommonUtils.isEmpty((String)((MySQLUser)this.getObject()).getHost())) {
                throw new DBException("Can't create user with empty host name");
            }
            super.validateCommand(monitor, options);
        }
    }

    private static class CommandDropUser
    extends DBECommandComposite<MySQLUser, UserPropertyHandler> {
        protected CommandDropUser(MySQLUser user) {
            super((DBPObject)user, MySQLUIMessages.edit_user_manager_command_drop_user);
        }

        @NotNull
        public DBEPersistAction[] getPersistActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull Map<String, Object> options) {
            return new DBEPersistAction[]{new SQLDatabasePersistAction(MySQLUIMessages.edit_user_manager_command_drop_user, "DROP USER " + ((MySQLUser)this.getObject()).getFullName()){

                public void afterExecute(DBCSession session, Throwable error) {
                    if (error == null) {
                        ((MySQLUser)this.getObject()).setPersisted(false);
                    }
                }
            }};
        }
    }

    public static final class CommandRenameUser
    extends DBECommandAbstract<MySQLUser>
    implements DBECommandRename {
        private final Map<String, Object> options;
        private final String oldName;
        private final String oldUserName;
        private final String oldHost;
        private String newName;
        private String newUserName;
        private String newHost;

        private CommandRenameUser(MySQLUser user, String title, Map<String, Object> options, String newName) {
            super((DBPObject)user, title);
            this.options = options;
            this.oldName = user.getName();
            this.oldUserName = user.getUserName();
            this.oldHost = user.getHost();
            this.setNewName(newName);
        }

        Map<String, Object> getOptions() {
            return Collections.unmodifiableMap(this.options);
        }

        String getOldName() {
            return this.oldName;
        }

        String getNewName() {
            return this.newName;
        }

        String getOldUserName() {
            return this.oldUserName;
        }

        String getOldHost() {
            return this.oldHost;
        }

        public String getNewUserName() {
            return this.newUserName;
        }

        public String getNewHost() {
            return this.newHost;
        }

        private void setNewName(String newName) {
            this.newName = newName;
            int atPosition = newName.indexOf(64);
            if (atPosition == -1 || atPosition == newName.length() - 1) {
                this.newUserName = newName;
                this.newHost = "";
                return;
            }
            this.newUserName = newName.substring(0, atPosition);
            this.newHost = newName.substring(atPosition + 1);
        }

        @NotNull
        public DBEPersistAction[] getPersistActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull Map<String, Object> options) {
            if (CommonUtils.equalObjects((Object)this.oldName, (Object)this.newName)) {
                return new DBEPersistAction[0];
            }
            ArrayList<SQLDatabasePersistAction> actions = new ArrayList<SQLDatabasePersistAction>();
            DBPDataSource dataSource = executionContext.getDataSource();
            actions.add(new SQLDatabasePersistAction("Rename user", "RENAME USER " + CommandRenameUser.getQuotedName(this.oldUserName, this.oldHost, dataSource) + " TO " + CommandRenameUser.getQuotedName(this.newUserName, this.newHost, dataSource)));
            return actions.toArray(new DBEPersistAction[0]);
        }

        @NotNull
        private static String getQuotedName(@NotNull String userName, @NotNull String host, @NotNull DBPDataSource dataSource) {
            if (host.isEmpty()) {
                return DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)userName);
            }
            return DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)userName) + "@" + DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)host);
        }

        @NotNull
        public DBECommand<?> merge(@NotNull DBECommand<?> prevCommand, @NotNull Map<Object, Object> userParams) {
            String mergeId = "rename" + ((MySQLUser)this.getObject()).hashCode();
            CommandRenameUser renameCmd = (CommandRenameUser)((Object)userParams.get(mergeId));
            if (renameCmd != null) {
                renameCmd.setNewName(this.newName);
                return renameCmd;
            }
            renameCmd = new CommandRenameUser((MySQLUser)this.getObject(), this.getTitle(), this.options, this.newName);
            userParams.put(mergeId, (Object)renameCmd);
            return super.merge(prevCommand, userParams);
        }

        public String toString() {
            return "CMD:RenameObject:" + String.valueOf(this.getObject());
        }
    }

    private class ReflectorRenameUser
    implements DBECommandReflector<MySQLUser, CommandRenameUser> {
        private ReflectorRenameUser() {
        }

        public void redoCommand(CommandRenameUser command) {
            MySQLUser user = (MySQLUser)command.getObject();
            user.setUserName(command.getNewUserName());
            this.setHost(user, command.getNewHost());
            DBSObjectCache<? extends DBSObject, MySQLUser> cache = MySQLUserManager.this.getObjectsCache((MySQLUser)command.getObject());
            if (cache != null) {
                cache.renameObject((DBSObject)((MySQLUser)command.getObject()), command.getOldName(), command.getNewName());
            }
            LinkedHashMap<String, Object> options = new LinkedHashMap<String, Object>(command.getOptions());
            options.put("oldName", command.getOldName());
            options.put("newName", command.getNewName());
            DBUtils.fireObjectUpdate((DBSObject)((DBSObject)command.getObject()), options, (Object)DBPEvent.RENAME);
        }

        public void undoCommand(CommandRenameUser command) {
            MySQLUser user = (MySQLUser)command.getObject();
            user.setUserName(command.getOldUserName());
            this.setHost(user, command.getOldHost());
            DBSObjectCache<? extends DBSObject, MySQLUser> cache = MySQLUserManager.this.getObjectsCache((MySQLUser)command.getObject());
            if (cache != null) {
                cache.renameObject((DBSObject)((MySQLUser)command.getObject()), command.getNewName(), command.getOldName());
            }
            LinkedHashMap<String, Object> options = new LinkedHashMap<String, Object>(command.getOptions());
            DBUtils.fireObjectUpdate((DBSObject)((DBSObject)command.getObject()), options, (Object)DBPEvent.RENAME);
        }

        private void setHost(@NotNull MySQLUser user, @NotNull String host) {
            if (host.isEmpty()) {
                host = "%";
            }
            user.setHost(host);
        }
    }
}

