/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.runtime.cert.controller;

import com.dbeaver.ee.runtime.cert.controller.TrustStoreController;
import com.dbeaver.ee.runtime.cert.model.CertDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class LocalTrustStoreController
implements TrustStoreController {
    private static final Log log = Log.getLog(LocalTrustStoreController.class);
    public static final LocalTrustStoreController INSTANCE = new LocalTrustStoreController();
    public static final String TRUST_STORE_FILE_NAME = ".dbeaver-trust-store.bks";

    @Override
    @NotNull
    public List<CertDescriptor> getCertificates(@Nullable KeyStore activeTruststore) throws DBException {
        if (activeTruststore == null) {
            return Collections.emptyList();
        }
        ArrayList<CertDescriptor> certDescriptors = new ArrayList<CertDescriptor>();
        try {
            Enumeration<String> aliases = activeTruststore.aliases();
            while (aliases.hasMoreElements()) {
                String certName = aliases.nextElement();
                X509Certificate certificate = (X509Certificate)activeTruststore.getCertificate(certName);
                certDescriptors.add(this.createCertDescriptor(certName, certificate));
            }
        }
        catch (KeyStoreException e) {
            throw new DBException("Error reading certificate", (Throwable)e);
        }
        return certDescriptors;
    }

    @Override
    public void removeCertificate(@NotNull KeyStore activeTruststore, @NotNull String alias) throws DBException {
        try {
            activeTruststore.deleteEntry(alias);
            this.saveToDBeaverTrustStore(activeTruststore);
        }
        catch (KeyStoreException e) {
            throw new DBException("Error, Keystore is not initialized", (Throwable)e);
        }
    }

    @Override
    public X509Certificate addCertificate(@NotNull KeyStore activeTruststore, @NotNull String alias, @NotNull Path certificate) throws DBException {
        CertificateFactory fac;
        try {
            fac = CertificateFactory.getInstance("X509");
        }
        catch (CertificateException e) {
            throw new DBException("Error adding certificates", (Throwable)e);
        }
        try {
            Throwable e = null;
            Object var6_9 = null;
            try (InputStream is = Files.newInputStream(certificate, new OpenOption[0]);){
                X509Certificate cert = (X509Certificate)fac.generateCertificate(is);
                activeTruststore.setCertificateEntry(alias, cert);
                this.saveToDBeaverTrustStore(activeTruststore);
                return cert;
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (Exception e) {
            throw new DBException("Error adding certificates", (Throwable)e);
        }
    }

    @Override
    @Nullable
    public KeyStore getTrustStoreInstance(@NotNull TrustStoreController.TrustType types) throws DBException {
        KeyStore activeKeystore;
        try {
            switch (types) {
                case DBEAVER: {
                    Path trustStore = LocalTrustStoreController.getDBeaverTrustStorePath();
                    String storeType = "bks";
                    activeKeystore = KeyStore.getInstance(storeType);
                    if (!Files.exists(trustStore, new LinkOption[0])) {
                        this.initDBeaverTruststore(trustStore, activeKeystore);
                    }
                    Throwable throwable = null;
                    Object var6_8 = null;
                    try (InputStream is = Files.newInputStream(trustStore, new OpenOption[0]);){
                        activeKeystore.load(is, null);
                        break;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                case CA: {
                    activeKeystore = this.getCATrust();
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        catch (IOException | GeneralSecurityException e) {
            throw new DBException("Error getting truststore instance", (Throwable)e);
        }
        return activeKeystore;
    }

    private void injectCACerts(@NotNull KeyStore activeKeystore) throws GeneralSecurityException, IOException {
        KeyStore caTrust = this.getCATrust();
        try {
            Enumeration<String> aliases = caTrust.aliases();
            while (aliases.hasMoreElements()) {
                String certName = aliases.nextElement();
                X509Certificate certificate = (X509Certificate)caTrust.getCertificate(certName);
                activeKeystore.setCertificateEntry(certName, certificate);
            }
        }
        catch (KeyStoreException e) {
            log.warn((Object)"Error reading certificate information", (Throwable)e);
        }
    }

    @NotNull
    private KeyStore getCATrust() throws GeneralSecurityException, IOException {
        Path filename = Path.of(System.getProperty("java.home"), new String[0]).resolve("lib").resolve("security").resolve("cacerts");
        KeyStore caTrust = KeyStore.getInstance(KeyStore.getDefaultType());
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileInputStream is = new FileInputStream(filename.toFile());){
            caTrust.load(is, null);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return caTrust;
    }

    private void initDBeaverTruststore(@NotNull Path trustStore, @NotNull KeyStore activeKeystore) throws DBException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (OutputStream fileOutputStream = Files.newOutputStream(trustStore, new OpenOption[0]);){
                activeKeystore.load(null, null);
                this.injectCACerts(activeKeystore);
                activeKeystore.store(fileOutputStream, null);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | GeneralSecurityException e) {
            throw new DBException("Error creating keystore instance", (Throwable)e);
        }
    }

    private CertDescriptor createCertDescriptor(@NotNull String certName, @Nullable X509Certificate certificate) {
        if (certificate != null) {
            boolean isValid = true;
            try {
                certificate.checkValidity();
            }
            catch (CertificateExpiredException | CertificateNotYetValidException certificateException) {
                isValid = false;
            }
            return new CertDescriptor(certName, certificate, isValid);
        }
        return null;
    }

    private void saveToDBeaverTrustStore(@NotNull KeyStore activeTruststore) {
        Path dBeaverTrustStorePath = LocalTrustStoreController.getDBeaverTrustStorePath();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (OutputStream fileOutputStream = Files.newOutputStream(dBeaverTrustStorePath, new OpenOption[0]);){
                activeTruststore.store(fileOutputStream, null);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.error((Object)"Error saving Truststore", (Throwable)e);
        }
    }

    @NotNull
    public static Path getDBeaverTrustStorePath() {
        return GeneralUtils.getMetadataFolder().resolve(TRUST_STORE_FILE_NAME);
    }

    private LocalTrustStoreController() {
    }
}

