/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.runtime;

import com.dbeaver.ee.runtime.core.DBeaverEnterprisePreferences;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.crypto.SecretKey;
import org.eclipse.core.resources.IProject;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.auth.SMSessionContext;
import org.jkiss.dbeaver.model.impl.app.DefaultValueEncryptor;
import org.jkiss.dbeaver.registry.BaseWorkspaceImpl;
import org.jkiss.dbeaver.registry.LocalProjectImpl;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.ui.UIServiceSecurity;
import org.jkiss.dbeaver.utils.SystemVariablesResolver;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public class LocalProjectAdvanced
extends LocalProjectImpl {
    private static final Log log = Log.getLog(LocalProjectAdvanced.class);
    public static final String PROP_SECURE_PROJECT = "secureProject";
    public static final String VAR_PROJECT_PASSWORD = "dbeaver.project.password";
    private SecretKey projectPassword;

    public LocalProjectAdvanced(@NotNull BaseWorkspaceImpl workspace, @NotNull IProject project, @Nullable SMSessionContext sessionContext) {
        super(workspace, project, sessionContext);
    }

    public boolean isUseSecretStorage() {
        return !this.isProjectPasswordUsed() && DBeaverEnterprisePreferences.useSecurePreferences();
    }

    public boolean isEncryptedProject() {
        return CommonUtils.toBoolean((Object)this.getProjectProperty(PROP_SECURE_PROJECT));
    }

    @NotNull
    public SecretKey getLocalSecretKey() {
        if (this.isProjectPasswordUsed()) {
            if (this.projectPassword == null) {
                this.projectPassword = DBWorkbench.getPlatform().getApplication().isHeadlessMode() ? this.acquireSecretKeyFromConfiguration() : this.acquireSecretKey();
            }
            return this.projectPassword;
        }
        return super.getLocalSecretKey();
    }

    public boolean isProjectPasswordUsed() {
        return CommonUtils.getBoolean((Object)this.getProjectProperty("useProjectPassword"), (boolean)false);
    }

    @Nullable
    private SecretKey acquireSecretKey() {
        String password;
        UIServiceSecurity serviceSecurity = (UIServiceSecurity)DBWorkbench.getService(UIServiceSecurity.class);
        if (serviceSecurity == null) {
            return null;
        }
        Object message = "Project: " + this.getName();
        while ((password = serviceSecurity.askForPassword((DBPProject)this, "Project '" + this.getName() + "' password", (String)message, null, false)) != null) {
            SecretKey key = DefaultValueEncryptor.makeSecretKeyFromPassword((String)password);
            if (this.isValidSecretKey(key)) {
                return key;
            }
            message = "Incorrect password. Try again";
        }
        return null;
    }

    @Nullable
    private SecretKey acquireSecretKeyFromConfiguration() {
        String passwords = SystemVariablesResolver.INSTANCE.get(VAR_PROJECT_PASSWORD);
        if (passwords == null) {
            return null;
        }
        String[] stringArray = passwords.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String projectPassword;
            String projectName;
            String entry = stringArray[n2];
            if (entry.startsWith("@") && entry.indexOf(58) > 0) {
                int div = entry.indexOf(58);
                projectName = entry.substring(1, div);
                projectPassword = entry.substring(div + 1);
            } else {
                projectName = null;
                projectPassword = entry;
            }
            if (projectName == null || projectName.equals(this.getName())) {
                SecretKey key = DefaultValueEncryptor.makeSecretKeyFromPassword((String)projectPassword);
                if (!this.isValidSecretKey(key)) break;
                return key;
            }
            ++n2;
        }
        return null;
    }

    public boolean isValidSecretKey(SecretKey key) {
        Path credFile;
        Path mdFolder = this.getMetadataFolder(false);
        if (Files.exists(mdFolder, new LinkOption[0]) && Files.exists(credFile = mdFolder.resolve("credentials-config.json"), new LinkOption[0])) {
            byte[] bytes;
            try {
                bytes = IOUtils.readFileToBuffer((File)credFile.toFile());
            }
            catch (IOException iOException) {
                log.error((Object)"Error reading credentials file");
                return true;
            }
            DefaultValueEncryptor encryptor = new DefaultValueEncryptor(key);
            try {
                encryptor.decryptValue(bytes);
                return true;
            }
            catch (Exception e) {
                log.debug((Object)"Error decrypting secure credentials", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    public void setProjectPassword(String password) {
        this.projectPassword = CommonUtils.isEmpty((String)password) ? null : DefaultValueEncryptor.makeSecretKeyFromPassword((String)password);
    }
}

