/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.erd.ui.notation.crowsfoot;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.PolylineDecoration;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.jkiss.dbeaver.erd.ui.notations.ERDAssociationType;

public class CrowsFootPolylineDecoration
extends PolylineDecoration {
    private static PointList geometryList = new PointList();
    private ERDAssociationType association;
    private static final int DIAMETER = 8;

    static {
        geometryList.addPoint(0, -1);
        geometryList.addPoint(-2, 0);
        geometryList.addPoint(0, 1);
        geometryList.addPoint(-2, -1);
        geometryList.addPoint(-2, 1);
        geometryList.addPoint(-3, -1);
        geometryList.addPoint(-3, 1);
        geometryList.addPoint(-3, 0);
        geometryList.addPoint(-6, 0);
    }

    public CrowsFootPolylineDecoration(ERDAssociationType association) {
        this.setTemplate(geometryList);
        this.setScale(5.0, 5.0);
        this.association = association;
    }

    protected void outlineShape(Graphics g) {
        PointList crowsFootPoints = this.getPoints();
        int radius = 4;
        switch (this.association) {
            case ZERO_OR_ONE: {
                g.drawLine(crowsFootPoints.getPoint(3), crowsFootPoints.getPoint(4));
                Point point = crowsFootPoints.getPoint(7);
                g.fillOval(point.x - 4, point.y - 4, 8, 8);
                g.drawOval(point.x - 4, point.y - 4, 8, 8);
                break;
            }
            case ONE_ONLY: {
                g.drawLine(crowsFootPoints.getPoint(3), crowsFootPoints.getPoint(4));
                g.drawLine(crowsFootPoints.getPoint(5), crowsFootPoints.getPoint(6));
                break;
            }
            case ZERO: {
                Point point = crowsFootPoints.getPoint(7);
                g.fillOval(point.x - 4, point.y - 4, 8, 8);
                g.drawOval(point.x - 4, point.y - 4, 8, 8);
                break;
            }
            case MANY: {
                g.drawLine(crowsFootPoints.getPoint(0), crowsFootPoints.getPoint(1));
                g.drawLine(crowsFootPoints.getPoint(1), crowsFootPoints.getPoint(2));
                break;
            }
            case ONE_OR_MANY: {
                g.drawLine(crowsFootPoints.getPoint(0), crowsFootPoints.getPoint(1));
                g.drawLine(crowsFootPoints.getPoint(1), crowsFootPoints.getPoint(2));
                g.drawLine(crowsFootPoints.getPoint(3), crowsFootPoints.getPoint(4));
                break;
            }
            case ZERO_OR_MANY: {
                g.drawLine(crowsFootPoints.getPoint(0), crowsFootPoints.getPoint(1));
                g.drawLine(crowsFootPoints.getPoint(1), crowsFootPoints.getPoint(2));
                Point point = crowsFootPoints.getPoint(7);
                g.fillOval(point.x - radius, point.y - radius, 8, 8);
                g.drawOval(point.x - radius, point.y - radius, 8, 8);
                break;
            }
        }
    }
}

