/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.erd.ui.layout.algorithm.direct;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.DirectedGraphLayout;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.erd.ui.part.EntityPart;

public class OrthoDirectedGraphLayout
extends DirectedGraphLayout {
    private AbstractGraphicalEditPart diagram;
    private TreeMap<Integer, List<Node>> nodeByLevels;
    private List<Node> singleConnectedNodes = new LinkedList<Node>();
    private static final int OFFSET_FROM_TOP = 30;
    private static final int OFFSET_FROM_LEFT = 50;
    private static final int DISTANCE_ENTITIES_X = 75;
    private static final int DISTANCE_ENTITIES_Y = 40;
    private static final int DISTANCE_BTW_ELEMENT_PER_COLUMNS = 2;
    private static final int COLUMN_MAX = 8;
    private static final int COLUMN_ISLAND_MAX = 3;
    private static final int DISTANCE_PER_EDGE_X = 7;
    private static final int DISTANCE_PER_EDGE_Y = 10;

    public OrthoDirectedGraphLayout(AbstractGraphicalEditPart diagram) {
        this.diagram = diagram;
    }

    public void visit(DirectedGraph graph) {
        this.nodeByLevels = this.computeRootNodes(graph);
        this.singleConnectedNodes = this.computeSingleConnectedNodes(graph);
        this.nodeByLevels = this.removeIslandNodesFromRoots(this.singleConnectedNodes, this.nodeByLevels);
        this.nodeByLevels = this.recomputeGraph(this.nodeByLevels);
        this.nodeByLevels = this.verifyNodesOnGraph(graph, this.nodeByLevels);
        this.drawGraphNodes(this.nodeByLevels);
        this.drawIsolatedNodes(this.singleConnectedNodes, this.nodeByLevels);
        List<Node> nodeMissed = this.findMissedGraphNodes(graph, this.nodeByLevels);
        Collections.sort(nodeMissed, (n1, n2) -> {
            Object object = n1.data;
            if (object instanceof EntityPart) {
                EntityPart entityPart = (EntityPart)object;
                EntityPart cfr_ignored_0 = (EntityPart)object;
                Object object2 = n2.data;
                if (object2 instanceof EntityPart) {
                    void ep2;
                    void ep1;
                    EntityPart entityPart2 = (EntityPart)object2;
                    EntityPart cfr_ignored_1 = (EntityPart)object2;
                    return ep1.getName().compareTo(ep2.getName());
                }
            }
            return 0;
        });
        this.drawMissedNodes(this.singleConnectedNodes, nodeMissed, this.nodeByLevels);
    }

    private int computeDistance(@NotNull Collection<Node> nodes) {
        int maxCountOfEdges = 0;
        int distance = 75;
        for (Node node : nodes) {
            maxCountOfEdges += node.incoming.size() + node.outgoing.size();
        }
        if (maxCountOfEdges > 0) {
            distance += maxCountOfEdges * 7;
        }
        if (distance < 7) {
            distance = 75;
        }
        return distance;
    }

    private int computeDistanceY(Node n) {
        int distance = (n.outgoing.size() + n.incoming.size()) * 10;
        if (distance < 40) {
            distance = 40;
        }
        return distance;
    }

    private TreeMap<Integer, List<Node>> removeIslandNodesFromRoots(@NotNull List<Node> islands, @NotNull TreeMap<Integer, List<Node>> nodeByLevels) {
        List<Node> listOfNodes = nodeByLevels.get(0);
        if (listOfNodes != null) {
            listOfNodes.removeAll(islands);
            nodeByLevels.put(0, listOfNodes);
        }
        return nodeByLevels;
    }

    private void drawIsolatedNodes(@NotNull List<Node> islandNodes, @NotNull TreeMap<Integer, List<Node>> mainNodes) {
        Map.Entry<Integer, List<Node>> lastEntry = mainNodes.lastEntry();
        int offsetX = 50;
        for (Node n : lastEntry.getValue()) {
            if (offsetX >= n.width) continue;
            offsetX = n.width;
        }
        int currentX = 50;
        int currentY = this.findBottomPosition(mainNodes);
        int distanceX = this.computeDistance(islandNodes);
        int offsetY = 0;
        for (Node nodeSource : islandNodes) {
            nodeSource.x = currentX;
            nodeSource.y = currentY;
            for (Edge edge : nodeSource.outgoing) {
                Node nodeTarget = edge.target;
                nodeTarget.x = currentX + nodeSource.width + distanceX;
                nodeTarget.y = currentY;
                if (offsetY < nodeSource.height) {
                    offsetY = nodeSource.height;
                }
                if (offsetY < nodeTarget.height) {
                    offsetY = nodeTarget.height;
                }
                if ((islandNodes.indexOf(nodeSource) + 1) % 3 != 0) {
                    currentX += nodeSource.width + nodeTarget.width + distanceX + 75;
                    continue;
                }
                currentX = 50;
                currentY += offsetY + 20;
            }
        }
    }

    private void drawMissedNodes(@NotNull List<Node> islands, @NotNull List<Node> missedNodes, @NotNull TreeMap<Integer, List<Node>> nodeByLevels) {
        Map.Entry<Integer, List<Node>> lastEntry = nodeByLevels.lastEntry();
        int offsetX = 50;
        for (Node n : lastEntry.getValue()) {
            if (offsetX >= n.width) continue;
            offsetX = n.width;
        }
        int currentX = 50;
        int currentY = this.findBottomPosition(nodeByLevels) + this.getBottomPositionIslands(islands);
        int curColumnIndex = 0;
        offsetX = currentX;
        int offsetY = currentY;
        int height = 40;
        for (Node node : missedNodes) {
            if (height < node.height) {
                height = node.height;
            }
            node.x = offsetX;
            node.y = offsetY;
            if (++curColumnIndex % 8 == 0) {
                offsetY += height + 40;
                offsetX = currentX;
                height = 0;
                continue;
            }
            offsetX += node.width + 37;
        }
    }

    private int getBottomPositionIslands(List<Node> islands) {
        int positionY = 0;
        int offsetY = 0;
        for (Node nodeSource : islands) {
            for (Edge edge : nodeSource.outgoing) {
                Node nodeTarget = edge.target;
                if (offsetY < nodeSource.height) {
                    offsetY = nodeSource.height;
                }
                if (offsetY >= nodeTarget.height) continue;
                offsetY = nodeTarget.height;
            }
            if ((islands.indexOf(nodeSource) + 1) % 3 != 0) continue;
            positionY += offsetY + 20;
            offsetY = 0;
        }
        if (offsetY != 0) {
            offsetY += 40;
        }
        return positionY + offsetY;
    }

    private void drawGraphNodes(@NotNull TreeMap<Integer, List<Node>> nodeByEdges) {
        int currentX = 50;
        int currentY = 30;
        Map<Integer, Integer> height2Level = this.computeHeight(this.nodeByLevels);
        int middle = Collections.max(height2Level.values()) / 2;
        int index = 0;
        for (Map.Entry<Integer, List<Node>> entry : nodeByEdges.entrySet()) {
            Integer height = height2Level.get(index);
            currentY = height / 2 > middle ? 30 : 30 + middle - height / 2;
            List<Node> nodes = entry.getValue();
            int nodeWidthMax = 0;
            for (Node n : nodes) {
                n.x = currentX;
                n.y = currentY;
                currentY = index == 0 ? (currentY += n.height + 40) : (currentY += n.height + 40 / nodes.size() + this.computeDistanceY(n));
                if (nodeWidthMax >= n.width) continue;
                nodeWidthMax = n.width;
            }
            if (!nodes.isEmpty()) {
                currentX += nodeWidthMax + this.computeDistance(nodes);
            }
            ++index;
        }
    }

    @NotNull
    private List<Node> computeSingleConnectedNodes(@NotNull DirectedGraph graph) {
        LinkedList<Node> isolated = new LinkedList<Node>();
        int i = 0;
        while (i < graph.nodes.size()) {
            Node node = (Node)graph.nodes.get(i);
            if (node.outgoing.size() == 1 && node.incoming.isEmpty()) {
                boolean hasNoFurtherConnections = false;
                Node nodeTarget = null;
                for (Edge edge : node.outgoing) {
                    nodeTarget = edge.target;
                    hasNoFurtherConnections = nodeTarget != null && nodeTarget.outgoing.isEmpty() && nodeTarget.incoming.size() == 1;
                }
                if (hasNoFurtherConnections) {
                    isolated.add(node);
                }
            }
            ++i;
        }
        return isolated;
    }

    private TreeMap<Integer, List<Node>> computeRootNodes(DirectedGraph graph) {
        TreeMap<Integer, List<Node>> nodes = new TreeMap<Integer, List<Node>>();
        LinkedList<Node> firstLineOutput = new LinkedList<Node>();
        int i = 0;
        while (i < graph.nodes.size()) {
            Node node = (Node)graph.nodes.get(i);
            if (!node.outgoing.isEmpty() && node.incoming.isEmpty()) {
                firstLineOutput.add(node);
            }
            ++i;
        }
        if (!firstLineOutput.isEmpty()) {
            nodes.put(0, firstLineOutput);
        }
        return nodes;
    }

    @NotNull
    private TreeMap<Integer, List<Node>> recomputeGraph(@NotNull TreeMap<Integer, List<Node>> graph) {
        int idx = 0;
        while (idx < graph.keySet().size()) {
            this.createGraphLayers(graph, idx);
            List<Node> nextLevelNodes = graph.get(idx + 1);
            if (nextLevelNodes != null && graph.get(idx).isEmpty() && !nextLevelNodes.isEmpty()) {
                graph.put(idx, nextLevelNodes);
                graph.remove(idx + 1);
            }
            ++idx;
        }
        return graph;
    }

    @NotNull
    private List<Node> findMissedGraphNodes(@NotNull DirectedGraph graph, @NotNull TreeMap<Integer, List<Node>> nodeByEdges) {
        ArrayList<Node> missedNodes = new ArrayList<Node>();
        for (Node node : graph.nodes) {
            boolean isContains = false;
            for (Map.Entry<Integer, List<Node>> entry : nodeByEdges.entrySet()) {
                if (entry.getValue().contains(node) || this.singleConnectedNodes.contains(node)) {
                    isContains = true;
                    break;
                }
                block2: for (Node isoNode : this.singleConnectedNodes) {
                    for (Edge edge : isoNode.outgoing) {
                        Node nodeTarget = edge.target;
                        if (!node.equals(nodeTarget)) continue;
                        isContains = true;
                        continue block2;
                    }
                }
            }
            if (isContains) continue;
            missedNodes.add(node);
        }
        return missedNodes;
    }

    @NotNull
    private TreeMap<Integer, List<Node>> verifyNodesOnGraph(@NotNull DirectedGraph graph, @NotNull TreeMap<Integer, List<Node>> nodeByLevels) {
        if (nodeByLevels.isEmpty() && !graph.nodes.isEmpty()) {
            nodeByLevels.put(0, (List<Node>)graph.nodes);
        }
        return nodeByLevels;
    }

    private void createGraphLayers(@NotNull TreeMap<Integer, List<Node>> nodeByEdges, int idx) {
        HashMap<Node, Integer> duplicationNode2index = new HashMap<Node, Integer>();
        List<Node> nodesLine = nodeByEdges.get(idx);
        for (Node inNode : nodesLine) {
            for (Edge edge : inNode.outgoing) {
                Node trg;
                Node src = edge.source;
                if (src != null && !src.equals(inNode)) {
                    Integer nodeIndex = this.getNodeIndex(nodeByEdges, src);
                    if (nodeIndex != null) {
                        duplicationNode2index.put(src, nodeIndex);
                    }
                    nodeByEdges.computeIfAbsent(idx + 2, n -> new ArrayList()).add(src);
                }
                if ((trg = edge.target) == null) continue;
                Integer nodeIndex = this.getNodeIndex(nodeByEdges, trg);
                boolean skip = false;
                for (Edge e : trg.incoming) {
                    Node incomingSourceNode = e.source;
                    Integer childIndex = this.getNodeIndex(nodeByEdges, incomingSourceNode);
                    if (childIndex == null || childIndex == 0 || idx - childIndex <= 2) continue;
                    skip = true;
                    break;
                }
                if (skip) continue;
                if (nodeIndex != null) {
                    if (duplicationNode2index.containsKey(trg)) continue;
                    duplicationNode2index.put(trg, nodeIndex);
                }
                nodeByEdges.computeIfAbsent(idx + 1, n -> new ArrayList()).add(trg);
            }
        }
        duplicationNode2index.forEach((key, value) -> {
            boolean bl = ((List)nodeByEdges.get(value)).remove(key);
        });
    }

    @Nullable
    private Integer getNodeIndex(@NotNull TreeMap<Integer, List<Node>> nodeByEdges, @NotNull Node src) {
        for (Map.Entry<Integer, List<Node>> nodeOnLevel : nodeByEdges.entrySet()) {
            if (!nodeOnLevel.getValue().contains(src)) continue;
            return nodeOnLevel.getKey();
        }
        return null;
    }

    @NotNull
    private Map<Integer, Integer> computeHeight(@NotNull TreeMap<Integer, List<Node>> nodeByEdges) {
        HashMap<Integer, Integer> mapOfHeight = new HashMap<Integer, Integer>();
        for (Map.Entry<Integer, List<Node>> entry : nodeByEdges.entrySet()) {
            int height = 0;
            for (Node node : entry.getValue()) {
                height += node.height + 40;
            }
            mapOfHeight.put(entry.getKey(), height);
        }
        return mapOfHeight;
    }

    public AbstractGraphicalEditPart getDiagram() {
        return this.diagram;
    }

    private int findRightPosition(@NotNull TreeMap<Integer, List<Node>> nodeByEdges) {
        int positionByX;
        if (nodeByEdges.lastEntry().getValue().isEmpty()) {
            positionByX = 50;
        } else {
            Node lastNode = nodeByEdges.lastEntry().getValue().get(0);
            positionByX = lastNode.x + 50;
        }
        return positionByX;
    }

    private int findBottomPosition(@NotNull TreeMap<Integer, List<Node>> nodeByEdges) {
        return 70 + Collections.max(this.computeHeight(nodeByEdges).values());
    }
}

