/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.erd.ui.layout.algorithm.direct;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.DirectedGraphLayout;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeList;
import org.eclipse.draw2d.graph.Subgraph;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.erd.model.ERDEntity;
import org.jkiss.dbeaver.erd.ui.editor.ERDEditorPart;
import org.jkiss.dbeaver.erd.ui.layout.GraphAnimation;
import org.jkiss.dbeaver.erd.ui.layout.algorithm.direct.NodeJoiningDirectedGraphLayout;
import org.jkiss.dbeaver.erd.ui.layout.algorithm.direct.OrthoDirectedGraphLayout;
import org.jkiss.dbeaver.erd.ui.model.ERDDecorator;
import org.jkiss.dbeaver.erd.ui.part.AttributePart;
import org.jkiss.dbeaver.erd.ui.part.DiagramPart;
import org.jkiss.dbeaver.erd.ui.part.EntityPart;
import org.jkiss.dbeaver.erd.ui.part.NodePart;
import org.jkiss.dbeaver.erd.ui.router.ERDConnectionRouterDescriptor;

public class DirectedGraphLayoutVisitor {
    private static final Log log = Log.getLog(DirectedGraphLayoutVisitor.class);
    private final ERDDecorator decorator;
    private Map<EditPart, Object> partToNodesMap;
    private DirectedGraph graph;

    public DirectedGraphLayoutVisitor(ERDDecorator decorator) {
        this.decorator = decorator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void layoutDiagram(AbstractGraphicalEditPart diagram) {
        DirectedGraphLayoutVisitor directedGraphLayoutVisitor = this;
        synchronized (directedGraphLayoutVisitor) {
            this.partToNodesMap = new IdentityHashMap<EditPart, Object>();
            this.graph = new DirectedGraph();
            this.graph.setDirection(16);
            this.addDiagramNodes(diagram);
            if (!this.graph.nodes.isEmpty()) {
                this.addDiagramEdges(diagram);
                try {
                    AbstractGraphicalEditPart abstractGraphicalEditPart = diagram;
                    if (abstractGraphicalEditPart instanceof DiagramPart) {
                        void diagramPart;
                        DiagramPart diagramPart2 = (DiagramPart)abstractGraphicalEditPart;
                        DiagramPart cfr_ignored_0 = (DiagramPart)abstractGraphicalEditPart;
                        ERDEditorPart editor = diagramPart.getEditor();
                        if (editor == null) {
                            return;
                        }
                        ERDConnectionRouterDescriptor diagramRouter = editor.getDiagramRouter();
                        DirectedGraphLayout layout = null;
                        layout = diagramRouter.supportedAttributeAssociation() ? new OrthoDirectedGraphLayout(diagram) : new NodeJoiningDirectedGraphLayout(diagram);
                        layout.visit(this.graph);
                    }
                }
                catch (Exception e) {
                    log.error((Object)("Error during layoting elements:" + e.getMessage()), (Throwable)e);
                }
                this.applyDiagramResults(diagram);
            }
        }
    }

    protected void addDiagramNodes(AbstractGraphicalEditPart diagram) {
        GraphAnimation.recordInitialState(diagram.getFigure());
        for (Object child : diagram.getChildren()) {
            this.addEntityNode((NodePart)child);
        }
    }

    protected void addEntityNode(NodePart nodeEditPart) {
        Node entityNode = null;
        ERDEntity entity = null;
        if (nodeEditPart instanceof EntityPart && (entity = ((EntityPart)nodeEditPart).getEntity()).hasSelfLinks()) {
            entityNode = new Subgraph((Object)nodeEditPart);
        }
        if (entityNode == null) {
            entityNode = new Node((Object)nodeEditPart);
        }
        Dimension preferredSize = nodeEditPart.getFigure().getPreferredSize(-1, -1);
        entityNode.width = preferredSize.width;
        entityNode.height = preferredSize.height;
        entityNode.setPadding(this.decorator.getDefaultEntityInsets());
        this.partToNodesMap.put((EditPart)nodeEditPart, entityNode);
        this.graph.nodes.add((Object)entityNode);
        if (entityNode instanceof Subgraph) {
            Node sourceAnchor = new Node((Object)"Fake node for source links", (Subgraph)entityNode);
            sourceAnchor.width = 0;
            sourceAnchor.height = 0;
            Node targetAnchor = new Node((Object)"Fake node for target links", (Subgraph)entityNode);
            targetAnchor.width = 0;
            targetAnchor.height = 0;
        }
    }

    protected void addDiagramEdges(AbstractGraphicalEditPart diagram) {
        for (Object child : diagram.getChildren()) {
            this.addEntityEdges((GraphicalEditPart)child);
        }
    }

    protected void addEntityEdges(GraphicalEditPart entityPart) {
        List outgoing = entityPart.getSourceConnections();
        for (Object o : outgoing) {
            this.addConnectionEdges((AbstractConnectionEditPart)o);
        }
        for (Object child : entityPart.getChildren()) {
            for (Object sourceConnection : ((AttributePart)child).getSourceConnections()) {
                this.addConnectionEdges((AbstractConnectionEditPart)sourceConnection);
            }
        }
    }

    protected void addConnectionEdges(AbstractConnectionEditPart connectionPart) {
        Node target;
        GraphAnimation.recordInitialState((Connection)connectionPart.getFigure());
        Node source = (Node)this.partToNodesMap.get(connectionPart.getSource());
        if (source == null && connectionPart.getSource() != null) {
            source = (Node)this.partToNodesMap.get(connectionPart.getSource().getParent());
        }
        if ((target = (Node)this.partToNodesMap.get(connectionPart.getTarget())) == null && connectionPart.getTarget() != null) {
            target = (Node)this.partToNodesMap.get(connectionPart.getTarget().getParent());
        }
        if (source == null || target == null) {
            log.warn((Object)"Source or target node not found");
            return;
        }
        if (source instanceof Subgraph && target instanceof Subgraph) {
            source = ((Subgraph)source).members.getNode(0);
            target = ((Subgraph)target).members.getNode(1);
        }
        Edge e = new Edge((Object)connectionPart, source, target);
        e.setPadding(10);
        e.weight = 2;
        this.graph.edges.add((Object)e);
        this.partToNodesMap.put((EditPart)connectionPart, e);
    }

    protected void applyDiagramResults(AbstractGraphicalEditPart diagram) {
        for (Object child : diagram.getChildren()) {
            this.applyEntityResults((GraphicalEditPart)child);
        }
    }

    public void applyEntityResults(GraphicalEditPart entityPart) {
        Node n = (Node)this.partToNodesMap.get(entityPart);
        IFigure tableFigure = entityPart.getFigure();
        Dimension preferredSize = tableFigure.getPreferredSize();
        Dimension snapSize = this.decorator.getEntitySnapSize();
        Rectangle bounds = new Rectangle(n.x, n.y, preferredSize.width, preferredSize.height);
        if (snapSize != null) {
            bounds.translate(n.x / snapSize.width * snapSize.width - n.x, n.y / snapSize.height * snapSize.height - n.y);
        }
        tableFigure.setBounds(bounds);
        List sourceConnections = entityPart.getSourceConnections();
        int i = 0;
        while (i < sourceConnections.size()) {
            Object srcObject = sourceConnections.get(i);
            if (srcObject instanceof AbstractConnectionEditPart) {
                AbstractConnectionEditPart connectionPart = (AbstractConnectionEditPart)srcObject;
                this.applyConnectionResults(connectionPart);
            } else {
                log.info((Object)("Object: " + srcObject.toString() + " is not an instance of AbstractConnectionEditPart."));
            }
            ++i;
        }
        for (Object child : entityPart.getChildren()) {
            if (!(child instanceof AttributePart)) continue;
            for (Object srcObject : ((AttributePart)child).getSourceConnections()) {
                if (srcObject instanceof AbstractConnectionEditPart) {
                    AbstractConnectionEditPart connectionPart = (AbstractConnectionEditPart)srcObject;
                    this.applyConnectionResults(connectionPart);
                    continue;
                }
                log.info((Object)("Object: " + srcObject.toString() + " is not an instance of AbstractConnectionEditPart."));
            }
        }
    }

    protected void applyConnectionResults(AbstractConnectionEditPart connectionPart) {
        if (!this.partToNodesMap.containsKey(connectionPart)) {
            log.info((Object)"Can't find associated edge for connection.");
            return;
        }
        Edge connEdge = (Edge)this.partToNodesMap.get(connectionPart);
        NodeList edgeNodes = connEdge.vNodes;
        PolylineConnection conn = (PolylineConnection)connectionPart.getConnectionFigure();
        if (edgeNodes != null && edgeNodes.size() > 1) {
            ArrayList<AbsoluteBendpoint> bends = new ArrayList<AbsoluteBendpoint>();
            int i = 0;
            while (i < edgeNodes.size()) {
                Node vn = edgeNodes.getNode(i);
                int x = vn.x;
                int y = vn.y;
                bends.add(new AbsoluteBendpoint(x, y));
                ++i;
            }
            conn.setRoutingConstraint(bends);
        }
    }
}

