/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.erd.ui.editor;

import java.util.Arrays;
import java.util.Objects;
import java.util.StringJoiner;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.erd.ui.internal.ERDUIMessages;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.utils.CommonUtils;

public enum ERDViewStyle {
    ICONS(1, ERDUIMessages.erd_view_style_selection_item_icons, ERDUIMessages.erd_view_style_selection_item_icons_action),
    TYPES(2, ERDUIMessages.erd_view_style_selection_item_data_types, ERDUIMessages.erd_view_style_selection_item_data_types_action),
    NULLABILITY(4, ERDUIMessages.erd_view_style_selection_item_nullability, ERDUIMessages.erd_view_style_selection_item_nullability_action),
    COMMENTS(8, ERDUIMessages.erd_view_style_selection_item_comments, ERDUIMessages.erd_view_style_selection_item_comments_action),
    ENTITY_FQN(16, ERDUIMessages.erd_view_style_selection_item_fully_qualified_names, ERDUIMessages.erd_view_style_selection_item_fully_qualified_names_action),
    ALPHABETICAL_ORDER(32, ERDUIMessages.erd_view_style_selection_item_alphabetical_order, ERDUIMessages.erd_view_style_selection_item_alphabetical_order_action);

    private final int value;
    private final String title;
    private final String actionTitle;

    private ERDViewStyle(@NotNull int value, String title, String actionTitle) {
        this.value = value;
        this.title = title;
        this.actionTitle = actionTitle;
    }

    public int getValue() {
        return this.value;
    }

    @NotNull
    public String getTitle() {
        return this.title;
    }

    @NotNull
    public String getActionTitle() {
        return this.actionTitle;
    }

    @NotNull
    public static ERDViewStyle[] getDefaultStyles(@NotNull DBPPreferenceStore store) {
        String attrString = store.getString("erd.attr.styles");
        if (!CommonUtils.isEmpty((String)attrString)) {
            return (ERDViewStyle[])Arrays.stream(attrString.split(",")).map(x -> (ERDViewStyle)CommonUtils.valueOf(ERDViewStyle.class, (String)x)).filter(Objects::nonNull).toArray(ERDViewStyle[]::new);
        }
        return new ERDViewStyle[]{ICONS};
    }

    public static void setDefaultStyles(@NotNull DBPPreferenceStore store, @NotNull ERDViewStyle[] styles) {
        StringJoiner buffer = new StringJoiner(",");
        ERDViewStyle[] eRDViewStyleArray = styles;
        int n = styles.length;
        int n2 = 0;
        while (n2 < n) {
            ERDViewStyle style = eRDViewStyleArray[n2];
            buffer.add(style.name());
            ++n2;
        }
        store.setValue("erd.attr.styles", buffer.toString());
    }
}

