/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.erd.ui.editor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.swt.graphics.Color;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.erd.model.ERDEntityAttribute;
import org.jkiss.dbeaver.erd.ui.connector.ERDConnection;
import org.jkiss.dbeaver.erd.ui.editor.ERDHighlightingHandle;
import org.jkiss.dbeaver.erd.ui.part.AssociationPart;
import org.jkiss.dbeaver.erd.ui.part.AttributePart;
import org.jkiss.dbeaver.erd.ui.part.EntityPart;
import org.jkiss.dbeaver.erd.ui.part.NodePart;
import org.jkiss.dbeaver.utils.ListNode;

public class ERDHighlightingManager {
    private static final Log log = Log.getLog(ERDHighlightingManager.class);
    @NotNull
    private final Map<IFigure, PartHighlighter> highlightedParts = new HashMap<IFigure, PartHighlighter>();

    @NotNull
    public ERDHighlightingHandle highlight(@NotNull IFigure part, @NotNull Color color) {
        return this.highlightedParts.computeIfAbsent(part, iFigure -> new PartHighlighter((IFigure)iFigure)).highlight(color);
    }

    @Nullable
    public ERDHighlightingHandle makeHighlightingGroupHandle(@Nullable ListNode<ERDHighlightingHandle> highlightings) {
        if (highlightings == null) {
            return null;
        }
        return () -> {
            for (ERDHighlightingHandle highlighting : highlightings) {
                highlighting.release();
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public ListNode<ERDHighlightingHandle> highlightRelatedAttributes(@NotNull AttributePart attributePart, @NotNull Color color) {
        AssociationPart associationPart;
        AssociationPart associationPart2;
        void entityPart;
        EditPart editPart = attributePart.getParent();
        if (!(editPart instanceof EntityPart)) {
            return null;
        }
        EntityPart entityPart2 = (EntityPart)editPart;
        EntityPart cfr_ignored_0 = (EntityPart)editPart;
        ListNode highlightings = null;
        for (AssociationPart associationPart3 : attributePart.getAssociatingBySource()) {
            if (!associationPart3.getAssociation().getSourceAttributes().contains(attributePart.getAttribute()) && !associationPart3.getAssociation().getTargetAttributes().contains(attributePart.getAttribute())) continue;
            highlightings = ListNode.join(highlightings, this.highlightRelatedAttributes(associationPart3, color));
        }
        for (AssociationPart associationPart3 : attributePart.getAssociatingByTarget()) {
            if (!associationPart3.getAssociation().getSourceAttributes().contains(attributePart.getAttribute()) && !associationPart3.getAssociation().getTargetAttributes().contains(attributePart.getAttribute())) continue;
            highlightings = ListNode.join((ListNode)highlightings, this.highlightRelatedAttributes(associationPart3, color));
        }
        if (highlightings == null) {
            for (AssociationPart connection : entityPart.getSourceConnections()) {
                associationPart2 = connection;
                if (!(associationPart2 instanceof AssociationPart)) continue;
                if (!associationPart.getAssociation().getSourceAttributes().contains(attributePart.getAttribute()) && !associationPart.getAssociation().getTargetAttributes().contains(attributePart.getAttribute())) continue;
                highlightings = ListNode.join((ListNode)highlightings, this.highlightRelatedAttributes(associationPart, color));
            }
        }
        if (highlightings == null) {
            for (AssociationPart connection : entityPart.getTargetConnections()) {
                associationPart2 = connection;
                if (!(associationPart2 instanceof AssociationPart)) continue;
                if (!associationPart.getAssociation().getSourceAttributes().contains(attributePart.getAttribute()) && !associationPart.getAssociation().getTargetAttributes().contains(attributePart.getAttribute())) continue;
                highlightings = ListNode.join((ListNode)highlightings, this.highlightRelatedAttributes(associationPart, color));
            }
        }
        return highlightings;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public ListNode<ERDHighlightingHandle> highlightRelatedAttributes(@NotNull AssociationPart associationPart, @NotNull Color color) {
        ListNode highlightings = null;
        EntityPart sourceEntityPart = null;
        EditPart editPart = associationPart.getSource();
        if (editPart instanceof EntityPart) {
            void entityPartFromSource;
            EntityPart entityPart = (EntityPart)editPart;
            EntityPart cfr_ignored_0 = (EntityPart)editPart;
            sourceEntityPart = entityPartFromSource;
        } else {
            EditPart editPart2 = associationPart.getSource().getParent();
            if (editPart2 instanceof EntityPart) {
                void entityPartFromParent;
                EntityPart entityPart = (EntityPart)editPart2;
                EntityPart cfr_ignored_1 = (EntityPart)editPart2;
                sourceEntityPart = entityPartFromParent;
            }
        }
        List<AttributePart> sourcePartAttributes = this.getEntityAttributes(sourceEntityPart, associationPart.getAssociation().getSourceAttributes());
        for (NodePart attrPart : sourcePartAttributes) {
            highlightings = ListNode.push(highlightings, (Object)this.highlight((IFigure)attrPart.getFigure(), color));
        }
        EditPart editPart3 = associationPart.getSource();
        if (editPart3 instanceof EntityPart) {
            void entityPart;
            NodePart attrPart;
            attrPart = (EntityPart)editPart3;
            EntityPart cfr_ignored_2 = (EntityPart)editPart3;
            for (AttributePart attrPart2 : this.getEntityAttributes((EntityPart)entityPart, associationPart.getAssociation().getSourceAttributes())) {
                highlightings = ListNode.push((ListNode)highlightings, (Object)this.highlight((IFigure)attrPart2.getFigure(), color));
            }
        }
        EntityPart targetEntityPart = null;
        EditPart editPart4 = associationPart.getTarget();
        if (editPart4 instanceof EntityPart) {
            void entityPartFromSource;
            EntityPart entityPart = (EntityPart)editPart4;
            EntityPart cfr_ignored_3 = (EntityPart)editPart4;
            targetEntityPart = entityPartFromSource;
        } else {
            EditPart editPart5 = associationPart.getTarget().getParent();
            if (editPart5 instanceof EntityPart) {
                void entityPartFromParent;
                EntityPart entityPart = (EntityPart)editPart5;
                EntityPart cfr_ignored_4 = (EntityPart)editPart5;
                targetEntityPart = entityPartFromParent;
            }
        }
        List<AttributePart> targetPartAttributes = this.getEntityAttributes(targetEntityPart, associationPart.getAssociation().getTargetAttributes());
        for (NodePart attrPart : targetPartAttributes) {
            highlightings = ListNode.push((ListNode)highlightings, (Object)this.highlight((IFigure)attrPart.getFigure(), color));
        }
        EditPart editPart6 = associationPart.getTarget();
        if (editPart6 instanceof EntityPart) {
            void entityPart;
            NodePart attrPart;
            attrPart = (EntityPart)editPart6;
            EntityPart cfr_ignored_5 = (EntityPart)editPart6;
            for (AttributePart attrPart3 : this.getEntityAttributes((EntityPart)entityPart, associationPart.getAssociation().getTargetAttributes())) {
                highlightings = ListNode.push((ListNode)highlightings, (Object)this.highlight((IFigure)attrPart3.getFigure(), color));
            }
        }
        return highlightings;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public ListNode<ERDHighlightingHandle> highlightAssociation(@Nullable ListNode<ERDHighlightingHandle> highlightings, @NotNull AssociationPart associationPart, @NotNull Color color) {
        Connection connection = associationPart.getConnectionFigure();
        if (connection instanceof ERDConnection) {
            void erdConnection;
            ERDConnection eRDConnection = (ERDConnection)connection;
            ERDConnection cfr_ignored_0 = (ERDConnection)connection;
            erdConnection.setSelected(!erdConnection.isSelected());
        }
        highlightings = ListNode.push(highlightings, (Object)this.highlight(associationPart.getFigure(), color));
        return highlightings;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public ListNode<ERDHighlightingHandle> highlightAssociation(@Nullable ListNode<ERDHighlightingHandle> highlightings, @NotNull AttributePart attributePart, @NotNull Color color) {
        EditPart editPart;
        Object object;
        List associatingBySource = attributePart.getAssociatingBySource();
        if ((associatingBySource == null || associatingBySource.isEmpty()) && (object = attributePart.getParent()) instanceof EntityPart) {
            void entityPart;
            EntityPart entityPart2 = (EntityPart)object;
            EntityPart cfr_ignored_0 = (EntityPart)object;
            associatingBySource = entityPart.getSourceConnections();
        }
        for (AssociationPart associationPart : associatingBySource) {
            if (!associationPart.getAssociation().getSourceAttributes().contains(attributePart.getAttribute()) && !associationPart.getAssociation().getTargetAttributes().contains(attributePart.getAttribute())) continue;
            highlightings = ListNode.push(highlightings, (Object)this.highlight(associationPart.getFigure(), color));
        }
        List associatingByTarget = attributePart.getAssociatingByTarget();
        if ((associatingByTarget == null || associatingByTarget.isEmpty()) && (editPart = attributePart.getParent()) instanceof EntityPart) {
            void entityPart;
            EntityPart entityPart3 = (EntityPart)editPart;
            EntityPart cfr_ignored_1 = (EntityPart)editPart;
            associatingByTarget = entityPart.getTargetConnections();
        }
        for (AssociationPart associationPart : associatingByTarget) {
            if (!associationPart.getAssociation().getSourceAttributes().contains(attributePart.getAttribute()) && !associationPart.getAssociation().getTargetAttributes().contains(attributePart.getAttribute())) continue;
            highlightings = ListNode.push((ListNode)highlightings, (Object)this.highlight(associationPart.getFigure(), color));
        }
        return highlightings;
    }

    @NotNull
    private List<AttributePart> getEntityAttributes(@NotNull EntityPart source, @NotNull List<ERDEntityAttribute> columns) {
        ArrayList<AttributePart> result = new ArrayList<AttributePart>(columns.size());
        for (Object attrPart : source.getChildren()) {
            if (!(attrPart instanceof AttributePart) || !columns.contains(((AttributePart)attrPart).getAttribute())) continue;
            result.add((AttributePart)attrPart);
        }
        return result;
    }

    private static final class HighlightingEntry {
        public final Color color;

        public HighlightingEntry(@NotNull Color color) {
            this.color = color;
        }
    }

    private final class PartHighlighter {
        @NotNull
        private final IFigure part;
        @NotNull
        private final Color originalColor;
        private final boolean originalOpaque;
        @NotNull
        private final LinkedList<HighlightingEntry> highlightings = new LinkedList();

        public PartHighlighter(IFigure part) {
            this.originalColor = part instanceof Connection ? part.getForegroundColor() : part.getBackgroundColor();
            this.originalOpaque = part.isOpaque();
            this.part = part;
        }

        private void refresh() {
            try {
                if (this.highlightings.isEmpty()) {
                    if (this.part instanceof ERDConnection) {
                        this.part.setForegroundColor(this.originalColor);
                    } else {
                        this.part.setBackgroundColor(this.originalColor);
                    }
                    this.part.setOpaque(this.originalOpaque);
                } else {
                    if (this.part instanceof ERDConnection) {
                        this.part.setForegroundColor(this.highlightings.getLast().color);
                    } else {
                        this.part.setBackgroundColor(this.highlightings.getLast().color);
                    }
                    this.part.setOpaque(true);
                }
                this.part.repaint();
            }
            catch (Throwable ex) {
                log.warn((Object)"Inconsistent highlighting management detected during figure props refresh.", ex);
            }
        }

        @NotNull
        public ERDHighlightingHandle highlight(@NotNull Color color) {
            HighlightingEntry entry = new HighlightingEntry(color);
            this.highlightings.addLast(entry);
            this.refresh();
            return () -> {
                this.highlightings.remove(entry);
                if (this.highlightings.isEmpty()) {
                    ERDHighlightingManager.this.highlightedParts.remove(this.part);
                }
                this.refresh();
            };
        }
    }
}

