/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.erd.ui.editor;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.erd.ui.editor.ERDEditorPart;
import org.jkiss.dbeaver.erd.ui.model.DiagramLoader;
import org.jkiss.dbeaver.erd.ui.model.EntityDiagram;
import org.jkiss.dbeaver.erd.ui.part.DiagramPart;
import org.jkiss.dbeaver.model.app.DBPPlatformDesktop;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.load.AbstractLoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadService;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.LoadingJob;
import org.jkiss.dbeaver.ui.UIExecutionQueue;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.ConfirmationDialog;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class ERDEditorStandalone
extends ERDEditorPart
implements IResourceChangeListener {
    private static final Log log = Log.getLog(ERDEditorStandalone.class);

    @Override
    public void dispose() {
        super.dispose();
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    @Override
    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    @Override
    public boolean isReadOnly() {
        return !this.isProjectResourceEditable();
    }

    @Override
    public boolean isModelEditEnabled() {
        return super.isModelEditEnabled() && this.isProjectResourceEditable();
    }

    private boolean isProjectResourceEditable() {
        DBPProject project = this.getDiagramProject();
        return project == null || project.hasRealmPermission("project-resource-edit");
    }

    @Override
    public void refreshDiagram(boolean force, boolean refreshMetadata) {
        if (this.isDirty() && ConfirmationDialog.confirmAction(null, (String)"entity_revert", (int)3, (Object[])new Object[]{this.getTitle()}) != 2) {
            return;
        }
        super.refreshDiagram(force, refreshMetadata);
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.loadDiagram(false);
    }

    @Override
    public void doSave(IProgressMonitor monitor) {
        try {
            String diagramState = DiagramLoader.serializeDiagram(RuntimeUtils.makeMonitor((IProgressMonitor)monitor), this.getDiagramPart(), this.getDiagram(), false, false);
            IFile file = EditorUtils.getFileFromInput((IEditorInput)this.getEditorInput());
            if (file == null) {
                throw new DBException("Can't determine diagram file");
            }
            file.setContents((InputStream)new ByteArrayInputStream(diagramState.getBytes(StandardCharsets.UTF_8)), true, true, monitor);
            this.getCommandStack().markSaveLocation();
        }
        catch (Exception e) {
            DBWorkbench.getPlatformUI().showError("Save diagram", null, (Throwable)e);
        }
    }

    @Override
    protected synchronized void loadDiagram(boolean refreshMetadata) {
        if (this.diagramLoadingJob != null) {
            return;
        }
        this.diagramLoadingJob = LoadingJob.createService((ILoadService)new AbstractLoadService<EntityDiagram>("Load diagram '" + this.getEditorInput().getName() + "'"){

            public EntityDiagram evaluate(DBRProgressMonitor monitor) throws InvocationTargetException {
                try {
                    EntityDiagram entityDiagram = ERDEditorStandalone.this.loadContentFromFile(monitor);
                    ERDEditorStandalone.this.visuallize(monitor, entityDiagram);
                    return entityDiagram;
                }
                catch (DBException e) {
                    throw new InvocationTargetException(e);
                }
            }

            public Object getFamily() {
                return ERDEditorStandalone.this;
            }
        }, this.progressControl.createLoadVisualizer());
        this.diagramLoadingJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                ERDEditorStandalone.this.diagramLoadingJob = null;
            }
        });
        UIExecutionQueue.queueExec(() -> ((LoadingJob)this.diagramLoadingJob).schedule());
        this.setPartName(this.getEditorInput().getName());
    }

    @Override
    @NotNull
    public DBPProject getDiagramProject() {
        IFile resource = this.getEditorFile();
        if (resource != null) {
            return DBPPlatformDesktop.getInstance().getWorkspace().getProject(resource.getProject());
        }
        return DBWorkbench.getPlatform().getWorkspace().getActiveProject();
    }

    private EntityDiagram loadContentFromFile(DBRProgressMonitor progressMonitor) throws DBException {
        IStorage storage = EditorUtils.getStorageFromInput((Object)this.getEditorInput());
        DiagramPart diagramPart = this.getDiagramPart();
        EntityDiagram entityDiagram = new EntityDiagram(null, storage == null ? CommonUtils.toString((Object)this.getEditorInput()) : storage.getName(), this.getContentProvider(), this.getDecorator());
        entityDiagram.clear();
        entityDiagram.setLayoutManualAllowed(true);
        entityDiagram.setLayoutManualDesired(true);
        diagramPart.setModel(entityDiagram);
        if (storage != null) {
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (InputStreamReader isr = new InputStreamReader(storage.getContents(), GeneralUtils.UTF8_CHARSET);){
                    DiagramLoader.load(progressMonitor, this.getDiagramProject(), diagramPart, isr);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                throw new DBException("Error loading ER diagram from '" + storage.getName() + "'", (Throwable)e);
            }
        }
        return entityDiagram;
    }

    private IFile getEditorFile() {
        return EditorUtils.getFileFromInput((IEditorInput)this.getEditorInput());
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta == null) {
            return;
        }
        IFile file = this.getEditorFile();
        if (file == null) {
            return;
        }
        if ((delta = delta.findMember(file.getFullPath())) == null) {
            return;
        }
        if (delta.getKind() == 2) {
            if ((0x2000 & delta.getFlags()) != 0) {
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IFile newFile = workspace.getRoot().getFile(delta.getMovedToPath());
                this.setInput((IEditorInput)new FileEditorInput(newFile));
                this.setPartName(this.getEditorInput().getName());
            } else {
                UIUtils.asyncExec(() -> {
                    boolean bl = this.getSite().getWorkbenchWindow().getActivePage().closeEditor((IEditorPart)this, false);
                });
            }
        }
    }
}

