CREATE TABLE {table_prefix}QM_AI_COMPLETION_HISTORY (
    COMPLETION_ID BIGINT AUTO_INCREMENT NOT NULL,
    USER_ID BIGINT NOT NULL,

    DATASOURCE_ID VARCHAR(100) NOT NULL,
    LOGICAL_DATASOURCE_NAME VARCHAR(100),
    DEFAULT_CATALOG VARCHAR(64) NOT NULL,
    DEFAULT_SCHEMA VARCHAR(64) NOT NULL,

    NATURAL_TEXT TEXT NOT NULL,
    SQL_TEXT CLOB NULL,

    FIRST_COMPLETION_TIME TIMESTAMP NOT NULL,
    LAST_COMPLETION_TIME TIMESTAMP NOT NULL,
    COMPLETION_COUNT INTEGER NOT NULL,

    COMPLETION_ERROR VARCHAR(2048),
    QUERY_ERROR VARCHAR(2048),

    PRIMARY KEY (USER_ID,COMPLETION_ID),
    FOREIGN KEY (USER_ID) REFERENCES {table_prefix}QM_USER(USER_ID),
    FOREIGN KEY (DATASOURCE_ID) REFERENCES {table_prefix}QM_DATASOURCE(DATASOURCE_ID)
);

CREATE INDEX IDX_AI_HISTORY_CONNECTION ON {table_prefix}QM_AI_COMPLETION_HISTORY(USER_ID,DATASOURCE_ID,LOGICAL_DATASOURCE_NAME,DEFAULT_CATALOG,DEFAULT_SCHEMA);
