/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.influxdb.views;

import com.dbeaver.ee.influxdb.Activator;
import com.dbeaver.ee.influxdb.InfluxDBMessages;
import com.dbeaver.ee.influxdb.views.InfluxAdvancedSettingsPage;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.IDialogPageProvider;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageWithAuth;
import org.jkiss.utils.CommonUtils;

public class InfluxMainConnectionPage
extends ConnectionPageWithAuth
implements IDialogPageProvider {
    private static final ImageDescriptor logoImage = Activator.getImageDescriptor("platform:/plugin/com.dbeaver.db.influxdb/icons/influxdb_logo.png");
    private Composite settingsGroup;
    private Text hostText;
    private Text portText;
    private Text databaseText;
    private Button userSSLCheck;
    private Button trustSelfSignedCheck;
    private boolean activated;

    public void createControl(Composite composite) {
        this.setImageDescriptor(logoImage);
        this.createGeneralTab(composite);
        this.setControl((Control)this.settingsGroup);
    }

    private Composite createGeneralTab(Composite parent) {
        ModifyListener textListener = e -> {
            if (this.activated) {
                this.saveAndUpdate();
            }
        };
        this.settingsGroup = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        this.settingsGroup.setLayout((Layout)gl);
        GridData gd = new GridData(1808);
        this.settingsGroup.setLayoutData((Object)gd);
        Group serverGroup = UIUtils.createControlGroup((Composite)this.settingsGroup, (String)InfluxDBMessages.connection_page_control_group_server, (int)1, (int)768, (int)-1);
        Composite serverComposite = UIUtils.createComposite((Composite)serverGroup, (int)4);
        serverComposite.setLayoutData((Object)new GridData(768));
        this.hostText = UIUtils.createLabelText((Composite)serverComposite, (String)InfluxDBMessages.connection_page_label_text_host, (String)"");
        this.hostText.setLayoutData((Object)new GridData(768));
        this.hostText.addModifyListener(textListener);
        this.portText = UIUtils.createLabelText((Composite)serverComposite, (String)InfluxDBMessages.connection_page_label_text_port, (String)"");
        gd = new GridData(2);
        gd.widthHint = 60;
        this.portText.setLayoutData((Object)gd);
        this.portText.addModifyListener(textListener);
        this.databaseText = UIUtils.createLabelText((Composite)serverComposite, (String)InfluxDBMessages.connection_page_label_text_database, (String)"");
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.databaseText.setLayoutData((Object)gd);
        this.databaseText.addModifyListener(textListener);
        Composite sslComposite = UIUtils.createComposite((Composite)serverGroup, (int)2);
        sslComposite.setLayoutData((Object)new GridData(32));
        this.userSSLCheck = UIUtils.createCheckbox((Composite)sslComposite, (String)InfluxDBMessages.connection_page_checkbox_use_ssl, (String)InfluxDBMessages.connection_page_checkbox_tip_use_ssl, (boolean)false, (int)4);
        this.userSSLCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InfluxMainConnectionPage.this.trustSelfSignedCheck.setEnabled(InfluxMainConnectionPage.this.userSSLCheck.getSelection());
                if (!InfluxMainConnectionPage.this.userSSLCheck.getSelection()) {
                    InfluxMainConnectionPage.this.trustSelfSignedCheck.setSelection(false);
                }
            }
        });
        this.userSSLCheck.setLayoutData((Object)new GridData(256));
        this.trustSelfSignedCheck = UIUtils.createCheckbox((Composite)sslComposite, (String)InfluxDBMessages.connection_page_checkbox_trust_self_signed, (String)InfluxDBMessages.connection_page_checkbox_trust_self_signed_tip, (boolean)false, (int)4);
        this.trustSelfSignedCheck.setEnabled(this.userSSLCheck.getSelection());
        this.trustSelfSignedCheck.setLayoutData((Object)new GridData(256));
        this.createAuthPanel(this.settingsGroup, 1);
        this.createDriverPanel(this.settingsGroup);
        return this.settingsGroup;
    }

    public boolean isComplete() {
        return super.isComplete() && !this.hostText.getText().isEmpty() && !this.portText.getText().isEmpty();
    }

    public void loadSettings() {
        DBPConnectionConfiguration connectionInfo = this.site.getActiveDataSource().getConnectionConfiguration();
        if (this.hostText != null) {
            if (!CommonUtils.isEmpty((String)connectionInfo.getHostName())) {
                this.hostText.setText(CommonUtils.notEmpty((String)connectionInfo.getHostName()));
            } else {
                this.hostText.setText("localhost");
            }
            if (!CommonUtils.isEmpty((String)connectionInfo.getHostPort())) {
                this.portText.setText(connectionInfo.getHostPort());
            } else if (this.site.getDriver().getDefaultPort() != null) {
                this.portText.setText(this.site.getDriver().getDefaultPort());
            } else {
                this.portText.setText("");
            }
            if (!CommonUtils.isEmpty((String)connectionInfo.getDatabaseName())) {
                this.databaseText.setText(CommonUtils.notEmpty((String)connectionInfo.getDatabaseName()));
            } else {
                this.databaseText.setText("");
            }
            this.userSSLCheck.setSelection(CommonUtils.getBoolean((String)connectionInfo.getProviderProperty("@dbeaver-influxdb.use.ssl"), (boolean)false));
            this.trustSelfSignedCheck.setEnabled(this.userSSLCheck.getSelection());
            this.trustSelfSignedCheck.setSelection(CommonUtils.getBoolean((String)connectionInfo.getProviderProperty("influxdb.trust.self.signed"), (boolean)false));
        }
        super.loadSettings();
        this.activated = true;
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        if (this.hostText != null) {
            connectionInfo.setHostName(this.hostText.getText().trim());
            connectionInfo.setHostPort(this.portText.getText().trim());
            connectionInfo.setDatabaseName(this.databaseText.getText().trim());
            connectionInfo.setProviderProperty("@dbeaver-influxdb.use.ssl", String.valueOf(this.userSSLCheck.getSelection()));
            connectionInfo.setProviderProperty("influxdb.trust.self.signed", String.valueOf(this.trustSelfSignedCheck.getSelection()));
        }
        super.saveSettings(dataSource);
    }

    private void saveAndUpdate() {
        this.site.updateButtons();
    }

    public IDialogPage[] getDialogPages(boolean extrasOnly, boolean forceCreate) {
        return new IDialogPage[]{new InfluxAdvancedSettingsPage()};
    }
}

