/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.influxdb2.views;

import com.dbeaver.ee.influxdb2.Activator;
import com.dbeaver.ee.influxdb2.Influx2DBMessages;
import com.dbeaver.ee.influxdb2.views.Influx2AdvancedSettingsPage;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.IDialogPageProvider;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageWithAuth;
import org.jkiss.utils.CommonUtils;

public class Influx2MainConnectionPage
extends ConnectionPageWithAuth
implements IDialogPageProvider {
    private static ImageDescriptor logoImage = Activator.getImageDescriptor("icons/influxdb_logo.png");
    private Composite settingsGroup;
    private Text hostText;
    private Text portText;
    private Text databaseText;
    private Text orgText;
    private Button userSSLCheck;
    private Button trustSelfSignedCheck;
    private boolean activated;

    public void createControl(Composite composite) {
        this.setImageDescriptor(logoImage);
        this.createGeneralTab(composite);
        this.setControl((Control)this.settingsGroup);
    }

    private Composite createGeneralTab(Composite parent) {
        ModifyListener textListener = e -> {
            if (this.activated) {
                this.saveAndUpdate();
            }
        };
        this.settingsGroup = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        this.settingsGroup.setLayout((Layout)gl);
        GridData gd = new GridData(1808);
        this.settingsGroup.setLayoutData((Object)gd);
        Group serverGroup = UIUtils.createControlGroup((Composite)this.settingsGroup, (String)Influx2DBMessages.connection_page_control_group_server, (int)1, (int)768, (int)-1);
        Composite serverComposite = UIUtils.createComposite((Composite)serverGroup, (int)4);
        serverComposite.setLayoutData((Object)new GridData(768));
        this.hostText = UIUtils.createLabelText((Composite)serverComposite, (String)Influx2DBMessages.connection_page_label_text_host, (String)"");
        this.hostText.setLayoutData((Object)new GridData(768));
        this.hostText.addModifyListener(textListener);
        this.portText = UIUtils.createLabelText((Composite)serverComposite, (String)Influx2DBMessages.connection_page_label_text_port, (String)"");
        gd = new GridData(2);
        gd.widthHint = 60;
        this.portText.setLayoutData((Object)gd);
        this.portText.addModifyListener(textListener);
        this.databaseText = UIUtils.createLabelText((Composite)serverComposite, (String)Influx2DBMessages.connection_page_label_text_database, (String)"");
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.databaseText.setLayoutData((Object)gd);
        this.databaseText.addModifyListener(textListener);
        this.orgText = UIUtils.createLabelText((Composite)serverComposite, (String)Influx2DBMessages.connection_page_label_text_org, (String)"");
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.orgText.setLayoutData((Object)gd);
        this.orgText.addModifyListener(textListener);
        Composite sslComposite = UIUtils.createComposite((Composite)serverGroup, (int)2);
        sslComposite.setLayoutData((Object)new GridData(32));
        this.userSSLCheck = UIUtils.createCheckbox((Composite)sslComposite, (String)Influx2DBMessages.connection_page_checkbox_use_ssl, (String)Influx2DBMessages.connection_page_checkbox_tip_use_ssl, (boolean)false, (int)4);
        this.userSSLCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Influx2MainConnectionPage.this.trustSelfSignedCheck.setEnabled(Influx2MainConnectionPage.this.userSSLCheck.getSelection());
                if (!Influx2MainConnectionPage.this.userSSLCheck.getSelection()) {
                    Influx2MainConnectionPage.this.trustSelfSignedCheck.setSelection(false);
                }
            }
        });
        this.userSSLCheck.setLayoutData((Object)new GridData(256));
        this.trustSelfSignedCheck = UIUtils.createCheckbox((Composite)sslComposite, (String)Influx2DBMessages.connection_page_checkbox_trust_self_signed, (String)Influx2DBMessages.connection_page_checkbox_trust_self_signed_tip, (boolean)false, (int)4);
        this.trustSelfSignedCheck.setEnabled(this.userSSLCheck.getSelection());
        this.trustSelfSignedCheck.setLayoutData((Object)new GridData(256));
        this.createAuthPanel(this.settingsGroup, 1);
        this.createDriverPanel(this.settingsGroup);
        return this.settingsGroup;
    }

    public boolean isComplete() {
        return super.isComplete() && !this.hostText.getText().isEmpty() && !this.portText.getText().isEmpty() && !this.orgText.getText().isEmpty();
    }

    public void loadSettings() {
        DBPConnectionConfiguration connectionInfo = this.site.getActiveDataSource().getConnectionConfiguration();
        if (this.hostText != null) {
            if (!CommonUtils.isEmpty((String)connectionInfo.getHostName())) {
                this.hostText.setText(CommonUtils.notEmpty((String)connectionInfo.getHostName()));
            } else {
                this.hostText.setText("localhost");
            }
            if (!CommonUtils.isEmpty((String)connectionInfo.getHostPort())) {
                this.portText.setText(connectionInfo.getHostPort());
            } else if (this.site.getDriver().getDefaultPort() != null) {
                this.portText.setText(this.site.getDriver().getDefaultPort());
            } else {
                this.portText.setText("");
            }
            if (!CommonUtils.isEmpty((String)connectionInfo.getDatabaseName())) {
                this.databaseText.setText(CommonUtils.notEmpty((String)connectionInfo.getDatabaseName()));
            } else {
                this.databaseText.setText("");
            }
            if (!CommonUtils.isEmpty((String)connectionInfo.getProviderProperty("influx.org"))) {
                this.orgText.setText(CommonUtils.notEmpty((String)connectionInfo.getProviderProperty("influx.org")));
            } else {
                this.orgText.setText("");
            }
            this.userSSLCheck.setSelection(CommonUtils.getBoolean((String)connectionInfo.getProviderProperty("@dbeaver-influxdb.use.ssl"), (boolean)false));
            this.trustSelfSignedCheck.setEnabled(this.userSSLCheck.getSelection());
            this.trustSelfSignedCheck.setSelection(CommonUtils.getBoolean((String)connectionInfo.getProviderProperty("influxdb.trust.self.signed"), (boolean)false));
        }
        super.loadSettings();
        this.activated = true;
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        if (this.hostText != null) {
            connectionInfo.setHostName(this.hostText.getText().trim());
            connectionInfo.setHostPort(this.portText.getText().trim());
            connectionInfo.setDatabaseName(this.databaseText.getText().trim());
            connectionInfo.setProviderProperty("influx.org", this.orgText.getText().trim());
            connectionInfo.setProviderProperty("@dbeaver-influxdb.use.ssl", String.valueOf(this.userSSLCheck.getSelection()));
            connectionInfo.setProviderProperty("influxdb.trust.self.signed", String.valueOf(this.trustSelfSignedCheck.getSelection()));
        }
        super.saveSettings(dataSource);
    }

    private void saveAndUpdate() {
        this.site.updateButtons();
    }

    public IDialogPage[] getDialogPages(boolean extrasOnly, boolean forceCreate) {
        return new IDialogPage[]{new Influx2AdvancedSettingsPage()};
    }
}

