/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.influxdb2;

import com.dbeaver.ee.influxdb2.Influx2DBMessages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

public class Influx2TokenConfigurator
implements IObjectPropertyConfigurator<Object, DBPDataSourceContainer> {
    protected Text tokenText;

    public void createControl(@NotNull Composite parent, Object object, @NotNull Runnable propertyChangeListener) {
        int fontHeight = UIUtils.getFontHeight((Control)parent);
        UIUtils.createLabel((Composite)parent, (String)Influx2DBMessages.connection_page_auth_label_token);
        this.tokenText = new Text(parent, 0x400800);
        GridData gd = new GridData(768);
        gd.widthHint = fontHeight * 20;
        this.tokenText.setLayoutData((Object)gd);
        this.tokenText.addModifyListener(e -> propertyChangeListener.run());
    }

    public void loadSettings(@NotNull DBPDataSourceContainer dataSourceContainer) {
        DBPConnectionConfiguration connectionConfiguration = dataSourceContainer.getConnectionConfiguration();
        this.tokenText.setText(CommonUtils.notEmpty((String)connectionConfiguration.getAuthProperty("influx.token")));
    }

    public void saveSettings(@NotNull DBPDataSourceContainer dataSourceContainer) {
        dataSourceContainer.getConnectionConfiguration().setAuthProperty("influx.token", this.tokenText.getText());
    }

    public void resetSettings(@NotNull DBPDataSourceContainer dataSourceContainer) {
        this.loadSettings(dataSourceContainer);
    }

    public boolean isComplete() {
        return true;
    }
}

