/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.databricks.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.databricks.DatabricksDataSource;
import org.jkiss.dbeaver.ext.databricks.model.DatabricksSchema;
import org.jkiss.dbeaver.ext.databricks.model.DatabricksTable;
import org.jkiss.dbeaver.ext.databricks.model.DatabricksView;
import org.jkiss.dbeaver.ext.generic.model.GenericCatalog;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericView;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformProvider;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformType;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformer;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.sql.QueryTransformerLimit;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.utils.CommonUtils;

public class DatabricksMetaModel
extends GenericMetaModel
implements DBCQueryTransformProvider {
    private static final Log log = Log.getLog(DatabricksMetaModel.class);
    private List<ViewInfo> tempViewsList = new ArrayList<ViewInfo>();

    @Nullable
    public DBCQueryTransformer createQueryTransformer(@NotNull DBCQueryTransformType type) {
        if (type == DBCQueryTransformType.RESULT_SET_LIMIT) {
            return new QueryTransformerLimit(false, false);
        }
        return null;
    }

    public GenericDataSource createDataSourceImpl(DBRProgressMonitor monitor, DBPDataSourceContainer container) throws DBException {
        return new DatabricksDataSource(monitor, container, this);
    }

    public GenericSchema createSchemaImpl(@NotNull GenericDataSource dataSource, @Nullable GenericCatalog catalog, @NotNull String schemaName) {
        return new DatabricksSchema(dataSource, catalog, schemaName);
    }

    public boolean isSystemSchema(GenericSchema schema) {
        return "global_temp".equals(schema.getName()) || "information_schema".equalsIgnoreCase(schema.getName());
    }

    public JDBCStatement prepareTableLoadStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer owner, @Nullable GenericTableBase object, @Nullable String objectName) throws SQLException {
        block34: {
            boolean catalogChanged = false;
            DBSCatalog originalDefaultCatalog = null;
            DBCExecutionContextDefaults contextDefaults = session.getExecutionContext().getContextDefaults();
            try {
                try {
                    if (contextDefaults != null && (originalDefaultCatalog = contextDefaults.getDefaultCatalog()) != owner.getCatalog()) {
                        contextDefaults.setDefaultCatalog(session.getProgressMonitor(), (DBSCatalog)owner.getCatalog(), null);
                        catalogChanged = true;
                    }
                    Throwable throwable = null;
                    Object var9_11 = null;
                    try (JDBCPreparedStatement dbStat = session.prepareStatement("SHOW VIEWS IN " + DBUtils.getQuotedIdentifier((DBSObject)owner));){
                        Throwable throwable2 = null;
                        Object var12_16 = null;
                        try (JDBCResultSet dbResult = dbStat.executeQuery();){
                            while (dbResult.next()) {
                                String viewName;
                                String namespace = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"namespace");
                                if (CommonUtils.isEmpty((String)namespace) || !CommonUtils.isNotEmpty((String)(viewName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"viewName")))) continue;
                                this.tempViewsList.add(new ViewInfo(owner, viewName));
                            }
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                        } else if (throwable != throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        throw throwable;
                    }
                }
                catch (SQLException | DBCException e) {
                    log.debug((Object)"Can't read current views list", e);
                    if (catalogChanged && originalDefaultCatalog != null) {
                        try {
                            contextDefaults.setDefaultCatalog(session.getProgressMonitor(), originalDefaultCatalog, null);
                        }
                        catch (DBCException e2) {
                            log.debug((Object)"Can't set original default catalog", (Throwable)e2);
                        }
                    }
                    break block34;
                }
            }
            catch (Throwable throwable) {
                if (catalogChanged && originalDefaultCatalog != null) {
                    try {
                        contextDefaults.setDefaultCatalog(session.getProgressMonitor(), originalDefaultCatalog, null);
                    }
                    catch (DBCException e) {
                        log.debug((Object)"Can't set original default catalog", (Throwable)e);
                    }
                }
                throw throwable;
            }
            if (catalogChanged && originalDefaultCatalog != null) {
                try {
                    contextDefaults.setDefaultCatalog(session.getProgressMonitor(), originalDefaultCatalog, null);
                }
                catch (DBCException e) {
                    log.debug((Object)"Can't set original default catalog", (Throwable)e);
                }
            }
        }
        return super.prepareTableLoadStatement(session, owner, object, objectName);
    }

    public GenericTableBase createTableOrViewImpl(GenericStructContainer container, @Nullable String tableName, @Nullable String tableType, @Nullable JDBCResultSet dbResult) {
        if (CommonUtils.isNotEmpty((String)tableName) && !this.tempViewsList.isEmpty() && this.tempViewsList.stream().anyMatch(e -> e.name.equalsIgnoreCase(tableName)) || tableType != null && this.isView(tableType)) {
            return new DatabricksView(container, tableName, tableType, dbResult);
        }
        return new DatabricksTable(container, tableName, tableType, dbResult);
    }

    public boolean supportsTableDDLSplit(GenericTableBase sourceObject) {
        return false;
    }

    public boolean isTableCommentEditable() {
        return true;
    }

    /*
     * Exception decompiling
     */
    public String getTableDDL(DBRProgressMonitor monitor, GenericTableBase sourceObject, Map<String, Object> options) throws DBException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String getViewDDL(DBRProgressMonitor monitor, GenericView sourceObject, Map<String, Object> options) throws DBException {
        return this.getTableDDL(monitor, (GenericTableBase)sourceObject, options);
    }

    private class ViewInfo {
        GenericStructContainer schema;
        String name;

        ViewInfo(GenericStructContainer schema, String name) {
            this.schema = schema;
            this.name = name;
        }
    }
}

