/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.mysqlflexibleserver.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.mysqlflexibleserver.MySqlManager;
import com.azure.resourcemanager.mysqlflexibleserver.fluent.models.ServerInner;
import com.azure.resourcemanager.mysqlflexibleserver.implementation.Utils;
import com.azure.resourcemanager.mysqlflexibleserver.models.Backup;
import com.azure.resourcemanager.mysqlflexibleserver.models.CreateMode;
import com.azure.resourcemanager.mysqlflexibleserver.models.DataEncryption;
import com.azure.resourcemanager.mysqlflexibleserver.models.HighAvailability;
import com.azure.resourcemanager.mysqlflexibleserver.models.Identity;
import com.azure.resourcemanager.mysqlflexibleserver.models.MaintenanceWindow;
import com.azure.resourcemanager.mysqlflexibleserver.models.Network;
import com.azure.resourcemanager.mysqlflexibleserver.models.ReplicationRole;
import com.azure.resourcemanager.mysqlflexibleserver.models.Server;
import com.azure.resourcemanager.mysqlflexibleserver.models.ServerForUpdate;
import com.azure.resourcemanager.mysqlflexibleserver.models.ServerGtidSetParameter;
import com.azure.resourcemanager.mysqlflexibleserver.models.ServerRestartParameter;
import com.azure.resourcemanager.mysqlflexibleserver.models.ServerState;
import com.azure.resourcemanager.mysqlflexibleserver.models.ServerVersion;
import com.azure.resourcemanager.mysqlflexibleserver.models.Sku;
import com.azure.resourcemanager.mysqlflexibleserver.models.Storage;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.Map;

public final class ServerImpl
implements Server,
Server.Definition,
Server.Update {
    private ServerInner innerObject;
    private final MySqlManager serviceManager;
    private String resourceGroupName;
    private String serverName;
    private ServerForUpdate updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public Identity identity() {
        return this.innerModel().identity();
    }

    @Override
    public Sku sku() {
        return this.innerModel().sku();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String administratorLogin() {
        return this.innerModel().administratorLogin();
    }

    @Override
    public String administratorLoginPassword() {
        return this.innerModel().administratorLoginPassword();
    }

    @Override
    public ServerVersion version() {
        return this.innerModel().version();
    }

    @Override
    public String availabilityZone() {
        return this.innerModel().availabilityZone();
    }

    @Override
    public CreateMode createMode() {
        return this.innerModel().createMode();
    }

    @Override
    public String sourceServerResourceId() {
        return this.innerModel().sourceServerResourceId();
    }

    @Override
    public OffsetDateTime restorePointInTime() {
        return this.innerModel().restorePointInTime();
    }

    @Override
    public ReplicationRole replicationRole() {
        return this.innerModel().replicationRole();
    }

    @Override
    public Integer replicaCapacity() {
        return this.innerModel().replicaCapacity();
    }

    @Override
    public DataEncryption dataEncryption() {
        return this.innerModel().dataEncryption();
    }

    @Override
    public ServerState state() {
        return this.innerModel().state();
    }

    @Override
    public String fullyQualifiedDomainName() {
        return this.innerModel().fullyQualifiedDomainName();
    }

    @Override
    public Storage storage() {
        return this.innerModel().storage();
    }

    @Override
    public Backup backup() {
        return this.innerModel().backup();
    }

    @Override
    public HighAvailability highAvailability() {
        return this.innerModel().highAvailability();
    }

    @Override
    public Network network() {
        return this.innerModel().network();
    }

    @Override
    public MaintenanceWindow maintenanceWindow() {
        return this.innerModel().maintenanceWindow();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ServerInner innerModel() {
        return this.innerObject;
    }

    private MySqlManager manager() {
        return this.serviceManager;
    }

    @Override
    public ServerImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public Server create() {
        this.innerObject = this.serviceManager.serviceClient().getServers().create(this.resourceGroupName, this.serverName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public Server create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getServers().create(this.resourceGroupName, this.serverName, this.innerModel(), context);
        return this;
    }

    ServerImpl(String name, MySqlManager serviceManager) {
        this.innerObject = new ServerInner();
        this.serviceManager = serviceManager;
        this.serverName = name;
    }

    @Override
    public ServerImpl update() {
        this.updateParameters = new ServerForUpdate();
        return this;
    }

    @Override
    public Server apply() {
        this.innerObject = this.serviceManager.serviceClient().getServers().update(this.resourceGroupName, this.serverName, this.updateParameters, Context.NONE);
        return this;
    }

    @Override
    public Server apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getServers().update(this.resourceGroupName, this.serverName, this.updateParameters, context);
        return this;
    }

    ServerImpl(ServerInner innerObject, MySqlManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = Utils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serverName = Utils.getValueFromIdByName(innerObject.id(), "flexibleServers");
    }

    @Override
    public Server refresh() {
        this.innerObject = (ServerInner)((Object)this.serviceManager.serviceClient().getServers().getByResourceGroupWithResponse(this.resourceGroupName, this.serverName, Context.NONE).getValue());
        return this;
    }

    @Override
    public Server refresh(Context context) {
        this.innerObject = (ServerInner)((Object)this.serviceManager.serviceClient().getServers().getByResourceGroupWithResponse(this.resourceGroupName, this.serverName, context).getValue());
        return this;
    }

    @Override
    public void failover() {
        this.serviceManager.servers().failover(this.resourceGroupName, this.serverName);
    }

    @Override
    public void failover(Context context) {
        this.serviceManager.servers().failover(this.resourceGroupName, this.serverName, context);
    }

    @Override
    public void restart(ServerRestartParameter parameters) {
        this.serviceManager.servers().restart(this.resourceGroupName, this.serverName, parameters);
    }

    @Override
    public void restart(ServerRestartParameter parameters, Context context) {
        this.serviceManager.servers().restart(this.resourceGroupName, this.serverName, parameters, context);
    }

    @Override
    public void start() {
        this.serviceManager.servers().start(this.resourceGroupName, this.serverName);
    }

    @Override
    public void start(Context context) {
        this.serviceManager.servers().start(this.resourceGroupName, this.serverName, context);
    }

    @Override
    public void stop() {
        this.serviceManager.servers().stop(this.resourceGroupName, this.serverName);
    }

    @Override
    public void stop(Context context) {
        this.serviceManager.servers().stop(this.resourceGroupName, this.serverName, context);
    }

    @Override
    public void resetGtid(ServerGtidSetParameter parameters) {
        this.serviceManager.servers().resetGtid(this.resourceGroupName, this.serverName, parameters);
    }

    @Override
    public void resetGtid(ServerGtidSetParameter parameters, Context context) {
        this.serviceManager.servers().resetGtid(this.resourceGroupName, this.serverName, parameters, context);
    }

    @Override
    public ServerImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public ServerImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public ServerImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateParameters.withTags(tags);
        return this;
    }

    @Override
    public ServerImpl withIdentity(Identity identity) {
        if (this.isInCreateMode()) {
            this.innerModel().withIdentity(identity);
            return this;
        }
        this.updateParameters.withIdentity(identity);
        return this;
    }

    @Override
    public ServerImpl withSku(Sku sku) {
        if (this.isInCreateMode()) {
            this.innerModel().withSku(sku);
            return this;
        }
        this.updateParameters.withSku(sku);
        return this;
    }

    @Override
    public ServerImpl withAdministratorLogin(String administratorLogin) {
        this.innerModel().withAdministratorLogin(administratorLogin);
        return this;
    }

    @Override
    public ServerImpl withAdministratorLoginPassword(String administratorLoginPassword) {
        if (this.isInCreateMode()) {
            this.innerModel().withAdministratorLoginPassword(administratorLoginPassword);
            return this;
        }
        this.updateParameters.withAdministratorLoginPassword(administratorLoginPassword);
        return this;
    }

    @Override
    public ServerImpl withVersion(ServerVersion version) {
        if (this.isInCreateMode()) {
            this.innerModel().withVersion(version);
            return this;
        }
        this.updateParameters.withVersion(version);
        return this;
    }

    @Override
    public ServerImpl withAvailabilityZone(String availabilityZone) {
        this.innerModel().withAvailabilityZone(availabilityZone);
        return this;
    }

    @Override
    public ServerImpl withCreateMode(CreateMode createMode) {
        this.innerModel().withCreateMode(createMode);
        return this;
    }

    @Override
    public ServerImpl withSourceServerResourceId(String sourceServerResourceId) {
        this.innerModel().withSourceServerResourceId(sourceServerResourceId);
        return this;
    }

    @Override
    public ServerImpl withRestorePointInTime(OffsetDateTime restorePointInTime) {
        this.innerModel().withRestorePointInTime(restorePointInTime);
        return this;
    }

    @Override
    public ServerImpl withReplicationRole(ReplicationRole replicationRole) {
        if (this.isInCreateMode()) {
            this.innerModel().withReplicationRole(replicationRole);
            return this;
        }
        this.updateParameters.withReplicationRole(replicationRole);
        return this;
    }

    @Override
    public ServerImpl withDataEncryption(DataEncryption dataEncryption) {
        if (this.isInCreateMode()) {
            this.innerModel().withDataEncryption(dataEncryption);
            return this;
        }
        this.updateParameters.withDataEncryption(dataEncryption);
        return this;
    }

    @Override
    public ServerImpl withStorage(Storage storage) {
        if (this.isInCreateMode()) {
            this.innerModel().withStorage(storage);
            return this;
        }
        this.updateParameters.withStorage(storage);
        return this;
    }

    @Override
    public ServerImpl withBackup(Backup backup) {
        if (this.isInCreateMode()) {
            this.innerModel().withBackup(backup);
            return this;
        }
        this.updateParameters.withBackup(backup);
        return this;
    }

    @Override
    public ServerImpl withHighAvailability(HighAvailability highAvailability) {
        if (this.isInCreateMode()) {
            this.innerModel().withHighAvailability(highAvailability);
            return this;
        }
        this.updateParameters.withHighAvailability(highAvailability);
        return this;
    }

    @Override
    public ServerImpl withNetwork(Network network) {
        if (this.isInCreateMode()) {
            this.innerModel().withNetwork(network);
            return this;
        }
        this.updateParameters.withNetwork(network);
        return this;
    }

    @Override
    public ServerImpl withMaintenanceWindow(MaintenanceWindow maintenanceWindow) {
        this.updateParameters.withMaintenanceWindow(maintenanceWindow);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

