/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.mysqlflexibleserver.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.mysqlflexibleserver.MySqlManager;
import com.azure.resourcemanager.mysqlflexibleserver.fluent.LogFilesClient;
import com.azure.resourcemanager.mysqlflexibleserver.fluent.models.LogFileInner;
import com.azure.resourcemanager.mysqlflexibleserver.implementation.LogFileImpl;
import com.azure.resourcemanager.mysqlflexibleserver.implementation.Utils;
import com.azure.resourcemanager.mysqlflexibleserver.models.LogFile;
import com.azure.resourcemanager.mysqlflexibleserver.models.LogFiles;

public final class LogFilesImpl
implements LogFiles {
    private static final ClientLogger LOGGER = new ClientLogger(LogFilesImpl.class);
    private final LogFilesClient innerClient;
    private final MySqlManager serviceManager;

    public LogFilesImpl(LogFilesClient innerClient, MySqlManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<LogFile> listByServer(String resourceGroupName, String serverName) {
        PagedIterable<LogFileInner> inner = this.serviceClient().listByServer(resourceGroupName, serverName);
        return Utils.mapPage(inner, inner1 -> new LogFileImpl((LogFileInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<LogFile> listByServer(String resourceGroupName, String serverName, Context context) {
        PagedIterable<LogFileInner> inner = this.serviceClient().listByServer(resourceGroupName, serverName, context);
        return Utils.mapPage(inner, inner1 -> new LogFileImpl((LogFileInner)((Object)inner1), this.manager()));
    }

    private LogFilesClient serviceClient() {
        return this.innerClient;
    }

    private MySqlManager manager() {
        return this.serviceManager;
    }
}

