/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.mysqlflexibleserver.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.mysqlflexibleserver.MySqlManager;
import com.azure.resourcemanager.mysqlflexibleserver.fluent.CheckVirtualNetworkSubnetUsagesClient;
import com.azure.resourcemanager.mysqlflexibleserver.fluent.models.VirtualNetworkSubnetUsageResultInner;
import com.azure.resourcemanager.mysqlflexibleserver.implementation.VirtualNetworkSubnetUsageResultImpl;
import com.azure.resourcemanager.mysqlflexibleserver.models.CheckVirtualNetworkSubnetUsages;
import com.azure.resourcemanager.mysqlflexibleserver.models.VirtualNetworkSubnetUsageParameter;
import com.azure.resourcemanager.mysqlflexibleserver.models.VirtualNetworkSubnetUsageResult;

public final class CheckVirtualNetworkSubnetUsagesImpl
implements CheckVirtualNetworkSubnetUsages {
    private static final ClientLogger LOGGER = new ClientLogger(CheckVirtualNetworkSubnetUsagesImpl.class);
    private final CheckVirtualNetworkSubnetUsagesClient innerClient;
    private final MySqlManager serviceManager;

    public CheckVirtualNetworkSubnetUsagesImpl(CheckVirtualNetworkSubnetUsagesClient innerClient, MySqlManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<VirtualNetworkSubnetUsageResult> executeWithResponse(String locationName, VirtualNetworkSubnetUsageParameter parameters, Context context) {
        Response<VirtualNetworkSubnetUsageResultInner> inner = this.serviceClient().executeWithResponse(locationName, parameters, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new VirtualNetworkSubnetUsageResultImpl((VirtualNetworkSubnetUsageResultInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public VirtualNetworkSubnetUsageResult execute(String locationName, VirtualNetworkSubnetUsageParameter parameters) {
        VirtualNetworkSubnetUsageResultInner inner = this.serviceClient().execute(locationName, parameters);
        if (inner != null) {
            return new VirtualNetworkSubnetUsageResultImpl(inner, this.manager());
        }
        return null;
    }

    private CheckVirtualNetworkSubnetUsagesClient serviceClient() {
        return this.innerClient;
    }

    private MySqlManager manager() {
        return this.serviceManager;
    }
}

