/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.mysqlflexibleserver.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.mysqlflexibleserver.MySqlManager;
import com.azure.resourcemanager.mysqlflexibleserver.fluent.BackupAndExportsClient;
import com.azure.resourcemanager.mysqlflexibleserver.fluent.models.BackupAndExportResponseInner;
import com.azure.resourcemanager.mysqlflexibleserver.fluent.models.ValidateBackupResponseInner;
import com.azure.resourcemanager.mysqlflexibleserver.implementation.BackupAndExportResponseImpl;
import com.azure.resourcemanager.mysqlflexibleserver.implementation.ValidateBackupResponseImpl;
import com.azure.resourcemanager.mysqlflexibleserver.models.BackupAndExportRequest;
import com.azure.resourcemanager.mysqlflexibleserver.models.BackupAndExportResponse;
import com.azure.resourcemanager.mysqlflexibleserver.models.BackupAndExports;
import com.azure.resourcemanager.mysqlflexibleserver.models.ValidateBackupResponse;

public final class BackupAndExportsImpl
implements BackupAndExports {
    private static final ClientLogger LOGGER = new ClientLogger(BackupAndExportsImpl.class);
    private final BackupAndExportsClient innerClient;
    private final MySqlManager serviceManager;

    public BackupAndExportsImpl(BackupAndExportsClient innerClient, MySqlManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public BackupAndExportResponse create(String resourceGroupName, String serverName, BackupAndExportRequest parameters) {
        BackupAndExportResponseInner inner = this.serviceClient().create(resourceGroupName, serverName, parameters);
        if (inner != null) {
            return new BackupAndExportResponseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public BackupAndExportResponse create(String resourceGroupName, String serverName, BackupAndExportRequest parameters, Context context) {
        BackupAndExportResponseInner inner = this.serviceClient().create(resourceGroupName, serverName, parameters, context);
        if (inner != null) {
            return new BackupAndExportResponseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<ValidateBackupResponse> validateBackupWithResponse(String resourceGroupName, String serverName, Context context) {
        Response<ValidateBackupResponseInner> inner = this.serviceClient().validateBackupWithResponse(resourceGroupName, serverName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ValidateBackupResponseImpl((ValidateBackupResponseInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public ValidateBackupResponse validateBackup(String resourceGroupName, String serverName) {
        ValidateBackupResponseInner inner = this.serviceClient().validateBackup(resourceGroupName, serverName);
        if (inner != null) {
            return new ValidateBackupResponseImpl(inner, this.manager());
        }
        return null;
    }

    private BackupAndExportsClient serviceClient() {
        return this.innerClient;
    }

    private MySqlManager manager() {
        return this.serviceManager;
    }
}

