/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.oracle.model.data;

import java.sql.SQLException;
import java.sql.Struct;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.data.gis.handlers.GISGeometryValueHandler;
import org.jkiss.dbeaver.model.data.DBDValueBinder;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.gis.DBGeometry;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.geotools.oracle.SDOGeometryConverter;
import org.locationtech.jts.geom.Geometry;

public class OracleGeometryValueHandler
extends GISGeometryValueHandler
implements DBDValueBinder {
    public static final OracleGeometryValueHandler INSTANCE = new OracleGeometryValueHandler();
    private SDOGeometryConverter geometryConverter = new SDOGeometryConverter();

    protected Object fetchColumnValue(DBCSession session, JDBCResultSet resultSet, DBSTypedObject type, int index) throws DBCException, SQLException {
        return this.getValueFromObject(session, type, resultSet.getObject(index), false, false);
    }

    protected void bindParameter(JDBCSession session, JDBCPreparedStatement statement, DBSTypedObject paramType, int paramIndex, Object value) throws DBCException, SQLException {
        if (value instanceof DBGeometry) {
            value = ((DBGeometry)value).getRawValue();
        }
        if (value == null) {
            statement.setNull(paramIndex, paramType.getTypeID(), paramType.getFullTypeName());
        } else if (value instanceof Geometry) {
            statement.setString(paramIndex, ((Geometry)value).toText());
        }
    }

    public String makeQueryBind(DBSAttributeBase attribute, Object value) throws DBCException {
        if (value instanceof DBGeometry) {
            ((DBGeometry)value).getSRID();
        } else if (value instanceof Geometry) {
            ((Geometry)value).getSRID();
        }
        return "SDO_UTIL.FROM_WKTGEOMETRY(?)";
    }

    @NotNull
    public DBGeometry getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, Object object, boolean copy, boolean validateValue) throws DBCException {
        if (object instanceof Struct) {
            try {
                return new DBGeometry(this.geometryConverter.asGeometry((Struct)object));
            }
            catch (Exception e) {
                throw new DBCException("Error converting geometry value", (Throwable)e);
            }
        }
        return super.getValueFromObject(session, type, object, copy, validateValue);
    }
}

