/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.oracle.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchema;
import org.jkiss.dbeaver.ext.oracle.model.OracleTable;
import org.jkiss.dbeaver.ext.oracle.model.OracleTablePartition;
import org.jkiss.dbeaver.ext.oracle.model.OracleTablePhysical;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLStructEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLTableManager;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.utils.CommonUtils;

public class OracleTablePartitionManager
extends SQLTableManager<OracleTablePartition, OracleSchema>
implements DBEObjectRenamer<OracleTablePartition> {
    private static final Class<? extends DBSObject>[] CHILD_TYPES = (Class[])CommonUtils.array((Object[])new Class[]{OracleTablePartition.class});

    @NotNull
    public Class<? extends DBSObject>[] getChildTypes() {
        return CHILD_TYPES;
    }

    public long getMakerOptions(DBPDataSource dataSource) {
        return 1L;
    }

    protected OracleTablePartition createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object container, Object copyFrom, Map<String, Object> options) {
        OracleTablePartition partition = null;
        OracleTable parentTable = null;
        OracleTablePartition partitionParent = null;
        if (container instanceof OracleTable) {
            parentTable = (OracleTable)container;
        } else if (container instanceof OracleTablePartition) {
            parentTable = ((OracleTablePartition)container).getParent();
            partitionParent = (OracleTablePartition)container;
        }
        if (parentTable != null) {
            partition = new OracleTablePartition(parentTable.getSchema(), "NEW_PARTITION", (OracleTablePhysical)parentTable, partitionParent);
            if (partitionParent != null) {
                partitionParent.addSubPartition(partition);
            }
        }
        return partition;
    }

    protected void addStructObjectCreateActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLStructEditor.StructCreateCommand command, Map<String, Object> options) {
        OracleTablePartition partition = (OracleTablePartition)command.getObject();
        String partName = DBUtils.getQuotedIdentifier((DBSObject)partition);
        boolean subPartition = partition.isSubPartition();
        StringBuilder query = new StringBuilder(64);
        query.append("ALTER TABLE ").append(partition.getParent().getFullyQualifiedName(DBPEvaluationContext.DDL)).append(subPartition ? " MODIFY" : " ADD").append(" PARTITION ").append(subPartition ? DBUtils.getQuotedIdentifier((DBSObject)partition.getPartitionParent()) : partName).append(subPartition ? " ADD SUBPARTITION " + partName : "").append("\nVALUES ");
        if (partition.isPartitionByRange()) {
            query.append("LESS THAN ");
        }
        query.append("(").append(partition.getValuesForCreating()).append(")");
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create new partition", query.toString()));
    }

    @Nullable
    public DBSObjectCache<? extends DBSObject, OracleTablePartition> getObjectsCache(OracleTablePartition object) {
        return object.getParent().getPartitionCache();
    }

    protected void addObjectModifyActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) throws DBException {
        Map properties = command.getProperties();
        if (properties.containsKey("tablespace")) {
            OracleTablePartition partition = (OracleTablePartition)command.getObject();
            String tablespaceName = CommonUtils.toString(properties.get("tablespace"));
            if (CommonUtils.isNotEmpty((String)tablespaceName)) {
                actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Move partition", "ALTER TABLE " + partition.getParent().getFullyQualifiedName(DBPEvaluationContext.DDL) + " MOVE " + (partition.isSubPartition() ? "SUB" : "") + "PARTITION " + DBUtils.getQuotedIdentifier((DBSObject)partition) + " TABLESPACE " + tablespaceName));
            }
        }
        super.addObjectModifyActions(monitor, executionContext, actionList, command, options);
    }

    public void renameObject(@NotNull DBECommandContext commandContext, @NotNull OracleTablePartition object, @NotNull Map<String, Object> options, @NotNull String newName) throws DBException {
        this.processObjectRename(commandContext, (DBSObject)object, options, newName);
    }

    protected void addObjectRenameActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectRenameCommand command, Map<String, Object> options) {
        OracleTablePartition tablePartition = (OracleTablePartition)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename table partition", "ALTER TABLE " + tablePartition.getParent().getFullyQualifiedName(DBPEvaluationContext.DDL) + " RENAME " + (tablePartition.isSubPartition() ? "SUB" : "") + "PARTITION " + DBUtils.getQuotedIdentifier((DBPDataSource)tablePartition.getDataSource(), (String)command.getOldName()) + " TO " + DBUtils.getQuotedIdentifier((DBPDataSource)tablePartition.getDataSource(), (String)command.getNewName())));
    }

    protected void addObjectDeleteActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) {
        OracleTablePartition object = (OracleTablePartition)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop table partition", "ALTER TABLE " + object.getParent().getFullyQualifiedName(DBPEvaluationContext.DDL) + " DROP " + (object.isSubPartition() ? "SUB" : "") + "PARTITION " + DBUtils.getQuotedIdentifier((DBSObject)object)));
    }
}

