/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.admin.directory;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.admin.directory.DirectoryRequest;
import com.google.api.services.admin.directory.DirectoryRequestInitializer;
import com.google.api.services.admin.directory.model.Alias;
import com.google.api.services.admin.directory.model.Aliases;
import com.google.api.services.admin.directory.model.Asp;
import com.google.api.services.admin.directory.model.Building;
import com.google.api.services.admin.directory.model.Buildings;
import com.google.api.services.admin.directory.model.CalendarResource;
import com.google.api.services.admin.directory.model.CalendarResources;
import com.google.api.services.admin.directory.model.Channel;
import com.google.api.services.admin.directory.model.ChromeOsDevice;
import com.google.api.services.admin.directory.model.ChromeOsDeviceAction;
import com.google.api.services.admin.directory.model.ChromeOsDevices;
import com.google.api.services.admin.directory.model.ChromeOsMoveDevicesToOu;
import com.google.api.services.admin.directory.model.Customer;
import com.google.api.services.admin.directory.model.DomainAlias;
import com.google.api.services.admin.directory.model.Domains2;
import com.google.api.services.admin.directory.model.Feature;
import com.google.api.services.admin.directory.model.FeatureRename;
import com.google.api.services.admin.directory.model.Features;
import com.google.api.services.admin.directory.model.Group;
import com.google.api.services.admin.directory.model.Member;
import com.google.api.services.admin.directory.model.MembersHasMember;
import com.google.api.services.admin.directory.model.MobileDevice;
import com.google.api.services.admin.directory.model.MobileDeviceAction;
import com.google.api.services.admin.directory.model.MobileDevices;
import com.google.api.services.admin.directory.model.Notification;
import com.google.api.services.admin.directory.model.OrgUnit;
import com.google.api.services.admin.directory.model.OrgUnits;
import com.google.api.services.admin.directory.model.Role;
import com.google.api.services.admin.directory.model.RoleAssignment;
import com.google.api.services.admin.directory.model.Schema;
import com.google.api.services.admin.directory.model.Token;
import com.google.api.services.admin.directory.model.User;
import com.google.api.services.admin.directory.model.UserMakeAdmin;
import com.google.api.services.admin.directory.model.UserPhoto;
import com.google.api.services.admin.directory.model.UserUndelete;
import java.io.IOException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Directory
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "admin/directory/v1/";
    public static final String DEFAULT_BATCH_PATH = "batch/admin/directory_v1";
    public static final String DEFAULT_BASE_URL = "https://www.googleapis.com/admin/directory/v1/";

    public Directory(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    Directory(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public Asps asps() {
        return new Asps();
    }

    public Channels channels() {
        return new Channels();
    }

    public Chromeosdevices chromeosdevices() {
        return new Chromeosdevices();
    }

    public Customers customers() {
        return new Customers();
    }

    public DomainAliases domainAliases() {
        return new DomainAliases();
    }

    public Domains domains() {
        return new Domains();
    }

    public Groups groups() {
        return new Groups();
    }

    public Members members() {
        return new Members();
    }

    public Mobiledevices mobiledevices() {
        return new Mobiledevices();
    }

    public Notifications notifications() {
        return new Notifications();
    }

    public Orgunits orgunits() {
        return new Orgunits();
    }

    public Privileges privileges() {
        return new Privileges();
    }

    public Resources resources() {
        return new Resources();
    }

    public RoleAssignments roleAssignments() {
        return new RoleAssignments();
    }

    public Roles roles() {
        return new Roles();
    }

    public Schemas schemas() {
        return new Schemas();
    }

    public Tokens tokens() {
        return new Tokens();
    }

    public Users users() {
        return new Users();
    }

    public VerificationCodes verificationCodes() {
        return new VerificationCodes();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.25.0 of the Admin Directory API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, Directory.DEFAULT_ROOT_URL, Directory.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Directory.DEFAULT_BATCH_PATH);
        }

        public Directory build() {
            return new Directory(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setBatchPath(String string) {
            return (Builder)super.setBatchPath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setDirectoryRequestInitializer(DirectoryRequestInitializer directoryRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)directoryRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class VerificationCodes {
        public Generate generate(String string) throws IOException {
            Generate generate = new Generate(string);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)generate);
            return generate;
        }

        public Invalidate invalidate(String string) throws IOException {
            Invalidate invalidate = new Invalidate(string);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)invalidate);
            return invalidate;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends DirectoryRequest<com.google.api.services.admin.directory.model.VerificationCodes> {
            private static final String REST_PATH = "users/{userKey}/verificationCodes";
            @Key
            private String userKey;

            protected List(String string) {
                super(Directory.this, "GET", REST_PATH, null, com.google.api.services.admin.directory.model.VerificationCodes.class);
                this.userKey = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userKey must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getUserKey() {
                return this.userKey;
            }

            public List setUserKey(String string) {
                this.userKey = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Invalidate
        extends DirectoryRequest<Void> {
            private static final String REST_PATH = "users/{userKey}/verificationCodes/invalidate";
            @Key
            private String userKey;

            protected Invalidate(String string) {
                super(Directory.this, "POST", REST_PATH, null, Void.class);
                this.userKey = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userKey must be specified.");
            }

            public Invalidate setAlt(String string) {
                return (Invalidate)super.setAlt(string);
            }

            public Invalidate setFields(String string) {
                return (Invalidate)super.setFields(string);
            }

            public Invalidate setKey(String string) {
                return (Invalidate)super.setKey(string);
            }

            public Invalidate setOauthToken(String string) {
                return (Invalidate)super.setOauthToken(string);
            }

            public Invalidate setPrettyPrint(Boolean bl) {
                return (Invalidate)super.setPrettyPrint(bl);
            }

            public Invalidate setQuotaUser(String string) {
                return (Invalidate)super.setQuotaUser(string);
            }

            public Invalidate setUserIp(String string) {
                return (Invalidate)super.setUserIp(string);
            }

            public String getUserKey() {
                return this.userKey;
            }

            public Invalidate setUserKey(String string) {
                this.userKey = string;
                return this;
            }

            @Override
            public Invalidate set(String string, Object object) {
                return (Invalidate)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Generate
        extends DirectoryRequest<Void> {
            private static final String REST_PATH = "users/{userKey}/verificationCodes/generate";
            @Key
            private String userKey;

            protected Generate(String string) {
                super(Directory.this, "POST", REST_PATH, null, Void.class);
                this.userKey = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userKey must be specified.");
            }

            public Generate setAlt(String string) {
                return (Generate)super.setAlt(string);
            }

            public Generate setFields(String string) {
                return (Generate)super.setFields(string);
            }

            public Generate setKey(String string) {
                return (Generate)super.setKey(string);
            }

            public Generate setOauthToken(String string) {
                return (Generate)super.setOauthToken(string);
            }

            public Generate setPrettyPrint(Boolean bl) {
                return (Generate)super.setPrettyPrint(bl);
            }

            public Generate setQuotaUser(String string) {
                return (Generate)super.setQuotaUser(string);
            }

            public Generate setUserIp(String string) {
                return (Generate)super.setUserIp(string);
            }

            public String getUserKey() {
                return this.userKey;
            }

            public Generate setUserKey(String string) {
                this.userKey = string;
                return this;
            }

            @Override
            public Generate set(String string, Object object) {
                return (Generate)super.set(string, object);
            }
        }
    }

    public class Users {
        public Delete delete(String string) throws IOException {
            Delete delete = new Delete(string);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string) throws IOException {
            Get get = new Get(string);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(User user) throws IOException {
            Insert insert = new Insert(user);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list() throws IOException {
            List list = new List();
            Directory.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public MakeAdmin makeAdmin(String string, UserMakeAdmin userMakeAdmin) throws IOException {
            MakeAdmin makeAdmin = new MakeAdmin(string, userMakeAdmin);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)makeAdmin);
            return makeAdmin;
        }

        public Patch patch(String string, User user) throws IOException {
            Patch patch = new Patch(string, user);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)patch);
            return patch;
        }

        public Undelete undelete(String string, UserUndelete userUndelete) throws IOException {
            Undelete undelete = new Undelete(string, userUndelete);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)undelete);
            return undelete;
        }

        public Update update(String string, User user) throws IOException {
            Update update = new Update(string, user);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        public Watch watch(Channel channel) throws IOException {
            Watch watch = new Watch(channel);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)watch);
            return watch;
        }

        public Aliases aliases() {
            return new Aliases();
        }

        public Photos photos() {
            return new Photos();
        }

        public class Photos {
            public Delete delete(String string) throws IOException {
                Delete delete = new Delete(string);
                Directory.this.initialize((AbstractGoogleClientRequest<?>)delete);
                return delete;
            }

            public Get get(String string) throws IOException {
                Get get = new Get(string);
                Directory.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            public Patch patch(String string, UserPhoto userPhoto) throws IOException {
                Patch patch = new Patch(string, userPhoto);
                Directory.this.initialize((AbstractGoogleClientRequest<?>)patch);
                return patch;
            }

            public Update update(String string, UserPhoto userPhoto) throws IOException {
                Update update = new Update(string, userPhoto);
                Directory.this.initialize((AbstractGoogleClientRequest<?>)update);
                return update;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Update
            extends DirectoryRequest<UserPhoto> {
                private static final String REST_PATH = "users/{userKey}/photos/thumbnail";
                @Key
                private String userKey;

                protected Update(String string, UserPhoto userPhoto) {
                    super(Directory.this, "PUT", REST_PATH, (Object)userPhoto, UserPhoto.class);
                    this.userKey = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userKey must be specified.");
                    this.checkRequiredParameter((Object)userPhoto, "content");
                    this.checkRequiredParameter(userPhoto.getPhotoData(), "UserPhoto.getPhotoData()");
                }

                public Update setAlt(String string) {
                    return (Update)super.setAlt(string);
                }

                public Update setFields(String string) {
                    return (Update)super.setFields(string);
                }

                public Update setKey(String string) {
                    return (Update)super.setKey(string);
                }

                public Update setOauthToken(String string) {
                    return (Update)super.setOauthToken(string);
                }

                public Update setPrettyPrint(Boolean bl) {
                    return (Update)super.setPrettyPrint(bl);
                }

                public Update setQuotaUser(String string) {
                    return (Update)super.setQuotaUser(string);
                }

                public Update setUserIp(String string) {
                    return (Update)super.setUserIp(string);
                }

                public String getUserKey() {
                    return this.userKey;
                }

                public Update setUserKey(String string) {
                    this.userKey = string;
                    return this;
                }

                @Override
                public Update set(String string, Object object) {
                    return (Update)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Patch
            extends DirectoryRequest<UserPhoto> {
                private static final String REST_PATH = "users/{userKey}/photos/thumbnail";
                @Key
                private String userKey;

                protected Patch(String string, UserPhoto userPhoto) {
                    super(Directory.this, "PATCH", REST_PATH, (Object)userPhoto, UserPhoto.class);
                    this.userKey = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userKey must be specified.");
                }

                public Patch setAlt(String string) {
                    return (Patch)super.setAlt(string);
                }

                public Patch setFields(String string) {
                    return (Patch)super.setFields(string);
                }

                public Patch setKey(String string) {
                    return (Patch)super.setKey(string);
                }

                public Patch setOauthToken(String string) {
                    return (Patch)super.setOauthToken(string);
                }

                public Patch setPrettyPrint(Boolean bl) {
                    return (Patch)super.setPrettyPrint(bl);
                }

                public Patch setQuotaUser(String string) {
                    return (Patch)super.setQuotaUser(string);
                }

                public Patch setUserIp(String string) {
                    return (Patch)super.setUserIp(string);
                }

                public String getUserKey() {
                    return this.userKey;
                }

                public Patch setUserKey(String string) {
                    this.userKey = string;
                    return this;
                }

                @Override
                public Patch set(String string, Object object) {
                    return (Patch)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends DirectoryRequest<UserPhoto> {
                private static final String REST_PATH = "users/{userKey}/photos/thumbnail";
                @Key
                private String userKey;

                protected Get(String string) {
                    super(Directory.this, "GET", REST_PATH, null, UserPhoto.class);
                    this.userKey = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userKey must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUserIp(String string) {
                    return (Get)super.setUserIp(string);
                }

                public String getUserKey() {
                    return this.userKey;
                }

                public Get setUserKey(String string) {
                    this.userKey = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Delete
            extends DirectoryRequest<Void> {
                private static final String REST_PATH = "users/{userKey}/photos/thumbnail";
                @Key
                private String userKey;

                protected Delete(String string) {
                    super(Directory.this, "DELETE", REST_PATH, null, Void.class);
                    this.userKey = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userKey must be specified.");
                }

                public Delete setAlt(String string) {
                    return (Delete)super.setAlt(string);
                }

                public Delete setFields(String string) {
                    return (Delete)super.setFields(string);
                }

                public Delete setKey(String string) {
                    return (Delete)super.setKey(string);
                }

                public Delete setOauthToken(String string) {
                    return (Delete)super.setOauthToken(string);
                }

                public Delete setPrettyPrint(Boolean bl) {
                    return (Delete)super.setPrettyPrint(bl);
                }

                public Delete setQuotaUser(String string) {
                    return (Delete)super.setQuotaUser(string);
                }

                public Delete setUserIp(String string) {
                    return (Delete)super.setUserIp(string);
                }

                public String getUserKey() {
                    return this.userKey;
                }

                public Delete setUserKey(String string) {
                    this.userKey = string;
                    return this;
                }

                @Override
                public Delete set(String string, Object object) {
                    return (Delete)super.set(string, object);
                }
            }
        }

        public class Aliases {
            public Delete delete(String string, String string2) throws IOException {
                Delete delete = new Delete(string, string2);
                Directory.this.initialize((AbstractGoogleClientRequest<?>)delete);
                return delete;
            }

            public Insert insert(String string, Alias alias) throws IOException {
                Insert insert = new Insert(string, alias);
                Directory.this.initialize((AbstractGoogleClientRequest<?>)insert);
                return insert;
            }

            public List list(String string) throws IOException {
                List list = new List(string);
                Directory.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            public Watch watch(String string, Channel channel) throws IOException {
                Watch watch = new Watch(string, channel);
                Directory.this.initialize((AbstractGoogleClientRequest<?>)watch);
                return watch;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Watch
            extends DirectoryRequest<Channel> {
                private static final String REST_PATH = "users/{userKey}/aliases/watch";
                @Key
                private String userKey;
                @Key
                private String event;

                protected Watch(String string, Channel channel) {
                    super(Directory.this, "POST", REST_PATH, (Object)channel, Channel.class);
                    this.userKey = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userKey must be specified.");
                }

                public Watch setAlt(String string) {
                    return (Watch)super.setAlt(string);
                }

                public Watch setFields(String string) {
                    return (Watch)super.setFields(string);
                }

                public Watch setKey(String string) {
                    return (Watch)super.setKey(string);
                }

                public Watch setOauthToken(String string) {
                    return (Watch)super.setOauthToken(string);
                }

                public Watch setPrettyPrint(Boolean bl) {
                    return (Watch)super.setPrettyPrint(bl);
                }

                public Watch setQuotaUser(String string) {
                    return (Watch)super.setQuotaUser(string);
                }

                public Watch setUserIp(String string) {
                    return (Watch)super.setUserIp(string);
                }

                public String getUserKey() {
                    return this.userKey;
                }

                public Watch setUserKey(String string) {
                    this.userKey = string;
                    return this;
                }

                public String getEvent() {
                    return this.event;
                }

                public Watch setEvent(String string) {
                    this.event = string;
                    return this;
                }

                @Override
                public Watch set(String string, Object object) {
                    return (Watch)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends DirectoryRequest<com.google.api.services.admin.directory.model.Aliases> {
                private static final String REST_PATH = "users/{userKey}/aliases";
                @Key
                private String userKey;
                @Key
                private String event;

                protected List(String string) {
                    super(Directory.this, "GET", REST_PATH, null, com.google.api.services.admin.directory.model.Aliases.class);
                    this.userKey = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userKey must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUserIp(String string) {
                    return (List)super.setUserIp(string);
                }

                public String getUserKey() {
                    return this.userKey;
                }

                public List setUserKey(String string) {
                    this.userKey = string;
                    return this;
                }

                public String getEvent() {
                    return this.event;
                }

                public List setEvent(String string) {
                    this.event = string;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Insert
            extends DirectoryRequest<Alias> {
                private static final String REST_PATH = "users/{userKey}/aliases";
                @Key
                private String userKey;

                protected Insert(String string, Alias alias) {
                    super(Directory.this, "POST", REST_PATH, (Object)alias, Alias.class);
                    this.userKey = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userKey must be specified.");
                }

                public Insert setAlt(String string) {
                    return (Insert)super.setAlt(string);
                }

                public Insert setFields(String string) {
                    return (Insert)super.setFields(string);
                }

                public Insert setKey(String string) {
                    return (Insert)super.setKey(string);
                }

                public Insert setOauthToken(String string) {
                    return (Insert)super.setOauthToken(string);
                }

                public Insert setPrettyPrint(Boolean bl) {
                    return (Insert)super.setPrettyPrint(bl);
                }

                public Insert setQuotaUser(String string) {
                    return (Insert)super.setQuotaUser(string);
                }

                public Insert setUserIp(String string) {
                    return (Insert)super.setUserIp(string);
                }

                public String getUserKey() {
                    return this.userKey;
                }

                public Insert setUserKey(String string) {
                    this.userKey = string;
                    return this;
                }

                @Override
                public Insert set(String string, Object object) {
                    return (Insert)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Delete
            extends DirectoryRequest<Void> {
                private static final String REST_PATH = "users/{userKey}/aliases/{alias}";
                @Key
                private String userKey;
                @Key
                private String alias;

                protected Delete(String string, String string2) {
                    super(Directory.this, "DELETE", REST_PATH, null, Void.class);
                    this.userKey = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userKey must be specified.");
                    this.alias = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter alias must be specified.");
                }

                public Delete setAlt(String string) {
                    return (Delete)super.setAlt(string);
                }

                public Delete setFields(String string) {
                    return (Delete)super.setFields(string);
                }

                public Delete setKey(String string) {
                    return (Delete)super.setKey(string);
                }

                public Delete setOauthToken(String string) {
                    return (Delete)super.setOauthToken(string);
                }

                public Delete setPrettyPrint(Boolean bl) {
                    return (Delete)super.setPrettyPrint(bl);
                }

                public Delete setQuotaUser(String string) {
                    return (Delete)super.setQuotaUser(string);
                }

                public Delete setUserIp(String string) {
                    return (Delete)super.setUserIp(string);
                }

                public String getUserKey() {
                    return this.userKey;
                }

                public Delete setUserKey(String string) {
                    this.userKey = string;
                    return this;
                }

                public String getAlias() {
                    return this.alias;
                }

                public Delete setAlias(String string) {
                    this.alias = string;
                    return this;
                }

                @Override
                public Delete set(String string, Object object) {
                    return (Delete)super.set(string, object);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Watch
        extends DirectoryRequest<Channel> {
            private static final String REST_PATH = "users/watch";
            @Key
            private String customFieldMask;
            @Key
            private String customer;
            @Key
            private String domain;
            @Key
            private String event;
            @Key
            private Integer maxResults;
            @Key
            private String orderBy;
            @Key
            private String pageToken;
            @Key
            private String projection;
            @Key
            private String query;
            @Key
            private String showDeleted;
            @Key
            private String sortOrder;
            @Key
            private String viewType;

            protected Watch(Channel channel) {
                super(Directory.this, "POST", REST_PATH, (Object)channel, Channel.class);
            }

            public Watch setAlt(String string) {
                return (Watch)super.setAlt(string);
            }

            public Watch setFields(String string) {
                return (Watch)super.setFields(string);
            }

            public Watch setKey(String string) {
                return (Watch)super.setKey(string);
            }

            public Watch setOauthToken(String string) {
                return (Watch)super.setOauthToken(string);
            }

            public Watch setPrettyPrint(Boolean bl) {
                return (Watch)super.setPrettyPrint(bl);
            }

            public Watch setQuotaUser(String string) {
                return (Watch)super.setQuotaUser(string);
            }

            public Watch setUserIp(String string) {
                return (Watch)super.setUserIp(string);
            }

            public String getCustomFieldMask() {
                return this.customFieldMask;
            }

            public Watch setCustomFieldMask(String string) {
                this.customFieldMask = string;
                return this;
            }

            public String getCustomer() {
                return this.customer;
            }

            public Watch setCustomer(String string) {
                this.customer = string;
                return this;
            }

            public String getDomain() {
                return this.domain;
            }

            public Watch setDomain(String string) {
                this.domain = string;
                return this;
            }

            public String getEvent() {
                return this.event;
            }

            public Watch setEvent(String string) {
                this.event = string;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public Watch setMaxResults(Integer n) {
                this.maxResults = n;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public Watch setOrderBy(String string) {
                this.orderBy = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public Watch setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public Watch setProjection(String string) {
                this.projection = string;
                return this;
            }

            public String getQuery() {
                return this.query;
            }

            public Watch setQuery(String string) {
                this.query = string;
                return this;
            }

            public String getShowDeleted() {
                return this.showDeleted;
            }

            public Watch setShowDeleted(String string) {
                this.showDeleted = string;
                return this;
            }

            public String getSortOrder() {
                return this.sortOrder;
            }

            public Watch setSortOrder(String string) {
                this.sortOrder = string;
                return this;
            }

            public String getViewType() {
                return this.viewType;
            }

            public Watch setViewType(String string) {
                this.viewType = string;
                return this;
            }

            @Override
            public Watch set(String string, Object object) {
                return (Watch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends DirectoryRequest<User> {
            private static final String REST_PATH = "users/{userKey}";
            @Key
            private String userKey;

            protected Update(String string, User user) {
                super(Directory.this, "PUT", REST_PATH, (Object)user, User.class);
                this.userKey = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userKey must be specified.");
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getUserKey() {
                return this.userKey;
            }

            public Update setUserKey(String string) {
                this.userKey = string;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Undelete
        extends DirectoryRequest<Void> {
            private static final String REST_PATH = "users/{userKey}/undelete";
            @Key
            private String userKey;

            protected Undelete(String string, UserUndelete userUndelete) {
                super(Directory.this, "POST", REST_PATH, (Object)userUndelete, Void.class);
                this.userKey = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userKey must be specified.");
            }

            public Undelete setAlt(String string) {
                return (Undelete)super.setAlt(string);
            }

            public Undelete setFields(String string) {
                return (Undelete)super.setFields(string);
            }

            public Undelete setKey(String string) {
                return (Undelete)super.setKey(string);
            }

            public Undelete setOauthToken(String string) {
                return (Undelete)super.setOauthToken(string);
            }

            public Undelete setPrettyPrint(Boolean bl) {
                return (Undelete)super.setPrettyPrint(bl);
            }

            public Undelete setQuotaUser(String string) {
                return (Undelete)super.setQuotaUser(string);
            }

            public Undelete setUserIp(String string) {
                return (Undelete)super.setUserIp(string);
            }

            public String getUserKey() {
                return this.userKey;
            }

            public Undelete setUserKey(String string) {
                this.userKey = string;
                return this;
            }

            @Override
            public Undelete set(String string, Object object) {
                return (Undelete)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends DirectoryRequest<User> {
            private static final String REST_PATH = "users/{userKey}";
            @Key
            private String userKey;

            protected Patch(String string, User user) {
                super(Directory.this, "PATCH", REST_PATH, (Object)user, User.class);
                this.userKey = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userKey must be specified.");
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUserIp(String string) {
                return (Patch)super.setUserIp(string);
            }

            public String getUserKey() {
                return this.userKey;
            }

            public Patch setUserKey(String string) {
                this.userKey = string;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class MakeAdmin
        extends DirectoryRequest<Void> {
            private static final String REST_PATH = "users/{userKey}/makeAdmin";
            @Key
            private String userKey;

            protected MakeAdmin(String string, UserMakeAdmin userMakeAdmin) {
                super(Directory.this, "POST", REST_PATH, (Object)userMakeAdmin, Void.class);
                this.userKey = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userKey must be specified.");
            }

            public MakeAdmin setAlt(String string) {
                return (MakeAdmin)super.setAlt(string);
            }

            public MakeAdmin setFields(String string) {
                return (MakeAdmin)super.setFields(string);
            }

            public MakeAdmin setKey(String string) {
                return (MakeAdmin)super.setKey(string);
            }

            public MakeAdmin setOauthToken(String string) {
                return (MakeAdmin)super.setOauthToken(string);
            }

            public MakeAdmin setPrettyPrint(Boolean bl) {
                return (MakeAdmin)super.setPrettyPrint(bl);
            }

            public MakeAdmin setQuotaUser(String string) {
                return (MakeAdmin)super.setQuotaUser(string);
            }

            public MakeAdmin setUserIp(String string) {
                return (MakeAdmin)super.setUserIp(string);
            }

            public String getUserKey() {
                return this.userKey;
            }

            public MakeAdmin setUserKey(String string) {
                this.userKey = string;
                return this;
            }

            @Override
            public MakeAdmin set(String string, Object object) {
                return (MakeAdmin)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends DirectoryRequest<com.google.api.services.admin.directory.model.Users> {
            private static final String REST_PATH = "users";
            @Key
            private String customFieldMask;
            @Key
            private String customer;
            @Key
            private String domain;
            @Key
            private String event;
            @Key
            private Integer maxResults;
            @Key
            private String orderBy;
            @Key
            private String pageToken;
            @Key
            private String projection;
            @Key
            private String query;
            @Key
            private String showDeleted;
            @Key
            private String sortOrder;
            @Key
            private String viewType;

            protected List() {
                super(Directory.this, "GET", REST_PATH, null, com.google.api.services.admin.directory.model.Users.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getCustomFieldMask() {
                return this.customFieldMask;
            }

            public List setCustomFieldMask(String string) {
                this.customFieldMask = string;
                return this;
            }

            public String getCustomer() {
                return this.customer;
            }

            public List setCustomer(String string) {
                this.customer = string;
                return this;
            }

            public String getDomain() {
                return this.domain;
            }

            public List setDomain(String string) {
                this.domain = string;
                return this;
            }

            public String getEvent() {
                return this.event;
            }

            public List setEvent(String string) {
                this.event = string;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Integer n) {
                this.maxResults = n;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String string) {
                this.orderBy = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public List setProjection(String string) {
                this.projection = string;
                return this;
            }

            public String getQuery() {
                return this.query;
            }

            public List setQuery(String string) {
                this.query = string;
                return this;
            }

            public String getShowDeleted() {
                return this.showDeleted;
            }

            public List setShowDeleted(String string) {
                this.showDeleted = string;
                return this;
            }

            public String getSortOrder() {
                return this.sortOrder;
            }

            public List setSortOrder(String string) {
                this.sortOrder = string;
                return this;
            }

            public String getViewType() {
                return this.viewType;
            }

            public List setViewType(String string) {
                this.viewType = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends DirectoryRequest<User> {
            private static final String REST_PATH = "users";

            protected Insert(User user) {
                super(Directory.this, "POST", REST_PATH, (Object)user, User.class);
                this.checkRequiredParameter((Object)user, "content");
                this.checkRequiredParameter(user.getPassword(), "User.getPassword()");
                this.checkRequiredParameter((Object)user, "content");
                this.checkRequiredParameter(user.getPrimaryEmail(), "User.getPrimaryEmail()");
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends DirectoryRequest<User> {
            private static final String REST_PATH = "users/{userKey}";
            @Key
            private String userKey;
            @Key
            private String customFieldMask;
            @Key
            private String projection;
            @Key
            private String viewType;

            protected Get(String string) {
                super(Directory.this, "GET", REST_PATH, null, User.class);
                this.userKey = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userKey must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getUserKey() {
                return this.userKey;
            }

            public Get setUserKey(String string) {
                this.userKey = string;
                return this;
            }

            public String getCustomFieldMask() {
                return this.customFieldMask;
            }

            public Get setCustomFieldMask(String string) {
                this.customFieldMask = string;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public Get setProjection(String string) {
                this.projection = string;
                return this;
            }

            public String getViewType() {
                return this.viewType;
            }

            public Get setViewType(String string) {
                this.viewType = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends DirectoryRequest<Void> {
            private static final String REST_PATH = "users/{userKey}";
            @Key
            private String userKey;

            protected Delete(String string) {
                super(Directory.this, "DELETE", REST_PATH, null, Void.class);
                this.userKey = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userKey must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getUserKey() {
                return this.userKey;
            }

            public Delete setUserKey(String string) {
                this.userKey = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class Tokens {
        public Delete delete(String string, String string2) throws IOException {
            Delete delete = new Delete(string, string2);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends DirectoryRequest<com.google.api.services.admin.directory.model.Tokens> {
            private static final String REST_PATH = "users/{userKey}/tokens";
            @Key
            private String userKey;

            protected List(String string) {
                super(Directory.this, "GET", REST_PATH, null, com.google.api.services.admin.directory.model.Tokens.class);
                this.userKey = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userKey must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getUserKey() {
                return this.userKey;
            }

            public List setUserKey(String string) {
                this.userKey = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends DirectoryRequest<Token> {
            private static final String REST_PATH = "users/{userKey}/tokens/{clientId}";
            @Key
            private String userKey;
            @Key
            private String clientId;

            protected Get(String string, String string2) {
                super(Directory.this, "GET", REST_PATH, null, Token.class);
                this.userKey = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userKey must be specified.");
                this.clientId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter clientId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getUserKey() {
                return this.userKey;
            }

            public Get setUserKey(String string) {
                this.userKey = string;
                return this;
            }

            public String getClientId() {
                return this.clientId;
            }

            public Get setClientId(String string) {
                this.clientId = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends DirectoryRequest<Void> {
            private static final String REST_PATH = "users/{userKey}/tokens/{clientId}";
            @Key
            private String userKey;
            @Key
            private String clientId;

            protected Delete(String string, String string2) {
                super(Directory.this, "DELETE", REST_PATH, null, Void.class);
                this.userKey = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userKey must be specified.");
                this.clientId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter clientId must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getUserKey() {
                return this.userKey;
            }

            public Delete setUserKey(String string) {
                this.userKey = string;
                return this;
            }

            public String getClientId() {
                return this.clientId;
            }

            public Delete setClientId(String string) {
                this.clientId = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class Schemas {
        public Delete delete(String string, String string2) throws IOException {
            Delete delete = new Delete(string, string2);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(String string, Schema schema) throws IOException {
            Insert insert = new Insert(string, schema);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Patch patch(String string, String string2, Schema schema) throws IOException {
            Patch patch = new Patch(string, string2, schema);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)patch);
            return patch;
        }

        public Update update(String string, String string2, Schema schema) throws IOException {
            Update update = new Update(string, string2, schema);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends DirectoryRequest<Schema> {
            private static final String REST_PATH = "customer/{customerId}/schemas/{schemaKey}";
            @Key
            private String customerId;
            @Key
            private String schemaKey;

            protected Update(String string, String string2, Schema schema) {
                super(Directory.this, "PUT", REST_PATH, (Object)schema, Schema.class);
                this.customerId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customerId must be specified.");
                this.schemaKey = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter schemaKey must be specified.");
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getCustomerId() {
                return this.customerId;
            }

            public Update setCustomerId(String string) {
                this.customerId = string;
                return this;
            }

            public String getSchemaKey() {
                return this.schemaKey;
            }

            public Update setSchemaKey(String string) {
                this.schemaKey = string;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends DirectoryRequest<Schema> {
            private static final String REST_PATH = "customer/{customerId}/schemas/{schemaKey}";
            @Key
            private String customerId;
            @Key
            private String schemaKey;

            protected Patch(String string, String string2, Schema schema) {
                super(Directory.this, "PATCH", REST_PATH, (Object)schema, Schema.class);
                this.customerId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customerId must be specified.");
                this.schemaKey = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter schemaKey must be specified.");
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUserIp(String string) {
                return (Patch)super.setUserIp(string);
            }

            public String getCustomerId() {
                return this.customerId;
            }

            public Patch setCustomerId(String string) {
                this.customerId = string;
                return this;
            }

            public String getSchemaKey() {
                return this.schemaKey;
            }

            public Patch setSchemaKey(String string) {
                this.schemaKey = string;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends DirectoryRequest<com.google.api.services.admin.directory.model.Schemas> {
            private static final String REST_PATH = "customer/{customerId}/schemas";
            @Key
            private String customerId;

            protected List(String string) {
                super(Directory.this, "GET", REST_PATH, null, com.google.api.services.admin.directory.model.Schemas.class);
                this.customerId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customerId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getCustomerId() {
                return this.customerId;
            }

            public List setCustomerId(String string) {
                this.customerId = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends DirectoryRequest<Schema> {
            private static final String REST_PATH = "customer/{customerId}/schemas";
            @Key
            private String customerId;

            protected Insert(String string, Schema schema) {
                super(Directory.this, "POST", REST_PATH, (Object)schema, Schema.class);
                this.customerId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customerId must be specified.");
                this.checkRequiredParameter((Object)schema, "content");
                this.checkRequiredParameter(schema.getDisplayName(), "Schema.getDisplayName()");
                this.checkRequiredParameter((Object)schema, "content");
                this.checkRequiredParameter(schema.getSchemaName(), "Schema.getSchemaName()");
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getCustomerId() {
                return this.customerId;
            }

            public Insert setCustomerId(String string) {
                this.customerId = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends DirectoryRequest<Schema> {
            private static final String REST_PATH = "customer/{customerId}/schemas/{schemaKey}";
            @Key
            private String customerId;
            @Key
            private String schemaKey;

            protected Get(String string, String string2) {
                super(Directory.this, "GET", REST_PATH, null, Schema.class);
                this.customerId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customerId must be specified.");
                this.schemaKey = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter schemaKey must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getCustomerId() {
                return this.customerId;
            }

            public Get setCustomerId(String string) {
                this.customerId = string;
                return this;
            }

            public String getSchemaKey() {
                return this.schemaKey;
            }

            public Get setSchemaKey(String string) {
                this.schemaKey = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends DirectoryRequest<Void> {
            private static final String REST_PATH = "customer/{customerId}/schemas/{schemaKey}";
            @Key
            private String customerId;
            @Key
            private String schemaKey;

            protected Delete(String string, String string2) {
                super(Directory.this, "DELETE", REST_PATH, null, Void.class);
                this.customerId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customerId must be specified.");
                this.schemaKey = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter schemaKey must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getCustomerId() {
                return this.customerId;
            }

            public Delete setCustomerId(String string) {
                this.customerId = string;
                return this;
            }

            public String getSchemaKey() {
                return this.schemaKey;
            }

            public Delete setSchemaKey(String string) {
                this.schemaKey = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class Roles {
        public Delete delete(String string, String string2) throws IOException {
            Delete delete = new Delete(string, string2);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(String string, Role role) throws IOException {
            Insert insert = new Insert(string, role);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Patch patch(String string, String string2, Role role) throws IOException {
            Patch patch = new Patch(string, string2, role);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)patch);
            return patch;
        }

        public Update update(String string, String string2, Role role) throws IOException {
            Update update = new Update(string, string2, role);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends DirectoryRequest<Role> {
            private static final String REST_PATH = "customer/{customer}/roles/{roleId}";
            @Key
            private String customer;
            @Key
            private String roleId;

            protected Update(String string, String string2, Role role) {
                super(Directory.this, "PUT", REST_PATH, (Object)role, Role.class);
                this.customer = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customer must be specified.");
                this.roleId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter roleId must be specified.");
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getCustomer() {
                return this.customer;
            }

            public Update setCustomer(String string) {
                this.customer = string;
                return this;
            }

            public String getRoleId() {
                return this.roleId;
            }

            public Update setRoleId(String string) {
                this.roleId = string;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends DirectoryRequest<Role> {
            private static final String REST_PATH = "customer/{customer}/roles/{roleId}";
            @Key
            private String customer;
            @Key
            private String roleId;

            protected Patch(String string, String string2, Role role) {
                super(Directory.this, "PATCH", REST_PATH, (Object)role, Role.class);
                this.customer = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customer must be specified.");
                this.roleId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter roleId must be specified.");
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUserIp(String string) {
                return (Patch)super.setUserIp(string);
            }

            public String getCustomer() {
                return this.customer;
            }

            public Patch setCustomer(String string) {
                this.customer = string;
                return this;
            }

            public String getRoleId() {
                return this.roleId;
            }

            public Patch setRoleId(String string) {
                this.roleId = string;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends DirectoryRequest<com.google.api.services.admin.directory.model.Roles> {
            private static final String REST_PATH = "customer/{customer}/roles";
            @Key
            private String customer;
            @Key
            private Integer maxResults;
            @Key
            private String pageToken;

            protected List(String string) {
                super(Directory.this, "GET", REST_PATH, null, com.google.api.services.admin.directory.model.Roles.class);
                this.customer = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customer must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getCustomer() {
                return this.customer;
            }

            public List setCustomer(String string) {
                this.customer = string;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Integer n) {
                this.maxResults = n;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends DirectoryRequest<Role> {
            private static final String REST_PATH = "customer/{customer}/roles";
            @Key
            private String customer;

            protected Insert(String string, Role role) {
                super(Directory.this, "POST", REST_PATH, (Object)role, Role.class);
                this.customer = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customer must be specified.");
                this.checkRequiredParameter((Object)role, "content");
                this.checkRequiredParameter(role.getRoleName(), "Role.getRoleName()");
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getCustomer() {
                return this.customer;
            }

            public Insert setCustomer(String string) {
                this.customer = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends DirectoryRequest<Role> {
            private static final String REST_PATH = "customer/{customer}/roles/{roleId}";
            @Key
            private String customer;
            @Key
            private String roleId;

            protected Get(String string, String string2) {
                super(Directory.this, "GET", REST_PATH, null, Role.class);
                this.customer = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customer must be specified.");
                this.roleId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter roleId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getCustomer() {
                return this.customer;
            }

            public Get setCustomer(String string) {
                this.customer = string;
                return this;
            }

            public String getRoleId() {
                return this.roleId;
            }

            public Get setRoleId(String string) {
                this.roleId = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends DirectoryRequest<Void> {
            private static final String REST_PATH = "customer/{customer}/roles/{roleId}";
            @Key
            private String customer;
            @Key
            private String roleId;

            protected Delete(String string, String string2) {
                super(Directory.this, "DELETE", REST_PATH, null, Void.class);
                this.customer = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customer must be specified.");
                this.roleId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter roleId must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getCustomer() {
                return this.customer;
            }

            public Delete setCustomer(String string) {
                this.customer = string;
                return this;
            }

            public String getRoleId() {
                return this.roleId;
            }

            public Delete setRoleId(String string) {
                this.roleId = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class RoleAssignments {
        public Delete delete(String string, String string2) throws IOException {
            Delete delete = new Delete(string, string2);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(String string, RoleAssignment roleAssignment) throws IOException {
            Insert insert = new Insert(string, roleAssignment);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends DirectoryRequest<com.google.api.services.admin.directory.model.RoleAssignments> {
            private static final String REST_PATH = "customer/{customer}/roleassignments";
            @Key
            private String customer;
            @Key
            private Integer maxResults;
            @Key
            private String pageToken;
            @Key
            private String roleId;
            @Key
            private String userKey;

            protected List(String string) {
                super(Directory.this, "GET", REST_PATH, null, com.google.api.services.admin.directory.model.RoleAssignments.class);
                this.customer = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customer must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getCustomer() {
                return this.customer;
            }

            public List setCustomer(String string) {
                this.customer = string;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Integer n) {
                this.maxResults = n;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public String getRoleId() {
                return this.roleId;
            }

            public List setRoleId(String string) {
                this.roleId = string;
                return this;
            }

            public String getUserKey() {
                return this.userKey;
            }

            public List setUserKey(String string) {
                this.userKey = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends DirectoryRequest<RoleAssignment> {
            private static final String REST_PATH = "customer/{customer}/roleassignments";
            @Key
            private String customer;

            protected Insert(String string, RoleAssignment roleAssignment) {
                super(Directory.this, "POST", REST_PATH, (Object)roleAssignment, RoleAssignment.class);
                this.customer = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customer must be specified.");
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getCustomer() {
                return this.customer;
            }

            public Insert setCustomer(String string) {
                this.customer = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends DirectoryRequest<RoleAssignment> {
            private static final String REST_PATH = "customer/{customer}/roleassignments/{roleAssignmentId}";
            @Key
            private String customer;
            @Key
            private String roleAssignmentId;

            protected Get(String string, String string2) {
                super(Directory.this, "GET", REST_PATH, null, RoleAssignment.class);
                this.customer = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customer must be specified.");
                this.roleAssignmentId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter roleAssignmentId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getCustomer() {
                return this.customer;
            }

            public Get setCustomer(String string) {
                this.customer = string;
                return this;
            }

            public String getRoleAssignmentId() {
                return this.roleAssignmentId;
            }

            public Get setRoleAssignmentId(String string) {
                this.roleAssignmentId = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends DirectoryRequest<Void> {
            private static final String REST_PATH = "customer/{customer}/roleassignments/{roleAssignmentId}";
            @Key
            private String customer;
            @Key
            private String roleAssignmentId;

            protected Delete(String string, String string2) {
                super(Directory.this, "DELETE", REST_PATH, null, Void.class);
                this.customer = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customer must be specified.");
                this.roleAssignmentId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter roleAssignmentId must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getCustomer() {
                return this.customer;
            }

            public Delete setCustomer(String string) {
                this.customer = string;
                return this;
            }

            public String getRoleAssignmentId() {
                return this.roleAssignmentId;
            }

            public Delete setRoleAssignmentId(String string) {
                this.roleAssignmentId = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class Resources {
        public Buildings buildings() {
            return new Buildings();
        }

        public Calendars calendars() {
            return new Calendars();
        }

        public Features features() {
            return new Features();
        }

        public class Features {
            public Delete delete(String string, String string2) throws IOException {
                Delete delete = new Delete(string, string2);
                Directory.this.initialize((AbstractGoogleClientRequest<?>)delete);
                return delete;
            }

            public Get get(String string, String string2) throws IOException {
                Get get = new Get(string, string2);
                Directory.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            public Insert insert(String string, Feature feature) throws IOException {
                Insert insert = new Insert(string, feature);
                Directory.this.initialize((AbstractGoogleClientRequest<?>)insert);
                return insert;
            }

            public List list(String string) throws IOException {
                List list = new List(string);
                Directory.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            public Patch patch(String string, String string2, Feature feature) throws IOException {
                Patch patch = new Patch(string, string2, feature);
                Directory.this.initialize((AbstractGoogleClientRequest<?>)patch);
                return patch;
            }

            public Rename rename(String string, String string2, FeatureRename featureRename) throws IOException {
                Rename rename = new Rename(string, string2, featureRename);
                Directory.this.initialize((AbstractGoogleClientRequest<?>)rename);
                return rename;
            }

            public Update update(String string, String string2, Feature feature) throws IOException {
                Update update = new Update(string, string2, feature);
                Directory.this.initialize((AbstractGoogleClientRequest<?>)update);
                return update;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Update
            extends DirectoryRequest<Feature> {
                private static final String REST_PATH = "customer/{customer}/resources/features/{featureKey}";
                @Key
                private String customer;
                @Key
                private String featureKey;

                protected Update(String string, String string2, Feature feature) {
                    super(Directory.this, "PUT", REST_PATH, (Object)feature, Feature.class);
                    this.customer = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customer must be specified.");
                    this.featureKey = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter featureKey must be specified.");
                }

                public Update setAlt(String string) {
                    return (Update)super.setAlt(string);
                }

                public Update setFields(String string) {
                    return (Update)super.setFields(string);
                }

                public Update setKey(String string) {
                    return (Update)super.setKey(string);
                }

                public Update setOauthToken(String string) {
                    return (Update)super.setOauthToken(string);
                }

                public Update setPrettyPrint(Boolean bl) {
                    return (Update)super.setPrettyPrint(bl);
                }

                public Update setQuotaUser(String string) {
                    return (Update)super.setQuotaUser(string);
                }

                public Update setUserIp(String string) {
                    return (Update)super.setUserIp(string);
                }

                public String getCustomer() {
                    return this.customer;
                }

                public Update setCustomer(String string) {
                    this.customer = string;
                    return this;
                }

                public String getFeatureKey() {
                    return this.featureKey;
                }

                public Update setFeatureKey(String string) {
                    this.featureKey = string;
                    return this;
                }

                @Override
                public Update set(String string, Object object) {
                    return (Update)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Rename
            extends DirectoryRequest<Void> {
                private static final String REST_PATH = "customer/{customer}/resources/features/{oldName}/rename";
                @Key
                private String customer;
                @Key
                private String oldName;

                protected Rename(String string, String string2, FeatureRename featureRename) {
                    super(Directory.this, "POST", REST_PATH, (Object)featureRename, Void.class);
                    this.customer = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customer must be specified.");
                    this.oldName = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter oldName must be specified.");
                }

                public Rename setAlt(String string) {
                    return (Rename)super.setAlt(string);
                }

                public Rename setFields(String string) {
                    return (Rename)super.setFields(string);
                }

                public Rename setKey(String string) {
                    return (Rename)super.setKey(string);
                }

                public Rename setOauthToken(String string) {
                    return (Rename)super.setOauthToken(string);
                }

                public Rename setPrettyPrint(Boolean bl) {
                    return (Rename)super.setPrettyPrint(bl);
                }

                public Rename setQuotaUser(String string) {
                    return (Rename)super.setQuotaUser(string);
                }

                public Rename setUserIp(String string) {
                    return (Rename)super.setUserIp(string);
                }

                public String getCustomer() {
                    return this.customer;
                }

                public Rename setCustomer(String string) {
                    this.customer = string;
                    return this;
                }

                public String getOldName() {
                    return this.oldName;
                }

                public Rename setOldName(String string) {
                    this.oldName = string;
                    return this;
                }

                @Override
                public Rename set(String string, Object object) {
                    return (Rename)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Patch
            extends DirectoryRequest<Feature> {
                private static final String REST_PATH = "customer/{customer}/resources/features/{featureKey}";
                @Key
                private String customer;
                @Key
                private String featureKey;

                protected Patch(String string, String string2, Feature feature) {
                    super(Directory.this, "PATCH", REST_PATH, (Object)feature, Feature.class);
                    this.customer = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customer must be specified.");
                    this.featureKey = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter featureKey must be specified.");
                }

                public Patch setAlt(String string) {
                    return (Patch)super.setAlt(string);
                }

                public Patch setFields(String string) {
                    return (Patch)super.setFields(string);
                }

                public Patch setKey(String string) {
                    return (Patch)super.setKey(string);
                }

                public Patch setOauthToken(String string) {
                    return (Patch)super.setOauthToken(string);
                }

                public Patch setPrettyPrint(Boolean bl) {
                    return (Patch)super.setPrettyPrint(bl);
                }

                public Patch setQuotaUser(String string) {
                    return (Patch)super.setQuotaUser(string);
                }

                public Patch setUserIp(String string) {
                    return (Patch)super.setUserIp(string);
                }

                public String getCustomer() {
                    return this.customer;
                }

                public Patch setCustomer(String string) {
                    this.customer = string;
                    return this;
                }

                public String getFeatureKey() {
                    return this.featureKey;
                }

                public Patch setFeatureKey(String string) {
                    this.featureKey = string;
                    return this;
                }

                @Override
                public Patch set(String string, Object object) {
                    return (Patch)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends DirectoryRequest<com.google.api.services.admin.directory.model.Features> {
                private static final String REST_PATH = "customer/{customer}/resources/features";
                @Key
                private String customer;
                @Key
                private Integer maxResults;
                @Key
                private String pageToken;

                protected List(String string) {
                    super(Directory.this, "GET", REST_PATH, null, com.google.api.services.admin.directory.model.Features.class);
                    this.customer = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customer must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUserIp(String string) {
                    return (List)super.setUserIp(string);
                }

                public String getCustomer() {
                    return this.customer;
                }

                public List setCustomer(String string) {
                    this.customer = string;
                    return this;
                }

                public Integer getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Integer n) {
                    this.maxResults = n;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String string) {
                    this.pageToken = string;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Insert
            extends DirectoryRequest<Feature> {
                private static final String REST_PATH = "customer/{customer}/resources/features";
                @Key
                private String customer;

                protected Insert(String string, Feature feature) {
                    super(Directory.this, "POST", REST_PATH, (Object)feature, Feature.class);
                    this.customer = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customer must be specified.");
                    this.checkRequiredParameter((Object)feature, "content");
                    this.checkRequiredParameter(feature.getName(), "Feature.getName()");
                }

                public Insert setAlt(String string) {
                    return (Insert)super.setAlt(string);
                }

                public Insert setFields(String string) {
                    return (Insert)super.setFields(string);
                }

                public Insert setKey(String string) {
                    return (Insert)super.setKey(string);
                }

                public Insert setOauthToken(String string) {
                    return (Insert)super.setOauthToken(string);
                }

                public Insert setPrettyPrint(Boolean bl) {
                    return (Insert)super.setPrettyPrint(bl);
                }

                public Insert setQuotaUser(String string) {
                    return (Insert)super.setQuotaUser(string);
                }

                public Insert setUserIp(String string) {
                    return (Insert)super.setUserIp(string);
                }

                public String getCustomer() {
                    return this.customer;
                }

                public Insert setCustomer(String string) {
                    this.customer = string;
                    return this;
                }

                @Override
                public Insert set(String string, Object object) {
                    return (Insert)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends DirectoryRequest<Feature> {
                private static final String REST_PATH = "customer/{customer}/resources/features/{featureKey}";
                @Key
                private String customer;
                @Key
                private String featureKey;

                protected Get(String string, String string2) {
                    super(Directory.this, "GET", REST_PATH, null, Feature.class);
                    this.customer = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customer must be specified.");
                    this.featureKey = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter featureKey must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUserIp(String string) {
                    return (Get)super.setUserIp(string);
                }

                public String getCustomer() {
                    return this.customer;
                }

                public Get setCustomer(String string) {
                    this.customer = string;
                    return this;
                }

                public String getFeatureKey() {
                    return this.featureKey;
                }

                public Get setFeatureKey(String string) {
                    this.featureKey = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Delete
            extends DirectoryRequest<Void> {
                private static final String REST_PATH = "customer/{customer}/resources/features/{featureKey}";
                @Key
                private String customer;
                @Key
                private String featureKey;

                protected Delete(String string, String string2) {
                    super(Directory.this, "DELETE", REST_PATH, null, Void.class);
                    this.customer = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customer must be specified.");
                    this.featureKey = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter featureKey must be specified.");
                }

                public Delete setAlt(String string) {
                    return (Delete)super.setAlt(string);
                }

                public Delete setFields(String string) {
                    return (Delete)super.setFields(string);
                }

                public Delete setKey(String string) {
                    return (Delete)super.setKey(string);
                }

                public Delete setOauthToken(String string) {
                    return (Delete)super.setOauthToken(string);
                }

                public Delete setPrettyPrint(Boolean bl) {
                    return (Delete)super.setPrettyPrint(bl);
                }

                public Delete setQuotaUser(String string) {
                    return (Delete)super.setQuotaUser(string);
                }

                public Delete setUserIp(String string) {
                    return (Delete)super.setUserIp(string);
                }

                public String getCustomer() {
                    return this.customer;
                }

                public Delete setCustomer(String string) {
                    this.customer = string;
                    return this;
                }

                public String getFeatureKey() {
                    return this.featureKey;
                }

                public Delete setFeatureKey(String string) {
                    this.featureKey = string;
                    return this;
                }

                @Override
                public Delete set(String string, Object object) {
                    return (Delete)super.set(string, object);
                }
            }
        }

        public class Calendars {
            public Delete delete(String string, String string2) throws IOException {
                Delete delete = new Delete(string, string2);
                Directory.this.initialize((AbstractGoogleClientRequest<?>)delete);
                return delete;
            }

            public Get get(String string, String string2) throws IOException {
                Get get = new Get(string, string2);
                Directory.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            public Insert insert(String string, CalendarResource calendarResource) throws IOException {
                Insert insert = new Insert(string, calendarResource);
                Directory.this.initialize((AbstractGoogleClientRequest<?>)insert);
                return insert;
            }

            public List list(String string) throws IOException {
                List list = new List(string);
                Directory.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            public Patch patch(String string, String string2, CalendarResource calendarResource) throws IOException {
                Patch patch = new Patch(string, string2, calendarResource);
                Directory.this.initialize((AbstractGoogleClientRequest<?>)patch);
                return patch;
            }

            public Update update(String string, String string2, CalendarResource calendarResource) throws IOException {
                Update update = new Update(string, string2, calendarResource);
                Directory.this.initialize((AbstractGoogleClientRequest<?>)update);
                return update;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Update
            extends DirectoryRequest<CalendarResource> {
                private static final String REST_PATH = "customer/{customer}/resources/calendars/{calendarResourceId}";
                @Key
                private String customer;
                @Key
                private String calendarResourceId;

                protected Update(String string, String string2, CalendarResource calendarResource) {
                    super(Directory.this, "PUT", REST_PATH, (Object)calendarResource, CalendarResource.class);
                    this.customer = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customer must be specified.");
                    this.calendarResourceId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter calendarResourceId must be specified.");
                }

                public Update setAlt(String string) {
                    return (Update)super.setAlt(string);
                }

                public Update setFields(String string) {
                    return (Update)super.setFields(string);
                }

                public Update setKey(String string) {
                    return (Update)super.setKey(string);
                }

                public Update setOauthToken(String string) {
                    return (Update)super.setOauthToken(string);
                }

                public Update setPrettyPrint(Boolean bl) {
                    return (Update)super.setPrettyPrint(bl);
                }

                public Update setQuotaUser(String string) {
                    return (Update)super.setQuotaUser(string);
                }

                public Update setUserIp(String string) {
                    return (Update)super.setUserIp(string);
                }

                public String getCustomer() {
                    return this.customer;
                }

                public Update setCustomer(String string) {
                    this.customer = string;
                    return this;
                }

                public String getCalendarResourceId() {
                    return this.calendarResourceId;
                }

                public Update setCalendarResourceId(String string) {
                    this.calendarResourceId = string;
                    return this;
                }

                @Override
                public Update set(String string, Object object) {
                    return (Update)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Patch
            extends DirectoryRequest<CalendarResource> {
                private static final String REST_PATH = "customer/{customer}/resources/calendars/{calendarResourceId}";
                @Key
                private String customer;
                @Key
                private String calendarResourceId;

                protected Patch(String string, String string2, CalendarResource calendarResource) {
                    super(Directory.this, "PATCH", REST_PATH, (Object)calendarResource, CalendarResource.class);
                    this.customer = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customer must be specified.");
                    this.calendarResourceId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter calendarResourceId must be specified.");
                }

                public Patch setAlt(String string) {
                    return (Patch)super.setAlt(string);
                }

                public Patch setFields(String string) {
                    return (Patch)super.setFields(string);
                }

                public Patch setKey(String string) {
                    return (Patch)super.setKey(string);
                }

                public Patch setOauthToken(String string) {
                    return (Patch)super.setOauthToken(string);
                }

                public Patch setPrettyPrint(Boolean bl) {
                    return (Patch)super.setPrettyPrint(bl);
                }

                public Patch setQuotaUser(String string) {
                    return (Patch)super.setQuotaUser(string);
                }

                public Patch setUserIp(String string) {
                    return (Patch)super.setUserIp(string);
                }

                public String getCustomer() {
                    return this.customer;
                }

                public Patch setCustomer(String string) {
                    this.customer = string;
                    return this;
                }

                public String getCalendarResourceId() {
                    return this.calendarResourceId;
                }

                public Patch setCalendarResourceId(String string) {
                    this.calendarResourceId = string;
                    return this;
                }

                @Override
                public Patch set(String string, Object object) {
                    return (Patch)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends DirectoryRequest<CalendarResources> {
                private static final String REST_PATH = "customer/{customer}/resources/calendars";
                @Key
                private String customer;
                @Key
                private Integer maxResults;
                @Key
                private String orderBy;
                @Key
                private String pageToken;
                @Key
                private String query;

                protected List(String string) {
                    super(Directory.this, "GET", REST_PATH, null, CalendarResources.class);
                    this.customer = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customer must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUserIp(String string) {
                    return (List)super.setUserIp(string);
                }

                public String getCustomer() {
                    return this.customer;
                }

                public List setCustomer(String string) {
                    this.customer = string;
                    return this;
                }

                public Integer getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Integer n) {
                    this.maxResults = n;
                    return this;
                }

                public String getOrderBy() {
                    return this.orderBy;
                }

                public List setOrderBy(String string) {
                    this.orderBy = string;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String string) {
                    this.pageToken = string;
                    return this;
                }

                public String getQuery() {
                    return this.query;
                }

                public List setQuery(String string) {
                    this.query = string;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Insert
            extends DirectoryRequest<CalendarResource> {
                private static final String REST_PATH = "customer/{customer}/resources/calendars";
                @Key
                private String customer;

                protected Insert(String string, CalendarResource calendarResource) {
                    super(Directory.this, "POST", REST_PATH, (Object)calendarResource, CalendarResource.class);
                    this.customer = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customer must be specified.");
                    this.checkRequiredParameter((Object)calendarResource, "content");
                    this.checkRequiredParameter(calendarResource.getResourceId(), "CalendarResource.getResourceId()");
                    this.checkRequiredParameter((Object)calendarResource, "content");
                    this.checkRequiredParameter(calendarResource.getResourceName(), "CalendarResource.getResourceName()");
                }

                public Insert setAlt(String string) {
                    return (Insert)super.setAlt(string);
                }

                public Insert setFields(String string) {
                    return (Insert)super.setFields(string);
                }

                public Insert setKey(String string) {
                    return (Insert)super.setKey(string);
                }

                public Insert setOauthToken(String string) {
                    return (Insert)super.setOauthToken(string);
                }

                public Insert setPrettyPrint(Boolean bl) {
                    return (Insert)super.setPrettyPrint(bl);
                }

                public Insert setQuotaUser(String string) {
                    return (Insert)super.setQuotaUser(string);
                }

                public Insert setUserIp(String string) {
                    return (Insert)super.setUserIp(string);
                }

                public String getCustomer() {
                    return this.customer;
                }

                public Insert setCustomer(String string) {
                    this.customer = string;
                    return this;
                }

                @Override
                public Insert set(String string, Object object) {
                    return (Insert)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends DirectoryRequest<CalendarResource> {
                private static final String REST_PATH = "customer/{customer}/resources/calendars/{calendarResourceId}";
                @Key
                private String customer;
                @Key
                private String calendarResourceId;

                protected Get(String string, String string2) {
                    super(Directory.this, "GET", REST_PATH, null, CalendarResource.class);
                    this.customer = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customer must be specified.");
                    this.calendarResourceId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter calendarResourceId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUserIp(String string) {
                    return (Get)super.setUserIp(string);
                }

                public String getCustomer() {
                    return this.customer;
                }

                public Get setCustomer(String string) {
                    this.customer = string;
                    return this;
                }

                public String getCalendarResourceId() {
                    return this.calendarResourceId;
                }

                public Get setCalendarResourceId(String string) {
                    this.calendarResourceId = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Delete
            extends DirectoryRequest<Void> {
                private static final String REST_PATH = "customer/{customer}/resources/calendars/{calendarResourceId}";
                @Key
                private String customer;
                @Key
                private String calendarResourceId;

                protected Delete(String string, String string2) {
                    super(Directory.this, "DELETE", REST_PATH, null, Void.class);
                    this.customer = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customer must be specified.");
                    this.calendarResourceId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter calendarResourceId must be specified.");
                }

                public Delete setAlt(String string) {
                    return (Delete)super.setAlt(string);
                }

                public Delete setFields(String string) {
                    return (Delete)super.setFields(string);
                }

                public Delete setKey(String string) {
                    return (Delete)super.setKey(string);
                }

                public Delete setOauthToken(String string) {
                    return (Delete)super.setOauthToken(string);
                }

                public Delete setPrettyPrint(Boolean bl) {
                    return (Delete)super.setPrettyPrint(bl);
                }

                public Delete setQuotaUser(String string) {
                    return (Delete)super.setQuotaUser(string);
                }

                public Delete setUserIp(String string) {
                    return (Delete)super.setUserIp(string);
                }

                public String getCustomer() {
                    return this.customer;
                }

                public Delete setCustomer(String string) {
                    this.customer = string;
                    return this;
                }

                public String getCalendarResourceId() {
                    return this.calendarResourceId;
                }

                public Delete setCalendarResourceId(String string) {
                    this.calendarResourceId = string;
                    return this;
                }

                @Override
                public Delete set(String string, Object object) {
                    return (Delete)super.set(string, object);
                }
            }
        }

        public class Buildings {
            public Delete delete(String string, String string2) throws IOException {
                Delete delete = new Delete(string, string2);
                Directory.this.initialize((AbstractGoogleClientRequest<?>)delete);
                return delete;
            }

            public Get get(String string, String string2) throws IOException {
                Get get = new Get(string, string2);
                Directory.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            public Insert insert(String string, Building building) throws IOException {
                Insert insert = new Insert(string, building);
                Directory.this.initialize((AbstractGoogleClientRequest<?>)insert);
                return insert;
            }

            public List list(String string) throws IOException {
                List list = new List(string);
                Directory.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            public Patch patch(String string, String string2, Building building) throws IOException {
                Patch patch = new Patch(string, string2, building);
                Directory.this.initialize((AbstractGoogleClientRequest<?>)patch);
                return patch;
            }

            public Update update(String string, String string2, Building building) throws IOException {
                Update update = new Update(string, string2, building);
                Directory.this.initialize((AbstractGoogleClientRequest<?>)update);
                return update;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Update
            extends DirectoryRequest<Building> {
                private static final String REST_PATH = "customer/{customer}/resources/buildings/{buildingId}";
                @Key
                private String customer;
                @Key
                private String buildingId;
                @Key
                private String coordinatesSource;

                protected Update(String string, String string2, Building building) {
                    super(Directory.this, "PUT", REST_PATH, (Object)building, Building.class);
                    this.customer = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customer must be specified.");
                    this.buildingId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter buildingId must be specified.");
                }

                public Update setAlt(String string) {
                    return (Update)super.setAlt(string);
                }

                public Update setFields(String string) {
                    return (Update)super.setFields(string);
                }

                public Update setKey(String string) {
                    return (Update)super.setKey(string);
                }

                public Update setOauthToken(String string) {
                    return (Update)super.setOauthToken(string);
                }

                public Update setPrettyPrint(Boolean bl) {
                    return (Update)super.setPrettyPrint(bl);
                }

                public Update setQuotaUser(String string) {
                    return (Update)super.setQuotaUser(string);
                }

                public Update setUserIp(String string) {
                    return (Update)super.setUserIp(string);
                }

                public String getCustomer() {
                    return this.customer;
                }

                public Update setCustomer(String string) {
                    this.customer = string;
                    return this;
                }

                public String getBuildingId() {
                    return this.buildingId;
                }

                public Update setBuildingId(String string) {
                    this.buildingId = string;
                    return this;
                }

                public String getCoordinatesSource() {
                    return this.coordinatesSource;
                }

                public Update setCoordinatesSource(String string) {
                    this.coordinatesSource = string;
                    return this;
                }

                @Override
                public Update set(String string, Object object) {
                    return (Update)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Patch
            extends DirectoryRequest<Building> {
                private static final String REST_PATH = "customer/{customer}/resources/buildings/{buildingId}";
                @Key
                private String customer;
                @Key
                private String buildingId;
                @Key
                private String coordinatesSource;

                protected Patch(String string, String string2, Building building) {
                    super(Directory.this, "PATCH", REST_PATH, (Object)building, Building.class);
                    this.customer = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customer must be specified.");
                    this.buildingId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter buildingId must be specified.");
                }

                public Patch setAlt(String string) {
                    return (Patch)super.setAlt(string);
                }

                public Patch setFields(String string) {
                    return (Patch)super.setFields(string);
                }

                public Patch setKey(String string) {
                    return (Patch)super.setKey(string);
                }

                public Patch setOauthToken(String string) {
                    return (Patch)super.setOauthToken(string);
                }

                public Patch setPrettyPrint(Boolean bl) {
                    return (Patch)super.setPrettyPrint(bl);
                }

                public Patch setQuotaUser(String string) {
                    return (Patch)super.setQuotaUser(string);
                }

                public Patch setUserIp(String string) {
                    return (Patch)super.setUserIp(string);
                }

                public String getCustomer() {
                    return this.customer;
                }

                public Patch setCustomer(String string) {
                    this.customer = string;
                    return this;
                }

                public String getBuildingId() {
                    return this.buildingId;
                }

                public Patch setBuildingId(String string) {
                    this.buildingId = string;
                    return this;
                }

                public String getCoordinatesSource() {
                    return this.coordinatesSource;
                }

                public Patch setCoordinatesSource(String string) {
                    this.coordinatesSource = string;
                    return this;
                }

                @Override
                public Patch set(String string, Object object) {
                    return (Patch)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends DirectoryRequest<com.google.api.services.admin.directory.model.Buildings> {
                private static final String REST_PATH = "customer/{customer}/resources/buildings";
                @Key
                private String customer;
                @Key
                private Integer maxResults;
                @Key
                private String pageToken;

                protected List(String string) {
                    super(Directory.this, "GET", REST_PATH, null, com.google.api.services.admin.directory.model.Buildings.class);
                    this.customer = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customer must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUserIp(String string) {
                    return (List)super.setUserIp(string);
                }

                public String getCustomer() {
                    return this.customer;
                }

                public List setCustomer(String string) {
                    this.customer = string;
                    return this;
                }

                public Integer getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Integer n) {
                    this.maxResults = n;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String string) {
                    this.pageToken = string;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Insert
            extends DirectoryRequest<Building> {
                private static final String REST_PATH = "customer/{customer}/resources/buildings";
                @Key
                private String customer;
                @Key
                private String coordinatesSource;

                protected Insert(String string, Building building) {
                    super(Directory.this, "POST", REST_PATH, (Object)building, Building.class);
                    this.customer = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customer must be specified.");
                }

                public Insert setAlt(String string) {
                    return (Insert)super.setAlt(string);
                }

                public Insert setFields(String string) {
                    return (Insert)super.setFields(string);
                }

                public Insert setKey(String string) {
                    return (Insert)super.setKey(string);
                }

                public Insert setOauthToken(String string) {
                    return (Insert)super.setOauthToken(string);
                }

                public Insert setPrettyPrint(Boolean bl) {
                    return (Insert)super.setPrettyPrint(bl);
                }

                public Insert setQuotaUser(String string) {
                    return (Insert)super.setQuotaUser(string);
                }

                public Insert setUserIp(String string) {
                    return (Insert)super.setUserIp(string);
                }

                public String getCustomer() {
                    return this.customer;
                }

                public Insert setCustomer(String string) {
                    this.customer = string;
                    return this;
                }

                public String getCoordinatesSource() {
                    return this.coordinatesSource;
                }

                public Insert setCoordinatesSource(String string) {
                    this.coordinatesSource = string;
                    return this;
                }

                @Override
                public Insert set(String string, Object object) {
                    return (Insert)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends DirectoryRequest<Building> {
                private static final String REST_PATH = "customer/{customer}/resources/buildings/{buildingId}";
                @Key
                private String customer;
                @Key
                private String buildingId;

                protected Get(String string, String string2) {
                    super(Directory.this, "GET", REST_PATH, null, Building.class);
                    this.customer = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customer must be specified.");
                    this.buildingId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter buildingId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUserIp(String string) {
                    return (Get)super.setUserIp(string);
                }

                public String getCustomer() {
                    return this.customer;
                }

                public Get setCustomer(String string) {
                    this.customer = string;
                    return this;
                }

                public String getBuildingId() {
                    return this.buildingId;
                }

                public Get setBuildingId(String string) {
                    this.buildingId = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Delete
            extends DirectoryRequest<Void> {
                private static final String REST_PATH = "customer/{customer}/resources/buildings/{buildingId}";
                @Key
                private String customer;
                @Key
                private String buildingId;

                protected Delete(String string, String string2) {
                    super(Directory.this, "DELETE", REST_PATH, null, Void.class);
                    this.customer = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customer must be specified.");
                    this.buildingId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter buildingId must be specified.");
                }

                public Delete setAlt(String string) {
                    return (Delete)super.setAlt(string);
                }

                public Delete setFields(String string) {
                    return (Delete)super.setFields(string);
                }

                public Delete setKey(String string) {
                    return (Delete)super.setKey(string);
                }

                public Delete setOauthToken(String string) {
                    return (Delete)super.setOauthToken(string);
                }

                public Delete setPrettyPrint(Boolean bl) {
                    return (Delete)super.setPrettyPrint(bl);
                }

                public Delete setQuotaUser(String string) {
                    return (Delete)super.setQuotaUser(string);
                }

                public Delete setUserIp(String string) {
                    return (Delete)super.setUserIp(string);
                }

                public String getCustomer() {
                    return this.customer;
                }

                public Delete setCustomer(String string) {
                    this.customer = string;
                    return this;
                }

                public String getBuildingId() {
                    return this.buildingId;
                }

                public Delete setBuildingId(String string) {
                    this.buildingId = string;
                    return this;
                }

                @Override
                public Delete set(String string, Object object) {
                    return (Delete)super.set(string, object);
                }
            }
        }
    }

    public class Privileges {
        public List list(String string) throws IOException {
            List list = new List(string);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends DirectoryRequest<com.google.api.services.admin.directory.model.Privileges> {
            private static final String REST_PATH = "customer/{customer}/roles/ALL/privileges";
            @Key
            private String customer;

            protected List(String string) {
                super(Directory.this, "GET", REST_PATH, null, com.google.api.services.admin.directory.model.Privileges.class);
                this.customer = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customer must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getCustomer() {
                return this.customer;
            }

            public List setCustomer(String string) {
                this.customer = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Orgunits {
        public Delete delete(String string, java.util.List<String> list) throws IOException {
            Delete delete = new Delete(string, list);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, java.util.List<String> list) throws IOException {
            Get get = new Get(string, list);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(String string, OrgUnit orgUnit) throws IOException {
            Insert insert = new Insert(string, orgUnit);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Patch patch(String string, java.util.List<String> list, OrgUnit orgUnit) throws IOException {
            Patch patch = new Patch(string, list, orgUnit);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)patch);
            return patch;
        }

        public Update update(String string, java.util.List<String> list, OrgUnit orgUnit) throws IOException {
            Update update = new Update(string, list, orgUnit);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends DirectoryRequest<OrgUnit> {
            private static final String REST_PATH = "customer/{customerId}/orgunits{/orgUnitPath*}";
            @Key
            private String customerId;
            @Key
            private java.util.List<String> orgUnitPath;

            protected Update(String string, java.util.List<String> list, OrgUnit orgUnit) {
                super(Directory.this, "PUT", REST_PATH, (Object)orgUnit, OrgUnit.class);
                this.customerId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customerId must be specified.");
                this.orgUnitPath = (java.util.List)Preconditions.checkNotNull(list, (Object)"Required parameter orgUnitPath must be specified.");
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getCustomerId() {
                return this.customerId;
            }

            public Update setCustomerId(String string) {
                this.customerId = string;
                return this;
            }

            public java.util.List<String> getOrgUnitPath() {
                return this.orgUnitPath;
            }

            public Update setOrgUnitPath(java.util.List<String> list) {
                this.orgUnitPath = list;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends DirectoryRequest<OrgUnit> {
            private static final String REST_PATH = "customer/{customerId}/orgunits{/orgUnitPath*}";
            @Key
            private String customerId;
            @Key
            private java.util.List<String> orgUnitPath;

            protected Patch(String string, java.util.List<String> list, OrgUnit orgUnit) {
                super(Directory.this, "PATCH", REST_PATH, (Object)orgUnit, OrgUnit.class);
                this.customerId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customerId must be specified.");
                this.orgUnitPath = (java.util.List)Preconditions.checkNotNull(list, (Object)"Required parameter orgUnitPath must be specified.");
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUserIp(String string) {
                return (Patch)super.setUserIp(string);
            }

            public String getCustomerId() {
                return this.customerId;
            }

            public Patch setCustomerId(String string) {
                this.customerId = string;
                return this;
            }

            public java.util.List<String> getOrgUnitPath() {
                return this.orgUnitPath;
            }

            public Patch setOrgUnitPath(java.util.List<String> list) {
                this.orgUnitPath = list;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends DirectoryRequest<OrgUnits> {
            private static final String REST_PATH = "customer/{customerId}/orgunits";
            @Key
            private String customerId;
            @Key
            private String orgUnitPath;
            @Key
            private String type;

            protected List(String string) {
                super(Directory.this, "GET", REST_PATH, null, OrgUnits.class);
                this.customerId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customerId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getCustomerId() {
                return this.customerId;
            }

            public List setCustomerId(String string) {
                this.customerId = string;
                return this;
            }

            public String getOrgUnitPath() {
                return this.orgUnitPath;
            }

            public List setOrgUnitPath(String string) {
                this.orgUnitPath = string;
                return this;
            }

            public String getType() {
                return this.type;
            }

            public List setType(String string) {
                this.type = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends DirectoryRequest<OrgUnit> {
            private static final String REST_PATH = "customer/{customerId}/orgunits";
            @Key
            private String customerId;

            protected Insert(String string, OrgUnit orgUnit) {
                super(Directory.this, "POST", REST_PATH, (Object)orgUnit, OrgUnit.class);
                this.customerId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customerId must be specified.");
                this.checkRequiredParameter((Object)orgUnit, "content");
                this.checkRequiredParameter(orgUnit.getName(), "OrgUnit.getName()");
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getCustomerId() {
                return this.customerId;
            }

            public Insert setCustomerId(String string) {
                this.customerId = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends DirectoryRequest<OrgUnit> {
            private static final String REST_PATH = "customer/{customerId}/orgunits{/orgUnitPath*}";
            @Key
            private String customerId;
            @Key
            private java.util.List<String> orgUnitPath;

            protected Get(String string, java.util.List<String> list) {
                super(Directory.this, "GET", REST_PATH, null, OrgUnit.class);
                this.customerId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customerId must be specified.");
                this.orgUnitPath = (java.util.List)Preconditions.checkNotNull(list, (Object)"Required parameter orgUnitPath must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getCustomerId() {
                return this.customerId;
            }

            public Get setCustomerId(String string) {
                this.customerId = string;
                return this;
            }

            public java.util.List<String> getOrgUnitPath() {
                return this.orgUnitPath;
            }

            public Get setOrgUnitPath(java.util.List<String> list) {
                this.orgUnitPath = list;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends DirectoryRequest<Void> {
            private static final String REST_PATH = "customer/{customerId}/orgunits{/orgUnitPath*}";
            @Key
            private String customerId;
            @Key
            private java.util.List<String> orgUnitPath;

            protected Delete(String string, java.util.List<String> list) {
                super(Directory.this, "DELETE", REST_PATH, null, Void.class);
                this.customerId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customerId must be specified.");
                this.orgUnitPath = (java.util.List)Preconditions.checkNotNull(list, (Object)"Required parameter orgUnitPath must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getCustomerId() {
                return this.customerId;
            }

            public Delete setCustomerId(String string) {
                this.customerId = string;
                return this;
            }

            public java.util.List<String> getOrgUnitPath() {
                return this.orgUnitPath;
            }

            public Delete setOrgUnitPath(java.util.List<String> list) {
                this.orgUnitPath = list;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class Notifications {
        public Delete delete(String string, String string2) throws IOException {
            Delete delete = new Delete(string, string2);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Patch patch(String string, String string2, Notification notification) throws IOException {
            Patch patch = new Patch(string, string2, notification);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)patch);
            return patch;
        }

        public Update update(String string, String string2, Notification notification) throws IOException {
            Update update = new Update(string, string2, notification);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends DirectoryRequest<Notification> {
            private static final String REST_PATH = "customer/{customer}/notifications/{notificationId}";
            @Key
            private String customer;
            @Key
            private String notificationId;

            protected Update(String string, String string2, Notification notification) {
                super(Directory.this, "PUT", REST_PATH, (Object)notification, Notification.class);
                this.customer = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customer must be specified.");
                this.notificationId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter notificationId must be specified.");
                this.checkRequiredParameter((Object)notification, "content");
                this.checkRequiredParameter(notification.getIsUnread(), "Notification.getIsUnread()");
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getCustomer() {
                return this.customer;
            }

            public Update setCustomer(String string) {
                this.customer = string;
                return this;
            }

            public String getNotificationId() {
                return this.notificationId;
            }

            public Update setNotificationId(String string) {
                this.notificationId = string;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends DirectoryRequest<Notification> {
            private static final String REST_PATH = "customer/{customer}/notifications/{notificationId}";
            @Key
            private String customer;
            @Key
            private String notificationId;

            protected Patch(String string, String string2, Notification notification) {
                super(Directory.this, "PATCH", REST_PATH, (Object)notification, Notification.class);
                this.customer = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customer must be specified.");
                this.notificationId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter notificationId must be specified.");
                this.checkRequiredParameter((Object)notification, "content");
                this.checkRequiredParameter(notification.getIsUnread(), "Notification.getIsUnread()");
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUserIp(String string) {
                return (Patch)super.setUserIp(string);
            }

            public String getCustomer() {
                return this.customer;
            }

            public Patch setCustomer(String string) {
                this.customer = string;
                return this;
            }

            public String getNotificationId() {
                return this.notificationId;
            }

            public Patch setNotificationId(String string) {
                this.notificationId = string;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends DirectoryRequest<com.google.api.services.admin.directory.model.Notifications> {
            private static final String REST_PATH = "customer/{customer}/notifications";
            @Key
            private String customer;
            @Key
            private String language;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(String string) {
                super(Directory.this, "GET", REST_PATH, null, com.google.api.services.admin.directory.model.Notifications.class);
                this.customer = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customer must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getCustomer() {
                return this.customer;
            }

            public List setCustomer(String string) {
                this.customer = string;
                return this;
            }

            public String getLanguage() {
                return this.language;
            }

            public List setLanguage(String string) {
                this.language = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends DirectoryRequest<Notification> {
            private static final String REST_PATH = "customer/{customer}/notifications/{notificationId}";
            @Key
            private String customer;
            @Key
            private String notificationId;

            protected Get(String string, String string2) {
                super(Directory.this, "GET", REST_PATH, null, Notification.class);
                this.customer = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customer must be specified.");
                this.notificationId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter notificationId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getCustomer() {
                return this.customer;
            }

            public Get setCustomer(String string) {
                this.customer = string;
                return this;
            }

            public String getNotificationId() {
                return this.notificationId;
            }

            public Get setNotificationId(String string) {
                this.notificationId = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends DirectoryRequest<Void> {
            private static final String REST_PATH = "customer/{customer}/notifications/{notificationId}";
            @Key
            private String customer;
            @Key
            private String notificationId;

            protected Delete(String string, String string2) {
                super(Directory.this, "DELETE", REST_PATH, null, Void.class);
                this.customer = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customer must be specified.");
                this.notificationId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter notificationId must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getCustomer() {
                return this.customer;
            }

            public Delete setCustomer(String string) {
                this.customer = string;
                return this;
            }

            public String getNotificationId() {
                return this.notificationId;
            }

            public Delete setNotificationId(String string) {
                this.notificationId = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class Mobiledevices {
        public Action action(String string, String string2, MobileDeviceAction mobileDeviceAction) throws IOException {
            Action action = new Action(string, string2, mobileDeviceAction);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)action);
            return action;
        }

        public Delete delete(String string, String string2) throws IOException {
            Delete delete = new Delete(string, string2);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends DirectoryRequest<MobileDevices> {
            private static final String REST_PATH = "customer/{customerId}/devices/mobile";
            @Key
            private String customerId;
            @Key
            private Integer maxResults;
            @Key
            private String orderBy;
            @Key
            private String pageToken;
            @Key
            private String projection;
            @Key
            private String query;
            @Key
            private String sortOrder;

            protected List(String string) {
                super(Directory.this, "GET", REST_PATH, null, MobileDevices.class);
                this.customerId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customerId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getCustomerId() {
                return this.customerId;
            }

            public List setCustomerId(String string) {
                this.customerId = string;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Integer n) {
                this.maxResults = n;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String string) {
                this.orderBy = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public List setProjection(String string) {
                this.projection = string;
                return this;
            }

            public String getQuery() {
                return this.query;
            }

            public List setQuery(String string) {
                this.query = string;
                return this;
            }

            public String getSortOrder() {
                return this.sortOrder;
            }

            public List setSortOrder(String string) {
                this.sortOrder = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends DirectoryRequest<MobileDevice> {
            private static final String REST_PATH = "customer/{customerId}/devices/mobile/{resourceId}";
            @Key
            private String customerId;
            @Key
            private String resourceId;
            @Key
            private String projection;

            protected Get(String string, String string2) {
                super(Directory.this, "GET", REST_PATH, null, MobileDevice.class);
                this.customerId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customerId must be specified.");
                this.resourceId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter resourceId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getCustomerId() {
                return this.customerId;
            }

            public Get setCustomerId(String string) {
                this.customerId = string;
                return this;
            }

            public String getResourceId() {
                return this.resourceId;
            }

            public Get setResourceId(String string) {
                this.resourceId = string;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public Get setProjection(String string) {
                this.projection = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends DirectoryRequest<Void> {
            private static final String REST_PATH = "customer/{customerId}/devices/mobile/{resourceId}";
            @Key
            private String customerId;
            @Key
            private String resourceId;

            protected Delete(String string, String string2) {
                super(Directory.this, "DELETE", REST_PATH, null, Void.class);
                this.customerId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customerId must be specified.");
                this.resourceId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter resourceId must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getCustomerId() {
                return this.customerId;
            }

            public Delete setCustomerId(String string) {
                this.customerId = string;
                return this;
            }

            public String getResourceId() {
                return this.resourceId;
            }

            public Delete setResourceId(String string) {
                this.resourceId = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Action
        extends DirectoryRequest<Void> {
            private static final String REST_PATH = "customer/{customerId}/devices/mobile/{resourceId}/action";
            @Key
            private String customerId;
            @Key
            private String resourceId;

            protected Action(String string, String string2, MobileDeviceAction mobileDeviceAction) {
                super(Directory.this, "POST", REST_PATH, (Object)mobileDeviceAction, Void.class);
                this.customerId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customerId must be specified.");
                this.resourceId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter resourceId must be specified.");
            }

            public Action setAlt(String string) {
                return (Action)super.setAlt(string);
            }

            public Action setFields(String string) {
                return (Action)super.setFields(string);
            }

            public Action setKey(String string) {
                return (Action)super.setKey(string);
            }

            public Action setOauthToken(String string) {
                return (Action)super.setOauthToken(string);
            }

            public Action setPrettyPrint(Boolean bl) {
                return (Action)super.setPrettyPrint(bl);
            }

            public Action setQuotaUser(String string) {
                return (Action)super.setQuotaUser(string);
            }

            public Action setUserIp(String string) {
                return (Action)super.setUserIp(string);
            }

            public String getCustomerId() {
                return this.customerId;
            }

            public Action setCustomerId(String string) {
                this.customerId = string;
                return this;
            }

            public String getResourceId() {
                return this.resourceId;
            }

            public Action setResourceId(String string) {
                this.resourceId = string;
                return this;
            }

            @Override
            public Action set(String string, Object object) {
                return (Action)super.set(string, object);
            }
        }
    }

    public class Members {
        public Delete delete(String string, String string2) throws IOException {
            Delete delete = new Delete(string, string2);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public HasMember hasMember(String string, String string2) throws IOException {
            HasMember hasMember = new HasMember(string, string2);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)hasMember);
            return hasMember;
        }

        public Insert insert(String string, Member member) throws IOException {
            Insert insert = new Insert(string, member);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Patch patch(String string, String string2, Member member) throws IOException {
            Patch patch = new Patch(string, string2, member);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)patch);
            return patch;
        }

        public Update update(String string, String string2, Member member) throws IOException {
            Update update = new Update(string, string2, member);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends DirectoryRequest<Member> {
            private static final String REST_PATH = "groups/{groupKey}/members/{memberKey}";
            @Key
            private String groupKey;
            @Key
            private String memberKey;

            protected Update(String string, String string2, Member member) {
                super(Directory.this, "PUT", REST_PATH, (Object)member, Member.class);
                this.groupKey = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter groupKey must be specified.");
                this.memberKey = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter memberKey must be specified.");
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getGroupKey() {
                return this.groupKey;
            }

            public Update setGroupKey(String string) {
                this.groupKey = string;
                return this;
            }

            public String getMemberKey() {
                return this.memberKey;
            }

            public Update setMemberKey(String string) {
                this.memberKey = string;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends DirectoryRequest<Member> {
            private static final String REST_PATH = "groups/{groupKey}/members/{memberKey}";
            @Key
            private String groupKey;
            @Key
            private String memberKey;

            protected Patch(String string, String string2, Member member) {
                super(Directory.this, "PATCH", REST_PATH, (Object)member, Member.class);
                this.groupKey = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter groupKey must be specified.");
                this.memberKey = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter memberKey must be specified.");
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUserIp(String string) {
                return (Patch)super.setUserIp(string);
            }

            public String getGroupKey() {
                return this.groupKey;
            }

            public Patch setGroupKey(String string) {
                this.groupKey = string;
                return this;
            }

            public String getMemberKey() {
                return this.memberKey;
            }

            public Patch setMemberKey(String string) {
                this.memberKey = string;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends DirectoryRequest<com.google.api.services.admin.directory.model.Members> {
            private static final String REST_PATH = "groups/{groupKey}/members";
            @Key
            private String groupKey;
            @Key
            private Boolean includeDerivedMembership;
            @Key
            private Integer maxResults;
            @Key
            private String pageToken;
            @Key
            private String roles;

            protected List(String string) {
                super(Directory.this, "GET", REST_PATH, null, com.google.api.services.admin.directory.model.Members.class);
                this.groupKey = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter groupKey must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getGroupKey() {
                return this.groupKey;
            }

            public List setGroupKey(String string) {
                this.groupKey = string;
                return this;
            }

            public Boolean getIncludeDerivedMembership() {
                return this.includeDerivedMembership;
            }

            public List setIncludeDerivedMembership(Boolean bl) {
                this.includeDerivedMembership = bl;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Integer n) {
                this.maxResults = n;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public String getRoles() {
                return this.roles;
            }

            public List setRoles(String string) {
                this.roles = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends DirectoryRequest<Member> {
            private static final String REST_PATH = "groups/{groupKey}/members";
            @Key
            private String groupKey;

            protected Insert(String string, Member member) {
                super(Directory.this, "POST", REST_PATH, (Object)member, Member.class);
                this.groupKey = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter groupKey must be specified.");
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getGroupKey() {
                return this.groupKey;
            }

            public Insert setGroupKey(String string) {
                this.groupKey = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class HasMember
        extends DirectoryRequest<MembersHasMember> {
            private static final String REST_PATH = "groups/{groupKey}/hasMember/{memberKey}";
            @Key
            private String groupKey;
            @Key
            private String memberKey;

            protected HasMember(String string, String string2) {
                super(Directory.this, "GET", REST_PATH, null, MembersHasMember.class);
                this.groupKey = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter groupKey must be specified.");
                this.memberKey = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter memberKey must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public HasMember setAlt(String string) {
                return (HasMember)super.setAlt(string);
            }

            public HasMember setFields(String string) {
                return (HasMember)super.setFields(string);
            }

            public HasMember setKey(String string) {
                return (HasMember)super.setKey(string);
            }

            public HasMember setOauthToken(String string) {
                return (HasMember)super.setOauthToken(string);
            }

            public HasMember setPrettyPrint(Boolean bl) {
                return (HasMember)super.setPrettyPrint(bl);
            }

            public HasMember setQuotaUser(String string) {
                return (HasMember)super.setQuotaUser(string);
            }

            public HasMember setUserIp(String string) {
                return (HasMember)super.setUserIp(string);
            }

            public String getGroupKey() {
                return this.groupKey;
            }

            public HasMember setGroupKey(String string) {
                this.groupKey = string;
                return this;
            }

            public String getMemberKey() {
                return this.memberKey;
            }

            public HasMember setMemberKey(String string) {
                this.memberKey = string;
                return this;
            }

            @Override
            public HasMember set(String string, Object object) {
                return (HasMember)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends DirectoryRequest<Member> {
            private static final String REST_PATH = "groups/{groupKey}/members/{memberKey}";
            @Key
            private String groupKey;
            @Key
            private String memberKey;

            protected Get(String string, String string2) {
                super(Directory.this, "GET", REST_PATH, null, Member.class);
                this.groupKey = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter groupKey must be specified.");
                this.memberKey = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter memberKey must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getGroupKey() {
                return this.groupKey;
            }

            public Get setGroupKey(String string) {
                this.groupKey = string;
                return this;
            }

            public String getMemberKey() {
                return this.memberKey;
            }

            public Get setMemberKey(String string) {
                this.memberKey = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends DirectoryRequest<Void> {
            private static final String REST_PATH = "groups/{groupKey}/members/{memberKey}";
            @Key
            private String groupKey;
            @Key
            private String memberKey;

            protected Delete(String string, String string2) {
                super(Directory.this, "DELETE", REST_PATH, null, Void.class);
                this.groupKey = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter groupKey must be specified.");
                this.memberKey = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter memberKey must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getGroupKey() {
                return this.groupKey;
            }

            public Delete setGroupKey(String string) {
                this.groupKey = string;
                return this;
            }

            public String getMemberKey() {
                return this.memberKey;
            }

            public Delete setMemberKey(String string) {
                this.memberKey = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class Groups {
        public Delete delete(String string) throws IOException {
            Delete delete = new Delete(string);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string) throws IOException {
            Get get = new Get(string);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(Group group) throws IOException {
            Insert insert = new Insert(group);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list() throws IOException {
            List list = new List();
            Directory.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Patch patch(String string, Group group) throws IOException {
            Patch patch = new Patch(string, group);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)patch);
            return patch;
        }

        public Update update(String string, Group group) throws IOException {
            Update update = new Update(string, group);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        public Aliases aliases() {
            return new Aliases();
        }

        public class Aliases {
            public Delete delete(String string, String string2) throws IOException {
                Delete delete = new Delete(string, string2);
                Directory.this.initialize((AbstractGoogleClientRequest<?>)delete);
                return delete;
            }

            public Insert insert(String string, Alias alias) throws IOException {
                Insert insert = new Insert(string, alias);
                Directory.this.initialize((AbstractGoogleClientRequest<?>)insert);
                return insert;
            }

            public List list(String string) throws IOException {
                List list = new List(string);
                Directory.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends DirectoryRequest<com.google.api.services.admin.directory.model.Aliases> {
                private static final String REST_PATH = "groups/{groupKey}/aliases";
                @Key
                private String groupKey;

                protected List(String string) {
                    super(Directory.this, "GET", REST_PATH, null, com.google.api.services.admin.directory.model.Aliases.class);
                    this.groupKey = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter groupKey must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUserIp(String string) {
                    return (List)super.setUserIp(string);
                }

                public String getGroupKey() {
                    return this.groupKey;
                }

                public List setGroupKey(String string) {
                    this.groupKey = string;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Insert
            extends DirectoryRequest<Alias> {
                private static final String REST_PATH = "groups/{groupKey}/aliases";
                @Key
                private String groupKey;

                protected Insert(String string, Alias alias) {
                    super(Directory.this, "POST", REST_PATH, (Object)alias, Alias.class);
                    this.groupKey = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter groupKey must be specified.");
                }

                public Insert setAlt(String string) {
                    return (Insert)super.setAlt(string);
                }

                public Insert setFields(String string) {
                    return (Insert)super.setFields(string);
                }

                public Insert setKey(String string) {
                    return (Insert)super.setKey(string);
                }

                public Insert setOauthToken(String string) {
                    return (Insert)super.setOauthToken(string);
                }

                public Insert setPrettyPrint(Boolean bl) {
                    return (Insert)super.setPrettyPrint(bl);
                }

                public Insert setQuotaUser(String string) {
                    return (Insert)super.setQuotaUser(string);
                }

                public Insert setUserIp(String string) {
                    return (Insert)super.setUserIp(string);
                }

                public String getGroupKey() {
                    return this.groupKey;
                }

                public Insert setGroupKey(String string) {
                    this.groupKey = string;
                    return this;
                }

                @Override
                public Insert set(String string, Object object) {
                    return (Insert)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Delete
            extends DirectoryRequest<Void> {
                private static final String REST_PATH = "groups/{groupKey}/aliases/{alias}";
                @Key
                private String groupKey;
                @Key
                private String alias;

                protected Delete(String string, String string2) {
                    super(Directory.this, "DELETE", REST_PATH, null, Void.class);
                    this.groupKey = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter groupKey must be specified.");
                    this.alias = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter alias must be specified.");
                }

                public Delete setAlt(String string) {
                    return (Delete)super.setAlt(string);
                }

                public Delete setFields(String string) {
                    return (Delete)super.setFields(string);
                }

                public Delete setKey(String string) {
                    return (Delete)super.setKey(string);
                }

                public Delete setOauthToken(String string) {
                    return (Delete)super.setOauthToken(string);
                }

                public Delete setPrettyPrint(Boolean bl) {
                    return (Delete)super.setPrettyPrint(bl);
                }

                public Delete setQuotaUser(String string) {
                    return (Delete)super.setQuotaUser(string);
                }

                public Delete setUserIp(String string) {
                    return (Delete)super.setUserIp(string);
                }

                public String getGroupKey() {
                    return this.groupKey;
                }

                public Delete setGroupKey(String string) {
                    this.groupKey = string;
                    return this;
                }

                public String getAlias() {
                    return this.alias;
                }

                public Delete setAlias(String string) {
                    this.alias = string;
                    return this;
                }

                @Override
                public Delete set(String string, Object object) {
                    return (Delete)super.set(string, object);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends DirectoryRequest<Group> {
            private static final String REST_PATH = "groups/{groupKey}";
            @Key
            private String groupKey;

            protected Update(String string, Group group) {
                super(Directory.this, "PUT", REST_PATH, (Object)group, Group.class);
                this.groupKey = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter groupKey must be specified.");
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getGroupKey() {
                return this.groupKey;
            }

            public Update setGroupKey(String string) {
                this.groupKey = string;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends DirectoryRequest<Group> {
            private static final String REST_PATH = "groups/{groupKey}";
            @Key
            private String groupKey;

            protected Patch(String string, Group group) {
                super(Directory.this, "PATCH", REST_PATH, (Object)group, Group.class);
                this.groupKey = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter groupKey must be specified.");
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUserIp(String string) {
                return (Patch)super.setUserIp(string);
            }

            public String getGroupKey() {
                return this.groupKey;
            }

            public Patch setGroupKey(String string) {
                this.groupKey = string;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends DirectoryRequest<com.google.api.services.admin.directory.model.Groups> {
            private static final String REST_PATH = "groups";
            @Key
            private String customer;
            @Key
            private String domain;
            @Key
            private Integer maxResults;
            @Key
            private String orderBy;
            @Key
            private String pageToken;
            @Key
            private String query;
            @Key
            private String sortOrder;
            @Key
            private String userKey;

            protected List() {
                super(Directory.this, "GET", REST_PATH, null, com.google.api.services.admin.directory.model.Groups.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getCustomer() {
                return this.customer;
            }

            public List setCustomer(String string) {
                this.customer = string;
                return this;
            }

            public String getDomain() {
                return this.domain;
            }

            public List setDomain(String string) {
                this.domain = string;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Integer n) {
                this.maxResults = n;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String string) {
                this.orderBy = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public String getQuery() {
                return this.query;
            }

            public List setQuery(String string) {
                this.query = string;
                return this;
            }

            public String getSortOrder() {
                return this.sortOrder;
            }

            public List setSortOrder(String string) {
                this.sortOrder = string;
                return this;
            }

            public String getUserKey() {
                return this.userKey;
            }

            public List setUserKey(String string) {
                this.userKey = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends DirectoryRequest<Group> {
            private static final String REST_PATH = "groups";

            protected Insert(Group group) {
                super(Directory.this, "POST", REST_PATH, (Object)group, Group.class);
                this.checkRequiredParameter((Object)group, "content");
                this.checkRequiredParameter(group.getEmail(), "Group.getEmail()");
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends DirectoryRequest<Group> {
            private static final String REST_PATH = "groups/{groupKey}";
            @Key
            private String groupKey;

            protected Get(String string) {
                super(Directory.this, "GET", REST_PATH, null, Group.class);
                this.groupKey = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter groupKey must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getGroupKey() {
                return this.groupKey;
            }

            public Get setGroupKey(String string) {
                this.groupKey = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends DirectoryRequest<Void> {
            private static final String REST_PATH = "groups/{groupKey}";
            @Key
            private String groupKey;

            protected Delete(String string) {
                super(Directory.this, "DELETE", REST_PATH, null, Void.class);
                this.groupKey = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter groupKey must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getGroupKey() {
                return this.groupKey;
            }

            public Delete setGroupKey(String string) {
                this.groupKey = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class Domains {
        public Delete delete(String string, String string2) throws IOException {
            Delete delete = new Delete(string, string2);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(String string, com.google.api.services.admin.directory.model.Domains domains) throws IOException {
            Insert insert = new Insert(string, domains);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends DirectoryRequest<Domains2> {
            private static final String REST_PATH = "customer/{customer}/domains";
            @Key
            private String customer;

            protected List(String string) {
                super(Directory.this, "GET", REST_PATH, null, Domains2.class);
                this.customer = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customer must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getCustomer() {
                return this.customer;
            }

            public List setCustomer(String string) {
                this.customer = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends DirectoryRequest<com.google.api.services.admin.directory.model.Domains> {
            private static final String REST_PATH = "customer/{customer}/domains";
            @Key
            private String customer;

            protected Insert(String string, com.google.api.services.admin.directory.model.Domains domains2) {
                super(Directory.this, "POST", REST_PATH, (Object)domains2, com.google.api.services.admin.directory.model.Domains.class);
                this.customer = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customer must be specified.");
                this.checkRequiredParameter((Object)domains2, "content");
                this.checkRequiredParameter(domains2.getDomainName(), "Domains.getDomainName()");
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getCustomer() {
                return this.customer;
            }

            public Insert setCustomer(String string) {
                this.customer = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends DirectoryRequest<com.google.api.services.admin.directory.model.Domains> {
            private static final String REST_PATH = "customer/{customer}/domains/{domainName}";
            @Key
            private String customer;
            @Key
            private String domainName;

            protected Get(String string, String string2) {
                super(Directory.this, "GET", REST_PATH, null, com.google.api.services.admin.directory.model.Domains.class);
                this.customer = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customer must be specified.");
                this.domainName = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter domainName must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getCustomer() {
                return this.customer;
            }

            public Get setCustomer(String string) {
                this.customer = string;
                return this;
            }

            public String getDomainName() {
                return this.domainName;
            }

            public Get setDomainName(String string) {
                this.domainName = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends DirectoryRequest<Void> {
            private static final String REST_PATH = "customer/{customer}/domains/{domainName}";
            @Key
            private String customer;
            @Key
            private String domainName;

            protected Delete(String string, String string2) {
                super(Directory.this, "DELETE", REST_PATH, null, Void.class);
                this.customer = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customer must be specified.");
                this.domainName = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter domainName must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getCustomer() {
                return this.customer;
            }

            public Delete setCustomer(String string) {
                this.customer = string;
                return this;
            }

            public String getDomainName() {
                return this.domainName;
            }

            public Delete setDomainName(String string) {
                this.domainName = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class DomainAliases {
        public Delete delete(String string, String string2) throws IOException {
            Delete delete = new Delete(string, string2);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(String string, DomainAlias domainAlias) throws IOException {
            Insert insert = new Insert(string, domainAlias);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends DirectoryRequest<com.google.api.services.admin.directory.model.DomainAliases> {
            private static final String REST_PATH = "customer/{customer}/domainaliases";
            @Key
            private String customer;
            @Key
            private String parentDomainName;

            protected List(String string) {
                super(Directory.this, "GET", REST_PATH, null, com.google.api.services.admin.directory.model.DomainAliases.class);
                this.customer = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customer must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getCustomer() {
                return this.customer;
            }

            public List setCustomer(String string) {
                this.customer = string;
                return this;
            }

            public String getParentDomainName() {
                return this.parentDomainName;
            }

            public List setParentDomainName(String string) {
                this.parentDomainName = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends DirectoryRequest<DomainAlias> {
            private static final String REST_PATH = "customer/{customer}/domainaliases";
            @Key
            private String customer;

            protected Insert(String string, DomainAlias domainAlias) {
                super(Directory.this, "POST", REST_PATH, (Object)domainAlias, DomainAlias.class);
                this.customer = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customer must be specified.");
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getCustomer() {
                return this.customer;
            }

            public Insert setCustomer(String string) {
                this.customer = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends DirectoryRequest<DomainAlias> {
            private static final String REST_PATH = "customer/{customer}/domainaliases/{domainAliasName}";
            @Key
            private String customer;
            @Key
            private String domainAliasName;

            protected Get(String string, String string2) {
                super(Directory.this, "GET", REST_PATH, null, DomainAlias.class);
                this.customer = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customer must be specified.");
                this.domainAliasName = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter domainAliasName must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getCustomer() {
                return this.customer;
            }

            public Get setCustomer(String string) {
                this.customer = string;
                return this;
            }

            public String getDomainAliasName() {
                return this.domainAliasName;
            }

            public Get setDomainAliasName(String string) {
                this.domainAliasName = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends DirectoryRequest<Void> {
            private static final String REST_PATH = "customer/{customer}/domainaliases/{domainAliasName}";
            @Key
            private String customer;
            @Key
            private String domainAliasName;

            protected Delete(String string, String string2) {
                super(Directory.this, "DELETE", REST_PATH, null, Void.class);
                this.customer = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customer must be specified.");
                this.domainAliasName = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter domainAliasName must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getCustomer() {
                return this.customer;
            }

            public Delete setCustomer(String string) {
                this.customer = string;
                return this;
            }

            public String getDomainAliasName() {
                return this.domainAliasName;
            }

            public Delete setDomainAliasName(String string) {
                this.domainAliasName = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class Customers {
        public Get get(String string) throws IOException {
            Get get = new Get(string);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Patch patch(String string, Customer customer) throws IOException {
            Patch patch = new Patch(string, customer);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)patch);
            return patch;
        }

        public Update update(String string, Customer customer) throws IOException {
            Update update = new Update(string, customer);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends DirectoryRequest<Customer> {
            private static final String REST_PATH = "customers/{customerKey}";
            @Key
            private String customerKey;

            protected Update(String string, Customer customer) {
                super(Directory.this, "PUT", REST_PATH, (Object)customer, Customer.class);
                this.customerKey = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customerKey must be specified.");
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getCustomerKey() {
                return this.customerKey;
            }

            public Update setCustomerKey(String string) {
                this.customerKey = string;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends DirectoryRequest<Customer> {
            private static final String REST_PATH = "customers/{customerKey}";
            @Key
            private String customerKey;

            protected Patch(String string, Customer customer) {
                super(Directory.this, "PATCH", REST_PATH, (Object)customer, Customer.class);
                this.customerKey = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customerKey must be specified.");
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUserIp(String string) {
                return (Patch)super.setUserIp(string);
            }

            public String getCustomerKey() {
                return this.customerKey;
            }

            public Patch setCustomerKey(String string) {
                this.customerKey = string;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends DirectoryRequest<Customer> {
            private static final String REST_PATH = "customers/{customerKey}";
            @Key
            private String customerKey;

            protected Get(String string) {
                super(Directory.this, "GET", REST_PATH, null, Customer.class);
                this.customerKey = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customerKey must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getCustomerKey() {
                return this.customerKey;
            }

            public Get setCustomerKey(String string) {
                this.customerKey = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }
    }

    public class Chromeosdevices {
        public Action action(String string, String string2, ChromeOsDeviceAction chromeOsDeviceAction) throws IOException {
            Action action = new Action(string, string2, chromeOsDeviceAction);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)action);
            return action;
        }

        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public MoveDevicesToOu moveDevicesToOu(String string, String string2, ChromeOsMoveDevicesToOu chromeOsMoveDevicesToOu) throws IOException {
            MoveDevicesToOu moveDevicesToOu = new MoveDevicesToOu(string, string2, chromeOsMoveDevicesToOu);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)moveDevicesToOu);
            return moveDevicesToOu;
        }

        public Patch patch(String string, String string2, ChromeOsDevice chromeOsDevice) throws IOException {
            Patch patch = new Patch(string, string2, chromeOsDevice);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)patch);
            return patch;
        }

        public Update update(String string, String string2, ChromeOsDevice chromeOsDevice) throws IOException {
            Update update = new Update(string, string2, chromeOsDevice);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends DirectoryRequest<ChromeOsDevice> {
            private static final String REST_PATH = "customer/{customerId}/devices/chromeos/{deviceId}";
            @Key
            private String customerId;
            @Key
            private String deviceId;
            @Key
            private String projection;

            protected Update(String string, String string2, ChromeOsDevice chromeOsDevice) {
                super(Directory.this, "PUT", REST_PATH, (Object)chromeOsDevice, ChromeOsDevice.class);
                this.customerId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customerId must be specified.");
                this.deviceId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter deviceId must be specified.");
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getCustomerId() {
                return this.customerId;
            }

            public Update setCustomerId(String string) {
                this.customerId = string;
                return this;
            }

            public String getDeviceId() {
                return this.deviceId;
            }

            public Update setDeviceId(String string) {
                this.deviceId = string;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public Update setProjection(String string) {
                this.projection = string;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends DirectoryRequest<ChromeOsDevice> {
            private static final String REST_PATH = "customer/{customerId}/devices/chromeos/{deviceId}";
            @Key
            private String customerId;
            @Key
            private String deviceId;
            @Key
            private String projection;

            protected Patch(String string, String string2, ChromeOsDevice chromeOsDevice) {
                super(Directory.this, "PATCH", REST_PATH, (Object)chromeOsDevice, ChromeOsDevice.class);
                this.customerId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customerId must be specified.");
                this.deviceId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter deviceId must be specified.");
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUserIp(String string) {
                return (Patch)super.setUserIp(string);
            }

            public String getCustomerId() {
                return this.customerId;
            }

            public Patch setCustomerId(String string) {
                this.customerId = string;
                return this;
            }

            public String getDeviceId() {
                return this.deviceId;
            }

            public Patch setDeviceId(String string) {
                this.deviceId = string;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public Patch setProjection(String string) {
                this.projection = string;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class MoveDevicesToOu
        extends DirectoryRequest<Void> {
            private static final String REST_PATH = "customer/{customerId}/devices/chromeos/moveDevicesToOu";
            @Key
            private String customerId;
            @Key
            private String orgUnitPath;

            protected MoveDevicesToOu(String string, String string2, ChromeOsMoveDevicesToOu chromeOsMoveDevicesToOu) {
                super(Directory.this, "POST", REST_PATH, (Object)chromeOsMoveDevicesToOu, Void.class);
                this.customerId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customerId must be specified.");
                this.orgUnitPath = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter orgUnitPath must be specified.");
            }

            public MoveDevicesToOu setAlt(String string) {
                return (MoveDevicesToOu)super.setAlt(string);
            }

            public MoveDevicesToOu setFields(String string) {
                return (MoveDevicesToOu)super.setFields(string);
            }

            public MoveDevicesToOu setKey(String string) {
                return (MoveDevicesToOu)super.setKey(string);
            }

            public MoveDevicesToOu setOauthToken(String string) {
                return (MoveDevicesToOu)super.setOauthToken(string);
            }

            public MoveDevicesToOu setPrettyPrint(Boolean bl) {
                return (MoveDevicesToOu)super.setPrettyPrint(bl);
            }

            public MoveDevicesToOu setQuotaUser(String string) {
                return (MoveDevicesToOu)super.setQuotaUser(string);
            }

            public MoveDevicesToOu setUserIp(String string) {
                return (MoveDevicesToOu)super.setUserIp(string);
            }

            public String getCustomerId() {
                return this.customerId;
            }

            public MoveDevicesToOu setCustomerId(String string) {
                this.customerId = string;
                return this;
            }

            public String getOrgUnitPath() {
                return this.orgUnitPath;
            }

            public MoveDevicesToOu setOrgUnitPath(String string) {
                this.orgUnitPath = string;
                return this;
            }

            @Override
            public MoveDevicesToOu set(String string, Object object) {
                return (MoveDevicesToOu)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends DirectoryRequest<ChromeOsDevices> {
            private static final String REST_PATH = "customer/{customerId}/devices/chromeos";
            @Key
            private String customerId;
            @Key
            private Integer maxResults;
            @Key
            private String orderBy;
            @Key
            private String orgUnitPath;
            @Key
            private String pageToken;
            @Key
            private String projection;
            @Key
            private String query;
            @Key
            private String sortOrder;

            protected List(String string) {
                super(Directory.this, "GET", REST_PATH, null, ChromeOsDevices.class);
                this.customerId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customerId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getCustomerId() {
                return this.customerId;
            }

            public List setCustomerId(String string) {
                this.customerId = string;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Integer n) {
                this.maxResults = n;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String string) {
                this.orderBy = string;
                return this;
            }

            public String getOrgUnitPath() {
                return this.orgUnitPath;
            }

            public List setOrgUnitPath(String string) {
                this.orgUnitPath = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public List setProjection(String string) {
                this.projection = string;
                return this;
            }

            public String getQuery() {
                return this.query;
            }

            public List setQuery(String string) {
                this.query = string;
                return this;
            }

            public String getSortOrder() {
                return this.sortOrder;
            }

            public List setSortOrder(String string) {
                this.sortOrder = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends DirectoryRequest<ChromeOsDevice> {
            private static final String REST_PATH = "customer/{customerId}/devices/chromeos/{deviceId}";
            @Key
            private String customerId;
            @Key
            private String deviceId;
            @Key
            private String projection;

            protected Get(String string, String string2) {
                super(Directory.this, "GET", REST_PATH, null, ChromeOsDevice.class);
                this.customerId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customerId must be specified.");
                this.deviceId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter deviceId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getCustomerId() {
                return this.customerId;
            }

            public Get setCustomerId(String string) {
                this.customerId = string;
                return this;
            }

            public String getDeviceId() {
                return this.deviceId;
            }

            public Get setDeviceId(String string) {
                this.deviceId = string;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public Get setProjection(String string) {
                this.projection = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Action
        extends DirectoryRequest<Void> {
            private static final String REST_PATH = "customer/{customerId}/devices/chromeos/{resourceId}/action";
            @Key
            private String customerId;
            @Key
            private String resourceId;

            protected Action(String string, String string2, ChromeOsDeviceAction chromeOsDeviceAction) {
                super(Directory.this, "POST", REST_PATH, (Object)chromeOsDeviceAction, Void.class);
                this.customerId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customerId must be specified.");
                this.resourceId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter resourceId must be specified.");
            }

            public Action setAlt(String string) {
                return (Action)super.setAlt(string);
            }

            public Action setFields(String string) {
                return (Action)super.setFields(string);
            }

            public Action setKey(String string) {
                return (Action)super.setKey(string);
            }

            public Action setOauthToken(String string) {
                return (Action)super.setOauthToken(string);
            }

            public Action setPrettyPrint(Boolean bl) {
                return (Action)super.setPrettyPrint(bl);
            }

            public Action setQuotaUser(String string) {
                return (Action)super.setQuotaUser(string);
            }

            public Action setUserIp(String string) {
                return (Action)super.setUserIp(string);
            }

            public String getCustomerId() {
                return this.customerId;
            }

            public Action setCustomerId(String string) {
                this.customerId = string;
                return this;
            }

            public String getResourceId() {
                return this.resourceId;
            }

            public Action setResourceId(String string) {
                this.resourceId = string;
                return this;
            }

            @Override
            public Action set(String string, Object object) {
                return (Action)super.set(string, object);
            }
        }
    }

    public class Channels {
        public Stop stop(Channel channel) throws IOException {
            Stop stop = new Stop(channel);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)stop);
            return stop;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Stop
        extends DirectoryRequest<Void> {
            private static final String REST_PATH = "/admin/directory_v1/channels/stop";

            protected Stop(Channel channel) {
                super(Directory.this, "POST", REST_PATH, (Object)channel, Void.class);
            }

            public Stop setAlt(String string) {
                return (Stop)super.setAlt(string);
            }

            public Stop setFields(String string) {
                return (Stop)super.setFields(string);
            }

            public Stop setKey(String string) {
                return (Stop)super.setKey(string);
            }

            public Stop setOauthToken(String string) {
                return (Stop)super.setOauthToken(string);
            }

            public Stop setPrettyPrint(Boolean bl) {
                return (Stop)super.setPrettyPrint(bl);
            }

            public Stop setQuotaUser(String string) {
                return (Stop)super.setQuotaUser(string);
            }

            public Stop setUserIp(String string) {
                return (Stop)super.setUserIp(string);
            }

            @Override
            public Stop set(String string, Object object) {
                return (Stop)super.set(string, object);
            }
        }
    }

    public class Asps {
        public Delete delete(String string, Integer n) throws IOException {
            Delete delete = new Delete(string, n);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, Integer n) throws IOException {
            Get get = new Get(string, n);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends DirectoryRequest<com.google.api.services.admin.directory.model.Asps> {
            private static final String REST_PATH = "users/{userKey}/asps";
            @Key
            private String userKey;

            protected List(String string) {
                super(Directory.this, "GET", REST_PATH, null, com.google.api.services.admin.directory.model.Asps.class);
                this.userKey = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userKey must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getUserKey() {
                return this.userKey;
            }

            public List setUserKey(String string) {
                this.userKey = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends DirectoryRequest<Asp> {
            private static final String REST_PATH = "users/{userKey}/asps/{codeId}";
            @Key
            private String userKey;
            @Key
            private Integer codeId;

            protected Get(String string, Integer n) {
                super(Directory.this, "GET", REST_PATH, null, Asp.class);
                this.userKey = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userKey must be specified.");
                this.codeId = (Integer)Preconditions.checkNotNull((Object)n, (Object)"Required parameter codeId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getUserKey() {
                return this.userKey;
            }

            public Get setUserKey(String string) {
                this.userKey = string;
                return this;
            }

            public Integer getCodeId() {
                return this.codeId;
            }

            public Get setCodeId(Integer n) {
                this.codeId = n;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends DirectoryRequest<Void> {
            private static final String REST_PATH = "users/{userKey}/asps/{codeId}";
            @Key
            private String userKey;
            @Key
            private Integer codeId;

            protected Delete(String string, Integer n) {
                super(Directory.this, "DELETE", REST_PATH, null, Void.class);
                this.userKey = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userKey must be specified.");
                this.codeId = (Integer)Preconditions.checkNotNull((Object)n, (Object)"Required parameter codeId must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getUserKey() {
                return this.userKey;
            }

            public Delete setUserKey(String string) {
                this.userKey = string;
                return this;
            }

            public Integer getCodeId() {
                return this.codeId;
            }

            public Delete setCodeId(Integer n) {
                this.codeId = n;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }
}

