/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.informix.edit;

import com.dbeaver.db.informix.model.InformixConstraint;
import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.ext.generic.edit.GenericPrimaryKeyManager;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericUniqueKey;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.DBECommandAbstract;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.struct.AbstractTable;
import org.jkiss.dbeaver.model.impl.struct.AbstractTableConstraint;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.utils.CommonUtils;

public class InformixConstraintManager
extends GenericPrimaryKeyManager {
    protected void addObjectCreateActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) {
        InformixConstraint constraint = (InformixConstraint)command.getObject();
        if (((GenericUniqueKey)command.getObject()).getConstraintType() == DBSEntityConstraintType.CHECK) {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction(ModelMessages.model_jdbc_create_new_constraint, "ALTER TABLE " + ((GenericTableBase)constraint.getParentObject()).getFullyQualifiedName(DBPEvaluationContext.DDL) + " ADD CONSTRAINT CHECK (" + constraint.getCheckConstraintDefinition() + ")"));
        } else {
            super.addObjectCreateActions(monitor, executionContext, actions, command, options);
        }
    }

    public StringBuilder getNestedDeclaration(DBRProgressMonitor monitor, GenericTableBase owner, DBECommandAbstract<GenericUniqueKey> command, Map<String, Object> options) {
        InformixConstraint constraint = (InformixConstraint)command.getObject();
        StringBuilder decl = new StringBuilder(40);
        if (owner.isPersisted() && !constraint.isPersisted()) {
            decl.append("CONSTRAINT ");
        }
        decl.append(this.getAddConstraintTypeClause((AbstractTableConstraint)constraint));
        this.appendConstraintDefinition(decl, command);
        if (!CommonUtils.isEmpty((CharSequence)decl)) {
            return decl;
        }
        return super.getNestedDeclaration(monitor, (AbstractTable)owner, command, options);
    }

    protected void appendConstraintDefinition(StringBuilder decl, DBECommandAbstract<GenericUniqueKey> command) {
        if (((GenericUniqueKey)command.getObject()).getConstraintType() == DBSEntityConstraintType.CHECK) {
            decl.append("(").append(((InformixConstraint)command.getObject()).getCheckConstraintDefinition()).append(")");
        } else {
            super.appendConstraintDefinition(decl, command);
        }
    }
}

