/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.net.auth.aws;

import com.dbeaver.model.auth.SMAuthUtils;
import com.dbeaver.net.auth.aws.AWSIAMUtils;
import com.dbeaver.net.auth.aws.AuthModelAWSCredentials;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceOriginExternal;
import org.jkiss.dbeaver.model.auth.SMSession;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.impl.auth.AuthModelDatabaseNative;
import org.jkiss.dbeaver.model.impl.auth.AuthModelDatabaseNativeCredentials;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public abstract class AuthModelAWSAbstract
extends AuthModelDatabaseNative<AuthModelAWSCredentials> {
    @NotNull
    public AuthModelAWSCredentials createCredentials() {
        return new AuthModelAWSCredentials();
    }

    @NotNull
    public AuthModelAWSCredentials loadCredentials(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration) {
        AuthModelAWSCredentials credentials = (AuthModelAWSCredentials)super.loadCredentials(dataSource, configuration);
        Map authProperties = configuration.getAuthProperties();
        if (DBWorkbench.isDistributed() && !DBWorkbench.getPlatform().getApplication().isMultiuser() && !CommonUtils.isEmpty((Map)authProperties) && authProperties.containsKey("iam.use_session_credentials")) {
            this.updateAWSCredentialsFromSession(credentials);
        } else if (!CommonUtils.isEmpty((Map)authProperties)) {
            AuthModelAWSAbstract.loadCredentialsFromMap(credentials, authProperties);
        }
        if (!DBWorkbench.getPlatform().getApplication().isMultiuser() || dataSource.getOrigin() instanceof DBPDataSourceOriginExternal || credentials.isSessionCredentials()) {
            this.copyCredentialsFromCloudSession(credentials, configuration);
        }
        return credentials;
    }

    private void copyCredentialsFromCloudSession(@NotNull AuthModelAWSCredentials credentials, @NotNull DBPConnectionConfiguration configuration) {
        AuthModelAWSCredentials cloudCredentials = (AuthModelAWSCredentials)((Object)configuration.getRuntimeAttribute("iam.credentials"));
        if (cloudCredentials == null) {
            return;
        }
        if (CommonUtils.isEmpty((String)credentials.getAwsAccessKey()) && CommonUtils.isEmpty((String)credentials.getAwsSecretKey())) {
            credentials.setAwsAccessKey(cloudCredentials.getAwsAccessKey());
            credentials.setAwsSecretKey(cloudCredentials.getAwsSecretKey());
            credentials.setAwsSessionToken(cloudCredentials.getAwsSessionToken());
            credentials.setAwsCredentialsProvider(cloudCredentials.getAwsCredentialsProvider());
        }
    }

    private void updateAWSCredentialsFromSession(@NotNull AuthModelAWSCredentials iamCredentials) {
        Map objectMap;
        SMSession mainSession = DBWorkbench.getPlatform().getWorkspace().getWorkspaceSession();
        if (mainSession != null && !CommonUtils.isEmpty((Map)(objectMap = SMAuthUtils.getCredentialsFromSession((SMSession)mainSession, (String)"aws")))) {
            AWSIAMUtils.updateCredentialsFromSessionData(objectMap, iamCredentials);
        }
    }

    public void saveCredentials(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration, @NotNull AuthModelAWSCredentials credentials) {
        LinkedHashMap<String, String> authProperties = new LinkedHashMap<String, String>();
        AuthModelAWSAbstract.saveCredentialsToMap(credentials, authProperties, dataSource);
        for (Map.Entry ap : authProperties.entrySet()) {
            configuration.setAuthProperty((String)ap.getKey(), (String)ap.getValue());
        }
        super.saveCredentials(dataSource, configuration, (AuthModelDatabaseNativeCredentials)credentials);
    }

    public void refreshCredentials(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration, @NotNull AuthModelAWSCredentials credentials) throws DBException {
        credentials.refreshSession(monitor, dataSource);
    }

    public static void loadCredentialsFromMap(AuthModelAWSCredentials credentials, Map<String, String> authProperties) {
        credentials.setProfileName(authProperties.get("iam.profile_name"));
        credentials.setRegion(authProperties.get("iam.region"));
        credentials.setDefaultAwsCredentials(CommonUtils.getBoolean((String)authProperties.get("iam.use_default_aws")));
        credentials.setSessionCredentials(CommonUtils.toBoolean((Object)authProperties.get("iam.use_session_credentials")));
        if (!CommonUtils.isEmpty((String)authProperties.get("iam.aws_access_key"))) {
            credentials.setAwsAccessKey(authProperties.get("iam.aws_access_key"));
            credentials.setAwsSecretKey(authProperties.get("iam.aws_secret_key"));
            credentials.setAwsSessionToken(authProperties.get("iam.aws_session_token"));
        }
        credentials.setSsoOverCli(CommonUtils.getBoolean((String)authProperties.get("iam.sso_over_cli")));
        credentials.setAwsAssumeRoleName(authProperties.get("iam.role_name"));
        credentials.setCrossAccountAccess(CommonUtils.getBoolean((String)authProperties.get("iam.cross_account_access")));
        credentials.setAwsAssumeAccountId(authProperties.get("iam.account_id"));
        credentials.setAwsExternalId(authProperties.get("iam.external_id"));
        credentials.setSecretName(authProperties.get("iam.aws_secret_name"));
    }

    public static void saveCredentialsToMap(@NotNull AuthModelAWSCredentials credentials, @NotNull Map<String, String> authProperties) {
        AuthModelAWSAbstract.saveCredentialsToMap(credentials, authProperties, null);
    }

    public static void saveCredentialsToMap(@NotNull AuthModelAWSCredentials credentials, @NotNull Map<String, String> authProperties, @Nullable DBPDataSourceContainer dataSource) {
        if (!CommonUtils.isEmpty((String)credentials.getProfileName())) {
            authProperties.put("iam.profile_name", credentials.getProfileName());
        }
        if (!CommonUtils.isEmpty((String)credentials.getRegion())) {
            authProperties.put("iam.region", credentials.getRegion());
        }
        if (credentials.isDefaultAwsCredentials()) {
            authProperties.put("iam.use_default_aws", String.valueOf(true));
        }
        if (credentials.isSessionCredentials()) {
            authProperties.put("iam.use_session_credentials", String.valueOf(true));
        }
        if (dataSource == null || dataSource.isSavePassword() || dataSource.isSharedCredentials()) {
            if (!CommonUtils.isEmpty((String)credentials.getAwsAccessKey())) {
                authProperties.put("iam.aws_access_key", credentials.getAwsAccessKey());
            }
            if (!CommonUtils.isEmpty((String)credentials.getAwsSecretKey())) {
                authProperties.put("iam.aws_secret_key", credentials.getAwsSecretKey());
            }
            if (!CommonUtils.isEmpty((String)credentials.getAwsSessionToken())) {
                authProperties.put("iam.aws_session_token", credentials.getAwsSessionToken());
            }
        }
        authProperties.put("iam.sso_over_cli", String.valueOf(credentials.isSsoOverCli()));
        authProperties.put("iam.cross_account_access", String.valueOf(credentials.isCrossAccountAccess()));
        if (!CommonUtils.isEmpty((String)credentials.getAwsAssumeAccountId())) {
            authProperties.put("iam.account_id", credentials.getAwsAssumeAccountId());
        }
        if (!CommonUtils.isEmpty((String)credentials.getAwsAssumeRoleName())) {
            authProperties.put("iam.role_name", credentials.getAwsAssumeRoleName());
        }
        if (!CommonUtils.isEmpty((String)credentials.getSecretName())) {
            authProperties.put("iam.aws_secret_name", credentials.getSecretName());
        }
        if (!CommonUtils.isEmpty((String)credentials.getAwsExternalId())) {
            authProperties.put("iam.external_id", credentials.getAwsExternalId());
        }
    }

    public boolean supportsDatabaseUser() {
        return true;
    }

    public boolean supportsRegion() {
        return this.supportsDatabaseUser();
    }
}

