/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util;

import com.sap.db.annotations.Immutable;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;

@Immutable
public final class SSLUtils {
    private static final int ALTNAME_DNS = 2;

    private SSLUtils() {
        throw new AssertionError((Object)"Non-instantiable class");
    }

    public static boolean validateHostName(String rfc2253name, Collection<List<?>> alternativeNames, String urlHostName) {
        if (alternativeNames != null) {
            for (List<?> o : alternativeNames) {
                String dns;
                List<?> list;
                if (!(o instanceof List) || (list = o).size() < 2 || (Integer)list.get(0) != 2 || !SSLUtils._matches(dns = (String)list.get(1), urlHostName)) continue;
                return true;
            }
        }
        if (rfc2253name == null) {
            return false;
        }
        Rdn rdn = SSLUtils._getCommonNameRdn(rfc2253name);
        if (rdn == null) {
            return false;
        }
        String cnHostName = rdn.getValue() instanceof String ? (String)rdn.getValue() : null;
        String commonNamePart = rdn.toString();
        if (SSLUtils._looksLikeCommonName(urlHostName)) {
            return urlHostName.equals(commonNamePart);
        }
        return SSLUtils._matches(cnHostName, urlHostName);
    }

    private static boolean _matches(String nameFromCertificate, String host) {
        if (nameFromCertificate == null || host == null) {
            return false;
        }
        int pos = nameFromCertificate.indexOf("*");
        if (pos == -1) {
            return nameFromCertificate.equalsIgnoreCase(host);
        }
        String before = nameFromCertificate.substring(0, pos).toLowerCase(Locale.ENGLISH);
        if (before.indexOf(46) != -1) {
            return false;
        }
        String after = nameFromCertificate.substring(pos + 1).toLowerCase(Locale.ENGLISH);
        if (after.length() < 2) {
            return false;
        }
        if (after.charAt(0) != '.') {
            return false;
        }
        String host_lc = host.toLowerCase(Locale.ENGLISH);
        if (host_lc.startsWith(before) && host_lc.endsWith(after)) {
            if (host_lc.length() < before.length() + after.length()) {
                return false;
            }
            String match = host_lc.substring(before.length());
            return (match = match.substring(0, match.length() - after.length())).indexOf(46) == -1;
        }
        return false;
    }

    private static Rdn _getCommonNameRdn(String rfc2253name) {
        LdapName ldapDN;
        try {
            ldapDN = new LdapName(rfc2253name);
        }
        catch (InvalidNameException e) {
            return null;
        }
        for (Rdn rdn : ldapDN.getRdns()) {
            if (rdn == null || !rdn.getType().equalsIgnoreCase("CN") || !(rdn.getValue() instanceof String)) continue;
            return rdn;
        }
        return null;
    }

    private static boolean _looksLikeCommonName(String name) {
        return name != null && name.matches("^CN\\s*=.*");
    }
}

