/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.util.printf;

import com.sap.dbtech.util.MessageTranslator;
import com.sap.dbtech.util.printf.DataFormatter;
import com.sap.dbtech.util.printf.FormatException;
import com.sap.dbtech.util.printf.PrintfArgumentMismatch;

class IntegerFormatter
extends DataFormatter {
    protected int radix;

    protected IntegerFormatter(String format) throws FormatException {
        super(format);
        switch (this.kind) {
            case 'o': {
                this.radix = 8;
                break;
            }
            case 'x': {
                this.radix = 16;
                break;
            }
            default: {
                this.radix = 10;
            }
        }
    }

    protected String formatObject(Object obj, int kind, int width, int precision, boolean alignRight, char padChar) throws PrintfArgumentMismatch {
        Number number;
        try {
            number = (Number)obj;
        }
        catch (ClassCastException exc) {
            throw new PrintfArgumentMismatch(MessageTranslator.translate("error.format.notanumber", obj.toString()));
        }
        if (!alignRight) {
            padChar = (char)32;
        }
        long longVal = number.longValue();
        String stringVal = Long.toString(longVal, this.radix);
        return this.formatString(stringVal, kind, width, precision, alignRight, padChar);
    }
}

