/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.util;

import com.sap.dbtech.util.printf.PrintfException;
import com.sap.dbtech.util.printf.PrintfFormat;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class StringUtil {
    public static final char[] hexDigits_C = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static byte[] bytes_iso8859_1(String str) {
        char[] ca = str.toCharArray();
        int strlen = ca.length;
        byte[] r = new byte[strlen];
        for (int i = 0; i < strlen; ++i) {
            char c = ca[i];
            r[i] = c <= '\u00ff' ? (int)c : 63;
        }
        return r;
    }

    public static boolean isIso8859_1(String str) {
        int strlen = str.length();
        for (int i = 0; i < strlen; ++i) {
            char c = str.charAt(i);
            if (c <= '\u00ff') continue;
            return false;
        }
        return true;
    }

    public static byte[] bytes_ascii7bit(String str) {
        char[] ca = str.toCharArray();
        int strlen = ca.length;
        byte[] r = new byte[strlen];
        for (int i = 0; i < strlen; ++i) {
            char c = ca[i];
            r[i] = c <= '\u007f' ? (int)c : 63;
        }
        return r;
    }

    public static String[] breakCommandLine(String source) {
        String newval;
        Vector<String> tmpvec = new Vector<String>(10);
        int endPos = source.length();
        char[] chars = source.toCharArray();
        char quoteChar = '\u0000';
        boolean inWS_C = false;
        boolean inWord_C = true;
        int state = 0;
        boolean inQuote = false;
        int wordLen = 0;
        char[] word = new char[chars.length];
        block8: for (int pos = 0; pos < endPos; ++pos) {
            char current = chars[pos];
            if (Character.isWhitespace(current)) {
                switch (state) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        if (inQuote) {
                            word[wordLen] = current;
                            ++wordLen;
                            break;
                        }
                        newval = String.copyValueOf(word, 0, wordLen);
                        tmpvec.addElement(newval);
                        wordLen = 0;
                    }
                }
                continue;
            }
            switch (current) {
                case '\"': 
                case '\'': {
                    if (inQuote) {
                        if (quoteChar == current) {
                            inQuote = false;
                            continue block8;
                        }
                        word[wordLen] = current;
                        ++wordLen;
                        continue block8;
                    }
                    inQuote = true;
                    quoteChar = current;
                    state = 1;
                    continue block8;
                }
                case '\\': {
                    word[wordLen] = current = chars[++pos];
                    ++wordLen;
                    state = 1;
                    continue block8;
                }
                default: {
                    word[wordLen] = current;
                    ++wordLen;
                    state = 1;
                }
            }
        }
        if (state == 1) {
            newval = String.copyValueOf(word, 0, wordLen);
            tmpvec.addElement(newval);
        }
        String[] result = new String[tmpvec.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (String)tmpvec.elementAt(i);
        }
        return result;
    }

    public static void fprintfs(PrintStream stream, String format, Object[] objects) {
        stream.print(StringUtil.sprintfs(format, objects));
    }

    public static void fprintfs(PrintWriter stream, String format, Object[] objects) {
        stream.print(StringUtil.sprintfs(format, objects));
    }

    public static String hexDump(byte[] buf) {
        return StringUtil.hexDump(buf, 0, buf.length, 0);
    }

    public static String hexDump(byte[] buf, int from, int to) {
        return StringUtil.hexDump(buf, from, to, 0);
    }

    public static String hexDump(byte[] buf, int from, int to, int logicalPos) {
        int i;
        StringBuffer result = new StringBuffer();
        int chunkSize_C = 16;
        int posExtent_C = 4;
        int hexStart_C = 7;
        int clearStart_C = 59;
        int lineLen_C = 78;
        StringBuffer line = new StringBuffer(78);
        for (i = 0; i < 4; ++i) {
            line.append('0');
        }
        for (i = 4; i < 78; ++i) {
            line.append(' ');
        }
        line.append('\n');
        while (from < to) {
            int virtualFrom = from - from % 16;
            int nextBreak = virtualFrom + 16;
            if (nextBreak > to) {
                nextBreak = to;
            }
            int bufPos = from + logicalPos;
            int digitPos = 3;
            while (bufPos > 0) {
                line.setCharAt(digitPos, hexDigits_C[bufPos % 16]);
                bufPos /= 16;
                --digitPos;
            }
            line.setCharAt(58, ' ');
            line.setCharAt(58 + from - virtualFrom, '\'');
            for (i = from - virtualFrom; i < nextBreak - virtualFrom; ++i) {
                byte b = buf[i + virtualFrom];
                char ch = b >= 0 ? (char)b : (char)(256 + b);
                line.setCharAt(7 + i * 3 + 1, hexDigits_C[ch / 16]);
                line.setCharAt(7 + i * 3 + 2, hexDigits_C[ch % 16]);
                if (ch < ' ') {
                    ch = '.';
                }
                line.setCharAt(59 + i, ch);
            }
            line.setCharAt(59 + nextBreak - virtualFrom, '\'');
            for (i = to - virtualFrom; i < 16; ++i) {
                line.setCharAt(7 + i * 3 + 1, ' ');
                line.setCharAt(7 + i * 3 + 2, ' ');
                line.setCharAt(59 + i + 1, ' ');
            }
            result.append(line.toString());
            from = nextBreak;
        }
        return result.toString();
    }

    public static String join(Enumeration enume) {
        return StringUtil.join(enume, " ");
    }

    public static String join(Enumeration enume, String delimiter) {
        StringBuffer buf = new StringBuffer();
        if (enume.hasMoreElements()) {
            buf.append(enume.nextElement());
        }
        while (enume.hasMoreElements()) {
            buf.append(delimiter);
            buf.append(enume.nextElement());
        }
        return buf.toString();
    }

    public static String padLeft(String str, int len) {
        return StringUtil.padLeft(str, len, ' ');
    }

    public static String padLeft(String str, int len, char ch) {
        int strlen = str.length();
        if (len <= strlen) {
            return str;
        }
        StringBuffer buf = new StringBuffer(len);
        for (int i = strlen; i < len; ++i) {
            buf.append(ch);
        }
        buf.append(str);
        return buf.toString();
    }

    public static String padRight(String str, int len) {
        return StringUtil.padRight(str, len, ' ');
    }

    public static String padRight(String str, int len, char ch) {
        int strlen = str.length();
        if (len <= strlen) {
            return str;
        }
        StringBuffer buf = new StringBuffer(len);
        buf.append(str);
        for (int i = strlen; i < len; ++i) {
            buf.append(ch);
        }
        return buf.toString();
    }

    public static String repeat(String s, int count) {
        StringBuffer buf = new StringBuffer(count * s.length());
        for (int i = 0; i < count; ++i) {
            buf.append(s);
        }
        return buf.toString();
    }

    public static String replace(String source, String oldPart, String newPart) {
        int startPos = 0;
        int foundPos = 0;
        foundPos = source.indexOf(oldPart, startPos);
        if (foundPos == -1) {
            return source;
        }
        StringBuffer result = new StringBuffer();
        int oldLen = oldPart.length();
        while (foundPos != -1) {
            result.append(source.substring(startPos, foundPos));
            result.append(newPart);
            startPos = foundPos + oldLen;
            foundPos = source.indexOf(oldPart, startPos);
        }
        result.append(source.substring(startPos, source.length()));
        return result.toString();
    }

    public static String[] split(String source, String delimiter) {
        String newval;
        Vector<String> tmpvec = new Vector<String>(10);
        int delimLen = delimiter.length();
        int lastPos = 0;
        int pos = 0;
        pos = source.indexOf(delimiter, lastPos);
        while (pos != -1) {
            newval = source.substring(lastPos, pos);
            tmpvec.addElement(newval);
            lastPos = pos + delimLen;
            pos = source.indexOf(delimiter, lastPos);
        }
        newval = source.substring(lastPos);
        tmpvec.addElement(newval);
        String[] result = new String[tmpvec.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (String)tmpvec.elementAt(i);
        }
        return result;
    }

    public static String[] splitOnSpace(String source) {
        Vector<String> tmpvec = new Vector<String>(10);
        int lastPos = 0;
        int pos = 0;
        int endPos = source.length();
        char[] chars = source.toCharArray();
        while (pos < endPos) {
            char current;
            boolean inWhiteSpace = true;
            block7: while (lastPos < endPos && inWhiteSpace) {
                current = chars[lastPos];
                switch (current) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        ++lastPos;
                        continue block7;
                    }
                }
                inWhiteSpace = false;
            }
            pos = lastPos;
            if (pos >= endPos) continue;
            inWhiteSpace = false;
            block8: while (pos < endPos && !inWhiteSpace) {
                current = chars[lastPos];
                switch (current) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        inWhiteSpace = true;
                        continue block8;
                    }
                }
                ++pos;
            }
            String newval = String.copyValueOf(chars, lastPos, pos - lastPos);
            tmpvec.addElement(newval);
            lastPos = pos;
        }
        String[] result = new String[tmpvec.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (String)tmpvec.elementAt(i);
        }
        return result;
    }

    public static String[] splitOnSpaceIsWhiteSpace(String source) {
        Vector<String> tmpvec = new Vector<String>(10);
        int lastPos = 0;
        int pos = 0;
        int endPos = source.length();
        char[] chars = source.toCharArray();
        while (pos < endPos) {
            while (lastPos < endPos && Character.isWhitespace(chars[lastPos])) {
                ++lastPos;
            }
            pos = lastPos;
            if (pos >= endPos) continue;
            while (pos < endPos && !Character.isWhitespace(chars[pos])) {
                ++pos;
            }
            String newval = String.copyValueOf(chars, lastPos, pos - lastPos);
            tmpvec.addElement(newval);
            lastPos = pos;
        }
        String[] result = new String[tmpvec.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (String)tmpvec.elementAt(i);
        }
        return result;
    }

    public static String[] splitOnSpaceRaw(String source) {
        Vector<String> tmpvec = new Vector<String>(10);
        int lastPos = 0;
        int pos = 0;
        int endPos = source.length();
        char[] chars = source.toCharArray();
        while (pos < endPos) {
            char current;
            boolean inWhiteSpace = true;
            block7: while (lastPos < endPos && inWhiteSpace) {
                current = chars[lastPos];
                switch (current) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        ++lastPos;
                        continue block7;
                    }
                }
                inWhiteSpace = false;
            }
            pos = lastPos;
            if (pos >= endPos) continue;
            inWhiteSpace = false;
            block8: while (pos < endPos && !inWhiteSpace) {
                current = chars[lastPos];
                switch (current) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        inWhiteSpace = true;
                        continue block8;
                    }
                }
                ++pos;
            }
            String newval = String.copyValueOf(chars, lastPos, pos - lastPos);
            tmpvec.addElement(newval);
            lastPos = pos;
        }
        String[] result = new String[tmpvec.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (String)tmpvec.elementAt(i);
        }
        return result;
    }

    public static String[] splitOnSpaceStringTokenizer(String source) {
        Vector<String> tmpvec = new Vector<String>(10);
        StringTokenizer tokenizer = new StringTokenizer(source);
        while (tokenizer.hasMoreTokens()) {
            tmpvec.addElement(tokenizer.nextToken());
        }
        String[] result = new String[tmpvec.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (String)tmpvec.elementAt(i);
        }
        return result;
    }

    public static String sprintf(String format, Object[] objects) throws PrintfException {
        PrintfFormat formatter = new PrintfFormat(format);
        String result = formatter.format(objects);
        return result;
    }

    public static String sprintfs(String format, Object[] objects) {
        try {
            return StringUtil.sprintf(format, objects);
        }
        catch (PrintfException exc) {
            return "<PrintfError: " + exc.getMessage() + " >";
        }
    }

    public static String substring(String str, int from, int to) {
        int strlen = str.length();
        if (from < 0) {
            from = strlen - from;
        }
        if (from < 0) {
            from = 0;
        }
        if (to < 0) {
            to = strlen - to;
        }
        if (to > strlen) {
            to = strlen;
        }
        String result = from > strlen || to < 0 ? "" : str.substring(from, to);
        return result;
    }

    public static String trimLeft(String fullString) {
        int l = fullString.length();
        for (int i = l - 1; i >= 0; --i) {
            if (fullString.charAt(i) == ' ') continue;
            if (i == l - 1) {
                return fullString;
            }
            return new String(fullString.substring(0, i + 1));
        }
        return "";
    }

    public static String formatMilliSeconds(Timestamp d) {
        long fractional = d.getNanos() / 10000;
        String s = Long.toString(fractional);
        return "00000".substring(0, 5 - s.length()) + s;
    }
}

