/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.translators.StructureTranslator;
import com.sap.dbtech.util.StructuredBytes;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLOutput;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;

public class StructureSQLOutput
implements SQLOutput {
    private StructuredBytes data;
    private StructureTranslator translator;
    private int fieldIndex;

    public StructureSQLOutput(StructureTranslator translator) {
        this.translator = translator;
        this.data = new StructuredBytes(translator.logicalLength);
        this.fieldIndex = -1;
    }

    public boolean isDataComplete() {
        return this.fieldIndex == this.translator.parameterStructure.getMemberCount();
    }

    public byte[] getData() throws SQLException {
        if (!this.isDataComplete()) {
            throw SQLExceptionSapDB.generateSQLException("error.structure.incomplete");
        }
        return this.data.bytes();
    }

    private void checkDataComplete() throws SQLException {
        if (this.isDataComplete()) {
            throw SQLExceptionSapDB.generateSQLException("error.structure.complete");
        }
    }

    public void writeByte(byte b) throws SQLException {
        try {
            ++this.fieldIndex;
            this.checkDataComplete();
        }
        catch (SQLException sqlEx) {
            --this.fieldIndex;
            throw sqlEx;
        }
    }

    public void writeDouble(double arg0) throws SQLException {
    }

    public void writeFloat(float arg0) throws SQLException {
    }

    public void writeInt(int arg0) throws SQLException {
    }

    public void writeLong(long arg0) throws SQLException {
    }

    public void writeShort(short arg0) throws SQLException {
    }

    public void writeBoolean(boolean arg0) throws SQLException {
    }

    public void writeBytes(byte[] arg0) throws SQLException {
    }

    public void writeAsciiStream(InputStream arg0) throws SQLException {
    }

    public void writeBinaryStream(InputStream arg0) throws SQLException {
    }

    public void writeCharacterStream(Reader arg0) throws SQLException {
    }

    public void writeString(String arg0) throws SQLException {
    }

    public void writeBigDecimal(BigDecimal arg0) throws SQLException {
    }

    public void writeURL(URL arg0) throws SQLException {
    }

    public void writeArray(Array arg0) throws SQLException {
    }

    public void writeBlob(Blob arg0) throws SQLException {
    }

    public void writeClob(Clob arg0) throws SQLException {
    }

    public void writeDate(Date arg0) throws SQLException {
    }

    public void writeRef(Ref arg0) throws SQLException {
    }

    public void writeObject(SQLData arg0) throws SQLException {
    }

    public void writeStruct(Struct arg0) throws SQLException {
    }

    public void writeTime(Time arg0) throws SQLException {
    }

    public void writeTimestamp(Timestamp arg0) throws SQLException {
    }

    public void writeNClob(NClob x) throws SQLException {
    }

    public void writeNString(String x) throws SQLException {
    }

    public void writeRowId(RowId x) throws SQLException {
    }

    public void writeSQLXML(SQLXML x) throws SQLException {
    }
}

