/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.DBProcParameterInfo;
import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.translators.AbstractABAPStreamGetval;
import com.sap.dbtech.util.StringUtil;
import com.sap.dbtech.util.StructuredBytes;
import com.sap.dbtech.util.StructuredMem;
import java.sql.SQLException;

public abstract class StructMemberTranslator {
    protected DBProcParameterInfo.StructureElement structureElement;
    protected int index;
    protected int offset;

    public StructMemberTranslator(DBProcParameterInfo.StructureElement structureElement, int index, boolean unicode) {
        this.structureElement = structureElement;
        this.index = index;
        this.offset = unicode ? structureElement.unicodeOffset : structureElement.asciiOffset;
    }

    public abstract Object getObject(StructuredMem var1, int var2);

    public abstract void putObject(StructuredMem var1, Object var2) throws SQLException;

    public abstract void addOutStreamDescriptor(AbstractABAPStreamGetval var1) throws SQLException;

    protected void throwConversionError(String sourceObject) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.structure.element.conversion", this.structureElement.getSQLTypeName(), sourceObject);
    }

    public static StructMemberTranslator createStructMemberTranslator(DBProcParameterInfo paramInfo, int index, boolean unicode) throws SQLException {
        DBProcParameterInfo.StructureElement s = paramInfo.getMember(index);
        if (s.typeName.equals("CHAR")) {
            if (s.codeType.equals("BYTE")) {
                return new ByteStructureElementTranslator(s, index, unicode);
            }
            if (s.codeType.equals("ASCII")) {
                return new CharAsciiStructureElementTranslator(s, index, unicode);
            }
        } else {
            if (s.typeName.equals("WYDE")) {
                if (unicode) {
                    return new WydeStructureElementTranslator(s, index, unicode);
                }
                return new CharAsciiStructureElementTranslator(s, index, unicode);
            }
            if (s.typeName.equals("SMALLINT")) {
                if (s.length == 5) {
                    return new ShortStructureElementTranslator(s, index, unicode);
                }
            } else if (s.typeName.equals("INTEGER")) {
                if (s.length == 10) {
                    return new IntStructureElementTranslator(s, index, unicode);
                }
                if (s.length == 19) {
                    return new LongStructureElementTranslator(s, index, unicode);
                }
            } else if (s.typeName.equals("FIXED")) {
                if (s.precision == 0) {
                    if (s.length == 5) {
                        return new ShortStructureElementTranslator(s, index, unicode);
                    }
                    if (s.length == 10) {
                        return new IntStructureElementTranslator(s, index, unicode);
                    }
                    if (s.length == 19) {
                        return new LongStructureElementTranslator(s, index, unicode);
                    }
                }
            } else if (s.typeName.equals("FLOAT")) {
                if (s.length == 15) {
                    return new DoubleStructureElementTranslator(s, index, unicode);
                }
                if (s.length == 6) {
                    return new FloatStructureElementTranslator(s, index, unicode);
                }
            } else if (s.typeName.equals("BOOLEAN")) {
                return new BooleanStructureElementTranslator(s, index, unicode);
            }
        }
        throw SQLExceptionSapDB.generateSQLException("error.conversion.structuretype", new Integer(index), s.getSQLTypeName());
    }

    public static StructMemberTranslator[] createStructMemberTranslators(DBProcParameterInfo info, boolean unicode) throws SQLException {
        StructMemberTranslator[] result = new StructMemberTranslator[info.getMemberCount()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = StructMemberTranslator.createStructMemberTranslator(info, i, unicode);
        }
        return result;
    }

    static class BooleanStructureElementTranslator
    extends StructMemberTranslator {
        public BooleanStructureElementTranslator(DBProcParameterInfo.StructureElement structureElement, int index, boolean unicode) {
            super(structureElement, index, unicode);
        }

        public Object getObject(StructuredMem memory, int recordOffset) {
            byte b = memory.getInt1(this.offset + recordOffset);
            if (b == 0) {
                return new Boolean(false);
            }
            return new Boolean(true);
        }

        public void putObject(StructuredMem memory, Object o) throws SQLException {
            if (o instanceof Boolean) {
                boolean bval = (Boolean)o;
                if (bval) {
                    memory.putInt1(1, this.offset);
                } else {
                    memory.putInt1(0, this.offset);
                }
            } else {
                this.throwConversionError(o.getClass().getName());
            }
        }

        public void addOutStreamDescriptor(AbstractABAPStreamGetval getval) throws SQLException {
            getval.addColumn(1, 1, 1, 0, 1, this.offset);
        }
    }

    static class FloatStructureElementTranslator
    extends StructMemberTranslator {
        public FloatStructureElementTranslator(DBProcParameterInfo.StructureElement structureElement, int index, boolean unicode) {
            super(structureElement, index, unicode);
        }

        public Object getObject(StructuredMem memory, int recordOffset) {
            int val = memory.getInt4(this.offset);
            return new Float(Float.intBitsToFloat(val));
        }

        public void putObject(StructuredMem memory, Object o) throws SQLException {
            if (o instanceof Float) {
                float fval = ((Float)o).floatValue();
                int ival = Float.floatToIntBits(fval);
                memory.putInt4(ival, this.offset);
            } else if (o instanceof Number) {
                double dval = ((Number)o).doubleValue();
                if (dval > 3.4028234663852886E38 || dval < (double)1.4E-45f) {
                    throw SQLExceptionSapDB.generateSQLException("error.structure.element.overflow", this.structureElement.getSQLTypeName(), o.toString());
                }
                float fval = ((Number)o).floatValue();
                int ival = Float.floatToIntBits(fval);
                memory.putInt4(ival, this.offset);
            } else {
                this.throwConversionError(o.getClass().getName());
            }
        }

        public void addOutStreamDescriptor(AbstractABAPStreamGetval getval) throws SQLException {
            getval.addColumn(1, 9, 4, 0, 1, this.offset);
        }
    }

    static class DoubleStructureElementTranslator
    extends StructMemberTranslator {
        public DoubleStructureElementTranslator(DBProcParameterInfo.StructureElement structureElement, int index, boolean unicode) {
            super(structureElement, index, unicode);
        }

        public Object getObject(StructuredMem memory, int recordOffset) {
            long val = memory.getInt8(this.offset + recordOffset);
            return new Double(Double.longBitsToDouble(val));
        }

        public void putObject(StructuredMem memory, Object o) throws SQLException {
            if (o instanceof Number) {
                double dval = ((Number)o).doubleValue();
                long lval = Double.doubleToLongBits(dval);
                memory.putInt8(lval, this.offset);
            } else {
                this.throwConversionError(o.getClass().getName());
            }
        }

        public void addOutStreamDescriptor(AbstractABAPStreamGetval getval) throws SQLException {
            getval.addColumn(1, 10, 8, 0, 1, this.offset);
        }
    }

    static class LongStructureElementTranslator
    extends StructMemberTranslator {
        public LongStructureElementTranslator(DBProcParameterInfo.StructureElement structureElement, int index, boolean unicode) {
            super(structureElement, index, unicode);
        }

        public Object getObject(StructuredMem memory, int recordOffset) {
            long val = memory.getInt8(this.offset + recordOffset);
            return new Long(val);
        }

        public void putObject(StructuredMem memory, Object o) throws SQLException {
            if (o instanceof Long) {
                long lval = (Long)o;
                memory.putInt8(lval, this.offset);
            } else if (o instanceof Number) {
                double dval = ((Number)o).doubleValue();
                if (dval > 9.223372036854776E18 || dval < -9.223372036854776E18) {
                    throw SQLExceptionSapDB.generateSQLException("error.structure.element.overflow", this.structureElement.getSQLTypeName(), o.toString());
                }
                long lval = ((Number)o).longValue();
                memory.putInt8(lval, this.offset);
            } else {
                this.throwConversionError(o.getClass().getName());
            }
        }

        public void addOutStreamDescriptor(AbstractABAPStreamGetval getval) throws SQLException {
            getval.addColumn(1, 7, 8, 0, 1, this.offset);
        }
    }

    static class IntStructureElementTranslator
    extends StructMemberTranslator {
        public IntStructureElementTranslator(DBProcParameterInfo.StructureElement structureElement, int index, boolean unicode) {
            super(structureElement, index, unicode);
        }

        public Object getObject(StructuredMem memory, int recordOffset) {
            int val = memory.getInt4(this.offset + recordOffset);
            return new Integer(val);
        }

        public void putObject(StructuredMem memory, Object o) throws SQLException {
            if (o instanceof Integer) {
                int ival = (Integer)o;
                memory.putInt4(ival, this.offset);
            } else if (o instanceof Number) {
                double dval = ((Number)o).doubleValue();
                if (dval > 2.147483647E9 || dval < -2.147483648E9) {
                    throw SQLExceptionSapDB.generateSQLException("error.structure.element.overflow", this.structureElement.getSQLTypeName(), o.toString());
                }
                int ival = ((Number)o).intValue();
                memory.putInt4(ival, this.offset);
            } else {
                this.throwConversionError(o.getClass().getName());
            }
        }

        public void addOutStreamDescriptor(AbstractABAPStreamGetval getval) throws SQLException {
            getval.addColumn(1, 5, 4, 0, 1, this.offset);
        }
    }

    static class ShortStructureElementTranslator
    extends StructMemberTranslator {
        public ShortStructureElementTranslator(DBProcParameterInfo.StructureElement structureElement, int index, boolean unicode) {
            super(structureElement, index, unicode);
        }

        public Object getObject(StructuredMem memory, int recordOffset) {
            int shortval = memory.getInt2(this.offset + recordOffset);
            return new Short((short)shortval);
        }

        public void putObject(StructuredMem memory, Object o) throws SQLException {
            if (o instanceof Short) {
                short sval = (Short)o;
                memory.putInt2(sval, this.offset);
            } else if (o instanceof Number) {
                double dval = ((Number)o).doubleValue();
                if (dval > 32767.0 || dval < -32768.0) {
                    throw SQLExceptionSapDB.generateSQLException("error.structure.element.overflow", this.structureElement.getSQLTypeName(), o.toString());
                }
                short sval = ((Number)o).shortValue();
                memory.putInt2(sval, this.offset);
            } else {
                this.throwConversionError(o.getClass().getName());
            }
        }

        public void addOutStreamDescriptor(AbstractABAPStreamGetval getval) throws SQLException {
            getval.addColumn(1, 3, 2, 0, 1, this.offset);
        }
    }

    static class WydeStructureElementTranslator
    extends StructMemberTranslator {
        public WydeStructureElementTranslator(DBProcParameterInfo.StructureElement structureElement, int index, boolean unicode) {
            super(structureElement, index, unicode);
        }

        public Object getObject(StructuredMem memory, int recordOffset) {
            char[] ca = memory.getBigUnicode(this.offset + recordOffset, this.structureElement.length * 2);
            if (this.structureElement.length == 1) {
                return new Character(ca[0]);
            }
            return new String(ca);
        }

        public void putObject(StructuredMem memory, Object o) throws SQLException {
            String convStr = null;
            if (o instanceof char[]) {
                convStr = new String((char[])o);
            } else if (o instanceof String) {
                convStr = (String)o;
            } else if (o instanceof Character) {
                char[] ca = new char[]{((Character)o).charValue()};
                convStr = new String(ca);
            } else {
                this.throwConversionError(o.getClass().getName());
            }
            memory.putBigUnicode(convStr.toCharArray(), this.offset, this.structureElement.length * 2);
        }

        public void addOutStreamDescriptor(AbstractABAPStreamGetval getval) throws SQLException {
            getval.addColumn(1, 17, this.structureElement.length * 2, 0, this.structureElement.length, this.offset);
        }
    }

    static class CharAsciiStructureElementTranslator
    extends StructMemberTranslator {
        public CharAsciiStructureElementTranslator(DBProcParameterInfo.StructureElement structureElement, int index, boolean unicode) {
            super(structureElement, index, unicode);
        }

        public Object getObject(StructuredMem memory, int recordOffset) {
            byte[] bytes = memory.getBytes(this.offset + recordOffset, this.structureElement.length);
            if (this.structureElement.length == 1) {
                return new Character((char)bytes[0]);
            }
            return new String(bytes);
        }

        public void putObject(StructuredMem memory, Object o) throws SQLException {
            String convStr = null;
            if (o instanceof char[]) {
                convStr = new String((char[])o);
            } else if (o instanceof String) {
                convStr = (String)o;
            } else if (o instanceof Character) {
                char[] ca = new char[]{((Character)o).charValue()};
                convStr = new String(ca);
            } else {
                this.throwConversionError(o.getClass().getName());
            }
            byte[] bytes = StringUtil.bytes_ascii7bit(convStr);
            memory.putStringBytes(bytes, this.offset, this.structureElement.length);
        }

        public void addOutStreamDescriptor(AbstractABAPStreamGetval getval) throws SQLException {
            getval.addColumn(1, 14, this.structureElement.length, 0, this.structureElement.length, this.offset);
        }
    }

    static class ByteStructureElementTranslator
    extends StructMemberTranslator {
        public ByteStructureElementTranslator(DBProcParameterInfo.StructureElement structureElement, int index, boolean unicode) {
            super(structureElement, index, unicode);
        }

        public Object getObject(StructuredMem memory, int recordOffset) {
            byte[] bytes = memory.getBytes(this.offset + recordOffset, this.structureElement.length);
            StructuredBytes bb = new StructuredBytes(bytes);
            bb.traceOn(System.err);
            if (this.structureElement.length == 1) {
                return new Byte(bytes[0]);
            }
            return bytes;
        }

        public void putObject(StructuredMem memory, Object o) throws SQLException {
            if (o instanceof byte[]) {
                byte[] ba = (byte[])o;
                memory.putBytes(ba, this.offset);
            } else if (o instanceof Byte) {
                byte[] ba = new byte[]{(Byte)o};
            } else {
                this.throwConversionError(o.getClass().getName());
            }
        }

        public void addOutStreamDescriptor(AbstractABAPStreamGetval getval) throws SQLException {
            getval.addColumn(1, 14, this.structureElement.length, 0, this.structureElement.length, this.offset);
        }
    }
}

