/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.packet.DataPart;
import com.sap.dbtech.jdbc.translators.SQLParamController;
import com.sap.dbtech.jdbc.translators.TimeTranslator;
import java.sql.SQLException;

public class InternalTimeTranslator
extends TimeTranslator {
    public InternalTimeTranslator(int mode, int ioType, int dataType, int len, int ioLen, int bufpos_in, int bufpos_out, boolean readOnly, boolean autoIncr) {
        super(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncr);
    }

    protected int parseHours(byte[] raw) throws SQLException {
        int hours = (raw[0] - 48) * 1000;
        hours += (raw[1] - 48) * 100;
        hours += (raw[2] - 48) * 10;
        hours += raw[3] - 48;
        return hours %= 24;
    }

    protected int parseMinutes(byte[] raw) {
        return (raw[4] - 48) * 10 + (raw[5] - 48);
    }

    protected int parseSeconds(byte[] raw) {
        return (raw[6] - 48) * 10 + (raw[7] - 48);
    }

    protected byte[] formatTime(int hours, int minutes, int seconds) {
        byte[] formattedTime = new byte[]{48, 48, HighTime_C[hours], LowTime_C[hours], (byte)(48 + minutes / 10), (byte)(48 + minutes % 10), (byte)(48 + seconds / 10), (byte)(48 + seconds % 10)};
        return formattedTime;
    }

    public String getString(SQLParamController controller, DataPart mem) throws SQLException {
        String result = null;
        if (!this.isNull(controller, mem)) {
            byte[] raw = mem.getBytes(this.bufpos_output, this.physicalLength - 1);
            int hours = (raw[0] - 48) * 1000;
            hours += (raw[1] - 48) * 100;
            hours += (raw[2] - 48) * 10;
            hours += raw[3] - 48;
            raw[0] = HighTime_C[hours %= 24];
            raw[1] = LowTime_C[hours];
            raw[2] = 58;
            raw[3] = raw[4];
            raw[4] = raw[5];
            raw[5] = 58;
            raw[6] = raw[6];
            raw[7] = raw[7];
            result = new String(raw);
        }
        return result;
    }
}

