/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.packet.ReplyPacket;
import com.sap.dbtech.jdbc.translators.ABAPStreamDescriptor;
import com.sap.dbtech.jdbc.translators.ABAPStreamTranslator;
import com.sap.dbtech.util.StructuredBytes;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Vector;

public abstract class AbstractABAPStreamGetval
extends ABAPStreamDescriptor {
    private Vector replyBuffers = new Vector();
    protected int elementCount = 0;
    protected StructuredBytes data;

    public AbstractABAPStreamGetval(ABAPStreamTranslator translator) {
        super(translator);
    }

    public boolean addReplyData(ReplyPacket replyPacket) throws SQLException {
        if (replyPacket.findPart(5) == -1) {
            throw SQLExceptionSapDB.generateSQLException("error.stream.nodata");
        }
        int partArguments = replyPacket.partArguments();
        if (partArguments < 0) {
            int remainder = partArguments & Short.MAX_VALUE;
            partArguments = remainder += 32768;
        }
        this.elementCount += partArguments;
        if (partArguments != 0) {
            this.replyBuffers.add(replyPacket.getBytes(replyPacket.getPartDataPos(), replyPacket.partLength()));
        }
        return partArguments == 0;
    }

    public void coalesceReply() {
        int replySize = 0;
        for (int i = 0; i < this.replyBuffers.size(); ++i) {
            replySize += ((byte[])this.replyBuffers.elementAt(i)).length;
        }
        this.data = new StructuredBytes(replySize);
        int currentStart = 0;
        for (int i = 0; i < this.replyBuffers.size(); ++i) {
            byte[] currentBuffer = (byte[])this.replyBuffers.elementAt(i);
            System.arraycopy(currentBuffer, 0, this.data.bytes(), currentStart, currentBuffer.length);
            currentStart += currentBuffer.length;
        }
        this.replyBuffers = null;
    }

    public int getColIndex() {
        return this.translator.getColIndex();
    }

    public void throwIllegalConversion(String javatype) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.conversion.sqljava", this.translator.getColumnTypeName(), javatype);
    }

    public String getString() throws SQLException {
        this.throwIllegalConversion(String.class.getName());
        return null;
    }

    public InputStream getAsciiStream() throws SQLException {
        this.throwIllegalConversion(InputStream.class.getName());
        return null;
    }

    public BigDecimal getBigDecimal(int scale) throws SQLException {
        this.throwIllegalConversion(BigDecimal.class.getName());
        return null;
    }

    public BigDecimal getBigDecimal() throws SQLException {
        this.throwIllegalConversion(BigDecimal.class.getName());
        return null;
    }

    public InputStream getBinaryStream() throws SQLException {
        this.throwIllegalConversion(InputStream.class.getName());
        return null;
    }

    public Blob getBlob() throws SQLException {
        this.throwIllegalConversion(Blob.class.getName());
        return null;
    }

    public boolean getBoolean() throws SQLException {
        this.throwIllegalConversion("boolean");
        return false;
    }

    public byte getByte() throws SQLException {
        this.throwIllegalConversion("byte");
        return 0;
    }

    public byte[] getBytes() throws SQLException {
        this.throwIllegalConversion("byte[]");
        return null;
    }

    public Date getDate(Calendar cal) throws SQLException {
        this.throwIllegalConversion(Date.class.getName());
        return null;
    }

    public double getDouble() throws SQLException {
        this.throwIllegalConversion("double");
        return 0.0;
    }

    public Reader getCharacterStream() throws SQLException {
        this.throwIllegalConversion(Reader.class.getName());
        return null;
    }

    public Clob getClob() throws SQLException {
        this.throwIllegalConversion(Clob.class.getName());
        return null;
    }

    public float getFloat() throws SQLException {
        this.throwIllegalConversion("float");
        return 0.0f;
    }

    public int getInt() throws SQLException {
        this.throwIllegalConversion("int");
        return 0;
    }

    public long getLong() throws SQLException {
        this.throwIllegalConversion("long");
        return 0L;
    }

    public Object getObject() throws SQLException {
        this.throwIllegalConversion(Object.class.getName());
        return null;
    }

    public Time getTime(Calendar cal) throws SQLException {
        this.throwIllegalConversion(Time.class.getName());
        return null;
    }

    public Timestamp getTimestamp(Calendar cal) throws SQLException {
        this.throwIllegalConversion(Timestamp.class.getName());
        return null;
    }
}

