/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc;

import com.sap.dbtech.jdbc.ColumnInfo;
import com.sap.dbtech.jdbc.ConnectionItem;
import com.sap.dbtech.jdbc.ConnectionSapDB;
import com.sap.dbtech.jdbc.FetchChunk;
import com.sap.dbtech.jdbc.FetchInfo;
import com.sap.dbtech.jdbc.ResultSetMetaDataSapDB;
import com.sap.dbtech.jdbc.StatementSapDB;
import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.packet.DataPart;
import com.sap.dbtech.jdbc.packet.ReplyPacket;
import com.sap.dbtech.jdbc.translators.AbstractABAPStreamGetval;
import com.sap.dbtech.jdbc.translators.DBTechTranslator;
import com.sap.dbtech.jdbc.translators.SQLParamController;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;

public class ResultSetSapDB
extends ConnectionItem
implements ResultSet,
SQLParamController {
    public static final int DEFAULT_FETCHSIZE = 30000;
    protected static final int POSITION_BEFORE_FIRST = 1;
    protected static final int POSITION_INSIDE = 2;
    protected static final int POSITION_AFTER_LAST = 3;
    protected static final int POSITION_NOT_AVAILABLE = 4;
    protected FetchInfo fetchInfo;
    private StatementSapDB statement;
    private int fetchSize;
    private int maxRows;
    private FetchChunk currentChunk;
    protected int positionState;
    private int positionStateOfChunk;
    private boolean fromMetaData;
    private boolean lastWasNull;
    private boolean isClosed;
    private boolean empty;
    private int fetchDirection;
    private Vector openStreams;
    private int rowsInResultSet;
    private int safeFetchSize;
    private boolean safeFetchSizeDetermined;
    private int largestKnownAbsPos;
    private int maxRowsOutSideResult;
    protected int modifiedKernelPos;
    private int cursorType;

    ResultSetSapDB(ConnectionSapDB connection, FetchInfo fetchInfo, StatementSapDB statement, int fetchSize, int maxRows, int cursorType, ReplyPacket reply) throws SQLException {
        super(connection);
        this.fetchInfo = fetchInfo;
        this.statement = statement;
        this.fetchSize = fetchSize >= 1 ? fetchSize : 30000;
        this.maxRows = maxRows;
        this.isClosed = false;
        this.fetchDirection = 1000;
        this.initializeFields();
        this.openStreams = new Vector(5);
        this.cursorType = cursorType;
        if (reply != null) {
            this.setCurrentChunk(new FetchChunk(1, 1, reply, fetchInfo.getRecordSize(), maxRows, this.rowsInResultSet));
            this.positionState = 1;
        }
    }

    protected void initializeFields() {
        this.currentChunk = null;
        this.positionState = 1;
        this.positionStateOfChunk = 4;
        this.empty = false;
        this.safeFetchSize = 1;
        this.safeFetchSizeDetermined = false;
        this.largestKnownAbsPos = 1;
        this.maxRowsOutSideResult = 0;
        this.rowsInResultSet = -1;
        this.modifiedKernelPos = 0;
    }

    ResultSetSapDB(ConnectionSapDB connection, String cursorName, DBTechTranslator[] infos, ColumnInfo[] columnNames, StatementSapDB statement, int fetchSize, int maxRows, int cursorType, ReplyPacket reply) throws SQLException {
        this(connection, new FetchInfo(connection, cursorName, infos, columnNames, statement.isPacketEncodingUnicode()), statement, fetchSize, maxRows, cursorType, reply);
    }

    public boolean absolute(int row) throws SQLException {
        return this.absolute(row, false);
    }

    public boolean absolute(int row, boolean backward) throws SQLException {
        this.clearWarnings();
        this.assertNotClosed();
        this.assertNotForwardOnly();
        if (row == 0) {
            throw SQLExceptionSapDB.generateSQLException("error.row.isnull");
        }
        if (this.empty) {
            if (row > 0) {
                this.positionState = 3;
                return false;
            }
            this.positionState = 1;
            return false;
        }
        if (row > 0) {
            if (this.maxRowIsSet() && row > this.maxRows) {
                this.positionState = 3;
                return false;
            }
            if (this.rowsInResultSetKnown() && row > this.rowsInResultSet) {
                this.positionState = 3;
                return false;
            }
            if (this.positionStateOfChunk != 2) {
                boolean result = this.fetchAbsoluteUp(row, backward);
                if (!result) {
                    this.positionState = 3;
                }
                return result;
            }
            if (this.currentChunk.setRow(row)) {
                this.positionState = 2;
                return true;
            }
            boolean result = this.fetchAbsoluteUp(row, backward);
            if (!result) {
                this.positionState = 3;
            }
            return result;
        }
        if (this.rowsInResultSetKnown()) {
            int invertedPos = this.invertPosition(row);
            if (invertedPos <= 0) {
                this.positionState = 1;
                return false;
            }
            return this.absolute(invertedPos);
        }
        if (this.maxRowIsSet() && -row > this.maxRows) {
            this.positionState = 1;
            return false;
        }
        if (this.positionStateOfChunk != 2) {
            boolean result = this.fetchAbsoluteDown(row);
            if (!result) {
                this.positionState = 1;
            }
            return result;
        }
        if (this.currentChunk.setRow(row)) {
            this.positionState = 2;
            return true;
        }
        boolean result = this.fetchAbsoluteDown(row);
        if (!result) {
            this.positionState = 1;
        }
        return result;
    }

    public boolean next() throws SQLException {
        this.clearWarnings();
        this.assertNotClosed();
        if (this.empty) {
            this.positionState = 3;
            return false;
        }
        boolean result = false;
        this.closeOpenStreams();
        if (this.positionState == 1) {
            if (this.positionStateOfChunk == 2 && this.currentChunk.containsRow(1)) {
                this.currentChunk.setRow(1);
                this.positionState = 2;
                result = true;
            } else {
                result = this.fetchFirst();
            }
        } else if (this.positionState == 2) {
            if (this.currentChunk.move(1)) {
                result = true;
            } else {
                if (this.currentChunk.isLast()) {
                    this.positionState = 3;
                    return false;
                }
                result = this.fetchNextChunk();
            }
        } else if (this.positionState == 3) {
            // empty if block
        }
        if (result) {
            this.clearWarnings();
        }
        return result;
    }

    public boolean relative(int relativePos) throws SQLException {
        return this.relative(relativePos, true);
    }

    public boolean relative(int relativePos, boolean throwException) throws SQLException {
        this.clearWarnings();
        this.assertNotClosed();
        this.assertNotForwardOnly();
        if (this.empty) {
            if (throwException) {
                throw SQLExceptionSapDB.generateSQLException("warning.emptyresultset");
            }
            return false;
        }
        if (this.positionState != 2) {
            if (throwException) {
                if (this.positionState == 1) {
                    throw SQLExceptionSapDB.generateSQLException("error.resultset.beforefirst");
                }
                throw SQLExceptionSapDB.generateSQLException("error.resultset.afterlast");
            }
            return false;
        }
        int internal = this.getInternalRow();
        if (internal > 0) {
            if (internal + relativePos <= 0) {
                this.positionState = 1;
                return false;
            }
            return this.absolute(internal + relativePos, relativePos < 0);
        }
        if (internal + relativePos >= 0) {
            this.positionState = 3;
            return false;
        }
        return this.absolute(internal + relativePos, relativePos < 0);
    }

    public boolean previous() throws SQLException {
        this.clearWarnings();
        this.assertNotClosed();
        if (this.positionState == 3) {
            return this.absolute(-1);
        }
        return this.relative(-1, false);
    }

    public boolean first() throws SQLException {
        this.clearWarnings();
        this.assertNotClosed();
        this.assertNotForwardOnly();
        if (this.empty) {
            this.positionState = 3;
            return false;
        }
        this.closeOpenStreams();
        boolean result = false;
        if (this.positionStateOfChunk == 2 && this.currentChunk.containsRow(1)) {
            this.currentChunk.setRow(1);
            this.positionState = 2;
            result = true;
        } else {
            result = this.fetchFirst();
        }
        if (result) {
            this.clearWarnings();
        }
        return result;
    }

    public boolean last() throws SQLException {
        this.clearWarnings();
        this.assertNotClosed();
        this.assertNotForwardOnly();
        if (this.empty) {
            this.positionState = 3;
            return false;
        }
        this.closeOpenStreams();
        boolean result = false;
        if (this.positionStateOfChunk == 2 && this.currentChunk.setRow(-1)) {
            this.positionState = 2;
            result = true;
        } else {
            result = this.fetchLast();
        }
        if (result) {
            this.clearWarnings();
        }
        return result;
    }

    public void afterLast() throws SQLException {
        this.assertNotForwardOnly();
        this.assertNotClosed();
        this.positionState = 3;
    }

    public void beforeFirst() throws SQLException {
        this.clearWarnings();
        this.assertNotForwardOnly();
        this.assertNotClosed();
        this.positionState = 1;
    }

    public boolean isFirst() throws SQLException {
        this.assertNotClosed();
        return this.currentChunk != null && !this.empty && this.positionState == 2 && this.currentChunk.isFirst() && this.currentChunk.isAtLowerBound();
    }

    public boolean isLast() throws SQLException {
        this.assertNotClosed();
        return this.currentChunk != null && !this.empty && this.positionState == 2 && this.currentChunk.isLast() && this.currentChunk.isAtUpperBound();
    }

    public boolean isBeforeFirst() throws SQLException {
        this.assertNotClosed();
        return !this.empty && this.positionState == 1;
    }

    public boolean isAfterLast() throws SQLException {
        this.assertNotClosed();
        return !this.empty && this.positionState == 3;
    }

    public boolean wasNull() throws SQLException {
        this.assertNotClosed();
        return this.lastWasNull;
    }

    public void close() throws SQLException {
        this.close(false);
    }

    public void close(boolean keepCursorOpen) throws SQLException {
        this.clearWarnings();
        if (this.fetchInfo != null) {
            if (!(this.cursorType != 5 || this.currentChunk != null && this.currentChunk.isWasLastPart())) {
                this.cursorType = 1;
            }
            if (!(keepCursorOpen || this.cursorType != 1 && this.cursorType != 4)) {
                if (this.statement != null && !this.statement.defaultCursorName.equals(this.statement.cursorName)) {
                    this.connection.dropCursor(this.fetchInfo.getCursorName(), true);
                    this.statement.cursorName = this.statement.defaultCursorName;
                } else {
                    this.connection.dropCursor(this.fetchInfo.getCursorName(), false);
                }
            }
        }
        this.cursorType = 0;
        this.isClosed = true;
        this.currentChunk = null;
        this.fetchInfo = null;
    }

    public int findColumn(String columnName) throws SQLException {
        this.assertNotClosed();
        return this.findColumnInfo(columnName).getColIndex() + 1;
    }

    public Array getArray(int i) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "ResultSetSapDB", "getArray");
    }

    public Array getArray(String colName) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "ResultSetSapDB", "getArray");
    }

    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        InputStream is = this.findColumnInfo(columnIndex).getAsciiStream(this, this.getCurrentRecord(), this.getReplyData());
        if (is != null) {
            this.openStreams.addElement(is);
        }
        return is;
    }

    public InputStream getAsciiStream(String columnName) throws SQLException {
        InputStream is = this.findColumnInfo(columnName).getAsciiStream(this, this.getCurrentRecord(), this.getReplyData());
        if (is != null) {
            this.openStreams.addElement(is);
        }
        return is;
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return this.findColumnInfo(columnIndex).getBigDecimal(this, this.getCurrentRecord());
    }

    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return this.findColumnInfo(columnIndex).getBigDecimal(scale, this, this.getCurrentRecord());
    }

    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.findColumnInfo(columnName).getBigDecimal(this, this.getCurrentRecord());
    }

    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.findColumnInfo(columnName).getBigDecimal(scale, this, this.getCurrentRecord());
    }

    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        InputStream is = this.findColumnInfo(columnIndex).getBinaryStream(this, this.getCurrentRecord(), this.getReplyData());
        if (is != null) {
            this.openStreams.addElement(is);
        }
        return is;
    }

    public InputStream getBinaryStream(String columnName) throws SQLException {
        InputStream is = this.findColumnInfo(columnName).getBinaryStream(this, this.getCurrentRecord(), this.getReplyData());
        if (is != null) {
            this.openStreams.addElement(is);
        }
        return is;
    }

    public Blob getBlob(int i) throws SQLException {
        return this.findColumnInfo(i).getBlob(this, this.getCurrentRecord(), this.getReplyData());
    }

    public Blob getBlob(String colName) throws SQLException {
        return this.findColumnInfo(colName).getBlob(this, this.getCurrentRecord(), this.getReplyData());
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        return this.findColumnInfo(columnIndex).getBoolean(this, this.getCurrentRecord());
    }

    public boolean getBoolean(String columnName) throws SQLException {
        return this.findColumnInfo(columnName).getBoolean(this, this.getCurrentRecord());
    }

    public byte getByte(int columnIndex) throws SQLException {
        return this.findColumnInfo(columnIndex).getByte(this, this.getCurrentRecord());
    }

    public byte getByte(String columnName) throws SQLException {
        return this.findColumnInfo(columnName).getByte(this, this.getCurrentRecord());
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        return this.findColumnInfo(columnIndex).getBytes(this, this.getCurrentRecord());
    }

    public byte[] getBytes(String columnName) throws SQLException {
        return this.findColumnInfo(columnName).getBytes(this, this.getCurrentRecord());
    }

    public Reader getCharacterStream(int columnIndex) throws SQLException {
        Reader r = this.findColumnInfo(columnIndex).getCharacterStream(this, this.getCurrentRecord(), this.getReplyData());
        if (r != null) {
            this.openStreams.addElement(r);
        }
        return r;
    }

    public Reader getCharacterStream(String columnName) throws SQLException {
        Reader r = this.findColumnInfo(columnName).getCharacterStream(this, this.getCurrentRecord(), this.getReplyData());
        if (r != null) {
            this.openStreams.addElement(r);
        }
        return r;
    }

    public Clob getClob(int i) throws SQLException {
        return this.findColumnInfo(i).getClob(this, this.getCurrentRecord(), this.getReplyData());
    }

    public Clob getClob(String colName) throws SQLException {
        return this.findColumnInfo(colName).getClob(this, this.getCurrentRecord(), this.getReplyData());
    }

    public int getConcurrency() throws SQLException {
        return 1007;
    }

    public Date getDate(int columnIndex) throws SQLException {
        return this.findColumnInfo(columnIndex).getDate(this, this.getCurrentRecord(), null);
    }

    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        return this.findColumnInfo(columnIndex).getDate(this, this.getCurrentRecord(), cal);
    }

    public Date getDate(String columnName) throws SQLException {
        return this.findColumnInfo(columnName).getDate(this, this.getCurrentRecord(), null);
    }

    public Date getDate(String columnName, Calendar cal) throws SQLException {
        return this.findColumnInfo(columnName).getDate(this, this.getCurrentRecord(), cal);
    }

    public double getDouble(int columnIndex) throws SQLException {
        return this.findColumnInfo(columnIndex).getDouble(this, this.getCurrentRecord());
    }

    public double getDouble(String columnName) throws SQLException {
        return this.findColumnInfo(columnName).getDouble(this, this.getCurrentRecord());
    }

    public int getFetchDirection() throws SQLException {
        return this.fetchDirection;
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.assertNotClosed();
        switch (direction) {
            case 1001: 
            case 1002: {
                this.assertNotForwardOnly();
            }
            case 1000: {
                this.fetchDirection = direction;
                break;
            }
            default: {
                throw SQLExceptionSapDB.generateSQLException("error.invalid.argumentvalue.wexample", "direction", "FETCH_FORWARD, FETCH_REVERSE, FETCH_UNKNOWN");
            }
        }
    }

    public int getFetchSize() throws SQLException {
        this.assertNotClosed();
        return this.fetchSize;
    }

    public void setFetchSize(int fetchSize) throws SQLException {
        this.assertNotClosed();
        if (fetchSize >= 0) {
            this.fetchSize = fetchSize;
            this.safeFetchSize = Math.min(this.safeFetchSize, fetchSize);
            if (this.safeFetchSize <= this.fetchSize && this.safeFetchSize != 1) {
                this.safeFetchSizeDetermined = true;
            }
        } else {
            throw SQLExceptionSapDB.generateSQLException("error.invalid.fetchsize", Integer.toString(fetchSize));
        }
    }

    public boolean rowUpdated() throws SQLException {
        this.assertNotClosed();
        return false;
    }

    public boolean rowInserted() throws SQLException {
        this.assertNotClosed();
        return false;
    }

    public boolean rowDeleted() throws SQLException {
        this.assertNotClosed();
        return false;
    }

    public float getFloat(int columnIndex) throws SQLException {
        return this.findColumnInfo(columnIndex).getFloat(this, this.getCurrentRecord());
    }

    public float getFloat(String columnName) throws SQLException {
        return this.findColumnInfo(columnName).getFloat(this, this.getCurrentRecord());
    }

    public int getInt(int columnIndex) throws SQLException {
        return this.findColumnInfo(columnIndex).getInt(this, this.getCurrentRecord());
    }

    public int getInt(String columnName) throws SQLException {
        return this.findColumnInfo(columnName).getInt(this, this.getCurrentRecord());
    }

    public long getLong(int columnIndex) throws SQLException {
        return this.findColumnInfo(columnIndex).getLong(this, this.getCurrentRecord());
    }

    public long getLong(String columnName) throws SQLException {
        return this.findColumnInfo(columnName).getLong(this, this.getCurrentRecord());
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        this.assertNotClosed();
        return new ResultSetMetaDataSapDB(this.fetchInfo.getColInfo(), "");
    }

    public Object getObject(int columnIndex) throws SQLException {
        return this.findColumnInfo(columnIndex).getObject(this, this.getCurrentRecord());
    }

    public Object getObject(int i, Map map) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.getcolumnclassname.notimplemented", "ResultSetSapDB", "getObject");
    }

    public Object getObject(String columnName) throws SQLException {
        return this.findColumnInfo(columnName).getObject(this, this.getCurrentRecord());
    }

    public Object getObject(String colName, Map map) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.getcolumnclassname.notimplemented", "ResultSetSapDB", "getObject");
    }

    public Ref getRef(int i) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "ResultSetSapDB", "getRef");
    }

    public Ref getRef(String colName) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "ResultSetSapDB", "getRef");
    }

    public int getRow() throws SQLException {
        this.assertNotClosed();
        if (this.positionState != 2) {
            return 0;
        }
        int internalRow = this.getInternalRow();
        if (internalRow < 0) {
            if (this.connection.isFetchLastNewStyleSupported()) {
                this.getRowsInResult();
            } else {
                this.getRowsInResultOldStyle();
            }
            this.absolute(internalRow);
            internalRow = this.getInternalRow();
        }
        return internalRow;
    }

    public int getInternalRow() {
        if (this.currentChunk != null) {
            return this.currentChunk.getLogicalPos();
        }
        return 0;
    }

    public void traceChunk() {
        System.err.println(this.currentChunk.traceString());
    }

    public short getShort(int columnIndex) throws SQLException {
        return this.findColumnInfo(columnIndex).getShort(this, this.getCurrentRecord());
    }

    public short getShort(String columnName) throws SQLException {
        return this.findColumnInfo(columnName).getShort(this, this.getCurrentRecord());
    }

    public Statement getStatement() throws SQLException {
        this.assertNotClosed();
        if (this.fromMetaData) {
            return null;
        }
        return this.statement;
    }

    public String getString(int columnIndex) throws SQLException {
        return this.findColumnInfo(columnIndex).getString(this, this.getCurrentRecord());
    }

    public String getString(String columnName) throws SQLException {
        return this.findColumnInfo(columnName).getString(this, this.getCurrentRecord());
    }

    public Time getTime(int columnIndex) throws SQLException {
        return this.findColumnInfo(columnIndex).getTime(this, this.getCurrentRecord(), null);
    }

    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        return this.findColumnInfo(columnIndex).getTime(this, this.getCurrentRecord(), cal);
    }

    public Time getTime(String columnName) throws SQLException {
        return this.findColumnInfo(columnName).getTime(this, this.getCurrentRecord(), null);
    }

    public Time getTime(String columnName, Calendar cal) throws SQLException {
        return this.findColumnInfo(columnName).getTime(this, this.getCurrentRecord(), cal);
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.findColumnInfo(columnIndex).getTimestamp(this, this.getCurrentRecord(), null);
    }

    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return this.findColumnInfo(columnIndex).getTimestamp(this, this.getCurrentRecord(), cal);
    }

    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.findColumnInfo(columnName).getTimestamp(this, this.getCurrentRecord(), null);
    }

    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        return this.findColumnInfo(columnName).getTimestamp(this, this.getCurrentRecord(), cal);
    }

    public int getType() throws SQLException {
        return this.statement.getResultSetType();
    }

    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        InputStream is = this.findColumnInfo(columnIndex).getUnicodeStream(this, this.getCurrentRecord());
        if (is != null) {
            this.openStreams.addElement(is);
        }
        return is;
    }

    public InputStream getUnicodeStream(String columnName) throws SQLException {
        InputStream is = this.findColumnInfo(columnName).getUnicodeStream(this, this.getCurrentRecord());
        if (is != null) {
            this.openStreams.addElement(is);
        }
        return is;
    }

    public Object[] getValues() throws SQLException {
        int colinfo_length = this.fetchInfo.numberOfColumns();
        Object[] result = new Object[colinfo_length];
        for (int i = 0; i < colinfo_length; ++i) {
            result[i] = this.getObject(i + 1);
        }
        return result;
    }

    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateBoolean(String columnName, boolean x) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateByte(int columnIndex, byte x) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateByte(String columnName, byte x) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateBytes(String columnName, byte[] x) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateDate(int columnIndex, Date x) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateDate(String columnName, Date x) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateDouble(int columnIndex, double x) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateDouble(String columnName, double x) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateFloat(int columnIndex, float x) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateFloat(String columnName, float x) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateInt(int columnIndex, int x) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateInt(String columnName, int x) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateLong(int columnIndex, long x) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateLong(String columnName, long x) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateNull(int columnIndex) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateNull(String columnName) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateDefault(String columnName) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateDefault(int columnIndex) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateObject(int columnIndex, Object x) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateObject(String columnName, Object x) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateRow() throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateShort(int columnIndex, short x) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateShort(String columnName, short x) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateString(int columnIndex, String x) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateString(String columnName, String x) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateTime(int columnIndex, Time x) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateTime(String columnName, Time x) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this.throwNotUpdatable();
    }

    public void insertRow() throws SQLException {
        this.throwNotUpdatable();
    }

    public void deleteRow() throws SQLException {
        this.throwNotUpdatable();
    }

    public void refreshRow() throws SQLException {
        this.assertNotClosed();
        int internalPos = this.getInternalRow();
        this.initializeFields();
        this.absolute(internalPos);
    }

    public void cancelRowUpdates() throws SQLException {
        this.throwNotUpdatable();
    }

    public void moveToCurrentRow() throws SQLException {
        this.throwNotUpdatable();
    }

    public void moveToInsertRow() throws SQLException {
        this.throwNotUpdatable();
    }

    public String getCursorName() throws SQLException {
        this.assertNotClosed();
        return this.fetchInfo.getCursorName();
    }

    public DataPart getReplyData() {
        if (this.currentChunk != null) {
            return this.currentChunk.getReplyData();
        }
        return null;
    }

    public void setLastWasNull(boolean lastWasNull) {
        this.lastWasNull = lastWasNull;
    }

    void setFromMetaData(boolean fromMetaData) {
        this.fromMetaData = fromMetaData;
    }

    void setEmpty(boolean empty) {
        this.empty = empty;
    }

    void setRowsInResultSet(int rows) throws SQLException {
        this.rowsInResultSet = this.maxRows > 0 ? Math.min(rows, this.maxRows) : rows;
    }

    private boolean fetchNextChunk() throws SQLException {
        ReplyPacket reply;
        int usedFetchSize = this.fetchSize;
        int usedOffset = 1;
        if (this.currentChunk.isForward()) {
            if (this.maxRowIsSet()) {
                usedFetchSize = Math.min(this.maxRows - this.currentChunk.getEnd() + 1, usedFetchSize);
            }
            if (this.modifiedKernelPos != 0) {
                usedOffset += this.currentChunk.getEnd() - this.modifiedKernelPos;
            }
        } else {
            usedOffset = this.modifiedKernelPos == 0 ? (usedOffset += this.currentChunk.getEnd() - this.currentChunk.getKernelPos()) : (usedOffset += this.currentChunk.getEnd() - this.modifiedKernelPos);
        }
        try {
            reply = this.getType() == 1003 || usedOffset == 1 ? this.fetchInfo.executeFetchNext(usedFetchSize) : this.fetchInfo.executeFetchRelative(usedOffset, usedFetchSize);
        }
        catch (SQLException sqlEx) {
            if (sqlEx.getErrorCode() == 100) {
                this.currentChunk.setLast(true);
                this.updateRowStatistics();
                this.currentChunk = null;
                this.positionStateOfChunk = 4;
                this.positionState = 3;
                return false;
            }
            throw sqlEx;
        }
        this.setCurrentChunk(new FetchChunk(5, this.currentChunk.getEnd() + 1, reply, this.fetchInfo.getRecordSize(), this.maxRows, this.rowsInResultSet));
        return true;
    }

    private boolean fetchLast() throws SQLException {
        if (!this.maxRowIsSet() || this.maxRowsOutSideResult == 1) {
            ReplyPacket reply;
            try {
                reply = this.fetchInfo.executeFetchLast(this.safeFetchSize);
            }
            catch (SQLException sqlEx) {
                if (sqlEx.getErrorCode() == 100) {
                    this.empty = true;
                    this.positionState = 3;
                    this.currentChunk = null;
                    return false;
                }
                throw sqlEx;
            }
            if (reply.findDataPart() == -1) {
                throw SQLExceptionSapDB.generateSQLException("error.packet.fetchnodatapart");
            }
            this.setCurrentChunk(new FetchChunk(2, -reply.partArguments(), reply, this.fetchInfo.getRecordSize(), 0, this.rowsInResultSet));
            this.currentChunk.moveToUpperBound();
            return true;
        }
        if (this.rowsInResultSetKnown()) {
            ReplyPacket reply;
            int usedFetchSize = this.safeFetchSize;
            int usedPhysicalRow = this.rowsInResultSet - usedFetchSize + 1;
            try {
                reply = this.fetchInfo.executeFetchAbsolute(usedPhysicalRow, usedFetchSize);
            }
            catch (SQLException sqlEx) {
                if (sqlEx.getErrorCode() == 100) {
                    this.rowsInResultSet = -1;
                    return this.fetchLast();
                }
                throw sqlEx;
            }
            this.setCurrentChunk(new FetchChunk(3, usedPhysicalRow, reply, this.fetchInfo.getRecordSize(), this.maxRows, this.rowsInResultSet));
            this.currentChunk.moveToUpperBound();
            return true;
        }
        try {
            ReplyPacket reply = this.fetchInfo.executeFetchAbsolute(this.maxRows, 1);
            this.setCurrentChunk(new FetchChunk(3, this.maxRows, reply, this.fetchInfo.getRecordSize(), this.maxRows, this.rowsInResultSet));
            this.currentChunk.moveToUpperBound();
            return true;
        }
        catch (SQLException sqlEx) {
            if (sqlEx.getErrorCode() != 100) {
                throw sqlEx;
            }
            this.maxRowsOutSideResult = 1;
            return this.fetchLast();
        }
    }

    private boolean fetchFirst() throws SQLException {
        ReplyPacket reply;
        int usedFetchSize = this.fetchSize;
        if (this.maxRowIsSet()) {
            usedFetchSize = Math.min(usedFetchSize, this.maxRows);
        }
        try {
            reply = this.statement.resultSetType == 1003 ? this.fetchInfo.executeFetchNext(usedFetchSize) : this.fetchInfo.executeFetchFirst(usedFetchSize);
        }
        catch (SQLExceptionSapDB sqlEx) {
            if (sqlEx.getErrorCode() != 100) {
                throw sqlEx;
            }
            this.empty = true;
            this.positionState = 3;
            this.currentChunk = null;
            return false;
        }
        this.setCurrentChunk(new FetchChunk(1, 1, reply, this.fetchInfo.getRecordSize(), this.maxRows, this.rowsInResultSet));
        return true;
    }

    private boolean fetchAbsoluteDown(int physicalRow) throws SQLException {
        if (this.maxRowIsSet()) {
            if (this.maxRowsOutSideResult == -1) {
                if (this.rowsInResultSet == -1) {
                    throw SQLExceptionSapDB.generateSQLException("error.assertion.maxrowsinresult");
                }
                int absrow = this.maxRows + physicalRow + 1;
                if (absrow <= 0) {
                    this.positionState = 1;
                    return false;
                }
                return this.absolute(absrow);
            }
            if (this.maxRowsOutSideResult == 0) {
                try {
                    ReplyPacket reply = this.fetchInfo.executeFetchAbsolute(this.maxRows, 1);
                    this.setCurrentChunk(new FetchChunk(3, this.maxRows, reply, this.fetchInfo.getRecordSize(), this.maxRows, this.rowsInResultSet));
                    this.currentChunk.moveToUpperBound();
                }
                catch (SQLException sqlEx) {
                    if (sqlEx.getErrorCode() != 100) {
                        throw sqlEx;
                    }
                    this.maxRowsOutSideResult = 1;
                    return this.absolute(physicalRow);
                }
                this.maxRowsOutSideResult = -1;
                return this.absolute(physicalRow);
            }
            ReplyPacket reply = null;
            try {
                reply = this.fetchInfo.executeFetchAbsolute(physicalRow, this.fetchSize);
            }
            catch (SQLExceptionSapDB sqlEx) {
                if (sqlEx.getErrorCode() == 100) {
                    this.positionState = 1;
                    return false;
                }
                throw sqlEx;
            }
            this.setCurrentChunk(new FetchChunk(4, physicalRow, reply, this.fetchInfo.getRecordSize(), this.maxRows, this.rowsInResultSet));
            if (!this.currentChunk.setRow(physicalRow)) {
                this.positionState = 1;
                return false;
            }
            return true;
        }
        ReplyPacket reply = null;
        try {
            reply = this.fetchInfo.executeFetchAbsolute(physicalRow, this.fetchSize);
        }
        catch (SQLExceptionSapDB sqlEx) {
            if (sqlEx.getErrorCode() == 100) {
                this.positionState = 1;
                return false;
            }
            throw sqlEx;
        }
        this.setCurrentChunk(new FetchChunk(4, physicalRow, reply, this.fetchInfo.getRecordSize(), this.maxRows, this.rowsInResultSet));
        if (!this.currentChunk.setRow(physicalRow)) {
            this.positionState = 1;
            return false;
        }
        return true;
    }

    private boolean fetchAbsoluteUp(int physicalRow, boolean backward) throws SQLException {
        ReplyPacket reply;
        int maxKnownEnd = this.maxRowIsSet() ? (this.rowsInResultSetKnown() ? Math.min(this.maxRows, this.rowsInResultSet) : this.maxRows) : (this.rowsInResultSetKnown() ? this.rowsInResultSet : Integer.MAX_VALUE);
        int usedFetchSize = this.fetchSize;
        int usedPhysicalRow = physicalRow;
        if (backward && this.safeFetchSizeDetermined) {
            usedFetchSize = this.safeFetchSize;
            usedPhysicalRow = physicalRow - usedFetchSize + 1;
            if (usedPhysicalRow <= 0) {
                usedPhysicalRow = 1;
            }
        } else if (physicalRow + usedFetchSize > maxKnownEnd && usedFetchSize <= this.safeFetchSize) {
            usedPhysicalRow = maxKnownEnd - usedFetchSize + 1;
        }
        try {
            reply = this.fetchInfo.executeFetchAbsolute(usedPhysicalRow, usedFetchSize);
        }
        catch (SQLExceptionSapDB sqlEx) {
            if (sqlEx.getErrorCode() != 100) {
                throw sqlEx;
            }
            this.positionState = 3;
            return false;
        }
        this.setCurrentChunk(new FetchChunk(3, usedPhysicalRow, reply, this.fetchInfo.getRecordSize(), this.maxRows, this.rowsInResultSet));
        if (usedPhysicalRow != physicalRow && !this.currentChunk.setRow(physicalRow)) {
            this.positionState = 3;
            return false;
        }
        return true;
    }

    private boolean maxRowIsSet() {
        return this.maxRows != 0;
    }

    private boolean rowsInResultSetKnown() {
        return this.rowsInResultSet != -1;
    }

    private void assertNotForwardOnly() throws SQLException {
        if (this.getType() == 1003) {
            throw SQLExceptionSapDB.generateSQLException("error.resultset.forwardonly");
        }
    }

    protected void assertNotClosed() throws SQLException {
        super.assertOpen();
        if (this.isClosed) {
            throw SQLExceptionSapDB.generateSQLException("error.objectisclosed", this);
        }
    }

    protected final DBTechTranslator findColumnInfo(String columnName) throws SQLException {
        this.assertNotClosed();
        DBTechTranslator info = this.fetchInfo.getColumnInfo(columnName);
        if (info == null) {
            throw SQLExceptionSapDB.generateSQLException("error.invalidcolumnindex", columnName);
        }
        return info;
    }

    protected final DBTechTranslator[] getColInfo() throws SQLException {
        return this.fetchInfo.getColInfo();
    }

    protected final int numberOfColumns() {
        return this.fetchInfo.numberOfColumns();
    }

    protected final DataPart getCurrentRecord() throws SQLException {
        if (this.positionState == 1) {
            throw SQLExceptionSapDB.generateSQLException("error.resultset.beforefirst");
        }
        if (this.positionState == 3) {
            throw SQLExceptionSapDB.generateSQLException("error.resultset.afterlast");
        }
        return this.currentChunk.getCurrentRecord();
    }

    private DBTechTranslator findColumnInfo(int colIndex) throws SQLException {
        DBTechTranslator info;
        this.assertNotClosed();
        try {
            info = this.getColInfo()[colIndex - 1];
        }
        catch (ArrayIndexOutOfBoundsException exc) {
            throw SQLExceptionSapDB.generateSQLException("error.invalidcolumnindex", Integer.toString(colIndex));
        }
        return info;
    }

    private void throwNotUpdatable() throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.resultset.notupdatable");
    }

    private void closeOpenStreams() {
        Enumeration e = this.openStreams.elements();
        while (e.hasMoreElements()) {
            try {
                Object o = e.nextElement();
                try {
                    InputStream is = (InputStream)o;
                    is.close();
                }
                catch (ClassCastException ccx) {
                    Reader r = (Reader)o;
                    r.close();
                }
            }
            catch (IOException iOException) {}
        }
        this.openStreams.clear();
    }

    private void setCurrentChunk(FetchChunk newChunk) throws SQLException {
        this.positionStateOfChunk = 2;
        this.positionState = 2;
        this.currentChunk = newChunk;
        int safe_fetchsize = Math.min(this.fetchSize, Math.max(newChunk.size(), this.safeFetchSize));
        if (this.safeFetchSize != safe_fetchsize) {
            this.safeFetchSize = safe_fetchsize;
            this.safeFetchSizeDetermined = false;
        } else {
            this.safeFetchSizeDetermined = safe_fetchsize != 1;
        }
        this.modifiedKernelPos = 0;
        this.updateRowStatistics();
    }

    private void updateRowStatistics() throws SQLException {
        if (!this.rowsInResultSetKnown()) {
            if (this.currentChunk.isLast() && this.currentChunk.isFirst()) {
                this.setRowsInResultSet(this.currentChunk.size());
                this.currentChunk.setRowsInResultSet(this.rowsInResultSet);
            } else if (this.currentChunk.isLast() && this.currentChunk.isForward()) {
                this.setRowsInResultSet(this.currentChunk.getEnd());
                this.currentChunk.setRowsInResultSet(this.rowsInResultSet);
            } else if (this.currentChunk.isFirst() && !this.currentChunk.isForward()) {
                this.setRowsInResultSet(-this.currentChunk.getStart());
                this.currentChunk.setRowsInResultSet(this.rowsInResultSet);
            } else if (this.currentChunk.isForward()) {
                this.largestKnownAbsPos = Math.max(this.largestKnownAbsPos, this.currentChunk.getEnd());
            }
        }
    }

    private int invertPosition(int row) {
        return this.rowsInResultSet + row + 1;
    }

    private void getRowsInResultOldStyle() throws SQLException {
        int stepsize = 32;
        int pos = this.largestKnownAbsPos;
        int smallestbadpos = Integer.MAX_VALUE;
        try {
            this.fetchInfo.executeFetchAbsolute(this.largestKnownAbsPos, 1);
        }
        catch (SQLException sqlEx) {
            if (sqlEx.getErrorCode() == 100) {
                if (this.largestKnownAbsPos == 1) {
                    this.empty = true;
                    this.positionState = 1;
                    return;
                }
                this.largestKnownAbsPos = 1;
                this.getRowsInResultOldStyle();
                return;
            }
            throw sqlEx;
        }
        while (true) {
            if (this.maxRows != 0 && pos + stepsize > this.maxRows) {
                stepsize = this.maxRows - pos;
            }
            try {
                this.fetchInfo.executeFetchAbsolute(pos + stepsize, 1);
            }
            catch (SQLException sqlEx) {
                if (sqlEx.getErrorCode() == 100) {
                    if (stepsize == 1) {
                        this.setRowsInResultSet(pos);
                        this.currentChunk = null;
                        this.positionState = 1;
                        this.positionStateOfChunk = 4;
                        return;
                    }
                    smallestbadpos = pos + stepsize;
                    if ((stepsize /= 2) != 0) continue;
                    stepsize = 1;
                    continue;
                }
                throw sqlEx;
            }
            if ((stepsize *= 2) >= smallestbadpos - (pos += stepsize) && (stepsize = (smallestbadpos - pos) / 2) == 0) {
                stepsize = 1;
            }
            if (this.maxRows != 0 && pos == this.maxRows) break;
        }
        this.setRowsInResultSet(pos);
        this.currentChunk = null;
        this.positionState = 1;
        this.positionStateOfChunk = 4;
    }

    private void getRowsInResult() throws SQLException {
        ReplyPacket reply;
        try {
            reply = this.fetchInfo.executeFetchLastWithRowNo(this.safeFetchSize);
        }
        catch (SQLException sqlEx) {
            if (sqlEx.getErrorCode() == 100) {
                this.empty = true;
                this.positionState = 3;
                this.currentChunk = null;
                return;
            }
            if (sqlEx.getErrorCode() == -3014) {
                this.connection.setFetchLastNewStyleSupported(false);
                this.getRowsInResultOldStyle();
                return;
            }
            throw sqlEx;
        }
        this.rowsInResultSet = reply.resultCount(false);
        this.setCurrentChunk(new FetchChunk(2, -reply.partArguments(), reply, this.fetchInfo.getRecordSize(), 0, this.rowsInResultSet));
        this.currentChunk.moveToUpperBound();
    }

    public URL getURL(int parm1) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "ResultSetSapDB", "getURL");
    }

    public URL getURL(String parm1) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "ResultSetSapDB", "getURL");
    }

    public void updateRef(int parm1, Ref parm2) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "ResultSetSapDB", "updateRef");
    }

    public void updateRef(String parm1, Ref parm2) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "ResultSetSapDB", "updateRef");
    }

    public void updateBlob(int parm1, Blob parm2) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateBlob(String parm1, Blob parm2) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateClob(int parm1, Clob parm2) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateClob(String parm1, Clob parm2) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateArray(int parm1, Array parm2) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "ResultSetSapDB", "updateArray");
    }

    public void updateArray(String parm1, Array parm2) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "ResultSetSapDB", "updateArray");
    }

    public AbstractABAPStreamGetval getOMSGetval(int i) {
        return null;
    }

    public void cancel() throws SQLException {
    }

    Object getExecutingObject() {
        return this.fetchInfo;
    }

    public int getHoldability() throws SQLException {
        this.assertNotClosed();
        return this.statement.getResultSetHoldability();
    }

    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "getNCharacterStream", "ResultSetSapDB");
    }

    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "getNCharacterStream", "ResultSetSapDB");
    }

    public NClob getNClob(int columnIndex) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "getNClob", "ResultSetSapDB");
    }

    public NClob getNClob(String columnLabel) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "getNClob", "ResultSetSapDB");
    }

    public String getNString(int columnIndex) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "getNString", "ResultSetSapDB");
    }

    public String getNString(String columnLabel) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "getNString", "ResultSetSapDB");
    }

    public RowId getRowId(int columnIndex) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "getRowId", "ResultSetSapDB");
    }

    public RowId getRowId(String columnLabel) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "getRowId", "ResultSetSapDB");
    }

    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "getSQLXML", "ResultSetSapDB");
    }

    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "getSQLXML", "ResultSetSapDB");
    }

    public boolean isClosed() throws SQLException {
        return this.connection == null || this.connection.session == null || this.isClosed;
    }

    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateNClob(int columnIndex, NClob clob) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateNClob(String columnLabel, NClob clob) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateNString(int columnIndex, String string) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateNString(String columnLabel, String string) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        this.throwNotUpdatable();
    }
}

