/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc.importExport;

import com.exasol.jdbc.importExport.FileValidator;
import com.exasol.jdbc.importExport.QueryPattern;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class QueryManipulator {
    public static String GetCommentsFromLast(Matcher matcher, String string, FileValidator fileValidator) {
        String string2 = "";
        if (matcher.group(string) != null) {
            Pattern pattern = Pattern.compile("(/\\*(.*?)\\*/)", 34);
            Matcher matcher2 = pattern.matcher(matcher.group(string));
            while (matcher2.find()) {
                String string3 = matcher2.group(1);
                String string4 = fileValidator.getCommentForHash(string3);
                if (string4 == null) continue;
                if (string4.trim().startsWith("--")) {
                    string2 = string2.concat(string4);
                    continue;
                }
                string2 = string2.concat(string4 + " ");
            }
        }
        return string2;
    }

    public static String extractEndingQueries(String string, Matcher matcher, String string2) {
        String string3 = matcher.end(string2) >= string.length() ? "" : string.substring(matcher.end(string2)).replaceAll("^\\s+", "");
        return string3;
    }

    public static String addMultiFilesTagAndSemicolon(String string, boolean bl) {
        int n;
        if (string == null) {
            return null;
        }
        String string2 = "";
        if (bl) {
            string2 = " MULTIPLE LOCAL FILES";
        }
        Matcher matcher = Pattern.compile("^.*" + System.getProperty("line.separator") + "(?<LastLine>.*)$", 34).matcher(string);
        boolean bl2 = false;
        if (matcher.matches()) {
            bl2 = matcher.group("LastLine").contains("--");
        }
        if (bl2) {
            string2 = System.getProperty("line.separator") + string2;
        }
        string = (n = QueryManipulator.SemicolonIndex(string)) < 0 ? string + string2 + ";" : string.substring(0, n) + string2 + string.substring(n);
        return string;
    }

    public static String extractInbetweenQueryForError(String string, Matcher matcher, String string2, String string3) {
        String string4 = matcher.end(string2) >= string.length() ? "" : string.substring(matcher.end(string2), matcher.start(string3)).trim();
        return string4;
    }

    public static String ReplaceMultiLineComment(String string, char c) {
        Matcher matcher = Pattern.compile("/\\*(.*?)\\*/", 34).matcher(string);
        while (matcher.find()) {
            for (int i = 0; i < matcher.groupCount(); ++i) {
                char[] cArray = new char[matcher.group(i).length()];
                Arrays.fill(cArray, c);
                string = string.replace(matcher.group(i), new String(cArray));
            }
        }
        return string;
    }

    public static String ReplaceSingleLineComment(String string, char c) {
        Matcher matcher = Pattern.compile("--.*?(" + System.getProperty("line.separator") + "|\\n|$)", 34).matcher(string);
        while (matcher.find()) {
            for (int i = 0; i < matcher.groupCount(); ++i) {
                char[] cArray = new char[matcher.group(i).length()];
                Arrays.fill(cArray, c);
                string = string.replace(matcher.group(i), new String(cArray));
            }
        }
        return string;
    }

    public static int SemicolonIndex(String string) {
        boolean bl = QueryManipulator.RemoveComment(string).trim().endsWith(";");
        if (bl) {
            return QueryManipulator.ReplaceSingleLineComment(QueryManipulator.ReplaceMultiLineComment(string, '*'), '*').indexOf(59);
        }
        return -1;
    }

    public static String RemoveComment(String string) {
        return string.replaceAll("(/\\*((.|" + System.getProperty("line.separator") + "|\\n)*?)\\*/|--(.*?)(" + System.getProperty("line.separator") + "|\\n|$))", "");
    }

    public static String BuildImpExpQuery(String string, String string2, FileValidator fileValidator) throws SQLException {
        String string3;
        String string4;
        if (string == null) {
            throw new SQLException("[ERROR] Local File URL is null");
        }
        if (string.trim().length() == 0) {
            throw new SQLException("[ERROR] Local File URL is Empty");
        }
        String string5 = "";
        if (fileValidator.getErrFiles() != null) {
            if (string2 == null) {
                throw new SQLException("[ERROR] Local Error File URL is null");
            }
            if (string2.trim().length() == 0) {
                throw new SQLException("[ERROR] Local Error File URL is Empty");
            }
            string4 = QueryManipulator.extractInbetweenQueryForError(fileValidator.getSql(), fileValidator.getMatcher(), QueryPattern.regexMainKey, QueryPattern.regexErrorKey);
            string3 = string4 + " ERRORS INTO CSV AT '" + string2 + "' FILE '" + fileValidator.getCookieErr() + "' " + QueryPattern.CreateFilenameQueryComment(fileValidator.getErrFiles()) + QueryManipulator.GetCommentsFromLast(fileValidator.getMatcher(), QueryPattern.regexErrorKey, fileValidator);
            string5 = string5 + string3 + QueryManipulator.extractEndingQueries(fileValidator.getSql(), fileValidator.getMatcher(), QueryPattern.regexErrorKey);
        } else {
            string5 = QueryManipulator.extractEndingQueries(fileValidator.getSql(), fileValidator.getMatcher(), QueryPattern.regexMainKey);
        }
        string4 = fileValidator.getSql().substring(0, fileValidator.getMatcher().end(QueryPattern.regexMainKey) - fileValidator.getMatcher().group(QueryPattern.regexMainKey).length()) + (fileValidator.isCSV() ? "CSV" : "FBV") + " AT '" + string + "' FILE '" + fileValidator.getCookie() + "'";
        string3 = QueryPattern.CreateFilenameQueryComment(fileValidator.getFiles()) + " " + QueryManipulator.GetCommentsFromLast(fileValidator.getMatcher(), QueryPattern.regexMainKey, fileValidator);
        string4 = string4 + " " + string3 + string5;
        string4 = fileValidator.replaceHashWithComments(string4);
        if (string4 != null) {
            string4 = QueryManipulator.addMultiFilesTagAndSemicolon(string4, fileValidator.getFiles().length > 1);
        }
        return string4;
    }
}

