/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.Column;
import com.exasol.jdbc.EXAConnection;
import com.exasol.jdbc.EXAInputStream;
import com.exasol.jdbc.EXAOutputStream;
import com.exasol.jdbc.Translator;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.text.DecimalFormat;

class DecimalColumn
extends Column {
    long[] values;
    int precision = 18;
    int scale = 0;
    long factor;
    DecimalFormat formatter;
    protected boolean enableNumericTypeConversion = true;

    void setEnableNumericTypeConversion(boolean bl) {
        this.enableNumericTypeConversion = bl;
    }

    DecimalColumn(String string, long[] lArray, int n, int n2) {
        super(string);
        this.values = lArray;
        this.precision = n;
        this.scale = n2;
        if (this.scale > this.precision) {
            this.precision = this.scale;
        }
        this.formatter = new DecimalFormat(this.repeat('#', this.precision - 1 - this.scale) + "0" + (this.scale > 0 ? "." : "") + this.repeat('0', this.scale));
        this.compFactor();
    }

    DecimalColumn(int n, int n2) {
        this.values = new long[initialBatchCapacity];
        this.precision = n;
        this.scale = n2;
        if (this.scale > this.precision) {
            this.precision = this.scale;
        }
        this.formatter = new DecimalFormat(this.repeat('#', this.precision - 1 - this.scale) + "0" + (this.scale > 0 ? "." : "") + this.repeat('0', this.scale));
        this.compFactor();
    }

    @Override
    int getPrecision() throws SQLException {
        return this.precision;
    }

    @Override
    void setPrecision(int n) throws SQLException {
        this.precision = n;
    }

    @Override
    int getScale() throws SQLException {
        return this.scale;
    }

    String repeat(char c, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    void compFactor() {
        this.factor = 1L;
        for (int i = 0; i < this.scale; ++i) {
            this.factor *= 10L;
        }
    }

    @Override
    String getClassName() {
        if (0 == this.scale && this.enableNumericTypeConversion) {
            if (this.precision <= 4) {
                return "java.lang.Short";
            }
            if (this.precision <= 9) {
                return "java.lang.Integer";
            }
            if (this.precision <= 18) {
                return "java.lang.Long";
            }
        }
        return "java.math.BigDecimal";
    }

    @Override
    int getDisplaySize(EXAConnection eXAConnection) {
        return this.precision + 2;
    }

    @Override
    int getType() {
        if (0 == this.scale && this.enableNumericTypeConversion) {
            if (this.precision <= 4) {
                return 5;
            }
            if (this.precision <= 9) {
                return 4;
            }
            if (this.precision <= 18) {
                return -5;
            }
        }
        return 3;
    }

    @Override
    String getTypeName() {
        if (0 == this.scale && this.enableNumericTypeConversion) {
            if (this.precision <= 4) {
                return "SMALLINT";
            }
            if (this.precision <= 9) {
                return "INTEGER";
            }
            if (this.precision <= 18) {
                return "BIGINT";
            }
        }
        return "DECIMAL";
    }

    @Override
    void setString(int n, String string) {
        this.validMask[n] = true;
        this.values[n] = Long.parseLong(string) * this.factor;
    }

    @Override
    void setByte(int n, byte by) {
        this.validMask[n] = true;
        this.values[n] = (long)by * this.factor;
    }

    @Override
    void setShort(int n, short s) {
        this.validMask[n] = true;
        this.values[n] = (long)s * this.factor;
    }

    @Override
    void setInt(int n, int n2) {
        this.validMask[n] = true;
        this.values[n] = (long)n2 * this.factor;
    }

    @Override
    void setLong(int n, long l) {
        this.validMask[n] = true;
        this.values[n] = l * this.factor;
    }

    @Override
    Object getObject(int n) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException("DecimalColumn::getObject: " + Translator.Accessed_null_value());
        }
        switch (this.getType()) {
            case 5: {
                return new Short(this.getShort(n));
            }
            case 4: {
                return new Integer(this.getInt(n));
            }
            case -5: {
                return new Long(this.getLong(n));
            }
        }
        return BigDecimal.valueOf(this.values[n], this.scale);
    }

    @Override
    String getString(int n) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException("DecimalColumn::getString: " + Translator.Accessed_null_value());
        }
        return this.formatter.format(BigDecimal.valueOf(this.values[n], this.scale));
    }

    @Override
    boolean getBoolean(int n) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException("DecimalColumn::getByte: " + Translator.Accessed_null_value());
        }
        long l = this.values[n] / this.factor;
        if (l == 0L) {
            return false;
        }
        if (l == 1L) {
            return true;
        }
        throw new SQLException("DecimalColumn::getBoolean: " + Translator.Conversion_not_possible());
    }

    @Override
    byte getByte(int n) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException("DecimalColumn::getByte: " + Translator.Accessed_null_value());
        }
        long l = this.values[n] / this.factor;
        if ((long)((byte)l) != l) {
            throw new SQLDataException(Translator.numeric_value_out_of_range(), new String("22003"));
        }
        return (byte)l;
    }

    @Override
    short getShort(int n) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException("DecimalColumn::getShort: " + Translator.Accessed_null_value());
        }
        long l = this.values[n] / this.factor;
        if ((long)((short)l) != l) {
            throw new SQLDataException(Translator.numeric_value_out_of_range(), new String("22003"));
        }
        return (short)l;
    }

    @Override
    int getInt(int n) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException("DecimalColumn::getInt: " + Translator.Accessed_null_value());
        }
        long l = this.values[n] / this.factor;
        if ((long)((int)l) != l) {
            throw new SQLDataException(Translator.numeric_value_out_of_range(), new String("22003"));
        }
        return (int)l;
    }

    @Override
    double getDouble(int n) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException("DecimalColumn::getDouble: " + Translator.Accessed_null_value());
        }
        return (double)this.values[n] / (double)this.factor;
    }

    @Override
    float getFloat(int n) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException("DecimalColumn::getFloat: " + Translator.Accessed_null_value());
        }
        return (float)this.values[n] / (float)this.factor;
    }

    @Override
    long getLong(int n) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException("DecimalColumn::getLong: " + Translator.Accessed_null_value());
        }
        return this.values[n] / this.factor;
    }

    @Override
    BigDecimal getBigDecimal(int n) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException("DecimalColumn::getBigDecimal: " + Translator.Accessed_null_value());
        }
        return BigDecimal.valueOf(this.values[n], this.scale);
    }

    @Override
    void resize(int n) {
        int n2;
        long[] lArray = new long[n];
        boolean[] blArray = new boolean[n];
        int n3 = this.values.length;
        if (n3 > n) {
            n3 = n;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            blArray[n2] = this.validMask[n2];
            lArray[n2] = this.values[n2];
        }
        for (n2 = n3; n2 < n; ++n2) {
            blArray[n2] = false;
        }
        this.validMask = blArray;
        this.values = lArray;
    }

    static Column from_jdbc_type(EXAInputStream eXAInputStream) throws IOException {
        int n = eXAInputStream.readInt();
        int n2 = eXAInputStream.readInt();
        return new DecimalColumn(n, n2);
    }

    @Override
    long value_to_jdbc(EXAOutputStream eXAOutputStream, int n) throws IOException {
        if (this.validMask[n]) {
            eXAOutputStream.writeByte((byte)1);
            eXAOutputStream.writeLong(this.values[n]);
            return 9L;
        }
        eXAOutputStream.writeByte((byte)0);
        return 1L;
    }

    @Override
    void value_from_jdbc(EXAInputStream eXAInputStream, int n) throws IOException {
        if (eXAInputStream.nextIsNull()) {
            this.validMask[n] = false;
        } else {
            this.validMask[n] = true;
            this.values[n] = eXAInputStream.readLong();
        }
    }

    @Override
    int getEXAType() {
        return 6;
    }

    @Override
    boolean isSigned() throws SQLException {
        return true;
    }

    @Override
    void setScale(int n) throws SQLException {
        this.scale = n;
    }
}

