/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.BigDecimalColumn;
import com.exasol.jdbc.BoolColumn;
import com.exasol.jdbc.CharColumn;
import com.exasol.jdbc.DateColumn;
import com.exasol.jdbc.DecimalColumn;
import com.exasol.jdbc.DoubleColumn;
import com.exasol.jdbc.EXAConnection;
import com.exasol.jdbc.EXAInputStream;
import com.exasol.jdbc.EXAOutputStream;
import com.exasol.jdbc.EXAPreparedStatement;
import com.exasol.jdbc.Protocol;
import com.exasol.jdbc.ProtocolException;
import com.exasol.jdbc.ProtocolTypes;
import com.exasol.jdbc.SmallDecimalColumn;
import com.exasol.jdbc.TimestampColumn;
import com.exasol.jdbc.Translator;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

abstract class Column
implements Protocol,
ProtocolTypes {
    boolean[] validMask;
    private static long cn = 0L;
    static int initialBatchCapacity = EXAPreparedStatement.capacityDefault;
    String name = Column.constructedName();
    String label = "";

    private static SQLException type_error() {
        new Throwable().printStackTrace();
        return new SQLException(Translator.type_error());
    }

    private static String constructedName() {
        return "$$" + ++cn;
    }

    Column() {
        this.validMask = new boolean[initialBatchCapacity];
        for (int i = 0; i < initialBatchCapacity; ++i) {
            this.validMask[i] = false;
        }
    }

    Column(String string) {
        this();
        this.name = string;
        this.label = string;
    }

    abstract void resize(int var1);

    abstract String getClassName() throws SQLException;

    abstract int getDisplaySize(EXAConnection var1) throws SQLException;

    abstract int getEXAType();

    abstract int getType() throws SQLException;

    abstract String getTypeName() throws SQLException;

    abstract Object getObject(int var1) throws SQLException;

    abstract int getPrecision() throws SQLException;

    abstract void setPrecision(int var1) throws SQLException;

    int getScale() throws SQLException {
        return 0;
    }

    abstract void setScale(int var1) throws SQLException;

    boolean isSigned() throws SQLException {
        return false;
    }

    Array getArray(int n) throws SQLException {
        throw Column.type_error();
    }

    BigDecimal getBigDecimal(int n) throws SQLException {
        throw Column.type_error();
    }

    BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        throw Column.type_error();
    }

    boolean isNull(int n) {
        return !this.validMask[n];
    }

    void setNull(int n) throws SQLException {
        this.validMask[n] = false;
    }

    Blob getBlob(int n) throws SQLException {
        throw Column.type_error();
    }

    boolean getBoolean(int n) throws SQLException {
        throw Column.type_error();
    }

    byte getByte(int n) throws SQLException {
        throw Column.type_error();
    }

    byte[] getBytes(int n) throws SQLException {
        throw Column.type_error();
    }

    Clob getClob(int n) throws SQLException {
        throw Column.type_error();
    }

    Date getDate(int n) throws SQLException {
        throw Column.type_error();
    }

    Date getDate(int n, Calendar calendar) throws SQLException {
        throw Column.type_error();
    }

    double getDouble(int n) throws SQLException {
        throw Column.type_error();
    }

    float getFloat(int n) throws SQLException {
        throw Column.type_error();
    }

    int getInt(int n) throws SQLException {
        throw Column.type_error();
    }

    long getLong(int n) throws SQLException {
        throw Column.type_error();
    }

    Object getObject(int n, Map map) throws SQLException {
        throw Column.type_error();
    }

    Ref getRef(int n) throws SQLException {
        throw Column.type_error();
    }

    short getShort(int n) throws SQLException {
        throw Column.type_error();
    }

    String getString(int n) throws SQLException {
        throw Column.type_error();
    }

    Time getTime(int n) throws SQLException {
        throw Column.type_error();
    }

    Time getTime(int n, Calendar calendar) throws SQLException {
        throw Column.type_error();
    }

    Timestamp getTimestamp(int n) throws SQLException {
        throw Column.type_error();
    }

    Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        throw Column.type_error();
    }

    InputStream getAsciiStream(int n) throws SQLException {
        throw Column.type_error();
    }

    InputStream getBinaryStream(int n) throws SQLException {
        throw Column.type_error();
    }

    Reader getCharacterStream(int n) throws SQLException {
        throw Column.type_error();
    }

    InputStream getUnicodeStream(int n) throws SQLException {
        throw Column.type_error();
    }

    void setArray(int n, Array array) throws SQLException {
        throw Column.type_error();
    }

    void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        throw Column.type_error();
    }

    void setBigDecimal(int n, int n2, BigDecimal bigDecimal) throws SQLException {
        throw Column.type_error();
    }

    void setBlob(int n, Blob blob) throws SQLException {
        throw Column.type_error();
    }

    void setBoolean(int n, boolean bl) throws SQLException {
        throw Column.type_error();
    }

    void setByte(int n, byte by) throws SQLException {
        throw Column.type_error();
    }

    void setBytes(int n, byte[] byArray) throws SQLException {
        throw Column.type_error();
    }

    void setClob(int n, Clob clob) throws SQLException {
        throw Column.type_error();
    }

    void setDate(int n, Date date) throws SQLException {
        throw Column.type_error();
    }

    void setDate(int n, Date date, Calendar calendar) throws SQLException {
        throw Column.type_error();
    }

    void setDouble(int n, double d) throws SQLException {
        throw Column.type_error();
    }

    void setFloat(int n, float f) throws SQLException {
        throw Column.type_error();
    }

    void setInt(int n, int n2) throws SQLException {
        throw Column.type_error();
    }

    void setLong(int n, long l) throws SQLException {
        throw Column.type_error();
    }

    void setObject(int n, Object object) throws SQLException {
        throw Column.type_error();
    }

    void setObject(int n, Object object, int n2) throws SQLException {
        throw Column.type_error();
    }

    void setObject(int n, Object object, int n2, int n3) throws SQLException {
        throw Column.type_error();
    }

    void setRef(int n, Ref ref) throws SQLException {
        throw Column.type_error();
    }

    void setShort(int n, short s) throws SQLException {
        throw Column.type_error();
    }

    void setString(int n, String string) throws SQLException {
        throw Column.type_error();
    }

    void setTime(int n, Time time) throws SQLException {
        throw Column.type_error();
    }

    void setTime(int n, Time time, Calendar calendar) throws SQLException {
        throw Column.type_error();
    }

    void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        throw Column.type_error();
    }

    void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        throw Column.type_error();
    }

    void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw Column.type_error();
    }

    void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw Column.type_error();
    }

    void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        throw Column.type_error();
    }

    void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw Column.type_error();
    }

    abstract long value_to_jdbc(EXAOutputStream var1, int var2) throws SQLException, IOException;

    abstract void value_from_jdbc(EXAInputStream var1, int var2) throws SQLException, IOException;

    static Column from_jdbc_type(EXAInputStream eXAInputStream, EXAConnection eXAConnection) throws ProtocolException, IOException {
        int n = eXAInputStream.readInt();
        switch (n) {
            case 8: {
                return DoubleColumn.from_jdbc_type(eXAInputStream);
            }
            case 63: {
                return SmallDecimalColumn.from_jdbc_type(eXAInputStream);
            }
            case 6: {
                return DecimalColumn.from_jdbc_type(eXAInputStream);
            }
            case 10: 
            case 16: 
            case 17: 
            case 123: 
            case 126: {
                return CharColumn.from_jdbc_type(eXAInputStream, eXAConnection, n);
            }
            case 14: {
                return DateColumn.from_jdbc_type(eXAInputStream);
            }
            case 9: {
                return BoolColumn.from_jdbc_type(eXAInputStream);
            }
            case 21: {
                return TimestampColumn.from_jdbc_type(eXAInputStream);
            }
            case 64: {
                return BigDecimalColumn.from_jdbc_type(eXAInputStream);
            }
        }
        throw new ProtocolException(Translator.illegal_type_code() + n);
    }

    public String toString() {
        return "column size=" + this.validMask.length;
    }
}

