/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.salesforce.oauth;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.StringJoiner;

public class OAuthRequestURLBuilder {
    private String clientID;
    private String hostname;
    private String redirectURI;
    private String codeChallenge;

    public OAuthRequestURLBuilder clientID(String clientID) {
        this.clientID = clientID;
        return this;
    }

    public OAuthRequestURLBuilder hostname(String url) {
        this.hostname = url;
        return this;
    }

    public OAuthRequestURLBuilder redirectURI(String redirect) {
        this.redirectURI = redirect;
        return this;
    }

    public OAuthRequestURLBuilder codeChallenge(String codeChallenge) {
        this.codeChallenge = codeChallenge;
        return this;
    }

    public String build() throws SQLException {
        if (this.hostname == null) {
            throw new SQLException("OAuth URL not provided");
        }
        StringJoiner params = new StringJoiner("&");
        params.add("response_type=code");
        if (this.clientID == null) {
            throw new SQLException("Missing client_id parameter");
        }
        params.add("client_id=" + this.clientID);
        if (this.redirectURI == null) {
            throw new SQLException("Missing redirect URI");
        }
        if (this.codeChallenge == null) {
            throw new SQLException("Missing code challenge");
        }
        params.add("code_challenge=" + this.codeChallenge);
        params.add("redirect_uri=" + URLEncoder.encode(this.redirectURI, StandardCharsets.UTF_8));
        params.add("display=popup");
        params.add("prompt=select_account");
        return String.valueOf(String.format("https://%s/services/oauth2/authorize", this.hostname)) + "?" + params;
    }
}

