/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.salesforce.meta;

import com.dbeaver.jdbc.salesforce.SalesForceUtils;
import com.dbeaver.jdbc.salesforce.meta.ObjectElementInfo;
import com.sforce.soap.partner.FieldType;
import com.sforce.soap.partner.IDescribeSObjectResult;
import com.sforce.soap.partner.sobject.ISObject;
import com.sforce.soap.partner.sobject.SObject;
import com.sforce.ws.bind.XmlObject;
import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class SFArray
implements Array {
    private final IDescribeSObjectResult tableInfo;
    private final SObject records;
    private final Object[] arrayItems;

    public SFArray(IDescribeSObjectResult tableInfo, SObject object, ObjectElementInfo field) {
        this.tableInfo = tableInfo;
        this.records = object;
        ArrayList items = new ArrayList();
        Object fieldValue = object.getSObjectField(field.getName());
        if (fieldValue instanceof SObject) {
            Iterator iter = ((SObject)fieldValue).getChildren("records");
            while (iter.hasNext()) {
                XmlObject nextItem = (XmlObject)iter.next();
                LinkedHashMap<String, Object> itemAttributes = new LinkedHashMap<String, Object>();
                Iterator attrIter = nextItem.getChildren();
                while (attrIter.hasNext()) {
                    XmlObject nextAttr = (XmlObject)attrIter.next();
                    String attrName = nextAttr.getName().getLocalPart();
                    if (SalesForceUtils.isSystemField((ISObject)nextItem, attrName)) continue;
                    itemAttributes.put(attrName, nextAttr.getValue());
                }
                items.add(itemAttributes);
            }
        }
        this.arrayItems = items.toArray();
    }

    @Override
    public String getBaseTypeName() throws SQLException {
        return this.tableInfo.getName();
    }

    @Override
    public int getBaseType() throws SQLException {
        return 2002;
    }

    @Override
    public Object getArray() throws SQLException {
        return this.arrayItems;
    }

    @Override
    public Object getArray(Map<String, Class<?>> map) throws SQLException {
        return this.arrayItems;
    }

    @Override
    public Object getArray(long index, int count) throws SQLException {
        return Arrays.copyOfRange(this.arrayItems, (int)index, count);
    }

    @Override
    public Object getArray(long index, int count, Map<String, Class<?>> map) throws SQLException {
        return Arrays.copyOfRange(this.arrayItems, (int)index, count);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.createResultSet();
    }

    @Override
    public ResultSet getResultSet(Map<String, Class<?>> map) throws SQLException {
        return this.createResultSet();
    }

    @Override
    public ResultSet getResultSet(long index, int count) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public ResultSet getResultSet(long index, int count, Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void free() throws SQLException {
    }

    private ResultSet createResultSet() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public class ArrayItem
    implements Struct {
        private final Map<String, Object> attrValues;

        public ArrayItem(Map<String, Object> attrValues) {
            this.attrValues = attrValues;
        }

        @Override
        public String getSQLTypeName() {
            return FieldType.combobox.toString();
        }

        @Override
        public Object[] getAttributes() {
            return this.attrValues.values().toArray(new Object[0]);
        }

        @Override
        public Object[] getAttributes(Map<String, Class<?>> map) throws SQLException {
            return new Object[0];
        }

        public String toString() {
            return String.valueOf(this.getSQLTypeName()) + "{ " + Arrays.toString(this.getAttributes()) + " }";
        }
    }
}

