/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.salesforce;

import com.dbeaver.jdbc.salesforce.SalesForceConnection;
import com.dbeaver.jdbc.salesforce.meta.ObjectElementInfo;
import com.dbeaver.jdbc.salesforce.meta.SFArray;
import com.dbeaver.jdbc.salesforce.meta.SFStruct;
import com.sforce.soap.partner.FieldType;
import com.sforce.soap.partner.IDescribeGlobalSObjectResult;
import com.sforce.soap.partner.IDescribeSObjectResult;
import com.sforce.soap.partner.IField;
import com.sforce.soap.partner.sobject.ISObject;
import com.sforce.soap.partner.sobject.SObject;

public class SalesForceUtils {
    public static int getFieldDataType(FieldType field) {
        switch (field) {
            case id: {
                return -8;
            }
            case _boolean: {
                return 16;
            }
            case date: {
                return 91;
            }
            case datetime: {
                return 93;
            }
            case time: {
                return 92;
            }
            case string: 
            case textarea: 
            case phone: 
            case url: 
            case email: 
            case location: 
            case address: 
            case json: {
                return 12;
            }
            case _int: {
                return 4;
            }
            case _long: {
                return -5;
            }
            case _double: {
                return 8;
            }
            case currency: {
                return 2;
            }
            case reference: {
                return 12;
            }
            case picklist: {
                return 12;
            }
            case multipicklist: {
                return 2003;
            }
            case complexvalue: {
                return 2002;
            }
            case anyType: {
                return 2003;
            }
        }
        return 12;
    }

    public static boolean isSystemField(ISObject object, String fieldName) {
        return fieldName.equals("type") || fieldName.equals("Id") && object.getSObjectField(fieldName) == null;
    }

    public static Object makeJdbcValue(ISObject object, Object value) {
        if (value instanceof ISObject) {
            return new SFStruct(object, (ISObject)value);
        }
        return value;
    }

    public static IField findField(IDescribeSObjectResult tableInfo, String fieldName) {
        IField[] iFieldArray = tableInfo.getFields();
        int n = iFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            IField f = iFieldArray[n2];
            if (f.getName().equals(fieldName)) {
                return f;
            }
            ++n2;
        }
        return null;
    }

    public static Object readFieldValue(SalesForceConnection connection, ISObject object, ObjectElementInfo field) throws IllegalArgumentException {
        String fieldName = field.getName();
        if (!SalesForceUtils.isShowFlatStructures(connection) && field.getDataType() == FieldType.anyType) {
            try {
                return new SFArray(field.getReferencedTable(connection), (SObject)object, field);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        if (fieldName.indexOf(46) != -1) {
            String[] attrNames = fieldName.split("\\.");
            ISObject curObject = object;
            Object value = null;
            String[] stringArray = attrNames;
            int n = attrNames.length;
            int n2 = 0;
            while (n2 < n) {
                String fn = stringArray[n2];
                if (curObject == null) {
                    throw new IllegalArgumentException("Cannot find nested field '" + fieldName + "' in record");
                }
                value = curObject.getSObjectField(fn);
                if (value instanceof ISObject) {
                    curObject = (ISObject)value;
                    Object records = curObject.getSObjectField("records");
                    if (records instanceof ISObject) {
                        curObject = (ISObject)records;
                    }
                } else {
                    curObject = null;
                }
                ++n2;
            }
            return value;
        }
        return object.getSObjectField(fieldName);
    }

    public static String getTableType(IDescribeGlobalSObjectResult object) {
        if (object.isIsInterface() || object.isHasSubtypes()) {
            return "ABSTRACT_TABLE";
        }
        return "TABLE";
    }

    public static boolean isShowFlatStructures(SalesForceConnection connection) {
        return false;
    }
}

