/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.salesforce;

import com.dbeaver.jdbc.base.AbstractJdbcConnection;
import com.dbeaver.jdbc.base.AbstractJdbcStatement;
import com.dbeaver.jdbc.base.CachedJdbcResultSetMetaData;
import com.dbeaver.jdbc.salesforce.SalesForceConnection;
import com.dbeaver.jdbc.salesforce.SalesForceResultSet;
import com.dbeaver.jdbc.salesforce.SalesForceResultSetMetaData;
import com.dbeaver.jdbc.salesforce.SalesForceUtils;
import com.dbeaver.jdbc.salesforce.meta.ObjectArrayFieldInfo;
import com.dbeaver.jdbc.salesforce.meta.ObjectElementInfo;
import com.dbeaver.jdbc.salesforce.meta.ObjectRecordExpressionInfo;
import com.dbeaver.jdbc.salesforce.meta.ObjectRecordFieldInfo;
import com.dbeaver.jdbc.salesforce.meta.ObjectRelationInfo;
import com.sforce.soap.partner.FieldType;
import com.sforce.soap.partner.IDescribeSObjectResult;
import com.sforce.soap.partner.IField;
import com.sforce.soap.partner.IQueryResult;
import com.sforce.soap.partner.PartnerConnection;
import com.sforce.soap.partner.sobject.ISObject;
import com.sforce.soap.partner.sobject.SObject;
import com.sforce.ws.ConnectionException;
import com.sforce.ws.bind.XmlObject;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.IntKeyMap;

public class SalesForceQueryStatement
extends AbstractJdbcStatement<SalesForceConnection>
implements PreparedStatement {
    private static final Logger log = Logger.getLogger(SalesForceQueryStatement.class.getName());
    private static final Pattern TABLE_NAME_PATTERN = Pattern.compile("\\s+FROM\\s+(\\w+)");
    private static final Pattern COLUMN_NAME_PATTERN = Pattern.compile("SELECT\\s+([\\w\\s,()]+)\\s+FROM");
    private String queryText;
    private IQueryResult queryResult;
    private SalesForceResultSet<ISObject> resultSet;
    private IntKeyMap<Object> indexedParams;
    private Map<String, Object> namedParams;

    public SalesForceQueryStatement(@NotNull SalesForceConnection connection, @NotNull String sql) throws SQLException {
        this(connection);
        this.queryText = sql;
    }

    public SalesForceQueryStatement(@NotNull SalesForceConnection connection) throws SQLException {
        super((AbstractJdbcConnection)connection);
    }

    @Override
    public boolean execute() throws SQLException {
        String soqlText = this.queryText;
        if (soqlText == null) {
            throw new SQLException("Null query text");
        }
        if (this.indexedParams != null) {
            int i = 0;
            while (i < this.indexedParams.size()) {
                int paramIndex = i + 1;
                if (!this.indexedParams.containsKey(paramIndex)) {
                    throw new SQLException("Parameter " + paramIndex + " is not bind");
                }
                Object value = this.indexedParams.get(paramIndex);
                String strValue = value instanceof String || value instanceof java.util.Date ? "'" + value + "'" : value.toString();
                soqlText = soqlText.replaceFirst("\\?", strValue);
                ++i;
            }
        }
        try {
            PartnerConnection pc = ((SalesForceConnection)this.connection).getPartnerConnection();
            if (this.getMaxRows() > 0) {
                pc.setQueryOptions(this.getMaxRows());
            }
            try {
                this.queryResult = pc.query(soqlText);
            }
            finally {
                pc.clearQueryOptions();
            }
            String tableName = null;
            Object record = null;
            ArrayList<String> fieldNames = new ArrayList<String>();
            Object[] records = this.queryResult.getRecords();
            if (!ArrayUtils.isEmpty((Object[])records)) {
                record = records[0];
                if (record instanceof SObject) {
                    Iterator fi = ((SObject)record).getChildren();
                    while (fi.hasNext()) {
                        XmlObject fieldXml = (XmlObject)fi.next();
                        String fieldName = fieldXml.getName().getLocalPart();
                        if (SalesForceUtils.isSystemField((ISObject)record, fieldName)) continue;
                        fieldNames.add(fieldName);
                    }
                    tableName = record.getType();
                }
            } else {
                Matcher matcher = TABLE_NAME_PATTERN.matcher(soqlText);
                while (matcher.find()) {
                    tableName = matcher.group(1);
                }
                matcher = COLUMN_NAME_PATTERN.matcher(soqlText);
                if (matcher.find()) {
                    String colNamesString = matcher.group(1).trim();
                    String[] stringArray = colNamesString.split(",");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String colName = stringArray[n2];
                        fieldNames.add(colName.trim());
                        ++n2;
                    }
                }
            }
            if (tableName == null) {
                throw new SQLException("Cannot determine object name");
            }
            ArrayList<CachedJdbcResultSetMetaData.ColumnInfo> columns = new ArrayList<CachedJdbcResultSetMetaData.ColumnInfo>();
            List<ObjectElementInfo> objectFields = ((SalesForceConnection)this.connection).getMetaData().getObjectFields(tableName);
            if (!fieldNames.isEmpty()) {
                objectFields.removeIf(f -> !fieldNames.contains(f.getName()));
            }
            if (record != null) {
                int i = 0;
                while (i < fieldNames.size()) {
                    String fieldName = (String)fieldNames.get(i);
                    if (objectFields.stream().noneMatch(f -> f.getName().equals(fieldName))) {
                        Object fieldValue = record.getSObjectField(fieldName);
                        objectFields.add(Math.min(i, objectFields.size()), new ObjectRecordExpressionInfo(fieldName, fieldValue));
                    }
                    ++i;
                }
                if (objectFields.stream().anyMatch(f -> f.getDataType() == FieldType.complexvalue || f.getDataType() == FieldType.anyType)) {
                    ArrayList<ObjectElementInfo> newFields = new ArrayList<ObjectElementInfo>();
                    for (ObjectElementInfo attr : objectFields) {
                        if (attr.getDataType() == FieldType.complexvalue || attr.getDataType() == FieldType.anyType) {
                            this.extractStructAttributes((ISObject)record, attr, newFields);
                            continue;
                        }
                        newFields.add(attr);
                    }
                    objectFields = newFields;
                }
            } else if (this.queryResult.getSize() > 0) {
                objectFields.clear();
                objectFields.add(new ObjectRecordExpressionInfo("COUNT", this.queryResult.getSize()));
                SObject countObject = new SObject("COUNT");
                countObject.addField("COUNT", (Object)this.queryResult.getSize());
                records = new ISObject[]{countObject};
            } else {
                for (String fieldName : fieldNames) {
                    if (!objectFields.stream().noneMatch(of -> of.getName().equals(fieldName))) continue;
                    objectFields.add(new ObjectRecordExpressionInfo(fieldName, null));
                }
            }
            for (ObjectElementInfo field : objectFields) {
                CachedJdbcResultSetMetaData.ColumnInfo column = new CachedJdbcResultSetMetaData.ColumnInfo(field.getName(), field.getName(), SalesForceUtils.getFieldDataType(field.getDataType()), field.getReferenceTableName(), field.getReferenceTableName(), o -> SalesForceUtils.readFieldValue((SalesForceConnection)this.getConnection(), o, field));
                columns.add(column);
            }
            SalesForceResultSetMetaData meta = new SalesForceResultSetMetaData(this, columns.toArray(new CachedJdbcResultSetMetaData.ColumnInfo[0]));
            this.resultSet = new SalesForceResultSet<Object>(this, meta, records);
        }
        catch (ConnectionException e) {
            throw new SQLException(e);
        }
        return true;
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        if (this.indexedParams == null) {
            this.indexedParams = new IntKeyMap();
        }
        this.indexedParams.put(parameterIndex, x);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.setObject(parameterIndex, (Object)x, 12, 0);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.setObject(parameterIndex, (Object)x, 4, 0);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.setObject(parameterIndex, (Object)x, 4, 0);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.setObject(parameterIndex, (Object)x, 4, 0);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.setObject(parameterIndex, (Object)x, 91, 0);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.setObject(parameterIndex, (Object)x, 92, 0);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.setObject(parameterIndex, (Object)x, 93, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void extractStructAttributes(ISObject record, ObjectElementInfo attr, List<ObjectElementInfo> nestedAttrs) throws SQLException, ConnectionException {
        Object value = record.getSObjectField(attr.getName());
        if (!(value instanceof SObject)) return;
        SObject object = (SObject)value;
        Object records = object.getSObjectField("records");
        if (SalesForceUtils.isShowFlatStructures((SalesForceConnection)this.getConnection())) {
            if (!(records instanceof SObject)) throw new SQLException("Records is not SObject: " + records);
            this.createFlatStructAttributes(attr, (SObject)records, nestedAttrs);
            return;
        } else {
            this.createStructArrayAttribute(attr, object, nestedAttrs);
        }
    }

    private void createStructArrayAttribute(ObjectElementInfo attr, SObject object, List<ObjectElementInfo> nestedAttrs) throws SQLException, ConnectionException {
        IDescribeSObjectResult tableInfo = attr.getReferencedTable((SalesForceConnection)this.connection);
        if (tableInfo == null) {
            return;
        }
        if (!(attr instanceof ObjectRelationInfo)) {
            throw new SQLException("Invalid owner element type: " + attr);
        }
        ObjectArrayFieldInfo element = new ObjectArrayFieldInfo(tableInfo, (ObjectRelationInfo)attr);
        nestedAttrs.add(element);
    }

    private void createFlatStructAttributes(ObjectElementInfo attr, SObject object, List<ObjectElementInfo> nestedAttrs) throws ConnectionException, SQLException {
        Iterator fi = object.getChildren();
        while (fi.hasNext()) {
            XmlObject fieldXml = (XmlObject)fi.next();
            String fieldName = fieldXml.getName().getLocalPart();
            if (SalesForceUtils.isSystemField((ISObject)object, fieldName)) continue;
            String attrName = String.valueOf(attr.getName()) + "." + fieldName;
            IDescribeSObjectResult tableInfo = attr.getReferencedTable((SalesForceConnection)this.connection);
            if (tableInfo == null) continue;
            IField field = SalesForceUtils.findField(tableInfo, fieldName);
            if (field == null) {
                log.warning("Field '" + fieldName + "' not found in table '" + tableInfo.getName() + "'");
                continue;
            }
            ObjectRecordFieldInfo element = new ObjectRecordFieldInfo(tableInfo, field, attrName);
            nestedAttrs.add(element);
        }
    }

    protected boolean execute(@NotNull String sql, @Nullable int[] columnIndexes, @Nullable String[] columnNames, int autoGeneratedKeys) throws SQLException {
        this.queryText = sql;
        return this.execute();
    }

    protected int executeUpdate(@NotNull String sql, @Nullable int[] columnIndexes, @Nullable String[] columnNames, int autoGeneratedKeys) throws SQLException {
        throw new SQLFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.execute(sql, null, null, 2);
        return this.getResultSet();
    }

    @Override
    public void close() throws SQLException {
        this.indexedParams = null;
        this.namedParams = null;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return 0;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
    }

    @Override
    public void cancel() throws SQLException {
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.resultSet;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return 0;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return false;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return false;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return false;
    }
}

