/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.salesforce;

import com.dbeaver.jdbc.base.AbstractJdbcConnection;
import com.dbeaver.jdbc.base.AbstractJdbcDatabaseMetaData;
import com.dbeaver.jdbc.base.AbstractJdbcStatement;
import com.dbeaver.jdbc.base.CachedJdbcResultSetMetaData;
import com.dbeaver.jdbc.salesforce.SalesForceConnection;
import com.dbeaver.jdbc.salesforce.SalesForceMetaStatement;
import com.dbeaver.jdbc.salesforce.SalesForceResultSet;
import com.dbeaver.jdbc.salesforce.SalesForceResultSetMetaData;
import com.dbeaver.jdbc.salesforce.SalesForceUtils;
import com.dbeaver.jdbc.salesforce.meta.ObjectElementInfo;
import com.dbeaver.jdbc.salesforce.meta.ObjectFieldInfo;
import com.dbeaver.jdbc.salesforce.meta.ObjectRelationInfo;
import com.sforce.soap.partner.DescribeGlobalSObjectResult;
import com.sforce.soap.partner.DescribeSObjectResult;
import com.sforce.soap.partner.FieldType;
import com.sforce.soap.partner.IChildRelationship;
import com.sforce.soap.partner.IDescribeGlobalResult;
import com.sforce.soap.partner.IDescribeGlobalSObjectResult;
import com.sforce.soap.partner.IDescribeSObjectResult;
import com.sforce.soap.partner.IField;
import com.sforce.ws.ConnectionException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jkiss.code.NotNull;

public class SalesForceDatabaseMetaData
extends AbstractJdbcDatabaseMetaData<SalesForceConnection> {
    private static final Logger log = Logger.getLogger(SalesForceDatabaseMetaData.class.getName());
    private IDescribeGlobalResult schemaCache = null;
    private Map<String, IDescribeSObjectResult> sObjectsCache = null;

    public SalesForceDatabaseMetaData(SalesForceConnection connection, String url) {
        super((AbstractJdbcConnection)connection, url);
    }

    private synchronized IDescribeGlobalResult getGlobalMeta() throws ConnectionException {
        if (this.schemaCache == null) {
            this.schemaCache = ((SalesForceConnection)this.connection).getPartnerConnection().describeGlobal();
        }
        return this.schemaCache;
    }

    private synchronized void ensureAllMetadataCached() throws ConnectionException {
        this.getGlobalMeta();
        if (this.sObjectsCache != null) {
            return;
        }
        log.log(Level.FINE, "Load all SObjects");
        LinkedHashMap<String, IDescribeSObjectResult> localCache = new LinkedHashMap<String, IDescribeSObjectResult>();
        IDescribeGlobalSObjectResult[] sobjects = this.getGlobalMeta().getSobjects();
        int pageCount = sobjects.length / 100 + 1;
        int i = 0;
        while (i < pageCount) {
            int remainsCount = sobjects.length - i * 100;
            int readCount = Math.min(remainsCount, 100);
            String[] tableNames = new String[readCount];
            int k = 0;
            while (k < readCount) {
                tableNames[k] = sobjects[i * 100 + k].getName();
                ++k;
            }
            DescribeSObjectResult[] describeSObjectResultArray = ((SalesForceConnection)this.connection).getPartnerConnection().describeSObjects(tableNames);
            int n = describeSObjectResultArray.length;
            int n2 = 0;
            while (n2 < n) {
                DescribeSObjectResult tab = describeSObjectResultArray[n2];
                localCache.put(tab.getName(), (IDescribeSObjectResult)tab);
                ++n2;
            }
            ++i;
        }
        this.sObjectsCache = localCache;
    }

    private synchronized void cleanupGlobalCache() throws ConnectionException {
        this.schemaCache = null;
        this.sObjectsCache = null;
    }

    public IDescribeSObjectResult getTableInfo(String tableName) throws ConnectionException {
        this.ensureAllMetadataCached();
        return this.sObjectsCache.get(tableName);
    }

    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        try {
            if ("%".equals(tableNamePattern)) {
                tableNamePattern = null;
            }
            String tableName = tableNamePattern;
            IDescribeGlobalSObjectResult[] sobjects = this.getGlobalMeta().getSobjects();
            sobjects = (IDescribeGlobalSObjectResult[])Arrays.stream(sobjects).filter(o -> o.isQueryable() && (tableName == null || o.getName().equals(tableName))).toArray(IDescribeGlobalSObjectResult[]::new);
            SalesForceMetaStatement stmt = new SalesForceMetaStatement((SalesForceConnection)this.connection);
            SalesForceResultSetMetaData meta = new SalesForceResultSetMetaData((AbstractJdbcStatement<? extends SalesForceConnection>)stmt, new CachedJdbcResultSetMetaData.ColumnInfo[]{new CachedJdbcResultSetMetaData.ColumnInfo("TABLE_CAT", null, 12, r -> null), new CachedJdbcResultSetMetaData.ColumnInfo("TABLE_SCHEM", null, 12, r -> null), new CachedJdbcResultSetMetaData.ColumnInfo("TABLE_NAME", null, 12, DescribeGlobalSObjectResult::getName), new CachedJdbcResultSetMetaData.ColumnInfo("TABLE_TYPE", null, 12, SalesForceUtils::getTableType), new CachedJdbcResultSetMetaData.ColumnInfo("REMARKS", null, 12, IDescribeGlobalSObjectResult::getLabel), new CachedJdbcResultSetMetaData.ColumnInfo("TYPE_CAT", null, 12, r -> null), new CachedJdbcResultSetMetaData.ColumnInfo("TYPE_SCHEM", null, 12, r -> null), new CachedJdbcResultSetMetaData.ColumnInfo("TYPE_NAME", null, 12, r -> null), new CachedJdbcResultSetMetaData.ColumnInfo("SELF_REFERENCING_COL_NAME", null, 12, r -> null), new CachedJdbcResultSetMetaData.ColumnInfo("REF_GENERATION", null, 12, r -> null), new CachedJdbcResultSetMetaData.ColumnInfo("SF_ENTITY_TYPE", null, 12, IDescribeGlobalSObjectResult::getAssociateEntityType), new CachedJdbcResultSetMetaData.ColumnInfo("SF_PARENT_ENTITY", null, 12, IDescribeGlobalSObjectResult::getAssociateParentEntity), new CachedJdbcResultSetMetaData.ColumnInfo("SF_QUERYABLE", null, 16, IDescribeGlobalSObjectResult::isQueryable), new CachedJdbcResultSetMetaData.ColumnInfo("SF_RETRIEVEABLE", null, 16, IDescribeGlobalSObjectResult::isRetrieveable), new CachedJdbcResultSetMetaData.ColumnInfo("SF_SEARCHABLE", null, 16, IDescribeGlobalSObjectResult::isSearchable), new CachedJdbcResultSetMetaData.ColumnInfo("SF_UPDATEABLE", null, 16, IDescribeGlobalSObjectResult::isUpdateable), new CachedJdbcResultSetMetaData.ColumnInfo("SF_CUSTOM", null, 16, IDescribeGlobalSObjectResult::isCustom), new CachedJdbcResultSetMetaData.ColumnInfo("SF_INTERFACE", null, 16, IDescribeGlobalSObjectResult::isIsInterface), new CachedJdbcResultSetMetaData.ColumnInfo("SF_SUB_TYPE", null, 16, IDescribeGlobalSObjectResult::isIsSubtype)});
            return new SalesForceResultSet<IDescribeGlobalSObjectResult>((AbstractJdbcStatement<? extends SalesForceConnection>)stmt, meta, sobjects);
        }
        catch (ConnectionException e) {
            throw new SQLException("Error reading tables: " + e.getMessage(), e);
        }
    }

    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        try {
            if ("%".equals(tableNamePattern)) {
                tableNamePattern = null;
            }
            String tableName = tableNamePattern;
            List<ObjectElementInfo> fields = this.getObjectFields(tableName);
            fields.removeIf(f -> !f.isSimple());
            SalesForceMetaStatement stmt = new SalesForceMetaStatement((SalesForceConnection)this.connection);
            SalesForceResultSetMetaData meta = new SalesForceResultSetMetaData((AbstractJdbcStatement<? extends SalesForceConnection>)stmt, new CachedJdbcResultSetMetaData.ColumnInfo[]{new CachedJdbcResultSetMetaData.ColumnInfo("TABLE_CAT", null, 12, r -> null), new CachedJdbcResultSetMetaData.ColumnInfo("TABLE_SCHEM", null, 12, r -> null), new CachedJdbcResultSetMetaData.ColumnInfo("TABLE_NAME", null, 12, ObjectElementInfo::getName), new CachedJdbcResultSetMetaData.ColumnInfo("COLUMN_NAME", null, 12, ObjectElementInfo::getName), new CachedJdbcResultSetMetaData.ColumnInfo("DATA_TYPE", null, 4, r -> SalesForceUtils.getFieldDataType(r.getDataType())), new CachedJdbcResultSetMetaData.ColumnInfo("TYPE_NAME", null, 12, r -> r.getDataType().toString()), new CachedJdbcResultSetMetaData.ColumnInfo("COLUMN_SIZE", null, 4, ObjectElementInfo::getByteLength), new CachedJdbcResultSetMetaData.ColumnInfo("BUFFER_LENGTH", null, 4, ObjectElementInfo::getByteLength), new CachedJdbcResultSetMetaData.ColumnInfo("DECIMAL_DIGITS", null, 4, ObjectElementInfo::getDigits), new CachedJdbcResultSetMetaData.ColumnInfo("NUM_PREC_RADIX", null, 4, r -> 10), new CachedJdbcResultSetMetaData.ColumnInfo("NULLABLE", null, 4, r -> r.isNillable() ? 1 : 0), new CachedJdbcResultSetMetaData.ColumnInfo("REMARKS", null, 4, ObjectElementInfo::getLabel), new CachedJdbcResultSetMetaData.ColumnInfo("COLUMN_DEF", null, 4, r -> r.getField().getDefaultValue()), new CachedJdbcResultSetMetaData.ColumnInfo("IS_NULLABLE", null, 12, r -> r.isNillable() ? "YES" : "NO"), new CachedJdbcResultSetMetaData.ColumnInfo("IS_AUTOINCREMENT", null, 12, r -> r.isAutoIncrement() ? "YES" : "NO"), new CachedJdbcResultSetMetaData.ColumnInfo("IS_GENERATEDCOLUMN", null, 12, r -> "NO"), new CachedJdbcResultSetMetaData.ColumnInfo("SOURCE_DATA_TYPE", null, 12, r -> SalesForceUtils.getFieldDataType(r.getDataType())), new CachedJdbcResultSetMetaData.ColumnInfo("CHAR_OCTET_LENGTH", null, 4, ObjectElementInfo::getLength), new CachedJdbcResultSetMetaData.ColumnInfo("ORDINAL_POSITION", null, 4, r -> fields.indexOf(r) + 1)});
            return new SalesForceResultSet<ObjectElementInfo>((AbstractJdbcStatement<? extends SalesForceConnection>)stmt, meta, fields.toArray(new ObjectElementInfo[0]));
        }
        catch (ConnectionException e) {
            throw new SQLException("Error reading table columns", e);
        }
    }

    public ResultSet getPrimaryKeys(String catalog, String schema, String tableNamePattern) throws SQLException {
        try {
            if ("%".equals(tableNamePattern)) {
                tableNamePattern = null;
            }
            List<ObjectElementInfo> fields = this.getObjectFields(tableNamePattern);
            fields.removeIf(f -> f.getDataType() != FieldType.id);
            SalesForceMetaStatement stmt = new SalesForceMetaStatement((SalesForceConnection)this.connection);
            SalesForceResultSetMetaData meta = new SalesForceResultSetMetaData((AbstractJdbcStatement<? extends SalesForceConnection>)stmt, new CachedJdbcResultSetMetaData.ColumnInfo[]{new CachedJdbcResultSetMetaData.ColumnInfo("TABLE_CAT", null, 12, r -> null), new CachedJdbcResultSetMetaData.ColumnInfo("TABLE_SCHEM", null, 12, r -> null), new CachedJdbcResultSetMetaData.ColumnInfo("TABLE_NAME", null, 12, ObjectElementInfo::getName), new CachedJdbcResultSetMetaData.ColumnInfo("COLUMN_NAME", null, 12, ObjectElementInfo::getName), new CachedJdbcResultSetMetaData.ColumnInfo("KEY_SEQ", null, 4, r -> 1), new CachedJdbcResultSetMetaData.ColumnInfo("PK_NAME", null, 12, ObjectElementInfo::getName)});
            return new SalesForceResultSet<ObjectElementInfo>((AbstractJdbcStatement<? extends SalesForceConnection>)stmt, meta, fields.toArray(new ObjectElementInfo[0]));
        }
        catch (ConnectionException e) {
            throw new SQLException("Error reading table columns", e);
        }
    }

    public ResultSet getExportedKeys(String catalog, String schema, String tableNamePattern) throws SQLException {
        try {
            this.ensureAllMetadataCached();
            SalesForceMetaStatement stmt = new SalesForceMetaStatement((SalesForceConnection)this.connection);
            SalesForceResultSetMetaData meta = new SalesForceResultSetMetaData((AbstractJdbcStatement<? extends SalesForceConnection>)stmt, new CachedJdbcResultSetMetaData.ColumnInfo[]{new CachedJdbcResultSetMetaData.ColumnInfo("PKTABLE_CAT", null, 12, r -> null), new CachedJdbcResultSetMetaData.ColumnInfo("PKTABLE_SCHEM", null, 12, r -> null), new CachedJdbcResultSetMetaData.ColumnInfo("PKTABLE_NAME", null, 12, ObjectElementInfo::getReferenceTableName), new CachedJdbcResultSetMetaData.ColumnInfo("PKCOLUMN_NAME", null, 12, r -> "Id"), new CachedJdbcResultSetMetaData.ColumnInfo("FKTABLE_CAT", null, 12, r -> null), new CachedJdbcResultSetMetaData.ColumnInfo("FKTABLE_SCHEM", null, 12, r -> null), new CachedJdbcResultSetMetaData.ColumnInfo("FKTABLE_NAME", null, 12, ObjectElementInfo::getObjectName), new CachedJdbcResultSetMetaData.ColumnInfo("FKCOLUMN_NAME", null, 12, ObjectElementInfo::getReferenceName), new CachedJdbcResultSetMetaData.ColumnInfo("KEY_SEQ", null, 4, r -> 1), new CachedJdbcResultSetMetaData.ColumnInfo("UPDATE_RULE", null, 4, r -> null), new CachedJdbcResultSetMetaData.ColumnInfo("DELETE_RULE", null, 4, r -> null), new CachedJdbcResultSetMetaData.ColumnInfo("DEFERRABILITY", null, 4, r -> null), new CachedJdbcResultSetMetaData.ColumnInfo("FK_NAME", null, 12, r -> String.valueOf(r.getName()) + "_FK"), new CachedJdbcResultSetMetaData.ColumnInfo("PK_NAME", null, 12, r -> "Id")});
            return new SalesForceResultSet<ObjectElementInfo>((AbstractJdbcStatement<? extends SalesForceConnection>)stmt, meta, new ObjectElementInfo[0]);
        }
        catch (Exception e) {
            throw new SQLException("Error reading table columns", e);
        }
    }

    public ResultSet getTypeInfo() throws SQLException {
        try {
            SalesForceMetaStatement stmt = new SalesForceMetaStatement((SalesForceConnection)this.connection);
            SalesForceResultSetMetaData meta = new SalesForceResultSetMetaData((AbstractJdbcStatement<? extends SalesForceConnection>)stmt, new CachedJdbcResultSetMetaData.ColumnInfo[]{new CachedJdbcResultSetMetaData.ColumnInfo("TYPE_NAME", null, 12, Object::toString), new CachedJdbcResultSetMetaData.ColumnInfo("DATA_TYPE", null, 12, SalesForceUtils::getFieldDataType), new CachedJdbcResultSetMetaData.ColumnInfo("PRECISION", null, 4, r -> 0), new CachedJdbcResultSetMetaData.ColumnInfo("LITERAL_PREFIX", null, 12, r -> null), new CachedJdbcResultSetMetaData.ColumnInfo("CREATE_PARAMS", null, 12, r -> null), new CachedJdbcResultSetMetaData.ColumnInfo("NULLABLE", null, 4, r -> 1), new CachedJdbcResultSetMetaData.ColumnInfo("CASE_SENSITIVE", null, 16, r -> true), new CachedJdbcResultSetMetaData.ColumnInfo("SEARCHABLE", null, 4, r -> 2), new CachedJdbcResultSetMetaData.ColumnInfo("LOCAL_TYPE_NAME", null, 12, Object::toString), new CachedJdbcResultSetMetaData.ColumnInfo("UNSIGNED_ATTRIBUTE", null, 16, r -> false), new CachedJdbcResultSetMetaData.ColumnInfo("MINIMUM_SCALE", null, 4, r -> 0), new CachedJdbcResultSetMetaData.ColumnInfo("MAXIMUM_SCALE", null, 4, r -> 32)});
            return new SalesForceResultSet<FieldType>((AbstractJdbcStatement<? extends SalesForceConnection>)stmt, meta, FieldType.values());
        }
        catch (Exception e) {
            throw new SQLException("Error reading table columns", e);
        }
    }

    public ResultSet getImportedKeys(String catalog, String schema, String tableNamePattern) throws SQLException {
        try {
            this.ensureAllMetadataCached();
            if ("%".equals(tableNamePattern)) {
                tableNamePattern = null;
            }
            List<ObjectElementInfo> fields = this.getObjectFields(tableNamePattern);
            fields.removeIf(f -> f.getDataType() != FieldType.reference || !f.isSimple());
            SalesForceMetaStatement stmt = new SalesForceMetaStatement((SalesForceConnection)this.connection);
            SalesForceResultSetMetaData meta = new SalesForceResultSetMetaData((AbstractJdbcStatement<? extends SalesForceConnection>)stmt, new CachedJdbcResultSetMetaData.ColumnInfo[]{new CachedJdbcResultSetMetaData.ColumnInfo("PKTABLE_CAT", null, 12, r -> null), new CachedJdbcResultSetMetaData.ColumnInfo("PKTABLE_SCHEM", null, 12, r -> null), new CachedJdbcResultSetMetaData.ColumnInfo("PKTABLE_NAME", null, 12, ObjectElementInfo::getReferenceTableName), new CachedJdbcResultSetMetaData.ColumnInfo("PKCOLUMN_NAME", null, 12, r -> "Id"), new CachedJdbcResultSetMetaData.ColumnInfo("FKTABLE_CAT", null, 12, r -> null), new CachedJdbcResultSetMetaData.ColumnInfo("FKTABLE_SCHEM", null, 12, r -> null), new CachedJdbcResultSetMetaData.ColumnInfo("FKTABLE_NAME", null, 12, ObjectElementInfo::getObjectName), new CachedJdbcResultSetMetaData.ColumnInfo("FKCOLUMN_NAME", null, 12, ObjectElementInfo::getReferenceName), new CachedJdbcResultSetMetaData.ColumnInfo("KEY_SEQ", null, 4, r -> 1), new CachedJdbcResultSetMetaData.ColumnInfo("UPDATE_RULE", null, 4, r -> null), new CachedJdbcResultSetMetaData.ColumnInfo("DELETE_RULE", null, 4, r -> null), new CachedJdbcResultSetMetaData.ColumnInfo("DEFERRABILITY", null, 4, r -> null), new CachedJdbcResultSetMetaData.ColumnInfo("FK_NAME", null, 12, r -> String.valueOf(r.getName()) + "_FK"), new CachedJdbcResultSetMetaData.ColumnInfo("PK_NAME", null, 12, r -> "Id")});
            return new SalesForceResultSet<ObjectElementInfo>((AbstractJdbcStatement<? extends SalesForceConnection>)stmt, meta, fields.toArray(new ObjectElementInfo[0]));
        }
        catch (ConnectionException e) {
            throw new SQLException("Error reading table columns", e);
        }
    }

    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        SalesForceMetaStatement stmt = new SalesForceMetaStatement((SalesForceConnection)this.connection);
        SalesForceResultSetMetaData meta = new SalesForceResultSetMetaData((AbstractJdbcStatement<? extends SalesForceConnection>)stmt, new CachedJdbcResultSetMetaData.ColumnInfo[]{new CachedJdbcResultSetMetaData.ColumnInfo("TABLE_CAT", null, 12, r -> null), new CachedJdbcResultSetMetaData.ColumnInfo("TABLE_SCHEM", null, 12, r -> null), new CachedJdbcResultSetMetaData.ColumnInfo("TABLE_NAME", null, 12, ObjectElementInfo::getObjectName), new CachedJdbcResultSetMetaData.ColumnInfo("NON_UNIQUE", null, 16, r -> false), new CachedJdbcResultSetMetaData.ColumnInfo("INDEX_QUALIFIER", null, 12, r -> null), new CachedJdbcResultSetMetaData.ColumnInfo("INDEX_NAME", null, 12, r -> null)});
        return new SalesForceResultSet<ObjectElementInfo>((AbstractJdbcStatement<? extends SalesForceConnection>)stmt, meta, new ObjectElementInfo[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    List<ObjectElementInfo> getObjectFields(String tableName) throws ConnectionException {
        List<ObjectElementInfo> fields;
        SalesForceDatabaseMetaData salesForceDatabaseMetaData = this;
        synchronized (salesForceDatabaseMetaData) {
            if (tableName != null) {
                IDescribeSObjectResult sobject;
                if (this.sObjectsCache == null) {
                    log.log(Level.FINE, "Load SObject '" + tableName + "' info");
                    sobject = ((SalesForceConnection)this.connection).getPartnerConnection().describeSObject(tableName);
                } else {
                    sobject = this.sObjectsCache.get(tableName);
                }
                fields = this.makeObjectFields(new IDescribeSObjectResult[]{sobject});
            } else {
                this.ensureAllMetadataCached();
                fields = this.makeObjectFields(this.sObjectsCache.values().toArray(new IDescribeSObjectResult[0]));
            }
        }
        return fields;
    }

    private List<ObjectElementInfo> makeObjectFields(IDescribeSObjectResult[] sobjects) {
        ArrayList<ObjectElementInfo> fields = new ArrayList<ObjectElementInfo>();
        IDescribeSObjectResult[] iDescribeSObjectResultArray = sobjects;
        int n = sobjects.length;
        int n2 = 0;
        while (n2 < n) {
            IDescribeSObjectResult so = iDescribeSObjectResultArray[n2];
            IField[] iFieldArray = so.getFields();
            int n3 = iFieldArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IField f = iFieldArray[n4];
                fields.add(new ObjectFieldInfo(so, f));
                ++n4;
            }
            iFieldArray = so.getChildRelationships();
            n3 = iFieldArray.length;
            n4 = 0;
            while (n4 < n3) {
                IField cr = iFieldArray[n4];
                if (cr.getRelationshipName() != null) {
                    fields.add(new ObjectRelationInfo(so, (IChildRelationship)cr));
                }
                ++n4;
            }
            ++n2;
        }
        return fields;
    }

    public String getDriverName() throws SQLException {
        return "SalesForce JDBC Driver";
    }

    public String getDriverVersion() throws SQLException {
        return "1.0";
    }

    public int getDriverMajorVersion() {
        return 1;
    }

    public int getDriverMinorVersion() {
        return 0;
    }

    public String getDatabaseProductName() throws SQLException {
        return "SalesForce SOAP API";
    }

    public String getDatabaseProductVersion() throws SQLException {
        return "58.0";
    }
}

