/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.erd.router.ortho;

import com.dbeaver.ee.erd.router.ortho.RoutePoint;
import org.eclipse.draw2d.geometry.Geometry;
import org.eclipse.draw2d.geometry.Point;

public class RouteSegment {
    RoutePoint start;
    RoutePoint end;

    RouteSegment(RoutePoint start, RoutePoint end) {
        this.start = start;
        this.end = end;
    }

    double cosine(RouteSegment otherSegment) {
        double cos = (double)((this.start.x - this.end.x) * (otherSegment.end.x - otherSegment.start.x) + (this.start.y - this.end.y) * (otherSegment.end.y - otherSegment.start.y)) / (this.getLength() * otherSegment.getLength());
        double sin = (this.start.x - this.end.x) * (otherSegment.end.y - otherSegment.start.y) - (this.start.y - this.end.y) * (otherSegment.end.x - otherSegment.start.x);
        if (sin < 0.0) {
            return 1.0 + cos;
        }
        return -(1.0 + cos);
    }

    long crossProduct(RouteSegment otherSegment) {
        return (this.start.x - this.end.x) * (otherSegment.end.y - this.end.y) - (this.start.y - this.end.y) * (otherSegment.end.x - this.end.x);
    }

    private double getLength() {
        return this.end.getDistance(this.start);
    }

    double getSlope() {
        if (this.end.x - this.start.x >= 0) {
            return this.end.y - this.start.y;
        }
        return -(this.end.y - this.start.y);
    }

    boolean intersects(int sx, int sy, int tx, int ty) {
        return Geometry.linesIntersect((int)this.start.x, (int)this.start.y, (int)this.end.x, (int)this.end.y, (int)sx, (int)sy, (int)tx, (int)ty);
    }

    boolean intersects(Point s, Point t) {
        return this.intersects(s.x, s.y, t.x, t.y);
    }

    public String toString() {
        return (Object)((Object)this.start) + "---" + (Object)((Object)this.end);
    }
}

