/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.erd.router.ortho;

import com.dbeaver.ee.erd.router.ortho.RoutePoint;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class RouteRectangle
extends Rectangle {
    private static final long serialVersionUID = 1L;
    boolean exclude;
    RoutePoint topLeft;
    RoutePoint topRight;
    RoutePoint bottomLeft;
    RoutePoint bottomRight;
    RoutePoint center;
    RoutePoint centerLeft;
    RoutePoint centerRight;

    RouteRectangle(Rectangle rect) {
        this.init(rect);
    }

    public boolean containsProper(Point p) {
        return p.x > this.x && p.x < this.x + this.width - 1 && p.y > this.y && p.y < this.y + this.height - 1;
    }

    private void growVertex(RoutePoint vertex) {
        if (vertex.getTotalCount() > 0) {
            vertex.grow();
        }
    }

    void growVertices() {
        this.growVertex(this.topLeft);
        this.growVertex(this.topRight);
        this.growVertex(this.bottomLeft);
        this.growVertex(this.bottomRight);
    }

    void init(Rectangle rect) {
        this.x = rect.x;
        this.y = rect.y;
        this.width = rect.width;
        this.height = rect.height;
        this.exclude = false;
        this.topLeft = new RoutePoint(this.x, this.y, this);
        this.topLeft.setPositionOnObstacle(9);
        this.topRight = new RoutePoint(this.x + this.width - 1, this.y, this);
        this.topRight.setPositionOnObstacle(17);
        this.bottomLeft = new RoutePoint(this.x, this.y + this.height - 1, this);
        this.bottomLeft.setPositionOnObstacle(12);
        this.bottomRight = new RoutePoint(this.x + this.width - 1, this.y + this.height - 1, this);
        this.bottomRight.setPositionOnObstacle(20);
        this.center = new RoutePoint(this.getCenter(), this);
        this.centerLeft = new RoutePoint(this.x, this.y + this.height / 2 - 1, this);
        this.centerLeft.setPositionOnObstacle(8);
        this.centerRight = new RoutePoint(this.x + this.width - 1, this.y + this.height / 2 - 1, this);
        this.centerRight.setPositionOnObstacle(16);
    }

    void reset() {
        this.topLeft.fullReset();
        this.bottomLeft.fullReset();
        this.bottomRight.fullReset();
        this.topRight.fullReset();
    }

    private void shrinkVertex(RoutePoint vertex) {
        if (vertex.getTotalCount() > 0) {
            vertex.shrink();
        }
    }

    void shrinkVertices() {
        this.shrinkVertex(this.topLeft);
        this.shrinkVertex(this.topRight);
        this.shrinkVertex(this.bottomLeft);
        this.shrinkVertex(this.bottomRight);
    }

    public String toString() {
        return "Obstacle(" + this.x + ", " + this.y + ", " + this.width + ", " + this.height + ")";
    }
}

