/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.erd.router.ortho;

import com.dbeaver.ee.erd.router.ortho.OrthoPath;
import com.dbeaver.ee.erd.router.ortho.RoutePoint;
import com.dbeaver.ee.erd.router.ortho.RouteRectangle;
import com.dbeaver.ee.erd.router.ortho.RouteSegment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;

public class OrthogonalRouter {
    private static final int NUM_GROW_PASSES = 4;
    private int spacing = 10;
    private boolean growPassChangedObstacles;
    private List<OrthoPath> orderedPaths;
    private Map pathsToChildPaths;
    private PathStack stack;
    private List<OrthoPath> subPaths;
    private List<RouteRectangle> userObstacles;
    private List<OrthoPath> userPaths = new ArrayList<OrthoPath>();
    private List<OrthoPath> workingPaths = new ArrayList<OrthoPath>();

    public OrthogonalRouter() {
        this.pathsToChildPaths = new HashMap();
        this.userObstacles = new ArrayList<RouteRectangle>();
    }

    public boolean addObstacle(Rectangle rect) {
        return this.internalAddObstacle(new RouteRectangle(rect));
    }

    public void addPath(OrthoPath path) {
        this.userPaths.add(path);
        this.workingPaths.add(path);
    }

    private void bendPaths() {
        int i = 0;
        while (i < this.orderedPaths.size()) {
            OrthoPath path = this.orderedPaths.get(i);
            RouteSegment segment = null;
            path.points.addPoint(new Point(path.getStart().x, path.getStart().y));
            int v = 0;
            while (v < path.getGrownSegments().size()) {
                segment = (RouteSegment)path.getGrownSegments().get(v);
                RoutePoint vertex = segment.end;
                if (vertex != null && v < path.getGrownSegments().size() - 1) {
                    if (vertex.getType() == 1) {
                        ++vertex.count;
                        path.points.addPoint(vertex.bend(vertex.count));
                    } else {
                        path.points.addPoint(vertex.bend(vertex.getTotalCount()));
                        --vertex.totalCount;
                    }
                }
                ++v;
            }
            path.points.addPoint(new Point(path.getEnd().x, path.getEnd().y));
            ++i;
        }
    }

    private void checkVertexForIntersections(RoutePoint vertex) {
        if (vertex.getNearestObstacle() != 0 || vertex.isNearestObstacleChecked()) {
            return;
        }
        int sideLength = 2 * (vertex.totalCount * this.getSpacing()) + 1;
        if ((vertex.getPositionOnObstacle() & 1) <= 0 && (vertex.getPositionOnObstacle() & 4) <= 0 && (vertex.getPositionOnObstacle() & 0x10) <= 0) {
            vertex.getPositionOnObstacle();
        }
        int y = (vertex.getPositionOnObstacle() & 1) > 0 ? vertex.y - sideLength : vertex.y;
        int x = (vertex.getPositionOnObstacle() & 0x10) > 0 ? vertex.x : vertex.x - sideLength;
        Rectangle r = new Rectangle(x, y, sideLength, sideLength);
        int o = 0;
        while (o < this.userObstacles.size()) {
            int yDist;
            int xDist;
            int pos;
            RouteRectangle obs = this.userObstacles.get(o);
            if (obs != vertex.getObs() && r.intersects((Rectangle)obs) && (pos = obs.getPosition(vertex)) != 0 && (Math.max(xDist = (pos & 0x10) > 0 ? vertex.x - obs.right() + 1 : obs.x - vertex.x, yDist = (pos & 1) > 0 ? obs.y - vertex.y : vertex.y - obs.bottom() + 1) < vertex.getNearestObstacle() || vertex.getNearestObstacle() == 0)) {
                vertex.setNearestObstacle(Math.max(xDist, yDist));
                vertex.updateOffset();
            }
            ++o;
        }
        vertex.setNearestObstacleChecked(true);
    }

    private void checkVertexIntersections() {
        int i = 0;
        while (i < this.workingPaths.size()) {
            OrthoPath path = this.workingPaths.get(i);
            int s = 0;
            while (s < path.getSegments().size() - 1) {
                RoutePoint vertex = path.getSegments().get((int)s).end;
                this.checkVertexForIntersections(vertex);
                ++s;
            }
            ++i;
        }
    }

    private void cleanup() {
        int i = 0;
        while (i < this.workingPaths.size()) {
            OrthoPath path = this.workingPaths.get(i);
            path.cleanup();
            ++i;
        }
    }

    private void countVertices() {
        int i = 0;
        while (i < this.workingPaths.size()) {
            OrthoPath path = this.workingPaths.get(i);
            int v = 0;
            while (v < path.getSegments().size() - 1) {
                ++path.getSegments().get((int)v).end.totalCount;
                ++v;
            }
            ++i;
        }
    }

    private boolean dirtyPathsOn(RoutePoint vertex) {
        List<OrthoPath> paths = vertex.getPaths();
        if (paths != null && paths.size() != 0) {
            int i = 0;
            while (i < paths.size()) {
                paths.get((int)i).isDirty = true;
                ++i;
            }
            return true;
        }
        return false;
    }

    public int getSpacing() {
        return this.spacing;
    }

    private OrthoPath getSubpathForSplit(OrthoPath path, RouteSegment segment) {
        OrthoPath newPath = path.getSubPath(segment);
        this.workingPaths.add(newPath);
        this.subPaths.add(newPath);
        return newPath;
    }

    private void growObstacles() {
        this.growPassChangedObstacles = false;
        int i = 0;
        while (i < 4) {
            if (i == 0 || this.growPassChangedObstacles) {
                this.growObstaclesPass();
            }
            ++i;
        }
    }

    private void growObstaclesPass() {
        int i = 0;
        while (i < this.userObstacles.size()) {
            this.userObstacles.get(i).growVertices();
            ++i;
        }
        i = 0;
        while (i < this.workingPaths.size()) {
            OrthoPath path = this.workingPaths.get(i);
            int e = 0;
            while (e < path.getExcludedVertexRectangles().size()) {
                ((RouteRectangle)((Object)path.getExcludedVertexRectangles().get((int)e))).exclude = true;
                ++e;
            }
            if (path.getGrownSegments().size() == 0) {
                int s = 0;
                while (s < path.getSegments().size()) {
                    this.testOffsetSegmentForIntersections(path.getSegments().get(s), -1, path);
                    ++s;
                }
            } else {
                int counter = 0;
                ArrayList currentSegments = new ArrayList(path.getGrownSegments());
                int s = 0;
                while (s < currentSegments.size()) {
                    counter += this.testOffsetSegmentForIntersections((RouteSegment)currentSegments.get(s), s + counter, path);
                    ++s;
                }
            }
            e = 0;
            while (e < path.getExcludedVertexRectangles().size()) {
                ((RouteRectangle)((Object)path.getExcludedVertexRectangles().get((int)e))).exclude = false;
                ++e;
            }
            ++i;
        }
        i = 0;
        while (i < this.userObstacles.size()) {
            this.userObstacles.get(i).shrinkVertices();
            ++i;
        }
    }

    private boolean internalAddObstacle(RouteRectangle obs) {
        this.userObstacles.add(obs);
        return this.testAndDirtyPaths(obs);
    }

    private boolean internalRemoveObstacle(Rectangle rect) {
        RouteRectangle obs = null;
        int index = -1;
        int i = 0;
        while (i < this.userObstacles.size()) {
            obs = this.userObstacles.get(i);
            if (obs.equals(rect)) {
                index = i;
                break;
            }
            ++i;
        }
        this.userObstacles.remove(index);
        boolean result = false;
        result |= this.dirtyPathsOn(obs.bottomLeft);
        result |= this.dirtyPathsOn(obs.topLeft);
        result |= this.dirtyPathsOn(obs.bottomRight);
        result |= this.dirtyPathsOn(obs.topRight);
        int p = 0;
        while (p < this.workingPaths.size()) {
            OrthoPath path = this.workingPaths.get(p);
            if (!path.isDirty && path.isVertexRectangleVisible(obs)) {
                result = true;
                path.isDirty = true;
            }
            ++p;
        }
        return result;
    }

    private void labelPath(OrthoPath path) {
        RouteSegment segment = null;
        RouteSegment nextSegment = null;
        RoutePoint vertex = null;
        boolean agree = false;
        int v = 0;
        while (v < path.getGrownSegments().size() - 1) {
            segment = (RouteSegment)path.getGrownSegments().get(v);
            nextSegment = (RouteSegment)path.getGrownSegments().get(v + 1);
            vertex = segment.end;
            long crossProduct = segment.crossProduct(new RouteSegment(vertex, vertex.getObs().center));
            if (vertex.getType() == 0) {
                this.labelVertex(segment, crossProduct, path);
            } else if (!path.isInverted && (crossProduct > 0L && vertex.getType() == 2 || crossProduct < 0L && vertex.getType() == 1)) {
                if (agree) {
                    this.stack.push(this.getSubpathForSplit(path, segment));
                    return;
                }
                path.isInverted = true;
                path.invertPriorVertices(segment);
            } else {
                if (path.isInverted && (crossProduct < 0L && vertex.getType() == 2 || crossProduct > 0L && vertex.getType() == 1)) {
                    this.stack.push(this.getSubpathForSplit(path, segment));
                    return;
                }
                agree = true;
            }
            if (vertex.getPaths() != null) {
                int i = 0;
                while (i < vertex.getPaths().size()) {
                    OrthoPath nextPath = vertex.getPaths().get(i);
                    if (!nextPath.isMarked) {
                        nextPath.isMarked = true;
                        this.stack.push(nextPath);
                    }
                    ++i;
                }
            }
            vertex.addPath(path, segment, nextSegment);
            ++v;
        }
    }

    private void labelPaths() {
        OrthoPath path = null;
        int i = 0;
        while (i < this.workingPaths.size()) {
            path = this.workingPaths.get(i);
            this.stack.push(path);
            ++i;
        }
        while (!this.stack.isEmpty()) {
            path = this.stack.pop();
            if (path.isMarked) continue;
            path.isMarked = true;
            this.labelPath(path);
        }
        i = 0;
        while (i < this.workingPaths.size()) {
            path = this.workingPaths.get(i);
            path.isMarked = false;
            ++i;
        }
    }

    private void labelVertex(RouteSegment segment, long crossProduct, OrthoPath path) {
        if (crossProduct > 0L) {
            if (path.isInverted) {
                segment.end.setType(2);
            } else {
                segment.end.setType(1);
            }
        } else if (crossProduct < 0L) {
            if (path.isInverted) {
                segment.end.setType(1);
            } else {
                segment.end.setType(2);
            }
        } else if (segment.start.getType() != 0) {
            segment.end.setType(segment.start.getType());
        } else {
            segment.end.setType(1);
        }
    }

    private void orderPath(OrthoPath path) {
        if (path.isMarked) {
            return;
        }
        path.isMarked = true;
        RouteSegment segment = null;
        RoutePoint vertex = null;
        int v = 0;
        while (v < path.getGrownSegments().size() - 1) {
            segment = (RouteSegment)path.getGrownSegments().get(v);
            vertex = segment.end;
            double thisAngle = vertex.getCachedCosines().get(path);
            if (path.isInverted) {
                thisAngle = -thisAngle;
            }
            int i = 0;
            while (i < vertex.getPaths().size()) {
                OrthoPath vPath = vertex.getPaths().get(i);
                if (!vPath.isMarked) {
                    double otherAngle = vertex.getCachedCosines().get(vPath);
                    if (vPath.isInverted) {
                        otherAngle = -otherAngle;
                    }
                    if (otherAngle < thisAngle) {
                        this.orderPath(vPath);
                    }
                }
                ++i;
            }
            ++v;
        }
        this.orderedPaths.add(path);
    }

    private void orderPaths() {
        int i = 0;
        while (i < this.workingPaths.size()) {
            OrthoPath path = this.workingPaths.get(i);
            this.orderPath(path);
            ++i;
        }
    }

    private void recombineChildrenPaths() {
        for (OrthoPath path : this.pathsToChildPaths.keySet()) {
            path.fullReset();
            List childPaths = (List)this.pathsToChildPaths.get(path);
            OrthoPath childPath = null;
            int i = 0;
            while (i < childPaths.size()) {
                childPath = (OrthoPath)childPaths.get(i);
                path.points.addAll(childPath.getPoints());
                path.points.removePoint(path.points.size() - 1);
                path.getSegments().addAll(childPath.getSegments());
                path.getVisibleVertexRectangles().addAll(childPath.getVisibleVertexRectangles());
                ++i;
            }
            path.points.addPoint(childPath.points.getLastPoint());
        }
    }

    private void recombineSubpaths() {
        int p = 0;
        while (p < this.orderedPaths.size()) {
            OrthoPath path = this.orderedPaths.get(p);
            path.reconnectSubPaths();
            ++p;
        }
        this.orderedPaths.removeAll(this.subPaths);
        this.workingPaths.removeAll(this.subPaths);
        this.subPaths = null;
    }

    public boolean removeObstacle(Rectangle rect) {
        return this.internalRemoveObstacle(rect);
    }

    public boolean removePath(OrthoPath path) {
        this.userPaths.remove(path);
        List children = (List)this.pathsToChildPaths.get(path);
        if (children == null) {
            this.workingPaths.remove(path);
        } else {
            this.workingPaths.removeAll(children);
        }
        return true;
    }

    private void resetObstacleExclusions() {
        int i = 0;
        while (i < this.userObstacles.size()) {
            this.userObstacles.get((int)i).exclude = false;
            ++i;
        }
    }

    private void resetVertices() {
        int i = 0;
        while (i < this.userObstacles.size()) {
            RouteRectangle obs = this.userObstacles.get(i);
            obs.reset();
            ++i;
        }
        i = 0;
        while (i < this.workingPaths.size()) {
            OrthoPath path = this.workingPaths.get(i);
            path.getStart().fullReset();
            path.getEnd().fullReset();
            ++i;
        }
    }

    public void setSpacing(int spacing) {
        this.spacing = spacing;
    }

    public List<OrthoPath> solve() {
        this.solveDirtyPaths();
        this.countVertices();
        this.checkVertexIntersections();
        this.growObstacles();
        this.subPaths = new ArrayList<OrthoPath>();
        this.stack = new PathStack();
        this.labelPaths();
        this.stack = null;
        this.orderedPaths = new ArrayList<OrthoPath>();
        this.orderPaths();
        this.bendPaths();
        this.recombineSubpaths();
        this.orderedPaths = null;
        this.subPaths = null;
        this.recombineChildrenPaths();
        this.cleanup();
        return Collections.unmodifiableList(this.userPaths);
    }

    private int solveDirtyPaths() {
        OrthoPath path;
        int numSolved = 0;
        int i = 0;
        while (i < this.userPaths.size()) {
            path = this.userPaths.get(i);
            if (path.isDirty) {
                List children = (List)this.pathsToChildPaths.get(path);
                int prevCount = 1;
                int newCount = 1;
                if (children == null) {
                    children = Collections.EMPTY_LIST;
                } else {
                    prevCount = children.size();
                }
                if (path.getBendPoints() != null) {
                    newCount = path.getBendPoints().size() + 1;
                }
                if (prevCount != newCount) {
                    children = this.regenerateChildPaths(path, children, prevCount, newCount);
                }
                this.refreshChildrenEndpoints(path, children);
            }
            ++i;
        }
        i = 0;
        while (i < this.workingPaths.size()) {
            path = this.workingPaths.get(i);
            path.refreshExcludedVertexRectangles(this.userObstacles);
            if (!path.isDirty) {
                path.resetPartial();
            } else {
                ++numSolved;
                path.fullReset();
                boolean pathFoundCheck = path.generateShortestPath(this.userObstacles);
                if (!pathFoundCheck || path.getEnd().getCost() > path.getThreshold()) {
                    this.resetVertices();
                    path.fullReset();
                    path.setThreshold(0.0);
                    pathFoundCheck = path.generateShortestPath(this.userObstacles);
                }
                this.resetVertices();
            }
            ++i;
        }
        this.resetObstacleExclusions();
        if (numSolved == 0) {
            this.resetVertices();
        }
        return numSolved;
    }

    private void refreshChildrenEndpoints(OrthoPath path, List children) {
        Point previous = path.getStartPoint();
        PointList bendpoints = path.getBendPoints();
        int i = 0;
        while (i < children.size()) {
            Point next = i < bendpoints.size() ? bendpoints.getPoint(i) : path.getEndPoint();
            OrthoPath child = (OrthoPath)children.get(i);
            child.setStartPoint(previous);
            child.setEndPoint(next);
            previous = next;
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private List regenerateChildPaths(OrthoPath path, List children, int currentSize, int newSize) {
        block2: {
            if (currentSize != 1) break block2;
            this.workingPaths.remove(path);
            currentSize = 0;
            children = new ArrayList<OrthoPath>();
            this.pathsToChildPaths.put(path, children);
            ** GOTO lbl24
        }
        if (newSize != 1) ** GOTO lbl24
        this.workingPaths.removeAll(children);
        this.workingPaths.add(path);
        this.pathsToChildPaths.remove(path);
        return Collections.EMPTY_LIST;
lbl-1000:
        // 1 sources

        {
            child = new OrthoPath();
            this.workingPaths.add(child);
            children.add(child);
            ++currentSize;
lbl24:
            // 3 sources

            ** while (currentSize < newSize)
        }
lbl25:
        // 2 sources

        while (currentSize > newSize) {
            child = (OrthoPath)children.remove(children.size() - 1);
            this.workingPaths.remove(child);
            --currentSize;
        }
        return children;
    }

    private int testOffsetSegmentForIntersections(RouteSegment segment, int index, OrthoPath path) {
        return 0;
    }

    private boolean testAndDirtyPaths(RouteRectangle obs) {
        boolean result = false;
        int i = 0;
        while (i < this.workingPaths.size()) {
            OrthoPath path = this.workingPaths.get(i);
            result |= path.testAndSet(obs);
            ++i;
        }
        return result;
    }

    public boolean updateObstacle(Rectangle oldBounds, Rectangle newBounds) {
        boolean result = this.internalRemoveObstacle(oldBounds);
        return result |= this.addObstacle(newBounds);
    }

    public List<RouteRectangle> getEntityRectangle() {
        return this.userObstacles;
    }

    static class PathStack
    extends ArrayList<Object> {
        private static final long serialVersionUID = -1686339891731420061L;

        PathStack() {
        }

        OrthoPath pop() {
            return (OrthoPath)this.remove(this.size() - 1);
        }

        void push(OrthoPath path) {
            this.add(path);
        }
    }
}

