/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.erd.router.ortho;

import com.dbeaver.ee.erd.router.ortho.OrthoPath;
import com.dbeaver.ee.erd.router.ortho.OrthoPathUtils;
import com.dbeaver.ee.erd.router.ortho.OrthogonalConnection;
import com.dbeaver.ee.erd.router.ortho.OrthogonalRouter;
import com.dbeaver.ee.erd.router.ortho.RouteLine;
import com.dbeaver.ee.erd.router.ortho.RouteRectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.draw2d.Bendpoint;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutListener;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.jkiss.dbeaver.erd.ui.figures.AttributeItemFigure;
import org.jkiss.dbeaver.erd.ui.router.ERDConnectionRouter;

public class OrthogonalPathRouting
extends ERDConnectionRouter {
    private final Map<Connection, Object> constraintMap = new LinkedHashMap<Connection, Object>();
    private Map<IFigure, Rectangle> figuresToBounds = new LinkedHashMap<IFigure, Rectangle>();
    private Map<Connection, OrthoPath> connectionToPaths;
    private OrthogonalRouter algorithm = new OrthogonalRouter();
    private final Set<Connection> staleConnections = new HashSet<Connection>();
    private final LayoutListener listener = new LayoutTracker();
    private boolean isDirty;
    private static final double IDENTATION_DEFAULT = 35.0;
    private static final int INTERSECTION_LINE_SPACING = 7;
    private static final int LINE_SPACING_DEFAULT = 10;
    private static final int LINE_SPACING_VERTICAL = 17;
    private static final int LINE_SPACING_HORIZONTAL = 15;
    private final FigureListener figureListener = source -> {
        Rectangle newBounds = source.getBounds().getCopy();
        if (this.algorithm.updateObstacle(this.figuresToBounds.get(source), newBounds)) {
            this.queueSomeRouting();
            this.isDirty = true;
        }
        this.figuresToBounds.put(source, newBounds);
    };
    private boolean ignoreInvalidate;

    void addChild(IFigure child) {
        if (this.connectionToPaths == null) {
            return;
        }
        if (this.figuresToBounds.containsKey(child)) {
            return;
        }
        Rectangle bounds = child.getBounds().getCopy();
        this.algorithm.addObstacle(bounds);
        this.figuresToBounds.put(child, bounds);
        child.addFigureListener(this.figureListener);
        this.isDirty = true;
    }

    private void hookAll() {
        this.figuresToBounds = new LinkedHashMap<IFigure, Rectangle>();
        this.getContainer().getChildren().forEach(this::addChild);
        this.getContainer().addLayoutListener(this.listener);
    }

    private void unhookAll() {
        this.getContainer().removeLayoutListener(this.listener);
        if (this.figuresToBounds != null) {
            Iterator<IFigure> figureItr = this.figuresToBounds.keySet().iterator();
            while (figureItr.hasNext()) {
                IFigure child = figureItr.next();
                figureItr.remove();
                this.removeChild(child);
            }
            this.figuresToBounds = null;
        }
    }

    public Object getConstraint(Connection connection) {
        return this.constraintMap.get(connection);
    }

    public int getSpacing() {
        return this.algorithm.getSpacing();
    }

    public void invalidate(Connection connection) {
        if (this.ignoreInvalidate) {
            return;
        }
        this.staleConnections.add(connection);
        this.getConnectionPoints().put(connection, new PointList());
        this.isDirty = true;
    }

    private void processStaleConnections() {
        Iterator<Connection> iter = this.staleConnections.iterator();
        if (iter.hasNext() && this.connectionToPaths == null) {
            this.connectionToPaths = new LinkedHashMap<Connection, OrthoPath>();
            this.hookAll();
        }
        while (iter.hasNext()) {
            List constraint;
            Connection conn = iter.next();
            OrthoPath path = this.connectionToPaths.get(conn);
            if (path == null) {
                path = new OrthoPath(conn);
                this.connectionToPaths.put(conn, path);
                this.algorithm.addPath(path);
            }
            if ((constraint = (List)this.getConstraint(conn)) == null) {
                constraint = Collections.emptyList();
            }
            Point start = conn.getSourceAnchor().getReferencePoint().getCopy();
            Point end = conn.getTargetAnchor().getReferencePoint().getCopy();
            this.getContainer().translateToRelative((Translatable)start);
            this.getContainer().translateToRelative((Translatable)end);
            path.setStartPoint(start);
            path.setEndPoint(end);
            if (!constraint.isEmpty()) {
                PointList bends = new PointList(constraint.size());
                for (Object element : constraint) {
                    Bendpoint bp = (Bendpoint)element;
                    bends.addPoint(bp.getLocation());
                }
                path.setBendPoints(bends);
            } else {
                path.setBendPoints(null);
            }
            this.isDirty |= path.isDirty;
        }
        this.staleConnections.clear();
    }

    void queueSomeRouting() {
        if (this.connectionToPaths == null || this.connectionToPaths.isEmpty()) {
            return;
        }
        try {
            this.ignoreInvalidate = true;
            this.connectionToPaths.keySet().iterator().next().revalidate();
        }
        finally {
            this.ignoreInvalidate = false;
        }
    }

    public void remove(Connection connection) {
        this.staleConnections.remove(connection);
        this.constraintMap.remove(connection);
        if (this.connectionToPaths == null) {
            return;
        }
        OrthoPath path = this.connectionToPaths.remove(connection);
        this.algorithm.removePath(path);
        this.isDirty = true;
        if (this.connectionToPaths.isEmpty()) {
            this.unhookAll();
            this.connectionToPaths = null;
        } else {
            this.queueSomeRouting();
        }
    }

    void removeChild(IFigure child) {
        if (this.connectionToPaths == null) {
            return;
        }
        Rectangle bounds = child.getBounds().getCopy();
        boolean change = this.algorithm.removeObstacle(bounds);
        this.figuresToBounds.remove(child);
        child.removeFigureListener(this.figureListener);
        if (change) {
            this.isDirty = true;
            this.queueSomeRouting();
        }
    }

    public void route(Connection conn) {
        if (this.isDirty) {
            this.ignoreInvalidate = true;
            this.processStaleConnections();
            this.isDirty = false;
            List<OrthoPath> routePaths = this.algorithm.solve();
            PolylineConnection connection = null;
            for (OrthoPath path : routePaths) {
                if (path.data instanceof PolylineConnection) {
                    connection = (PolylineConnection)path.data;
                }
                if (connection instanceof OrthogonalConnection) {
                    ((OrthogonalConnection)connection).cleanupOverlappedPoints();
                }
                connection.revalidate();
                PointList points = path.getPoints().getCopy();
                PrecisionPoint ref1 = new PrecisionPoint(points.getPoint(1));
                PrecisionPoint ref2 = new PrecisionPoint(points.getPoint(points.size() - 2));
                connection.translateToAbsolute((Translatable)ref1);
                connection.translateToAbsolute((Translatable)ref2);
                Point start = connection.getSourceAnchor().getLocation((Point)ref1).getCopy();
                Point end = connection.getTargetAnchor().getLocation((Point)ref2).getCopy();
                connection.translateToRelative((Translatable)start);
                connection.translateToRelative((Translatable)end);
                IFigure srcOwner = connection.getSourceAnchor().getOwner();
                if (srcOwner == null) continue;
                Rectangle srcBounds = srcOwner.getBounds().getCopy();
                RouteRectangle vrSource = new RouteRectangle(srcBounds);
                IFigure targetOwner = connection.getTargetAnchor().getOwner();
                if (targetOwner == null) continue;
                Rectangle trgBounds = targetOwner.getBounds().getCopy();
                RouteRectangle vrTarget = new RouteRectangle(trgBounds);
                PointList modifiedPoints = new PointList();
                IFigure parentSrc = srcOwner;
                if (srcOwner instanceof AttributeItemFigure) {
                    parentSrc = srcOwner.getParent().getParent();
                }
                IFigure parentTrg = targetOwner;
                if (srcOwner instanceof AttributeItemFigure) {
                    parentTrg = targetOwner.getParent().getParent();
                }
                int direction = OrthoPathUtils.getDirection(srcBounds, trgBounds);
                int directionSrcToTrg = 0;
                int directionTrgToSrc = 0;
                if (points.size() > 2 && path.bendpoints != null) {
                    Point pointF1 = points.getPoint(1);
                    Point pointF2 = points.getPoint(points.size() - 2);
                    directionSrcToTrg = OrthoPathUtils.getLeftRightDirection(start, pointF1);
                    directionTrgToSrc = OrthoPathUtils.getLeftRightDirection(end, pointF2);
                    if (directionSrcToTrg == 1) {
                        start = vrSource.centerLeft;
                        directionSrcToTrg = 180;
                    } else {
                        start = vrSource.centerRight;
                        directionSrcToTrg = 0;
                    }
                    if (directionTrgToSrc == 1) {
                        end = vrTarget.centerLeft;
                        directionTrgToSrc = 0;
                    } else {
                        end = vrTarget.centerRight;
                        directionTrgToSrc = 180;
                    }
                } else {
                    if (parentSrc.equals(parentTrg)) {
                        directionSrcToTrg = -360;
                        directionTrgToSrc = 180;
                    }
                    switch (direction) {
                        case 90: {
                            directionSrcToTrg = 180;
                            directionTrgToSrc = 180;
                            start = vrSource.centerRight;
                            end = vrTarget.centerRight;
                            break;
                        }
                        case -90: {
                            directionSrcToTrg = 0;
                            directionTrgToSrc = 180;
                            start = vrSource.centerRight;
                            end = vrTarget.centerRight;
                            break;
                        }
                        case 0: {
                            directionSrcToTrg = 180;
                            directionTrgToSrc = 180;
                            start = vrSource.centerLeft;
                            end = vrTarget.centerRight;
                            break;
                        }
                        case 180: {
                            start = vrSource.centerRight;
                            end = vrTarget.centerLeft;
                            break;
                        }
                        case -360: {
                            directionSrcToTrg = 180;
                            directionTrgToSrc = 0;
                            start = vrSource.centerLeft;
                            end = vrTarget.centerLeft;
                            break;
                        }
                        default: {
                            directionSrcToTrg = 180;
                            directionTrgToSrc = 180;
                            start = vrSource.centerLeft;
                            end = vrTarget.centerRight;
                        }
                    }
                }
                modifiedPoints.addPoint(start);
                int dx1 = (int)(Math.cos(Math.toRadians(directionSrcToTrg)) * 35.0);
                int dy1 = (int)(Math.sin(Math.toRadians(directionSrcToTrg)) * 35.0);
                int dx2 = (int)(Math.cos(Math.toRadians(directionTrgToSrc)) * 35.0);
                int dy2 = (int)(Math.sin(Math.toRadians(directionTrgToSrc)) * 35.0);
                Point p1 = new Point(start.x + dx1, start.y - dy1);
                modifiedPoints.addPoint(p1);
                int i = 1;
                while (i < points.size() - 1) {
                    modifiedPoints.addPoint(points.getPoint(i));
                    ++i;
                }
                Point p2 = new Point(end.x - dx2, end.y - dy2);
                modifiedPoints.addPoint(p2);
                modifiedPoints.addPoint(end);
                PointList intermediate = new PointList();
                int i2 = 1;
                while (i2 < modifiedPoints.size() - 1) {
                    intermediate.addPoint(modifiedPoints.getPoint(i2));
                    ++i2;
                }
                PointList resolvedRoutePoints = OrthoPathUtils.calcOrthoRoutePoints(intermediate, directionSrcToTrg);
                List<RouteRectangle> entities = this.algorithm.getEntityRectangle();
                resolvedRoutePoints = this.resolveIntersections(resolvedRoutePoints, entities);
                resolvedRoutePoints = this.resolveExtraRoutePoints(resolvedRoutePoints);
                resolvedRoutePoints = this.resolveOverlappingRouteSegmentsVerticaly(resolvedRoutePoints, connection);
                resolvedRoutePoints = this.resolveExtraRoutePoints(resolvedRoutePoints);
                resolvedRoutePoints = this.resolveOverlappingRouteSegmentsVerticaly(resolvedRoutePoints, connection);
                resolvedRoutePoints = this.resolveExtraRoutePoints(resolvedRoutePoints);
                resolvedRoutePoints = this.resolveOverlappingRouteSegmentsHorizontaly(resolvedRoutePoints, connection);
                resolvedRoutePoints = this.combineRoutePoints(start, end, resolvedRoutePoints);
                resolvedRoutePoints = this.resolveExtraRoutePoints(resolvedRoutePoints);
                this.getConnectionPoints().put(connection, resolvedRoutePoints);
                connection.setPoints(resolvedRoutePoints);
                this.detectBridgesPoints();
            }
            this.ignoreInvalidate = false;
        }
    }

    private PointList combineRoutePoints(Point start, Point end, PointList resolvedRoutePoints) {
        PointList resultPointList = new PointList();
        resultPointList.addPoint(start);
        resultPointList.addAll(resolvedRoutePoints);
        resultPointList.addPoint(end);
        return resultPointList;
    }

    private PointList resolveOverlappingRouteSegmentsVerticaly(PointList originalPoints, PolylineConnection conn) {
        ArrayList<RouteLine> intersectionLines = new ArrayList<RouteLine>();
        for (Map.Entry entry : this.getConnectionPoints().entrySet()) {
            if (conn.equals(entry.getKey())) continue;
            intersectionLines.addAll(this.detectOverlappingRouteLinesByAxisX(originalPoints, (PointList)entry.getValue()));
        }
        ((OrthogonalConnection)conn).setOverlappingLinesByX(intersectionLines);
        if (intersectionLines.isEmpty()) {
            return originalPoints;
        }
        LinkedList<RouteLine> routerLines = OrthoPathUtils.toRouterLines(originalPoints);
        block1: for (RouteLine routeLine : routerLines) {
            for (RouteLine interSectionLine : intersectionLines) {
                if (!routeLine.equals(interSectionLine)) continue;
                routeLine.getFirst().x -= 17;
                routeLine.getLast().x -= 17;
                continue block1;
            }
        }
        return OrthoPathUtils.toPointList(routerLines);
    }

    private PointList resolveOverlappingRouteSegmentsHorizontaly(PointList originalPoints, PolylineConnection conn) {
        ArrayList<RouteLine> intersectionLines = new ArrayList<RouteLine>();
        for (Map.Entry entry : this.getConnectionPoints().entrySet()) {
            if (conn.equals(entry.getKey()) || entry.getValue() == null || ((PointList)entry.getValue()).size() <= 0) continue;
            intersectionLines.addAll(this.detectOverlappingRouteLinesByAxisY(originalPoints, (PointList)entry.getValue()));
        }
        ((OrthogonalConnection)conn).setOverlappingLinesByY(intersectionLines);
        if (intersectionLines.isEmpty()) {
            return originalPoints;
        }
        PointList list = new PointList();
        if (originalPoints.size() < 4) {
            int i = 0;
            while (i < originalPoints.size()) {
                Point p = originalPoints.getPoint(i);
                if (i == 0) {
                    list.addPoint(p);
                    list.addPoint(p.setY(p.y + 30));
                } else if (i == 1) {
                    list.addPoint(p.setY(p.y + 30));
                } else if (i == originalPoints.size() - 2) {
                    list.addPoint(p.setY(p.y + 30));
                } else if (i == originalPoints.size() - 1) {
                    list.addPoint(p);
                } else {
                    list.addPoint(p.setY(p.y + 15));
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < originalPoints.size()) {
                Point p = originalPoints.getPoint(i);
                if (i < 2 || i == originalPoints.size() - 1) {
                    list.addPoint(p);
                } else {
                    list.addPoint(p.setY(p.y - 15));
                }
                ++i;
            }
        }
        return list;
    }

    private PointList resolveIntersections(PointList routePoints, List<RouteRectangle> userObstacle) {
        PointList copyRoutePoints = routePoints.getCopy();
        PointList resolvedRoutePoints = this.detectIntersectionWithEntities(userObstacle, copyRoutePoints);
        if (resolvedRoutePoints.size() != routePoints.size()) {
            resolvedRoutePoints = this.resolveExtraRoutePoints(resolvedRoutePoints);
            resolvedRoutePoints = this.detectIntersectionWithEntities(userObstacle, copyRoutePoints);
            if (resolvedRoutePoints.size() != routePoints.size()) {
                resolvedRoutePoints = this.detectIntersectionWithEntities(userObstacle, copyRoutePoints);
                resolvedRoutePoints = this.resolveExtraRoutePoints(resolvedRoutePoints);
            }
        }
        return resolvedRoutePoints;
    }

    private PointList detectIntersectionWithEntities(List<RouteRectangle> userObstacles, PointList routePointList) {
        LinkedHashMap<Integer, PointList> intersection = new LinkedHashMap<Integer, PointList>();
        block0: for (RouteRectangle routeRectangle : userObstacles) {
            RouteRectangle vRect = this.getDeformedRectangle(routeRectangle, 35);
            int j = 1;
            while (j < routePointList.size()) {
                Point pointB;
                Point pointA = routePointList.getPoint(j - 1);
                RouteLine line = new RouteLine(pointA, pointB = routePointList.getPoint(j));
                if (OrthoPathUtils.isIntersects(line, routeRectangle)) {
                    PointList entityTopLine = new PointList();
                    entityTopLine.addPoint(routeRectangle.getTopLeft());
                    entityTopLine.addPoint(routeRectangle.getTopRight());
                    PointList entityTopLeftPartLine = new PointList();
                    entityTopLeftPartLine.addPoint(routeRectangle.getTopLeft());
                    entityTopLeftPartLine.addPoint(routeRectangle.getCenter());
                    PointList entityBottomLine = new PointList();
                    entityBottomLine.addPoint(routeRectangle.getBottomLeft());
                    entityBottomLine.addPoint(routeRectangle.getBottomRight());
                    PointList entityRightLine = new PointList();
                    entityRightLine.addPoint(routeRectangle.getTopRight());
                    entityRightLine.addPoint(routeRectangle.getBottomRight());
                    PointList entityRightLeftBottomLine = new PointList();
                    entityRightLeftBottomLine.addPoint(routeRectangle.getCenter());
                    entityRightLeftBottomLine.addPoint(routeRectangle.getBottomLeft());
                    PointList entityLeftLine = new PointList();
                    entityLeftLine.addPoint(routeRectangle.getTopLeft());
                    entityLeftLine.addPoint(routeRectangle.getBottomLeft());
                    PointList intesectionsByTop = OrthoPathUtils.detectIntesections(line, entityTopLine);
                    PointList intesectionsByTopLeft = OrthoPathUtils.detectIntesections(line, entityTopLeftPartLine);
                    PointList intesectionsByRight = OrthoPathUtils.detectIntesections(line, entityRightLine);
                    PointList intesectionsByBottom = OrthoPathUtils.detectIntesections(line, entityBottomLine);
                    PointList intesectionsByRightLeftBottom = OrthoPathUtils.detectIntesections(line, entityRightLeftBottomLine);
                    PointList intesectionsByLeft = OrthoPathUtils.detectIntesections(line, entityLeftLine);
                    PointList aroundEntity = new PointList();
                    Point p1 = null;
                    Point p2 = null;
                    Point p3 = null;
                    double degreesAngel = Math.toDegrees(line.getAngel());
                    if (intesectionsByTop.size() > 0) {
                        if (degreesAngel == -90.0) {
                            if (intesectionsByTopLeft.size() > 0) {
                                p1 = new Point(vRect.topLeft.x, pointA.y);
                                p2 = new Point(vRect.topLeft.x, vRect.topLeft.y);
                                p3 = new Point(pointB.x, vRect.topLeft.y);
                            } else {
                                p1 = new Point(vRect.topRight.x, pointA.y);
                                p2 = new Point(vRect.topRight.x, vRect.topRight.y);
                                p3 = new Point(pointB.x, vRect.topRight.y);
                            }
                        } else if (intesectionsByTopLeft.size() > 0) {
                            p1 = new Point(vRect.topLeft.x, pointA.y);
                            p2 = new Point(vRect.topLeft.x, vRect.bottomLeft.y);
                            p3 = new Point(pointB.x, vRect.bottomLeft.y);
                        } else {
                            p1 = new Point(vRect.topRight.x, pointA.y);
                            p2 = new Point(vRect.topRight.x, vRect.bottomRight.y);
                            p3 = new Point(pointA.x, vRect.bottomRight.y);
                        }
                    } else if (intesectionsByBottom.size() > 0) {
                        if (degreesAngel == -90.0) {
                            p1 = new Point(vRect.bottomLeft.x, pointA.y);
                            p2 = new Point(vRect.bottomLeft.x, vRect.bottomLeft.y);
                            p3 = new Point(pointB.x, vRect.bottomLeft.y);
                        } else {
                            p1 = new Point(vRect.bottomLeft.x, pointA.y);
                            p2 = new Point(vRect.bottomLeft.x, vRect.bottomLeft.y);
                            p3 = new Point(pointA.x, vRect.bottomLeft.y);
                        }
                    } else if (intesectionsByRight.size() > 0) {
                        if (intesectionsByRightLeftBottom.size() > 0) {
                            if (degreesAngel == 0.0) {
                                p1 = new Point(vRect.bottomLeft.x, pointA.y);
                                p2 = new Point(vRect.bottomLeft.x, vRect.bottomLeft.y);
                                p3 = new Point(pointB.x, vRect.bottomLeft.y);
                            } else {
                                p1 = new Point(vRect.bottomRight.x, pointA.y);
                                p2 = new Point(vRect.bottomRight.x, vRect.bottomRight.y);
                                p3 = new Point(pointB.x, vRect.bottomRight.y);
                            }
                        } else if (degreesAngel == 180.0) {
                            p1 = new Point(vRect.topRight.x, pointA.y);
                            p2 = new Point(vRect.topRight.x, vRect.topRight.y);
                            p3 = new Point(pointB.x, vRect.topRight.y);
                        } else {
                            p1 = new Point(vRect.topLeft.x, pointA.y);
                            p2 = new Point(vRect.topLeft.x, vRect.topLeft.y);
                            p3 = new Point(pointB.x, vRect.topLeft.y);
                        }
                    } else if (intesectionsByLeft.size() > 0) {
                        if (intesectionsByRightLeftBottom.size() > 0) {
                            if (degreesAngel == 0.0) {
                                p1 = new Point(vRect.bottomLeft.x, pointB.y);
                                p2 = new Point(vRect.bottomLeft.x, vRect.bottomLeft.y);
                                p3 = new Point(pointB.x, vRect.bottomLeft.y);
                            } else {
                                p1 = new Point(vRect.bottomLeft.x, pointA.y);
                                p2 = new Point(vRect.bottomLeft.x, vRect.bottomLeft.y);
                                p3 = new Point(pointB.x, vRect.bottomLeft.y);
                            }
                        } else if (degreesAngel == 0.0) {
                            p1 = new Point(vRect.topLeft.x, pointB.y);
                            p2 = new Point(vRect.topLeft.x, vRect.topLeft.y);
                            p3 = new Point(pointA.x, vRect.topLeft.y);
                        } else {
                            p1 = new Point(vRect.topLeft.x, pointA.y);
                            p2 = new Point(vRect.topLeft.x, vRect.topLeft.y);
                            p3 = new Point(pointB.x, vRect.topLeft.y);
                        }
                    }
                    if (p1 == null && p2 == null && p3 == null) continue block0;
                    aroundEntity.addPoint(p1);
                    aroundEntity.addPoint(p2);
                    aroundEntity.addPoint(p3);
                    intersection.put(j, aroundEntity);
                    continue block0;
                }
                ++j;
            }
        }
        for (Map.Entry entry : intersection.entrySet()) {
            int position = (Integer)entry.getKey();
            PointList points = (PointList)entry.getValue();
            int j = 0;
            while (j < points.size()) {
                Point p = points.getPoint(j);
                routePointList.insertPoint(p, position++);
                ++j;
            }
        }
        return routePointList;
    }

    private PointList resolveExtraRoutePoints(PointList routePointList) {
        if (routePointList.size() < 2) {
            return routePointList;
        }
        int j = 2;
        while (j < routePointList.size()) {
            Point pointA = routePointList.getPoint(j - 2);
            Point pointB = routePointList.getPoint(j - 1);
            Point pointC = routePointList.getPoint(j);
            if (pointA.x == pointB.x && pointA.x == pointC.x) {
                if (pointB.y < pointA.y && pointB.y < pointC.y) {
                    routePointList.removePoint(j - 1);
                } else if (pointB.y > pointA.y && pointB.y > pointC.y) {
                    routePointList.removePoint(j - 1);
                } else if (pointA.y < pointB.y && pointB.y < pointC.y) {
                    routePointList.removePoint(j - 1);
                } else if (pointC.y < pointB.y && pointB.y < pointA.y) {
                    routePointList.removePoint(j - 1);
                }
            }
            if (pointA.y == pointB.y && pointA.y == pointC.y) {
                if (pointB.x < pointA.x && pointB.x < pointC.x || pointB.x > pointA.x && pointB.x > pointC.x) {
                    routePointList.removePoint(j - 1);
                } else if ((pointA.x >= pointB.x || pointB.x >= pointC.x) && pointC.x < pointB.x) {
                    int cfr_ignored_0 = pointB.x;
                    int cfr_ignored_1 = pointA.x;
                }
            }
            ++j;
        }
        return routePointList;
    }

    private void detectBridgesPoints() {
        for (Map.Entry entry : this.getConnectionPoints().entrySet()) {
            if (!(entry.getKey() instanceof OrthogonalConnection)) continue;
            OrthogonalConnection erdConnection = (OrthogonalConnection)((Object)entry.getKey());
            erdConnection.cleanupCrossRouters();
            PointList crossPoints = new PointList();
            for (Map.Entry targetEntry : this.getConnectionPoints().entrySet()) {
                if (targetEntry.equals(entry)) continue;
                crossPoints.addAll(OrthoPathUtils.detectIntesections((PointList)entry.getValue(), (PointList)targetEntry.getValue()));
                if (crossPoints.size() <= 0) continue;
                erdConnection.setCrossRouters(crossPoints);
            }
        }
    }

    public static float angleBetween2Lines(Point A1, Point A2, Point B1, Point B2) {
        float angle2;
        float angle1 = (float)Math.atan2(A2.y - A1.y, A1.x - A2.x);
        float calculatedAngle = (float)Math.toDegrees(angle1 - (angle2 = (float)Math.atan2(B2.y - B1.y, B1.x - B2.x)));
        if (calculatedAngle < 0.0f) {
            calculatedAngle += 360.0f;
        }
        return calculatedAngle;
    }

    private List<RouteLine> detectOverlappingRouteLinesByAxisY(PointList orthoPoints, PointList connectionPoints) {
        ArrayList<RouteLine> lines = new ArrayList<RouteLine>();
        int j = 1;
        while (j < orthoPoints.size()) {
            Point pointA = orthoPoints.getPoint(j);
            Point pointB = orthoPoints.getPoint(j - 1);
            int i = 1;
            while (i < connectionPoints.size()) {
                Point pointC = connectionPoints.getPoint(i);
                Point pointD = connectionPoints.getPoint(i - 1);
                RouteLine intersectionLine = this.getIntersectionsHorizontally(pointA.x, pointA.y, pointB.x, pointB.y, pointC.x, pointC.y, pointD.x, pointD.y);
                if (intersectionLine != null) {
                    lines.add(new RouteLine(pointA, pointB));
                    lines.add(new RouteLine(pointC, pointD));
                }
                ++i;
            }
            ++j;
        }
        return lines;
    }

    private List<RouteLine> detectOverlappingRouteLinesByAxisX(PointList originalPoints, PointList routePoints) {
        ArrayList<RouteLine> lines = new ArrayList<RouteLine>();
        int j = 1;
        while (j < originalPoints.size()) {
            Point pointA = originalPoints.getPoint(j - 1);
            Point pointB = originalPoints.getPoint(j);
            int i = 1;
            while (i < routePoints.size()) {
                Point pointC = routePoints.getPoint(i - 1);
                Point pointD = routePoints.getPoint(i);
                RouteLine intersectionLine = this.getIntersectionsVertically(pointA.x, pointA.y, pointB.x, pointB.y, pointC.x, pointC.y, pointD.x, pointD.y);
                if (intersectionLine != null) {
                    lines.add(new RouteLine(pointA, pointB));
                    lines.add(new RouteLine(pointC, pointD));
                }
                ++i;
            }
            ++j;
        }
        return lines;
    }

    private RouteLine getIntersectionsVertically(int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4) {
        if (Math.abs(x1 - x3) < 7 && Math.abs(x2 - x4) < 7) {
            int lineABottom = 0;
            int lineATop = 0;
            int lineBBottom = 0;
            int lineBTop = 0;
            if (y1 > y2) {
                lineABottom = y1;
                lineATop = y2;
            } else {
                lineABottom = y2;
                lineATop = y1;
            }
            if (y3 > y4) {
                lineBTop = y4;
                lineBBottom = y3;
            } else {
                lineBTop = y3;
                lineBBottom = y4;
            }
            if (lineABottom == lineBBottom && lineATop == lineBTop && lineABottom == lineATop) {
                return null;
            }
            if (lineBBottom == lineBTop || lineABottom == lineATop) {
                return null;
            }
            if (lineATop == lineBTop && lineABottom == lineBBottom) {
                return new RouteLine(new Point(x1, y1), new Point(x2, y2));
            }
            if (lineATop < lineBTop && lineABottom < lineBBottom && lineABottom > lineBTop) {
                return new RouteLine(new Point(x1, y1), new Point(x2, y2));
            }
            if (lineBTop <= lineATop && lineBBottom < lineABottom && lineBBottom > lineATop) {
                return new RouteLine(new Point(x1, y1), new Point(x2, y2));
            }
            if (lineBTop <= lineATop && lineABottom < lineBBottom) {
                return new RouteLine(new Point(x1, y1), new Point(x2, y2));
            }
            if (lineBTop > lineATop && lineABottom > lineBTop && lineABottom > lineBBottom) {
                return new RouteLine(new Point(x1, y1), new Point(x2, y2));
            }
            if (lineBTop > lineATop && lineABottom > lineBTop && lineABottom < lineBBottom) {
                return new RouteLine(new Point(x1, y1), new Point(x2, y2));
            }
        }
        return null;
    }

    private RouteLine getIntersectionsHorizontally(int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4) {
        if (Math.abs(y1 - y3) < 7 && Math.abs(y2 - y4) < 7) {
            int lineARight = 0;
            int lineALeft = 0;
            int lineBRight = 0;
            int lineBLeft = 0;
            if (x1 > x2) {
                lineARight = x1;
                lineALeft = x2;
            } else {
                lineARight = x2;
                lineALeft = x1;
            }
            if (x3 > x4) {
                lineBRight = x3;
                lineBLeft = x4;
            } else {
                lineBRight = x4;
                lineBLeft = x3;
            }
            if (lineARight == lineBRight && lineALeft == lineBLeft && lineARight == lineBLeft) {
                return null;
            }
            if (lineBLeft == lineBRight || lineALeft == lineARight) {
                return null;
            }
            if (lineARight == lineBRight && lineALeft == lineBLeft) {
                return new RouteLine(new Point(x1, y1), new Point(x2, y2));
            }
            if (lineBRight > lineARight && lineALeft > lineBLeft) {
                return new RouteLine(new Point(x1, y1), new Point(x2, y2));
            }
            if (lineARight > lineBLeft && lineARight < lineBRight) {
                return new RouteLine(new Point(x1, y1), new Point(x2, y2));
            }
            if (lineALeft > lineBLeft && lineALeft < lineBRight) {
                return new RouteLine(new Point(x1, y1), new Point(x2, y2));
            }
            if (lineBRight >= lineARight && lineBLeft > lineALeft && lineBLeft < lineARight) {
                return new RouteLine(new Point(x1, y1), new Point(x2, y2));
            }
            if (lineALeft == lineBLeft && lineARight > lineBLeft) {
                return new RouteLine(new Point(x1, y1), new Point(x2, y2));
            }
        }
        return null;
    }

    public List<?> getPathsAfterRouting() {
        if (this.isDirty) {
            this.processStaleConnections();
            this.isDirty = false;
            return this.algorithm.solve();
        }
        return Collections.emptyList();
    }

    public void setConstraint(Connection connection, Object constraint) {
        this.staleConnections.add(connection);
        this.constraintMap.put(connection, constraint);
        this.isDirty = true;
    }

    public void setSpacing(int spacing) {
        this.algorithm.setSpacing(spacing);
    }

    public boolean hasMoreConnections() {
        return this.connectionToPaths != null && !this.connectionToPaths.isEmpty();
    }

    public void setIgnoreInvalidate(boolean b) {
        this.ignoreInvalidate = b;
    }

    public boolean shouldIgnoreInvalidate() {
        return this.ignoreInvalidate;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public boolean containsConnection(Connection conn) {
        return this.connectionToPaths != null && this.connectionToPaths.containsKey(conn);
    }

    public double getIndentation() {
        return 35.0;
    }

    public void setIndentation(double indentation) {
    }

    private RouteRectangle getDeformedRectangle(RouteRectangle r, int extraOffset) {
        int offset = extraOffset * 2;
        Rectangle rect = new Rectangle(r.x - extraOffset, r.y - extraOffset, r.width + offset, r.height + offset);
        return new RouteRectangle(rect);
    }

    public PolylineConnection getConnectionInstance() {
        return new OrthogonalConnection();
    }

    protected void handleCollision(PointList points, int index) {
        Point end;
        Point start = points.getFirstPoint();
        if (start.equals((Object)(end = points.getLastPoint()))) {
            return;
        }
        Point midPoint = new Point((end.x + start.x) / 2, (end.y + start.y) / 2);
        int position = end.getPosition(start);
        RouteLine line = position == 4 || position == 16 ? new RouteLine(start, end) : new RouteLine(end, start);
        double xSeparation = (double)(10 * line.getDx()) / line.getLength();
        double ySeparation = (double)(10 * line.getDy()) / line.getLength();
        PrecisionPoint bendPoint = index % 2 == 0 ? new PrecisionPoint((double)midPoint.x + (double)(index / 2) * (-1.0 * ySeparation), (double)midPoint.y + (double)(index / 2) * xSeparation) : new PrecisionPoint((double)midPoint.x + (double)(index / 2) * ySeparation, (double)midPoint.y + (double)(index / 2) * (-1.0 * xSeparation));
        if (!bendPoint.equals((Object)midPoint)) {
            points.insertPoint((Point)bendPoint, 1);
        }
    }

    private class LayoutTracker
    extends LayoutListener.Stub {
        private LayoutTracker() {
        }

        public void postLayout(IFigure container) {
            if (OrthogonalPathRouting.this.staleConnections.isEmpty()) {
                return;
            }
            OrthogonalPathRouting.this.staleConnections.iterator().next().revalidate();
        }

        public void remove(IFigure child) {
            OrthogonalPathRouting.this.removeChild(child);
        }

        public void setConstraint(IFigure child, Object constraint) {
            OrthogonalPathRouting.this.addChild(child);
        }
    }
}

